#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test macros.
#
# $Id: macro.py 8842 2007-03-12 06:04:09Z andrewm $

import unittest
import albatross
import albatross_test

class MacroCase(albatross_test.AlbatrossTestCase):
    template_dir = "macro"

    def check_macro_0arg(self):
        self.html_test("0arg.html", "content\n")

    def check_macro_0arg_dup(self):
        self.html_test("0arg-dup.html", "content\ncontent\n")

    def check_macro_1arg(self):
        self.html_test("1arg.html", "xxx argument xxx\n")

    def check_macro_2arg(self):
        self.html_test("2arg.html", "xxx first second xxx\n")

    def check_macro_simplearg(self):
        self.html_test("simplearg.html", "xxx aaa bbb xxx\n")

    def check_macro_argexpr(self):
        self.ctx.locals.aaa = 'first'
        self.ctx.locals.bbb = 'second'
        self.html_test("argexpr.html", "xxx first second xxx\n")

    def check_macro_unnamed(self):
        self.html_test("unnamed.html", "xxx unnamed body xxx\n")

    def check_macro_unnamedarg(self):
        self.html_test("unnamedarg.html", "xxx argument")

    def check_macro_nested(self):
        self.html_test("nested.html", "aaa second bbb first ccc second ddd\n")

    def check_macro_default(self):
        self.html_test("default.html", "aaa first bbb\naaa catflap bbb\n")

    def check_macro_defaultnested(self):
        self.html_test("defaultnested.html", "aaa second bbb first ccc second ddd catflap eee\n")

    def check_macro_unclosed(self):
        self.test_raise("unclosed.html")

    def check_macro_unclosedarg(self):
        self.test_raise("unclosedarg.html")

    def check_macro_missingarg(self):
        self.test_raise("missingarg.html")

class MacroSuite(unittest.TestSuite):
    test_list = (
        "check_macro_0arg",
        "check_macro_0arg_dup",
        "check_macro_1arg",
        "check_macro_2arg",
        "check_macro_simplearg",
        "check_macro_argexpr",
        "check_macro_unnamed",
        "check_macro_nested",
        "check_macro_default",
        "check_macro_defaultnested",
        "check_macro_unclosed",
        "check_macro_unclosedarg",
        "check_macro_missingarg",
        "check_macro_unnamedarg",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(MacroCase, self.test_list))

def suite():
    return MacroSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
