___
___
# API
It is quite easy to use bnd from Java, you only need to include biz.aQute.bndlib on your class path. This chapter shows you some samples of how to use bndlib.

## Creating a Manifest
By default, bnd creates a container with resources and then calculates the manifest. However, these phases are separated although they use the same instructions. The following snippet therefore shows how you can create a manifest from an existing file or directory.

  Analyzer analyzer = new Analyzer(); 
  Jar bin = new Jar( new File("bin") );  // where our data is
  analyzer.setJar( bin );                // give bnd the contents

  // You can provide additional class path entries to allow
  // bnd to pickup export version from the packageinfo file,
  // Version annotation, or their manifests.
  analyzer.addClasspath( new File("jar/spring.jar") );

  analyzer.setProperty("Bundle-SymbolicName","org.osgi.core");
  analyzer.setProperty("Export-Package", 
                       "org.osgi.framework,org.osgi.service.event");
  analyzer.setProperty("Bundle-Version","1.0");

  // There are no good defaults so make sure you set the 
  // Import-Package
  analyzer.setProperty("Import-Package","*");

  // Calculate the manifest
  Manifest manifest = analyzer.calcManifest();


