#
# $Id: GNUmakefile.CK,v 1.4 2002/05/28 18:23:59 lijewski Exp $
#
PBOXLIB_HOME  = $(HOME)/tmp/Parallel
TOP           = $(PBOXLIB_HOME)
#
# User-settable variables.
#
PRECISION      = DOUBLE
DEBUG	       = TRUE
DEBUG	       = FALSE
PROFILE        = FALSE
DIM    	       = 2
COMP           = KCC
COMP           = g++
USE_3RD        = FALSE
USE_MPI        = FALSE
BUILD_IN_PLACE = TRUE
EBASE          = flame
#
# Packages below are of the form dir/lib.  dir=location of the lib sources,
#  lib=library root name.  This info is separated into to corresponding
#  lists.  
#
Packages := $(TOP)/BoxLib/box \
	    $(TOP)/bndrylib/bndry \
	    $(TOP)/HeatTransfer/ChemKinDriver/chem
#
# Set standard defs
#
include $(TOP)/mk/Make.defs
DEFINES += -DBL_PARALLEL_IO
#
# Setup build locations/libraries
#
MyLibRoots := $(notdir $(Packages))
MyPackageDirs := $(dir $(Packages))
MySrcDirs =
ifeq ($(BUILD_IN_PLACE),TRUE)
  MySrcDirs += $(MyPackageDirs)
  INCLUDE_LOCATIONS += $(MySrcDirs) $(TOP)/amrlib
  ifeq ($(COMP),g++)
    INCLUDE_LOCATIONS += $(TOP)/BoxLib/std
  endif
else
  LIBRARIES += $(addsuffix $(DIM)d, $(addprefix -l, $(MyLibRoots)))
  INCLUDE_LOCATIONS += $(TOP)/include
  LIBRARY_LOCATIONS += $(TOP)/lib/$(machineSuffix)
endif
INCLUDE_LOCATIONS += $(TOP)/pAmrvis $(TOP)/bndrylib
CEXE_sources += AmrDeriveCK.cpp
#FEXE_sources += 
CEXE_headers += DataServices.H AmrData.H XYPlotDataList.H AmrvisConstants.H
CEXE_sources += DataServices.cpp AmrData.cpp XYPlotDataList.cpp
ifeq ($(DIM),3)
FEXE_sources += xtra_3D.F FILCC_3D.F DERIVE_3D.F FABUTIL_3D.F
else
FEXE_sources += xtra_2D.F FILCC_2D.F DERIVE_2D.F FABUTIL_2D.F
endif

include $(addsuffix /Make.package, $(MySrcDirs))
#
# Settle special parallel locations/libraries, and 3rd
#
ifeq ($(USE_3RD),TRUE)
  CXXFLAGS  += --link_command_prefix 3rd
  CXXDEBF    = +K0 --link_command_prefix 3rd
  LIBRARIES += -ldnet_stub
endif
#
# Generic defines and flags, then specific run config flags
#
ifeq ($(MACHINE),IRIX)
  CXX := $(filter-out -ptused -prelink, $(CXX))
endif
ifeq ($(MACHINE),OSF1)
ifeq ($(COMP),KCC)
    CXXOPTF := -O3 +K2 -g3 -Olimit 2000
endif
    FOPTF += -inline all
endif
ifeq ($(MACHINE),CRAY)
    CXX         := CC
    CXXLIBFLAGS := -h instantiate=local
    CXXOPTF     := -h noexceptions,inline0
    CXXOPTF     := -h noexceptions
    FOPTF       += -Wf"-dp"
    FDEBF       += -Wf"-dp"
    FPRFF       += -Wf"-dp"
endif

VPATHDIRS = $(MySrcDirs) .. $(TOP)/pAmrvis $(TOP)/amrlib $(TOP)/bndrylib $(TOP)/pAmrDerive
vpath %.cpp $(VPATHDIRS)
vpath %.F   $(VPATHDIRS)
vpath %.H   $(VPATHDIRS)
vpath %.h   $(VPATHDIRS)
vpath %.f   $(VPATHDIRS)
vpath %.a   $(LIBRARY_LOCATIONS)

MyMakeLine =  $(MAKE) PRECISION=$(PRECISION) PROFILE=$(PROFILE) COMP=$(COMP) \
	      DEBUG=$(DEBUG) DIM=$(DIM) USE_MPI=$(USE_MPI) PRVERSION=$(PRVERSION) \
	      USE_TENSOR=$(USE_TENSOR) USE_HGPROJ_SERIAL=$(USE_HGPROJ_SERIAL) \
	      DEFINES="$(DEFINES)" EBASE= LBASE=$@

MyLibDeps := $(shell perl -e '$$,=" ";print reverse @ARGV ;' $(MyLibRoots))

#
# Targets
#
all: $(executable)

$(executable): $(LIBRARIES)

libs: $(MyLibDeps)

$(MyLibDeps):
	cd $(dir $(filter %/$@, $(Packages))); $(MyMakeLine) install

cleanlibs:
	$(foreach lib,$(MyLibRoots),cd $lib; $(MyMakeLine) clean)

nodata:
	\rm -rf chk* plt* grdlog inspect.fab *.mfab *.fab *.asc *.out

#
# Create MS-IDE dsp file to build this project
#
DspOlevel = 1
DspFileRoot = $(EBASE)$(DIM)d
ifeq ($(DEBUG), TRUE)
  DspFileRoot := $(join $(DspFileRoot),.DEBUG)
  DspOlevel := 0
endif
dsp: $(DspFileRoot).dsp
.dspDepends: $(FEXE_sources) $(FEXE_headers) $(fEXE_sources) $(CEXE_headers) $(CEXE_sources) $(INCLUDE_LOCATIONS)
	@echo $^ > .dspDepends

$(DspFileRoot).dsp: .dspDepends
	@(echo Building DSP file = $(DspFileRoot).dsp;\
	$(TOP)/scripts/dsp.mak -p $(DspFileRoot) -t $(TOP) -d $(DIM) -o $(DspFileRoot).dsp -O $(DspOlevel) -f $^)

include $(TOP)/mk/Make.rules
