package memoplugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;


import com.db4o.osgi.Db4oService;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "MemoPlugin";

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
		plugin = this;
	}
	// end Activator

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 * Obtains a db4o_osgi service reference and registers it with Db4oProvider
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		ServiceReference serviceRef = context.getServiceReference(Db4oService.class.getName());
		Db4oService db4oService = (Db4oService)context.getService(serviceRef);
		Db4oProvider.Initialize(db4oService);
	}
	// end start

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 * Unregisters the db4o_osgi service from Db4oProvider
	 */
	public void stop(BundleContext context) throws Exception {
		Db4oProvider.UnInitialize();
		plugin = null;
		super.stop(context);
	}
	// end stop

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	// end getDefault

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	// end getImageDescriptor
}
