package enhancement;

import java.io.File;
import java.util.List;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectEventArgs;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.query.Db4oQueryExecutionListener;
import com.db4o.internal.query.NQOptimizationInfo;
import com.db4o.query.Predicate;
import com.db4o.reflect.jdk.JdkReflector;
import com.db4o.ta.TransparentActivationSupport;

import enhancement.model.Car;
import enhancement.model.Id;
import enhancement.model.MaintenanceQueue;
import enhancement.model.Pilot;

/**
 * Sample main class for TA instrumentation.
 * For build time instrumentation, refer to the build.xml and prepend the instrumented-bin target dir to the classpath.
 * For load time instrumentation, refer to TATestStarter.
 */
public class EnhancerMain {

	private static final int DEPTH = 10;
	private final static String DB4O_FILE_NAME = "enhancement.db4o";
	
	public static void main(String[] args) {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer db = Db4o.openFile(configuration(), DB4O_FILE_NAME);
		MaintenanceQueue<Car> queue = null;
		for(int number = 0; number < DEPTH; number++) {
			queue = MaintenanceQueue.add(queue, new Car("Car" + number, 
					new Pilot("Pilot #" + number, new Id("110021" + number))));
		}
		db.set(queue);
		db.close();

		db = Db4o.openFile(configuration(), DB4O_FILE_NAME);
		EventRegistry registry = EventRegistryFactory.forObjectContainer(db);
		registry.activated().addListener(new EventListener4() {
			public void onEvent(Event4 event, EventArgs args) {
				ObjectEventArgs objArgs = (ObjectEventArgs) args;
				System.out.println("ACTIVATED: " + objArgs.object());
			}
		});
		((ObjectContainerBase)db).getNativeQueryHandler().addListener(new Db4oQueryExecutionListener() {
			public void notifyQueryExecuted(NQOptimizationInfo info) {
				System.out.println(info);
			}
		});
		
		List<MaintenanceQueue<Car>> result = db.query(new Predicate<MaintenanceQueue<Car>>() {
			@Override
			public boolean match(MaintenanceQueue<Car> queue) {
				return queue.value().getModel().equals("Car0");
			}
		});
		System.out.println(result.size());
		//for (Iterator<MaintenanceQueue<Car>> i = result.iterator(); i.hasNext();){
			MaintenanceQueue<Car> carQueue = result.get(0);
			Car car = carQueue.value();
			System.out.println(car);
			
			Pilot pilot = car.getPilot();
			System.out.println(pilot);
			while (carQueue.hasNext()){
				carQueue = carQueue.next();
				car = carQueue.value();
				System.out.println(car);
				
				pilot = car.getPilot();
				System.out.println(pilot);
			}
		//}
		db.close();
		new File(DB4O_FILE_NAME).delete();
	}
	// end main

	private static Configuration configuration() {
		Configuration config = Db4o.newConfiguration();
		config.add(new TransparentActivationSupport());
		// NOTE: required for load time instrumentation!
		config.reflectWith(new JdkReflector(EnhancerMain.class.getClassLoader()));
		return config;
	}
	// end configuration
}
