! (C) Copyright 2005- ECMWF.
! (C) Copyright 2013- Meteo-France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

MODULE MPI4TO8_M
#ifdef USE_8_BYTE_WORDS

USE EC_PARKIND, ONLY : JPIM, JPRM, JPRD
USE MPL_MPIF

IMPLICIT NONE

PRIVATE :: STATUS8
  INTEGER(KIND=8), DIMENSION(MPI_STATUS_SIZE) :: STATUS8

INTERFACE MPI_ALLGATHERV8
  MODULE PROCEDURE MPI_ALLGATHERV8_R4, MPI_ALLGATHERV8_R8, &
                   MPI_ALLGATHERV8_I4, MPI_ALLGATHERV8_I1
END INTERFACE MPI_ALLGATHERV8

INTERFACE MPI_ALLREDUCE8
  MODULE PROCEDURE MPI_ALLREDUCE8_R4, MPI_ALLREDUCE8_R8, &
                   MPI_ALLREDUCE8_I4, MPI_ALLREDUCE8_R4_2D, &
                   MPI_ALLREDUCE8_R8_2D
END INTERFACE MPI_ALLREDUCE8

INTERFACE MPI_ALLTOALLV8
  MODULE PROCEDURE MPI_ALLTOALLV8_R8, MPI_ALLTOALLV8_I4
END INTERFACE MPI_ALLTOALLV8

INTERFACE MPI_BCAST8
  MODULE PROCEDURE MPI_BCAST8_R4, MPI_BCAST8_R8, &
                   MPI_BCAST8_I4, MPI_BCAST8_I1, &
                   MPI_BCAST8_CH
END INTERFACE MPI_BCAST8

INTERFACE MPI_BSEND8
  MODULE PROCEDURE MPI_BSEND8_R4, MPI_BSEND8_R8, &
                   MPI_BSEND8_R42, MPI_BSEND8_R82, &
                   MPI_BSEND8_I4, MPI_BSEND8_I1, &
                   MPI_BSEND8_CH, MPI_BSEND8_I42, &
                   MPI_BSEND8_R4_1, MPI_BSEND8_R8_1
END INTERFACE MPI_BSEND8

INTERFACE MPI_ISEND8
  MODULE PROCEDURE MPI_ISEND8_R4, MPI_ISEND8_R8, &
                   MPI_ISEND8_R42, MPI_ISEND8_R82, &
                   MPI_ISEND8_I4, MPI_ISEND8_I1, &
                   MPI_ISEND8_CH, MPI_ISEND8_I42, &
                   MPI_ISEND8_R4_1, MPI_ISEND8_R8_1
END INTERFACE MPI_ISEND8

INTERFACE MPI_SEND8
  MODULE PROCEDURE MPI_SEND8_R4, MPI_SEND8_R8, &
                   MPI_SEND8_R42, MPI_SEND8_R82, &
                   MPI_SEND8_I4, MPI_SEND8_I1, &
                   MPI_SEND8_CH, MPI_SEND8_I42, &
                   MPI_SEND8_R4_1, MPI_SEND8_R8_1
END INTERFACE MPI_SEND8

INTERFACE MPI_FILE_IREAD_SHARED8
  MODULE PROCEDURE MPI_FILE_IREAD_SHARED8_R8, MPI_FILE_IREAD_SHARED8_I4
END INTERFACE MPI_FILE_IREAD_SHARED8

INTERFACE MPI_FILE_IWRITE_SHARED8
  MODULE PROCEDURE MPI_FILE_IWRITE_SHARED8_R8, MPI_FILE_IWRITE_SHARED8_I4
END INTERFACE MPI_FILE_IWRITE_SHARED8

INTERFACE MPI_FILE_READ_ORDERED8
  MODULE PROCEDURE MPI_FILE_READ_ORDERED8_R8, MPI_FILE_READ_ORDERED8_I4
END INTERFACE MPI_FILE_READ_ORDERED8

INTERFACE MPI_FILE_READ_ORDERED_BEGIN8
  MODULE PROCEDURE MPI_FREAD_ORDERED_BEGIN8_R8, MPI_FREAD_ORDERED_BEGIN8_I4
END INTERFACE MPI_FILE_READ_ORDERED_BEGIN8

INTERFACE MPI_FILE_READ_ORDERED_END8
  MODULE PROCEDURE MPI_FREAD_ORDERED_END8_R8, MPI_FREAD_ORDERED_END8_I4
END INTERFACE MPI_FILE_READ_ORDERED_END8

INTERFACE MPI_FILE_READ_SHARED8
  MODULE PROCEDURE MPI_FILE_READ_SHARED8_R8, MPI_FILE_READ_SHARED8_I4
END INTERFACE MPI_FILE_READ_SHARED8

INTERFACE MPI_FILE_WRITE_ORDERED8
  MODULE PROCEDURE MPI_FILE_WRITE_ORDERED8_R8, MPI_FILE_WRITE_ORDERED8_I4
END INTERFACE MPI_FILE_WRITE_ORDERED8

INTERFACE MPI_FILE_WRITE_ORDERED_BEGIN8
  MODULE PROCEDURE MPI_FWRITE_ORDERED_BEGIN8_R8, MPI_FWRITE_ORDERED_BEGIN8_I4
END INTERFACE MPI_FILE_WRITE_ORDERED_BEGIN8

INTERFACE MPI_FILE_WRITE_ORDERED_END8
  MODULE PROCEDURE MPI_FWRITE_ORDERED_END8_R8, MPI_FWRITE_ORDERED_END8_I4
END INTERFACE MPI_FILE_WRITE_ORDERED_END8

INTERFACE MPI_FILE_WRITE_SHARED8
  MODULE PROCEDURE MPI_FILE_WRITE_SHARED8_R8, MPI_FILE_WRITE_SHARED8_I4
END INTERFACE MPI_FILE_WRITE_SHARED8

INTERFACE MPI_GATHER8
  MODULE PROCEDURE MPI_GATHER8_I1, MPI_GATHER8_R8_1
END INTERFACE MPI_GATHER8

INTERFACE MPI_GATHERV8
  MODULE PROCEDURE MPI_GATHERV8_R4, MPI_GATHERV8_R8, &
                   MPI_GATHERV8_R4S, MPI_GATHERV8_R8S, &
                   MPI_GATHERV8_I4, MPI_GATHERV8_I1, &
                   MPI_GATHERV8_I4S, MPI_GATHERV8_I4S_1, &
                   MPI_GATHERV8_R8_1, MPI_GATHERV8_R8S_1
END INTERFACE MPI_GATHERV8

INTERFACE MPI_RECV8
  MODULE PROCEDURE MPI_RECV8_R4, MPI_RECV8_R8, &
                   MPI_RECV8_R42, MPI_RECV8_R82, &
                   MPI_RECV8_I4, MPI_RECV8_I1, &
                   MPI_RECV8_R4_1, MPI_RECV8_R8_1, &
                   MPI_RECV8_CH, MPI_RECV8_I42
END INTERFACE MPI_RECV8

INTERFACE MPI_IRECV8
  MODULE PROCEDURE MPI_IRECV8_R4, MPI_IRECV8_R8, &
                   MPI_IRECV8_R42, MPI_IRECV8_R82, &
                   MPI_IRECV8_I4, MPI_IRECV8_I1, &
                   MPI_IRECV8_I42, &
                   MPI_IRECV8_R4_1, MPI_IRECV8_R8_1, &
                   MPI_IRECV8_CH
END INTERFACE MPI_IRECV8

INTERFACE MPI_SCATTERV8
  MODULE PROCEDURE MPI_SCATTERV8_R8, MPI_SCATTERV8_I4, &
                   MPI_SCATTERV8_R8S, MPI_SCATTERV8_I4S
END INTERFACE MPI_SCATTERV8

PUBLIC

CONTAINS

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ALLREDUCE8_R4(SENDDATA, RECVDATA, COUNT, DATATYPE, OP, &
                             COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA(:)
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, OP, COMM
  REAL(KIND=JPRM), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA(:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8, RECVDATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, OP8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))
  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDDATA8 = SENDDATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  OP8 = OP
  COMM8 = COMM

  CALL MPI_ALLREDUCE(SENDDATA8, RECVDATA8, COUNT8, DATATYPE8, OP8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)
  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_ALLREDUCE8_R4

SUBROUTINE MPI_ALLREDUCE8_R4_2D(SENDDATA, RECVDATA, COUNT, DATATYPE, OP, &
                             COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    SENDDATA(:,:)
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, OP, COMM
  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(OUT) :: &
    RECVDATA(:.:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    SENDDATA8, RECVDATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, OP8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))
  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDDATA8 = SENDDATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  OP8 = OP
  COMM8 = COMM

  CALL MPI_ALLREDUCE(SENDDATA8, RECVDATA8, COUNT8, DATATYPE8, OP8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)
  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_ALLREDUCE8_R4_2D


! ---------------------------------------------------------
SUBROUTINE MPI_ALLREDUCE8_R8(SENDDATA, RECVDATA, COUNT, DATATYPE, OP, &
                             COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDDATA(:)
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, OP, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA(:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, OP8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  OP8 = OP
  COMM8 = COMM

  CALL MPI_ALLREDUCE(SENDDATA, RECVDATA, COUNT8, DATATYPE8, OP8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_ALLREDUCE8_R8

SUBROUTINE MPI_ALLREDUCE8_R8_2D(SENDDATA, RECVDATA, COUNT, DATATYPE, OP, &
                             COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(IN) :: &
    SENDDATA(:,:)
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, OP, COMM
  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(OUT) :: &
    RECVDATA(:,:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, OP8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  OP8 = OP
  COMM8 = COMM

  CALL MPI_ALLREDUCE(SENDDATA, RECVDATA, COUNT8, DATATYPE8, OP8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_ALLREDUCE8_R8


! ---------------------------------------------------------
SUBROUTINE MPI_ALLREDUCE8_I4(SENDDATA, RECVDATA, COUNT, DATATYPE, OP, &
                              COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA(:)
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, OP, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA(:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8, RECVDATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, OP8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))
  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDDATA8 = SENDDATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  OP8 = OP
  COMM8 = COMM

  CALL MPI_ALLREDUCE(SENDDATA8, RECVDATA8, COUNT8, DATATYPE8, OP8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)
  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_ALLREDUCE8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ALLGATHERV8_R4(SENDAREA, SENDCOUNT, SENDTYPE, RECVAREA, &
                              RECVCOUNTS, DISPLS, RECVTYPE, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, COMM
  REAL(KIND=JPRM), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDAREA8, RECVAREA8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(SENDAREA8(SIZE(SENDAREA)))
  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDAREA8 = SENDAREA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLGATHERV(SENDAREA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                      RECVCOUNTS8, DISPLS8, RECVTYPE8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDAREA8)
  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_ALLGATHERV8_R4

! ---------------------------------------------------------
SUBROUTINE MPI_ALLGATHERV8_R8(SENDAREA, SENDCOUNT, SENDTYPE, RECVAREA, &
                              RECVCOUNTS, DISPLS, RECVTYPE, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLGATHERV(SENDAREA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                      RECVCOUNTS8, DISPLS8, RECVTYPE8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_ALLGATHERV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_ALLGATHERV8_I4(SENDAREA, SENDCOUNT, SENDTYPE, RECVAREA, &
                               RECVCOUNTS, DISPLS, RECVTYPE, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDAREA, RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDAREA8, RECVAREA8, RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(SENDAREA8(SIZE(SENDAREA)))
  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDAREA8 = SENDAREA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLGATHERV(SENDAREA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                      RECVCOUNTS8, DISPLS8, RECVTYPE8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDAREA8)
  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_ALLGATHERV8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_ALLGATHERV8_I1(SENDAREA, SENDCOUNT, SENDTYPE, RECVAREA, &
                               RECVCOUNTS, DISPLS, RECVTYPE, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVAREA8, RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDAREA8, SENDCOUNT8, SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDAREA8 = SENDAREA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLGATHERV(SENDAREA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                      RECVCOUNTS8, DISPLS8, RECVTYPE8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_ALLGATHERV8_I1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ALLTOALLV8_R8(SENDAREA, SENDCOUNTS, SDISPLS, SENDTYPE, &
                             RECVAREA, RECVCOUNTS, RDISPLS, RECVTYPE, &
                             COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDCOUNTS, SDISPLS, RECVCOUNTS, RDISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVTYPE, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDCOUNTS8, SDISPLS8, RECVCOUNTS8, RDISPLS8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(SENDCOUNTS8(SIZE(SENDCOUNTS)))
  ALLOCATE(SDISPLS8(SIZE(SDISPLS)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(RDISPLS8(SIZE(RDISPLS)))

  SENDCOUNTS8 = SENDCOUNTS
  SDISPLS8 = SDISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  RDISPLS8 = RDISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLTOALLV(SENDAREA, SENDCOUNTS8, SDISPLS8, SENDTYPE8, RECVAREA, &
                     RECVCOUNTS8, RDISPLS8, RECVTYPE8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(SENDCOUNTS8)
  DEALLOCATE(SDISPLS8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(RDISPLS8)

END SUBROUTINE MPI_ALLTOALLV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_ALLTOALLV8_I4(SENDAREA, SENDCOUNTS, SDISPLS, SENDTYPE, &
                              RECVAREA, RECVCOUNTS, RDISPLS, RECVTYPE, &
                              COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDAREA, SENDCOUNTS, SDISPLS, RECVCOUNTS, RDISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVTYPE, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDAREA8, SENDCOUNTS8, SDISPLS8, RECVAREA8, RECVCOUNTS8, RDISPLS8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVTYPE8, COMM8, IERROR8

  ALLOCATE(SENDAREA8(SIZE(SENDAREA)))
  ALLOCATE(SENDCOUNTS8(SIZE(SENDCOUNTS)))
  ALLOCATE(SDISPLS8(SIZE(SDISPLS)))
  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(RDISPLS8(SIZE(RDISPLS)))

  SENDAREA8 = SENDAREA
  SENDCOUNTS8 = SENDCOUNTS
  SDISPLS8 = SDISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  RDISPLS8 = RDISPLS
  RECVTYPE8 = RECVTYPE
  COMM8 = COMM

  CALL MPI_ALLTOALLV(SENDAREA8, SENDCOUNTS8, SDISPLS8, SENDTYPE8, RECVAREA8, &
                     RECVCOUNTS8, RDISPLS8, RECVTYPE8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDAREA8)
  DEALLOCATE(SENDCOUNTS8)
  DEALLOCATE(SDISPLS8)
  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(RDISPLS8)

END SUBROUTINE MPI_ALLTOALLV8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BCAST8_R4(DATA, COUNT, DATATYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(INOUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_BCAST(DATA8, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8)

  DATA = DATA8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BCAST8_R4

! ---------------------------------------------------------
SUBROUTINE MPI_BCAST8_R8(DATA, COUNT, DATATYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(INOUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_BCAST(DATA, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BCAST8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_BCAST8_I4(DATA, COUNT, DATATYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(INOUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_BCAST(DATA8, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8)

  DATA = DATA8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BCAST8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_BCAST8_I1(DATA, COUNT, DATATYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(INOUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_BCAST(DATA8, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8)

  DATA = DATA8
  IERROR = IERROR8

END SUBROUTINE MPI_BCAST8_I1

! ---------------------------------------------------------
SUBROUTINE MPI_BCAST8_CH(DATA, COUNT, DATATYPE, ROOT, COMM, IERROR)

  CHARACTER(LEN=*), INTENT(INOUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_BCAST(DATA, COUNT8, DATATYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BCAST8_CH

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_R4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BSEND8_R4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_R8(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_R42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BSEND8_R42

! =========================================================
SUBROUTINE MPI_BSEND8_I42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BSEND8_I42

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_R82(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_R82

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_I4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_BSEND8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_I1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_I1

! =========================================================
SUBROUTINE MPI_BSEND8_R4_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_R4_1

! =========================================================
SUBROUTINE MPI_BSEND8_R8_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_R8_1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_BSEND8_CH(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  CHARACTER(LEN=*), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_BSEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_BSEND8_CH

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_R4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_ISEND8_R4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_R8(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_R42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_ISEND8_R42

! =========================================================
SUBROUTINE MPI_ISEND8_I42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_ISEND8_I42

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_R82(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_R82

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_I4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_ISEND8_I4

! =========================================================
SUBROUTINE MPI_ISEND8_R4_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8):: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_R4_1

! =========================================================
SUBROUTINE MPI_ISEND8_R8_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8) :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_R8_1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_I1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_I1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_ISEND8_CH(DATA, COUNT, DATATYPE, DEST, TAG, COMM, REQUEST, IERROR)

  CHARACTER(LEN=*), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_ISEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_ISEND8_CH

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_R4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_SEND8_R4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_R8(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_R42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_SEND8_R42

! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_I42(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_SEND8_I42

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_R82(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_R82

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_I4(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_SEND8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_I1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_I1

! =========================================================
SUBROUTINE MPI_SEND8_R4_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRM), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8) :: DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_R4_1

! =========================================================
SUBROUTINE MPI_SEND8_R8_1(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8) :: DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  DATA8 = DATA
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA8, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_R8_1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SEND8_CH(DATA, COUNT, DATATYPE, DEST, TAG, COMM, IERROR)

  CHARACTER(LEN=*), INTENT(IN) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, DEST, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  DEST8 = DEST
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_SEND(DATA, COUNT8, DATATYPE8, DEST8, TAG8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_SEND8_CH

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_IREAD_SHARED8_R8(FH, BUF, COUNT, DATATYPE, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, REQUEST8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_IREAD_SHARED(FH8, BUF, COUNT8, DATATYPE8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_IREAD_SHARED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_IREAD_SHARED8_I4(FH, BUF, COUNT, DATATYPE, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, REQUEST8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_IREAD_SHARED(FH8, BUF8, COUNT8, DATATYPE8, REQUEST8, IERROR8)

  BUF = BUF8
  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_IREAD_SHARED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_IWRITE_SHARED8_R8(FH, BUF, COUNT, DATATYPE, REQUEST, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, REQUEST8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_IWRITE_SHARED(FH8, BUF, COUNT8, DATATYPE8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_IWRITE_SHARED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_IWRITE_SHARED8_I4(FH, BUF, COUNT, DATATYPE, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, BUF(:), COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, REQUEST8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  BUF8 = BUF
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_IWRITE_SHARED(FH8, BUF8, COUNT8, DATATYPE8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_IWRITE_SHARED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_READ_ORDERED8_R8(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_ORDERED(FH8, BUF, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_READ_ORDERED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_READ_ORDERED8_I4(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), STATUS(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_ORDERED(FH8, BUF8, COUNT8, DATATYPE8, STATUS8, IERROR8)

  BUF = BUF8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_READ_ORDERED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FREAD_ORDERED_BEGIN8_R8(FH, BUF, COUNT, DATATYPE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_ORDERED_BEGIN(FH8, BUF, COUNT8, DATATYPE8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_FREAD_ORDERED_BEGIN8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FREAD_ORDERED_BEGIN8_I4(FH, BUF, COUNT, DATATYPE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_ORDERED_BEGIN(FH8, BUF8, COUNT8, DATATYPE8, IERROR8)

  BUF = BUF8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FREAD_ORDERED_BEGIN8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FREAD_ORDERED_END8_R8(FH, BUF, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    FH8, IERROR8

  FH8 = FH

  CALL MPI_FILE_READ_ORDERED_END(FH8, BUF, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_FREAD_ORDERED_END8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FREAD_ORDERED_END8_I4(FH, BUF, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), STATUS(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH

  CALL MPI_FILE_READ_ORDERED_END(FH8, BUF8, STATUS8, IERROR8)

  BUF = BUF8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FREAD_ORDERED_END8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_READ_SHARED8_R8(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_SHARED(FH8, BUF, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_READ_SHARED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_READ_SHARED8_I4(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), STATUS(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_READ_SHARED(FH8, BUF8, COUNT8, DATATYPE8, STATUS8, IERROR8)

  BUF = BUF8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_READ_SHARED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_WRITE_ORDERED8_R8(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_ORDERED(FH8, BUF, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_WRITE_ORDERED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_WRITE_ORDERED8_I4(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, BUF(:), COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  BUF8 = BUF
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_ORDERED(FH8, BUF8, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_WRITE_ORDERED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FWRITE_ORDERED_BEGIN8_R8(FH, BUF, COUNT, DATATYPE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_ORDERED_BEGIN(FH8, BUF, COUNT8, DATATYPE8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_FWRITE_ORDERED_BEGIN8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FWRITE_ORDERED_BEGIN8_I4(FH, BUF, COUNT, DATATYPE, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_ORDERED_BEGIN(FH8, BUF8, COUNT8, DATATYPE8, IERROR8)

  BUF = BUF8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FWRITE_ORDERED_BEGIN8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FWRITE_ORDERED_END8_R8(FH, BUF, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, STATUS(:)
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    FH8, IERROR8

  FH8 = FH
  STATUS8 = STATUS

  CALL MPI_FILE_WRITE_ORDERED_END(FH8, BUF, STATUS8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_FWRITE_ORDERED_END8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FWRITE_ORDERED_END8_I4(FH, BUF, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, STATUS(:)
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    BUF(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  STATUS8 = STATUS

  CALL MPI_FILE_WRITE_ORDERED_END(FH8, BUF8, STATUS8, IERROR8)

  BUF = BUF8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FWRITE_ORDERED_END8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_FILE_WRITE_SHARED8_R8(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    BUF
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  FH8 = FH
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_SHARED(FH8, BUF, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_FILE_WRITE_SHARED8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_FILE_WRITE_SHARED8_I4(FH, BUF, COUNT, DATATYPE, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    FH, BUF(:), COUNT, DATATYPE
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    STATUS(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    BUF8
  INTEGER(KIND=8) :: &
    FH8, COUNT8, DATATYPE8, IERROR8

  ALLOCATE(BUF8(SIZE(BUF)))

  FH8 = FH
  BUF8 = BUF
  COUNT8 = COUNT
  DATATYPE8 = DATATYPE

  CALL MPI_FILE_WRITE_SHARED(FH8, BUF8, COUNT8, DATATYPE8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(BUF8)

END SUBROUTINE MPI_FILE_WRITE_SHARED8_I4

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_GATHER8_R8_1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                            RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHER(SENDDATA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                  RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_GATHER8_R8_1

! ---------------------------------------------------------
SUBROUTINE MPI_GATHER8_I1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                          RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDDATA, SENDCOUNT, SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RECVAREA, IERROR

  INTEGER(KIND=8) :: &
    SENDDATA8, RECVAREA8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHER(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                  RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

END SUBROUTINE MPI_GATHER8_I1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_R8(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_GATHERV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_R8S(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_GATHERV8_R8S

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_R4(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRM), DIMENSION(:), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8, RECVAREA8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))
  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)
  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_GATHERV8_R4

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_R4S(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRM), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8
  REAL(KIND=8) :: RECVAREA8
  INTEGER(KIND=8) :: RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)

END SUBROUTINE MPI_GATHERV8_R4S

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_I4(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA, RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RECVAREA(:), IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8, RECVAREA8, RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))
  ALLOCATE(RECVAREA8(SIZE(RECVAREA)))
  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)
  DEALLOCATE(RECVAREA8)
  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_GATHERV8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_I4S(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM, RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RECVAREA, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDDATA8
  INTEGER(KIND=8) :: &
    RECVAREA8, RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDDATA8(SIZE(SENDDATA)))

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(SENDDATA8)

END SUBROUTINE MPI_GATHERV8_I4S

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_I4S_1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM, RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RECVAREA, IERROR

  INTEGER(KIND=8) :: &
    SENDDATA8
  INTEGER(KIND=8) :: &
    RECVAREA8, RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

END SUBROUTINE MPI_GATHERV8_I4S_1

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_I1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                           RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDDATA, SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    RECVAREA, IERROR

  INTEGER(KIND=8) :: &
    SENDDATA8, RECVAREA8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDDATA8 = SENDDATA
  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA8, SENDCOUNT8, SENDTYPE8, RECVAREA8, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVAREA = RECVAREA8
  IERROR = IERROR8

  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_GATHERV8_I1

! ---------------------------------------------------------
SUBROUTINE MPI_GATHERV8_R8_1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                             RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(RECVCOUNTS8(SIZE(RECVCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

  DEALLOCATE(RECVCOUNTS8)
  DEALLOCATE(DISPLS8)

END SUBROUTINE MPI_GATHERV8_R8_1

! =========================================================
SUBROUTINE MPI_GATHERV8_R8S_1(SENDDATA, SENDCOUNT, SENDTYPE, RECVAREA, &
                             RECVCOUNTS, DISPLS, RECVTYPE, ROOT, COMM, IERROR)

  REAL(KIND=JPRD), INTENT(IN) :: &
    SENDDATA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    RECVCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDCOUNT, SENDTYPE, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), INTENT(OUT) :: &
    RECVAREA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    RECVCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDCOUNT8, SENDTYPE8, RECVTYPE8, ROOT8, COMM8, IERROR8

  SENDCOUNT8 = SENDCOUNT
  SENDTYPE8 = SENDTYPE
  RECVCOUNTS8 = RECVCOUNTS
  DISPLS8 = DISPLS
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_GATHERV(SENDDATA, SENDCOUNT8, SENDTYPE8, RECVAREA, &
                   RECVCOUNTS8, DISPLS8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  IERROR = IERROR8

END SUBROUTINE MPI_GATHERV8_R8S_1

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R4(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRM), DIMENSION(:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_RECV8_R4

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R8(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R42(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_RECV8_R42

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_I42(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_RECV8_I42

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R82(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_R82

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_I4(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    DATA, STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_RECV8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_I1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    DATA, IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_I1

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R4_1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  REAL(KIND=JPRM), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8) :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  DATA = DATA8
  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_R4_1

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_R8_1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  REAL(KIND=JPRD), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_R8_1

! ---------------------------------------------------------
SUBROUTINE MPI_RECV8_CH(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, STATUS, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    STATUS
  CHARACTER(LEN=*), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_RECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, STATUS8, IERROR8)

  STATUS = STATUS8
  IERROR = IERROR8

END SUBROUTINE MPI_RECV8_CH

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R4(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRM), DIMENSION(:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_IRECV8_R4

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R8(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R42(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRM), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_IRECV8_R42

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R82(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRD), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_R82

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_I4(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    DATA(:), REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_IRECV8_I4

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_I42(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), DIMENSION(:,:), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8), DIMENSION(:,:), ALLOCATABLE :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  ALLOCATE(DATA8(SIZE(DATA,DIM=1),SIZE(DATA,DIM=2)))

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

  DEALLOCATE(DATA8)

END SUBROUTINE MPI_IRECV8_I42

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_I1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    DATA, REQUEST, IERROR

  INTEGER(KIND=8) :: &
    DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_I1

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R4_1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRM), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  REAL(KIND=8) :: &
    DATA8
  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA8, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  DATA = DATA8
  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_R4_1

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_R8_1(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  REAL(KIND=JPRD), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_R8_1

! ---------------------------------------------------------
SUBROUTINE MPI_IRECV8_CH(DATA, COUNT, DATATYPE, SOURCE, TAG, COMM, REQUEST, IERROR)

  INTEGER(KIND=JPIM), INTENT(IN) :: &
    COUNT, DATATYPE, SOURCE, TAG, COMM
  CHARACTER(LEN=*), INTENT(OUT) :: &
    DATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    REQUEST, IERROR

  INTEGER(KIND=8) :: &
    COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8

  COUNT8 = COUNT
  DATATYPE8 = DATATYPE
  SOURCE8 = SOURCE
  TAG8 = TAG
  COMM8 = COMM

  CALL MPI_IRECV(DATA, COUNT8, DATATYPE8, SOURCE8, TAG8, COMM8, REQUEST8, IERROR8)

  REQUEST = REQUEST8
  IERROR = IERROR8

END SUBROUTINE MPI_IRECV8_CH

! =========================================================
! ---------------------------------------------------------
SUBROUTINE MPI_SCATTERV8_R8(SENDAREA, SENDCOUNTS, DISPLS, SENDTYPE, &
                            RECVDATA, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
  
  REAL(KIND=JPRD), DIMENSION(:), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDAREA8, RECVDATA8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDAREA8(SIZE(SENDAREA)))
  ALLOCATE(SENDCOUNTS8(SIZE(SENDCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))
  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDAREA8 = SENDAREA
  SENDCOUNTS8 = SENDCOUNTS
  DISPLS8 = DISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_SCATTERV(SENDAREA8, SENDCOUNTS8, DISPLS8, SENDTYPE8, &
                    RECVDATA8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(SENDAREA8)
  DEALLOCATE(SENDCOUNTS8)
  DEALLOCATE(DISPLS8)
  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_SCATTERV8_R8

! ---------------------------------------------------------
SUBROUTINE MPI_SCATTERV8_R8S(SENDAREA, SENDCOUNTS, DISPLS, SENDTYPE, &
                            RECVDATA, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
  
  REAL(KIND=JPRD), INTENT(IN) :: &
    SENDAREA
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM, SENDCOUNTS, DISPLS
  REAL(KIND=JPRD), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  REAL(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVDATA8
  REAL(KIND=8) :: &
    SENDAREA8
  INTEGER(KIND=8) :: &
    SENDCOUNTS8, DISPLS8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDAREA8 = SENDAREA
  SENDCOUNTS8 = SENDCOUNTS
  DISPLS8 = DISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_SCATTERV(SENDAREA8, SENDCOUNTS8, DISPLS8, SENDTYPE8, &
                    RECVDATA8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_SCATTERV8_R8S

! ---------------------------------------------------------
SUBROUTINE MPI_SCATTERV8_I4(SENDAREA, SENDCOUNTS, DISPLS, SENDTYPE, &
                            RECVDATA, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
  
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(IN) :: &
    SENDAREA, SENDCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    SENDAREA8, SENDCOUNTS8, DISPLS8, RECVDATA8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(SENDAREA8(SIZE(SENDAREA)))
  ALLOCATE(SENDCOUNTS8(SIZE(SENDCOUNTS)))
  ALLOCATE(DISPLS8(SIZE(DISPLS)))
  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDAREA8 = SENDAREA
  SENDCOUNTS8 = SENDCOUNTS
  DISPLS8 = DISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_SCATTERV(SENDAREA8, SENDCOUNTS8, DISPLS8, SENDTYPE8, &
                    RECVDATA8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(SENDAREA8)
  DEALLOCATE(SENDCOUNTS8)
  DEALLOCATE(DISPLS8)
  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_SCATTERV8_I4

! =========================================================
SUBROUTINE MPI_SCATTERV8_I4S(SENDAREA, SENDCOUNTS, DISPLS, SENDTYPE, &
                            RECVDATA, RECVCOUNT, RECVTYPE, ROOT, COMM, IERROR)
  
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDAREA, SENDCOUNTS, DISPLS
  INTEGER(KIND=JPIM), INTENT(IN) :: &
    SENDTYPE, RECVCOUNT, RECVTYPE, ROOT, COMM
  INTEGER(KIND=JPIM), DIMENSION(:), INTENT(OUT) :: &
    RECVDATA
  INTEGER(KIND=JPIM), INTENT(OUT) :: &
    IERROR

  INTEGER(KIND=8) :: &
    SENDAREA8, SENDCOUNTS8, DISPLS8
  INTEGER(KIND=8), DIMENSION(:), ALLOCATABLE :: &
    RECVDATA8
  INTEGER(KIND=8) :: &
    SENDTYPE8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8

  ALLOCATE(RECVDATA8(SIZE(RECVDATA)))

  SENDAREA8 = SENDAREA
  SENDCOUNTS8 = SENDCOUNTS
  DISPLS8 = DISPLS
  SENDTYPE8 = SENDTYPE
  RECVCOUNT8 = RECVCOUNT
  RECVTYPE8 = RECVTYPE
  ROOT8 = ROOT
  COMM8 = COMM

  CALL MPI_SCATTERV(SENDAREA8, SENDCOUNTS8, DISPLS8, SENDTYPE8, &
                    RECVDATA8, RECVCOUNT8, RECVTYPE8, ROOT8, COMM8, IERROR8)

  RECVDATA = RECVDATA8
  IERROR = IERROR8

  DEALLOCATE(RECVDATA8)

END SUBROUTINE MPI_SCATTERV8_I4S

! =========================================================
! =========================================================
! =========================================================

#endif
END MODULE MPI4TO8_M
