// Code generated by smithy-go-codegen DO NOT EDIT.

package globalaccelerator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Delete a cross-account attachment. When you delete an attachment, Global
// Accelerator revokes the permission to use the resources in the attachment from
// all principals in the list of principals. Global Accelerator revokes the
// permission for specific resources by doing the following:
//   - If the principal is an account ID, Global Accelerator reviews every
//     accelerator in the account and removes cross-account endpoints from all
//     accelerators.
//   - If the principal is an accelerator, Global Accelerator reviews just that
//     accelerator and removes cross-account endpoints from it.
//
// If there are overlapping permissions provided by multiple cross-account
// attachments, Global Accelerator only removes endpoints if there are no current
// cross-account attachments that provide access permission. For example, if you
// delete a cross-account attachment that lists an accelerator as a principal, but
// another cross-account attachment includes the account ID that owns that
// accelerator, endpoints will not be removed from the accelerator.
func (c *Client) DeleteCrossAccountAttachment(ctx context.Context, params *DeleteCrossAccountAttachmentInput, optFns ...func(*Options)) (*DeleteCrossAccountAttachmentOutput, error) {
	if params == nil {
		params = &DeleteCrossAccountAttachmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteCrossAccountAttachment", params, optFns, c.addOperationDeleteCrossAccountAttachmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteCrossAccountAttachmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteCrossAccountAttachmentInput struct {

	// The Amazon Resource Name (ARN) for the cross-account attachment to delete.
	//
	// This member is required.
	AttachmentArn *string

	noSmithyDocumentSerde
}

type DeleteCrossAccountAttachmentOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteCrossAccountAttachmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeleteCrossAccountAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeleteCrossAccountAttachment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteCrossAccountAttachment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteCrossAccountAttachmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteCrossAccountAttachment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteCrossAccountAttachment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteCrossAccountAttachment",
	}
}
