/* soapC.c
   Generated by gSOAP 2.7.9b from /home/veiko/MSSP_GW/src/MSSP_GW.h
   Copyright(C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"
#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.9b 2007-01-13 14:49:33 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_in_xsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__positiveInteger:
		return soap_in_xsd__positiveInteger(soap, NULL, NULL, "xsd:positiveInteger");
	case SOAP_TYPE_unsignedLong:
		return soap_in_unsignedLong(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_mss__MessagingModeType:
		return soap_in_mss__MessagingModeType(soap, NULL, NULL, "mss:MessagingModeType");
	case SOAP_TYPE_mss__SignatureProfileComparisonType:
		return soap_in_mss__SignatureProfileComparisonType(soap, NULL, NULL, "mss:SignatureProfileComparisonType");
	case SOAP_TYPE_mss__MSS_USCOREStatusReq:
		return soap_in_mss__MSS_USCOREStatusReq(soap, NULL, NULL, "mss:MSS_StatusReq");
	case SOAP_TYPE_mss__MSS_USCOREStatusResp:
		return soap_in_mss__MSS_USCOREStatusResp(soap, NULL, NULL, "mss:MSS_StatusResp");
	case SOAP_TYPE_mss__MSS_USCORESignatureReq:
		return soap_in_mss__MSS_USCORESignatureReq(soap, NULL, NULL, "mss:MSS_SignatureReq");
	case SOAP_TYPE_mss__MSS_USCORESignatureResp:
		return soap_in_mss__MSS_USCORESignatureResp(soap, NULL, NULL, "mss:MSS_SignatureResp");
	case SOAP_TYPE_mss__SignatureType:
		return soap_in_mss__SignatureType(soap, NULL, NULL, "mss:SignatureType");
	case SOAP_TYPE_mss__StatusType:
		return soap_in_mss__StatusType(soap, NULL, NULL, "mss:StatusType");
	case SOAP_TYPE_mss__StatusCodeType:
		return soap_in_mss__StatusCodeType(soap, NULL, NULL, "mss:StatusCodeType");
	case SOAP_TYPE_mss__KeyReferenceType:
		return soap_in_mss__KeyReferenceType(soap, NULL, NULL, "mss:KeyReferenceType");
	case SOAP_TYPE_mss__MSSP_InfoType:
		return soap_in_mss__MSSP_InfoType(soap, NULL, NULL, "mss:MSSP-InfoType");
	case SOAP_TYPE_mss__AP_InfoType:
		return soap_in_mss__AP_InfoType(soap, NULL, NULL, "mss:AP-InfoType");
	case SOAP_TYPE_mss__mssURIType:
		return soap_in_mss__mssURIType(soap, NULL, NULL, "mss:mssURIType");
	case SOAP_TYPE_mss__DigestAlgAndValueType:
		return soap_in_mss__DigestAlgAndValueType(soap, NULL, NULL, "mss:DigestAlgAndValueType");
	case SOAP_TYPE_DigestMethodType:
		return soap_in_DigestMethodType(soap, NULL, NULL, "DigestMethodType");
	case SOAP_TYPE_mss__MobileUserType:
		return soap_in_mss__MobileUserType(soap, NULL, NULL, "mss:MobileUserType");
	case SOAP_TYPE_mss__MeshMemberType:
		return soap_in_mss__MeshMemberType(soap, NULL, NULL, "mss:MeshMemberType");
	case SOAP_TYPE_mss__DataType:
		return soap_in_mss__DataType(soap, NULL, NULL, "mss:DataType");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTomss__MSS_USCOREStatusResp:
		return soap_in_PointerTomss__MSS_USCOREStatusResp(soap, NULL, NULL, "mss:MSS_StatusResp");
	case SOAP_TYPE_PointerTomss__MSS_USCORESignatureResp:
		return soap_in_PointerTomss__MSS_USCORESignatureResp(soap, NULL, NULL, "mss:MSS_SignatureResp");
	case SOAP_TYPE_PointerTomss__SignatureProfileComparisonType:
		return soap_in_PointerTomss__SignatureProfileComparisonType(soap, NULL, NULL, "mss:SignatureProfileComparisonType");
	case SOAP_TYPE_PointerTomss__KeyReferenceType:
		return soap_in_PointerTomss__KeyReferenceType(soap, NULL, NULL, "mss:KeyReferenceType");
	case SOAP_TYPE_PointerTomss__DataType:
		return soap_in_PointerTomss__DataType(soap, NULL, NULL, "mss:DataType");
	case SOAP_TYPE_PointerToxsd__positiveInteger:
		return soap_in_PointerToxsd__positiveInteger(soap, NULL, NULL, "xsd:positiveInteger");
	case SOAP_TYPE_PointerTomss__SignatureType:
		return soap_in_PointerTomss__SignatureType(soap, NULL, NULL, "mss:SignatureType");
	case SOAP_TYPE_PointerTomss__mssURIType:
		return soap_in_PointerTomss__mssURIType(soap, NULL, NULL, "mss:mssURIType");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_mss__StatusDetailType:
	{	char **s;
		s = soap_in_mss__StatusDetailType(soap, NULL, NULL, "mss:StatusDetailType");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTomss__DigestAlgAndValueType:
		return soap_in_PointerTomss__DigestAlgAndValueType(soap, NULL, NULL, "mss:DigestAlgAndValueType");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__dateTime:
	{	char **s;
		s = soap_in_xsd__dateTime(soap, NULL, NULL, "xsd:dateTime");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__string:
	{	char **s;
		s = soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_xsd__int;
			return soap_in_xsd__int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_xsd__float;
			return soap_in_xsd__float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:positiveInteger"))
		{	*type = SOAP_TYPE_xsd__positiveInteger;
			return soap_in_xsd__positiveInteger(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLong;
			return soap_in_unsignedLong(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MessagingModeType"))
		{	*type = SOAP_TYPE_mss__MessagingModeType;
			return soap_in_mss__MessagingModeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:SignatureProfileComparisonType"))
		{	*type = SOAP_TYPE_mss__SignatureProfileComparisonType;
			return soap_in_mss__SignatureProfileComparisonType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSS_StatusReq"))
		{	*type = SOAP_TYPE_mss__MSS_USCOREStatusReq;
			return soap_in_mss__MSS_USCOREStatusReq(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSS_StatusResp"))
		{	*type = SOAP_TYPE_mss__MSS_USCOREStatusResp;
			return soap_in_mss__MSS_USCOREStatusResp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSS_SignatureReq"))
		{	*type = SOAP_TYPE_mss__MSS_USCORESignatureReq;
			return soap_in_mss__MSS_USCORESignatureReq(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSS_SignatureResp"))
		{	*type = SOAP_TYPE_mss__MSS_USCORESignatureResp;
			return soap_in_mss__MSS_USCORESignatureResp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:SignatureType"))
		{	*type = SOAP_TYPE_mss__SignatureType;
			return soap_in_mss__SignatureType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:StatusType"))
		{	*type = SOAP_TYPE_mss__StatusType;
			return soap_in_mss__StatusType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:StatusCodeType"))
		{	*type = SOAP_TYPE_mss__StatusCodeType;
			return soap_in_mss__StatusCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:KeyReferenceType"))
		{	*type = SOAP_TYPE_mss__KeyReferenceType;
			return soap_in_mss__KeyReferenceType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MSSP-InfoType"))
		{	*type = SOAP_TYPE_mss__MSSP_InfoType;
			return soap_in_mss__MSSP_InfoType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:AP-InfoType"))
		{	*type = SOAP_TYPE_mss__AP_InfoType;
			return soap_in_mss__AP_InfoType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:mssURIType"))
		{	*type = SOAP_TYPE_mss__mssURIType;
			return soap_in_mss__mssURIType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:DigestAlgAndValueType"))
		{	*type = SOAP_TYPE_mss__DigestAlgAndValueType;
			return soap_in_mss__DigestAlgAndValueType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "DigestMethodType"))
		{	*type = SOAP_TYPE_DigestMethodType;
			return soap_in_DigestMethodType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MobileUserType"))
		{	*type = SOAP_TYPE_mss__MobileUserType;
			return soap_in_mss__MobileUserType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:MeshMemberType"))
		{	*type = SOAP_TYPE_mss__MeshMemberType;
			return soap_in_mss__MeshMemberType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:DataType"))
		{	*type = SOAP_TYPE_mss__DataType;
			return soap_in_mss__DataType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mss:StatusDetailType"))
		{	char **s;
			*type = SOAP_TYPE_mss__StatusDetailType;
			s = soap_in_mss__StatusDetailType(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	char **s;
			*type = SOAP_TYPE_xsd__dateTime;
			s = soap_in_xsd__dateTime(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_xsd__string;
			s = soap_in_xsd__string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_out_xsd__int(soap, tag, id, (const long *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_out_xsd__float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const unsigned char *)ptr, "xsd:boolean");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__positiveInteger:
		return soap_out_xsd__positiveInteger(soap, tag, id, (const unsigned long *)ptr, "xsd:positiveInteger");
	case SOAP_TYPE_unsignedLong:
		return soap_out_unsignedLong(soap, tag, id, (const unsigned long *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_mss__MessagingModeType:
		return soap_out_mss__MessagingModeType(soap, tag, id, (const enum mss__MessagingModeType *)ptr, "mss:MessagingModeType");
	case SOAP_TYPE_mss__SignatureProfileComparisonType:
		return soap_out_mss__SignatureProfileComparisonType(soap, tag, id, (const enum mss__SignatureProfileComparisonType *)ptr, "mss:SignatureProfileComparisonType");
	case SOAP_TYPE_mss__MSS_USCOREStatusReq:
		return soap_out_mss__MSS_USCOREStatusReq(soap, tag, id, (const struct mss__MSS_USCOREStatusReq *)ptr, "mss:MSS_StatusReq");
	case SOAP_TYPE_mss__MSS_USCOREStatusResp:
		return soap_out_mss__MSS_USCOREStatusResp(soap, tag, id, (const struct mss__MSS_USCOREStatusResp *)ptr, "mss:MSS_StatusResp");
	case SOAP_TYPE_mss__MSS_USCORESignatureReq:
		return soap_out_mss__MSS_USCORESignatureReq(soap, tag, id, (const struct mss__MSS_USCORESignatureReq *)ptr, "mss:MSS_SignatureReq");
	case SOAP_TYPE_mss__MSS_USCORESignatureResp:
		return soap_out_mss__MSS_USCORESignatureResp(soap, tag, id, (const struct mss__MSS_USCORESignatureResp *)ptr, "mss:MSS_SignatureResp");
	case SOAP_TYPE_mss__SignatureType:
		return soap_out_mss__SignatureType(soap, tag, id, (const struct mss__SignatureType *)ptr, "mss:SignatureType");
	case SOAP_TYPE_mss__StatusType:
		return soap_out_mss__StatusType(soap, tag, id, (const struct mss__StatusType *)ptr, "mss:StatusType");
	case SOAP_TYPE_mss__StatusCodeType:
		return soap_out_mss__StatusCodeType(soap, tag, id, (const struct mss__StatusCodeType *)ptr, "mss:StatusCodeType");
	case SOAP_TYPE_mss__KeyReferenceType:
		return soap_out_mss__KeyReferenceType(soap, tag, id, (const struct mss__KeyReferenceType *)ptr, "mss:KeyReferenceType");
	case SOAP_TYPE_mss__MSSP_InfoType:
		return soap_out_mss__MSSP_InfoType(soap, tag, id, (const struct mss__MSSP_InfoType *)ptr, "mss:MSSP-InfoType");
	case SOAP_TYPE_mss__AP_InfoType:
		return soap_out_mss__AP_InfoType(soap, tag, id, (const struct mss__AP_InfoType *)ptr, "mss:AP-InfoType");
	case SOAP_TYPE_mss__mssURIType:
		return soap_out_mss__mssURIType(soap, tag, id, (const struct mss__mssURIType *)ptr, "mss:mssURIType");
	case SOAP_TYPE_mss__DigestAlgAndValueType:
		return soap_out_mss__DigestAlgAndValueType(soap, tag, id, (const struct mss__DigestAlgAndValueType *)ptr, "mss:DigestAlgAndValueType");
	case SOAP_TYPE_DigestMethodType:
		return soap_out_DigestMethodType(soap, tag, id, (const struct DigestMethodType *)ptr, "DigestMethodType");
	case SOAP_TYPE_mss__MobileUserType:
		return soap_out_mss__MobileUserType(soap, tag, id, (const struct mss__MobileUserType *)ptr, "mss:MobileUserType");
	case SOAP_TYPE_mss__MeshMemberType:
		return soap_out_mss__MeshMemberType(soap, tag, id, (const struct mss__MeshMemberType *)ptr, "mss:MeshMemberType");
	case SOAP_TYPE_mss__DataType:
		return soap_out_mss__DataType(soap, tag, id, (const struct mss__DataType *)ptr, "mss:DataType");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTomss__MSS_USCOREStatusResp:
		return soap_out_PointerTomss__MSS_USCOREStatusResp(soap, tag, id, (struct mss__MSS_USCOREStatusResp *const*)ptr, "mss:MSS_StatusResp");
	case SOAP_TYPE_PointerTomss__MSS_USCORESignatureResp:
		return soap_out_PointerTomss__MSS_USCORESignatureResp(soap, tag, id, (struct mss__MSS_USCORESignatureResp *const*)ptr, "mss:MSS_SignatureResp");
	case SOAP_TYPE_PointerTomss__SignatureProfileComparisonType:
		return soap_out_PointerTomss__SignatureProfileComparisonType(soap, tag, id, (enum mss__SignatureProfileComparisonType *const*)ptr, "mss:SignatureProfileComparisonType");
	case SOAP_TYPE_PointerTomss__KeyReferenceType:
		return soap_out_PointerTomss__KeyReferenceType(soap, tag, id, (struct mss__KeyReferenceType *const*)ptr, "mss:KeyReferenceType");
	case SOAP_TYPE_PointerTomss__DataType:
		return soap_out_PointerTomss__DataType(soap, tag, id, (struct mss__DataType *const*)ptr, "mss:DataType");
	case SOAP_TYPE_PointerToxsd__positiveInteger:
		return soap_out_PointerToxsd__positiveInteger(soap, tag, id, (unsigned long *const*)ptr, "xsd:positiveInteger");
	case SOAP_TYPE_PointerTomss__SignatureType:
		return soap_out_PointerTomss__SignatureType(soap, tag, id, (struct mss__SignatureType *const*)ptr, "mss:SignatureType");
	case SOAP_TYPE_PointerTomss__mssURIType:
		return soap_out_PointerTomss__mssURIType(soap, tag, id, (struct mss__mssURIType *const*)ptr, "mss:mssURIType");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (struct xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_mss__StatusDetailType:
		return soap_out_string(soap, tag, id, (char**)&ptr, "mss:StatusDetailType");
	case SOAP_TYPE_PointerTomss__DigestAlgAndValueType:
		return soap_out_PointerTomss__DigestAlgAndValueType(soap, tag, id, (struct mss__DigestAlgAndValueType *const*)ptr, "mss:DigestAlgAndValueType");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_xsd__dateTime:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:dateTime");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_mss__MSS_USCOREStatusReq:
		soap_serialize_mss__MSS_USCOREStatusReq(soap, (const struct mss__MSS_USCOREStatusReq *)ptr);
		break;
	case SOAP_TYPE_mss__MSS_USCOREStatusResp:
		soap_serialize_mss__MSS_USCOREStatusResp(soap, (const struct mss__MSS_USCOREStatusResp *)ptr);
		break;
	case SOAP_TYPE_mss__MSS_USCORESignatureReq:
		soap_serialize_mss__MSS_USCORESignatureReq(soap, (const struct mss__MSS_USCORESignatureReq *)ptr);
		break;
	case SOAP_TYPE_mss__MSS_USCORESignatureResp:
		soap_serialize_mss__MSS_USCORESignatureResp(soap, (const struct mss__MSS_USCORESignatureResp *)ptr);
		break;
	case SOAP_TYPE_mss__SignatureType:
		soap_serialize_mss__SignatureType(soap, (const struct mss__SignatureType *)ptr);
		break;
	case SOAP_TYPE_mss__StatusType:
		soap_serialize_mss__StatusType(soap, (const struct mss__StatusType *)ptr);
		break;
	case SOAP_TYPE_mss__StatusCodeType:
		soap_serialize_mss__StatusCodeType(soap, (const struct mss__StatusCodeType *)ptr);
		break;
	case SOAP_TYPE_mss__KeyReferenceType:
		soap_serialize_mss__KeyReferenceType(soap, (const struct mss__KeyReferenceType *)ptr);
		break;
	case SOAP_TYPE_mss__MSSP_InfoType:
		soap_serialize_mss__MSSP_InfoType(soap, (const struct mss__MSSP_InfoType *)ptr);
		break;
	case SOAP_TYPE_mss__AP_InfoType:
		soap_serialize_mss__AP_InfoType(soap, (const struct mss__AP_InfoType *)ptr);
		break;
	case SOAP_TYPE_mss__mssURIType:
		soap_serialize_mss__mssURIType(soap, (const struct mss__mssURIType *)ptr);
		break;
	case SOAP_TYPE_mss__DigestAlgAndValueType:
		soap_serialize_mss__DigestAlgAndValueType(soap, (const struct mss__DigestAlgAndValueType *)ptr);
		break;
	case SOAP_TYPE_DigestMethodType:
		soap_serialize_DigestMethodType(soap, (const struct DigestMethodType *)ptr);
		break;
	case SOAP_TYPE_mss__MobileUserType:
		soap_serialize_mss__MobileUserType(soap, (const struct mss__MobileUserType *)ptr);
		break;
	case SOAP_TYPE_mss__MeshMemberType:
		soap_serialize_mss__MeshMemberType(soap, (const struct mss__MeshMemberType *)ptr);
		break;
	case SOAP_TYPE_mss__DataType:
		soap_serialize_mss__DataType(soap, (const struct mss__DataType *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_PointerTomss__MSS_USCOREStatusResp:
		soap_serialize_PointerTomss__MSS_USCOREStatusResp(soap, (struct mss__MSS_USCOREStatusResp *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__MSS_USCORESignatureResp:
		soap_serialize_PointerTomss__MSS_USCORESignatureResp(soap, (struct mss__MSS_USCORESignatureResp *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__SignatureProfileComparisonType:
		soap_serialize_PointerTomss__SignatureProfileComparisonType(soap, (enum mss__SignatureProfileComparisonType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__KeyReferenceType:
		soap_serialize_PointerTomss__KeyReferenceType(soap, (struct mss__KeyReferenceType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__DataType:
		soap_serialize_PointerTomss__DataType(soap, (struct mss__DataType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__positiveInteger:
		soap_serialize_PointerToxsd__positiveInteger(soap, (unsigned long *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__SignatureType:
		soap_serialize_PointerTomss__SignatureType(soap, (struct mss__SignatureType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTomss__mssURIType:
		soap_serialize_PointerTomss__mssURIType(soap, (struct mss__mssURIType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (struct xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_mss__StatusDetailType:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_PointerTomss__DigestAlgAndValueType:
		soap_serialize_PointerTomss__DigestAlgAndValueType(soap, (struct mss__DigestAlgAndValueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_xsd__dateTime:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_xsd__string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__int(struct soap *soap, long *a)
{	soap_default_long(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__int(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__int);
	if (soap_out_xsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_xsd__int(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_xsd__int(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__float(struct soap *soap, float *a)
{	soap_default_float(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__float);
	if (soap_out_xsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_xsd__float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_xsd__float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, unsigned char *a)
{	soap_default_unsignedByte(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__positiveInteger(struct soap *soap, unsigned long *a)
{	soap_default_unsignedLong(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__positiveInteger(struct soap *soap, const unsigned long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__positiveInteger);
	if (soap_out_xsd__positiveInteger(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__positiveInteger(struct soap *soap, const char *tag, int id, const unsigned long *a, const char *type)
{
	return soap_outunsignedLong(soap, tag, id, a, type, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_get_xsd__positiveInteger(struct soap *soap, unsigned long *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__positiveInteger(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_in_xsd__positiveInteger(struct soap *soap, const char *tag, unsigned long *a, const char *type)
{
	return soap_inunsignedLong(soap, tag, a, type, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLong(struct soap *soap, unsigned long *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLong
	*a = SOAP_DEFAULT_unsignedLong;
#else
	*a = (unsigned long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLong(struct soap *soap, const unsigned long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLong);
	if (soap_out_unsignedLong(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLong(struct soap *soap, const char *tag, int id, const unsigned long *a, const char *type)
{
	return soap_outunsignedLong(soap, tag, id, a, type, SOAP_TYPE_unsignedLong);
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_get_unsignedLong(struct soap *soap, unsigned long *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLong(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned long * SOAP_FMAC4 soap_in_unsignedLong(struct soap *soap, const char *tag, unsigned long *a, const char *type)
{
	return soap_inunsignedLong(soap, tag, a, type, SOAP_TYPE_unsignedLong);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MessagingModeType(struct soap *soap, enum mss__MessagingModeType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_mss__MessagingModeType
	*a = SOAP_DEFAULT_mss__MessagingModeType;
#else
	*a = (enum mss__MessagingModeType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MessagingModeType(struct soap *soap, const enum mss__MessagingModeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MessagingModeType);
	if (soap_out_mss__MessagingModeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_mss__MessagingModeType[] =
{	{ (long)synch, "synch" },
	{ (long)asynchClientServer, "asynchClientServer" },
	{ (long)asynchServerServer, "asynchServerServer" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_mss__MessagingModeType2s(struct soap *soap, enum mss__MessagingModeType n)
{	const char *s = soap_code_str(soap_codes_mss__MessagingModeType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MessagingModeType(struct soap *soap, const char *tag, int id, const enum mss__MessagingModeType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MessagingModeType), type);
	soap_send(soap, soap_mss__MessagingModeType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum mss__MessagingModeType * SOAP_FMAC4 soap_get_mss__MessagingModeType(struct soap *soap, enum mss__MessagingModeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MessagingModeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2mss__MessagingModeType(struct soap *soap, const char *s, enum mss__MessagingModeType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_mss__MessagingModeType, s);
	if (map)
		*a = (enum mss__MessagingModeType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum mss__MessagingModeType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum mss__MessagingModeType * SOAP_FMAC4 soap_in_mss__MessagingModeType(struct soap *soap, const char *tag, enum mss__MessagingModeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum mss__MessagingModeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MessagingModeType, sizeof(enum mss__MessagingModeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2mss__MessagingModeType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum mss__MessagingModeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MessagingModeType, 0, sizeof(enum mss__MessagingModeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__SignatureProfileComparisonType(struct soap *soap, enum mss__SignatureProfileComparisonType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_mss__SignatureProfileComparisonType
	*a = SOAP_DEFAULT_mss__SignatureProfileComparisonType;
#else
	*a = (enum mss__SignatureProfileComparisonType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__SignatureProfileComparisonType(struct soap *soap, const enum mss__SignatureProfileComparisonType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__SignatureProfileComparisonType);
	if (soap_out_mss__SignatureProfileComparisonType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_mss__SignatureProfileComparisonType[] =
{	{ (long)exact, "exact" },
	{ (long)minimum, "minimum" },
	{ (long)better, "better" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_mss__SignatureProfileComparisonType2s(struct soap *soap, enum mss__SignatureProfileComparisonType n)
{	const char *s = soap_code_str(soap_codes_mss__SignatureProfileComparisonType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__SignatureProfileComparisonType(struct soap *soap, const char *tag, int id, const enum mss__SignatureProfileComparisonType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__SignatureProfileComparisonType), type);
	soap_send(soap, soap_mss__SignatureProfileComparisonType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum mss__SignatureProfileComparisonType * SOAP_FMAC4 soap_get_mss__SignatureProfileComparisonType(struct soap *soap, enum mss__SignatureProfileComparisonType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__SignatureProfileComparisonType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2mss__SignatureProfileComparisonType(struct soap *soap, const char *s, enum mss__SignatureProfileComparisonType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_mss__SignatureProfileComparisonType, s);
	if (map)
		*a = (enum mss__SignatureProfileComparisonType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum mss__SignatureProfileComparisonType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum mss__SignatureProfileComparisonType * SOAP_FMAC4 soap_in_mss__SignatureProfileComparisonType(struct soap *soap, const char *tag, enum mss__SignatureProfileComparisonType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum mss__SignatureProfileComparisonType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__SignatureProfileComparisonType, sizeof(enum mss__SignatureProfileComparisonType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2mss__SignatureProfileComparisonType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum mss__SignatureProfileComparisonType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__SignatureProfileComparisonType, 0, sizeof(enum mss__SignatureProfileComparisonType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSS_USCOREStatusReq(struct soap *soap, const struct mss__MSS_USCOREStatusReq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->MajorVersion, SOAP_TYPE_xsd__positiveInteger);
	soap_embedded(soap, &a->MinorVersion, SOAP_TYPE_xsd__positiveInteger);
	soap_serialize_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_serialize_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_embedded(soap, &a->MSSP_USCORETransID, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSS_USCOREStatusReq(struct soap *soap, struct mss__MSS_USCOREStatusReq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__positiveInteger(soap, &a->MajorVersion);
	soap_default_xsd__positiveInteger(soap, &a->MinorVersion);
	soap_default_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_default_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_default_xsd__positiveInteger(soap, &a->MSSP_USCORETransID);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSS_USCOREStatusReq(struct soap *soap, const struct mss__MSS_USCOREStatusReq *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSS_USCOREStatusReq);
	if (soap_out_mss__MSS_USCOREStatusReq(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSS_USCOREStatusReq(struct soap *soap, const char *tag, int id, const struct mss__MSS_USCOREStatusReq *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSS_USCOREStatusReq), type);
	soap_out_xsd__positiveInteger(soap, "mss:MajorVersion", -1, &a->MajorVersion, "");
	soap_out_xsd__positiveInteger(soap, "mss:MinorVersion", -1, &a->MinorVersion, "");
	soap_out_mss__AP_InfoType(soap, "mss:AP_Info", -1, &a->AP_USCOREInfo, "");
	soap_out_mss__MSSP_InfoType(soap, "mss:MSSP_Info", -1, &a->MSSP_USCOREInfo, "");
	soap_out_xsd__positiveInteger(soap, "mss:MSSP_TransID", -1, &a->MSSP_USCORETransID, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusReq * SOAP_FMAC4 soap_get_mss__MSS_USCOREStatusReq(struct soap *soap, struct mss__MSS_USCOREStatusReq *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSS_USCOREStatusReq(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusReq * SOAP_FMAC4 soap_in_mss__MSS_USCOREStatusReq(struct soap *soap, const char *tag, struct mss__MSS_USCOREStatusReq *a, const char *type)
{
	short soap_flag_MajorVersion = 1, soap_flag_MinorVersion = 1, soap_flag_AP_USCOREInfo = 1, soap_flag_MSSP_USCOREInfo = 1, soap_flag_MSSP_USCORETransID = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSS_USCOREStatusReq *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSS_USCOREStatusReq, sizeof(struct mss__MSS_USCOREStatusReq), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSS_USCOREStatusReq(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MajorVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__positiveInteger(soap, "mss:MajorVersion", &a->MajorVersion, "xsd:positiveInteger"))
				{	soap_flag_MajorVersion--;
					continue;
				}
			if (soap_flag_MinorVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__positiveInteger(soap, "mss:MinorVersion", &a->MinorVersion, "xsd:positiveInteger"))
				{	soap_flag_MinorVersion--;
					continue;
				}
			if (soap_flag_AP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__AP_InfoType(soap, "mss:AP_Info", &a->AP_USCOREInfo, "mss:AP-InfoType"))
				{	soap_flag_AP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MSSP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MSSP_InfoType(soap, "mss:MSSP_Info", &a->MSSP_USCOREInfo, "mss:MSSP-InfoType"))
				{	soap_flag_MSSP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MSSP_USCORETransID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__positiveInteger(soap, "mss:MSSP_TransID", &a->MSSP_USCORETransID, "xsd:positiveInteger"))
				{	soap_flag_MSSP_USCORETransID--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_MajorVersion > 0 || soap_flag_MinorVersion > 0 || soap_flag_AP_USCOREInfo > 0 || soap_flag_MSSP_USCOREInfo > 0 || soap_flag_MSSP_USCORETransID > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCOREStatusReq *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSS_USCOREStatusReq, 0, sizeof(struct mss__MSS_USCOREStatusReq), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSS_USCOREStatusResp(struct soap *soap, const struct mss__MSS_USCOREStatusResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_serialize_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_serialize_mss__MobileUserType(soap, &a->MobileUser);
	soap_serialize_mss__StatusType(soap, &a->Status);
	soap_serialize_PointerTomss__SignatureType(soap, &a->MSS_USCORESignature);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSS_USCOREStatusResp(struct soap *soap, struct mss__MSS_USCOREStatusResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_default_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_default_xsd__positiveInteger(soap, &a->MajorVersion);
	soap_default_xsd__positiveInteger(soap, &a->MinorVersion);
	soap_default_mss__MobileUserType(soap, &a->MobileUser);
	soap_default_mss__StatusType(soap, &a->Status);
	a->MSS_USCORESignature = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSS_USCOREStatusResp(struct soap *soap, const struct mss__MSS_USCOREStatusResp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSS_USCOREStatusResp);
	if (soap_out_mss__MSS_USCOREStatusResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSS_USCOREStatusResp(struct soap *soap, const char *tag, int id, const struct mss__MSS_USCOREStatusResp *a, const char *type)
{
	soap_set_attr(soap, "mss:MajorVersion", soap_unsignedLong2s(soap, a->MajorVersion));
	soap_set_attr(soap, "mss:MinorVersion", soap_unsignedLong2s(soap, a->MinorVersion));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSS_USCOREStatusResp), type);
	soap_element_result(soap, "mss:AP_Info");
	soap_out_mss__AP_InfoType(soap, "mss:AP_Info", -1, &a->AP_USCOREInfo, "");
	soap_out_mss__MSSP_InfoType(soap, "mss:MSSP_Info", -1, &a->MSSP_USCOREInfo, "");
	soap_out_mss__MobileUserType(soap, "mss:MobileUser", -1, &a->MobileUser, "");
	soap_out_mss__StatusType(soap, "mss:Status", -1, &a->Status, "");
	soap_out_PointerTomss__SignatureType(soap, "mss:MSS_Signature", -1, &a->MSS_USCORESignature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusResp * SOAP_FMAC4 soap_get_mss__MSS_USCOREStatusResp(struct soap *soap, struct mss__MSS_USCOREStatusResp *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSS_USCOREStatusResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusResp * SOAP_FMAC4 soap_in_mss__MSS_USCOREStatusResp(struct soap *soap, const char *tag, struct mss__MSS_USCOREStatusResp *a, const char *type)
{
	short soap_flag_AP_USCOREInfo = 1, soap_flag_MSSP_USCOREInfo = 1, soap_flag_MobileUser = 1, soap_flag_Status = 1, soap_flag_MSS_USCORESignature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSS_USCOREStatusResp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSS_USCOREStatusResp, sizeof(struct mss__MSS_USCOREStatusResp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSS_USCOREStatusResp(soap, a);
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MajorVersion", 0), &a->MajorVersion))
		return NULL;
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MinorVersion", 0), &a->MinorVersion))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__AP_InfoType(soap, "mss:AP_Info", &a->AP_USCOREInfo, "mss:AP-InfoType"))
				{	soap_flag_AP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MSSP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MSSP_InfoType(soap, "mss:MSSP_Info", &a->MSSP_USCOREInfo, "mss:MSSP-InfoType"))
				{	soap_flag_MSSP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MobileUser && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MobileUserType(soap, "mss:MobileUser", &a->MobileUser, "mss:MobileUserType"))
				{	soap_flag_MobileUser--;
					continue;
				}
			if (soap_flag_Status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__StatusType(soap, "mss:Status", &a->Status, "mss:StatusType"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_MSS_USCORESignature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__SignatureType(soap, "mss:MSS_Signature", &a->MSS_USCORESignature, "mss:SignatureType"))
				{	soap_flag_MSS_USCORESignature--;
					continue;
				}
			soap_check_result(soap, "mss:AP_Info");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AP_USCOREInfo > 0 || soap_flag_MSSP_USCOREInfo > 0 || soap_flag_MobileUser > 0 || soap_flag_Status > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCOREStatusResp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSS_USCOREStatusResp, 0, sizeof(struct mss__MSS_USCOREStatusResp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSS_USCORESignatureReq(struct soap *soap, const struct mss__MSS_USCORESignatureReq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_serialize_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_serialize_mss__MobileUserType(soap, &a->MobileUser);
	soap_embedded(soap, &a->DataToBeSigned, SOAP_TYPE_mss__DataType);
	soap_serialize_mss__DataType(soap, &a->DataToBeSigned);
	soap_serialize_PointerTomss__DataType(soap, &a->DataToBeDisplayed);
	soap_serialize_PointerTomss__mssURIType(soap, &a->SignatureProfile);
	soap_serialize_PointerTomss__mssURIType(soap, &a->mssFormat);
	soap_serialize_PointerTomss__KeyReferenceType(soap, &a->KeyReference);
	soap_serialize_PointerTomss__SignatureProfileComparisonType(soap, &a->mss__SignatureProfileComparison);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSS_USCORESignatureReq(struct soap *soap, struct mss__MSS_USCORESignatureReq *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__positiveInteger(soap, &a->MajorVersion);
	soap_default_xsd__positiveInteger(soap, &a->MinorVersion);
	soap_default_xsd__dateTime(soap, &a->ValidityDate);
	a->TimeOut = NULL;
	soap_default_mss__MessagingModeType(soap, &a->MessagingMode);
	soap_default_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_default_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_default_mss__MobileUserType(soap, &a->MobileUser);
	soap_default_mss__DataType(soap, &a->DataToBeSigned);
	a->DataToBeDisplayed = NULL;
	a->SignatureProfile = NULL;
	a->mssFormat = NULL;
	a->KeyReference = NULL;
	a->mss__SignatureProfileComparison = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSS_USCORESignatureReq(struct soap *soap, const struct mss__MSS_USCORESignatureReq *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSS_USCORESignatureReq);
	if (soap_out_mss__MSS_USCORESignatureReq(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSS_USCORESignatureReq(struct soap *soap, const char *tag, int id, const struct mss__MSS_USCORESignatureReq *a, const char *type)
{
	soap_set_attr(soap, "mss:MajorVersion", soap_unsignedLong2s(soap, a->MajorVersion));
	soap_set_attr(soap, "mss:MinorVersion", soap_unsignedLong2s(soap, a->MinorVersion));
	if (a->ValidityDate)
		soap_set_attr(soap, "mss:ValidityDate", a->ValidityDate);
	if (a->TimeOut)
		soap_set_attr(soap, "mss:TimeOut", soap_unsignedLong2s(soap, *a->TimeOut));
	soap_set_attr(soap, "mss:MessagingMode", soap_mss__MessagingModeType2s(soap, a->MessagingMode));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSS_USCORESignatureReq), type);
	soap_out_mss__AP_InfoType(soap, "mss:AP_Info", -1, &a->AP_USCOREInfo, "");
	soap_out_mss__MSSP_InfoType(soap, "mss:MSSP_Info", -1, &a->MSSP_USCOREInfo, "");
	soap_out_mss__MobileUserType(soap, "mss:MobileUser", -1, &a->MobileUser, "");
	soap_out_mss__DataType(soap, "mss:DataToBeSigned", -1, &a->DataToBeSigned, "");
	soap_out_PointerTomss__DataType(soap, "mss:DataToBeDisplayed", -1, &a->DataToBeDisplayed, "");
	soap_out_PointerTomss__mssURIType(soap, "mss:SignatureProfile", -1, &a->SignatureProfile, "");
	soap_out_PointerTomss__mssURIType(soap, "mss:mssFormat", -1, &a->mssFormat, "");
	soap_out_PointerTomss__KeyReferenceType(soap, "mss:KeyReference", -1, &a->KeyReference, "");
	soap_out_PointerTomss__SignatureProfileComparisonType(soap, "mss:SignatureProfileComparison", -1, &a->mss__SignatureProfileComparison, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureReq * SOAP_FMAC4 soap_get_mss__MSS_USCORESignatureReq(struct soap *soap, struct mss__MSS_USCORESignatureReq *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSS_USCORESignatureReq(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureReq * SOAP_FMAC4 soap_in_mss__MSS_USCORESignatureReq(struct soap *soap, const char *tag, struct mss__MSS_USCORESignatureReq *a, const char *type)
{
	short soap_flag_AP_USCOREInfo = 1, soap_flag_MSSP_USCOREInfo = 1, soap_flag_MobileUser = 1, soap_flag_DataToBeSigned = 1, soap_flag_DataToBeDisplayed = 1, soap_flag_SignatureProfile = 1, soap_flag_mssFormat = 1, soap_flag_KeyReference = 1, soap_flag_mss__SignatureProfileComparison = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSS_USCORESignatureReq *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSS_USCORESignatureReq, sizeof(struct mss__MSS_USCORESignatureReq), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSS_USCORESignatureReq(soap, a);
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MajorVersion", 0), &a->MajorVersion))
		return NULL;
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MinorVersion", 0), &a->MinorVersion))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:ValidityDate", 0), &a->ValidityDate))
		return NULL;
	{	const char *t = soap_attr_value(soap, "mss:TimeOut", 0);
		if (t)
		{	if (!(a->TimeOut = (unsigned long *)soap_malloc(soap, sizeof(unsigned long))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2unsignedLong(soap, t, a->TimeOut))
		return NULL;
		}
	}
	if (soap_s2mss__MessagingModeType(soap, soap_attr_value(soap, "mss:MessagingMode", 0), &a->MessagingMode))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__AP_InfoType(soap, "mss:AP_Info", &a->AP_USCOREInfo, "mss:AP-InfoType"))
				{	soap_flag_AP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MSSP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MSSP_InfoType(soap, "mss:MSSP_Info", &a->MSSP_USCOREInfo, "mss:MSSP-InfoType"))
				{	soap_flag_MSSP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MobileUser && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MobileUserType(soap, "mss:MobileUser", &a->MobileUser, "mss:MobileUserType"))
				{	soap_flag_MobileUser--;
					continue;
				}
			if (soap_flag_DataToBeSigned && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__DataType(soap, "mss:DataToBeSigned", &a->DataToBeSigned, "mss:DataType"))
				{	soap_flag_DataToBeSigned--;
					continue;
				}
			if (soap_flag_DataToBeDisplayed && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__DataType(soap, "mss:DataToBeDisplayed", &a->DataToBeDisplayed, "mss:DataType"))
				{	soap_flag_DataToBeDisplayed--;
					continue;
				}
			if (soap_flag_SignatureProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__mssURIType(soap, "mss:SignatureProfile", &a->SignatureProfile, "mss:mssURIType"))
				{	soap_flag_SignatureProfile--;
					continue;
				}
			if (soap_flag_mssFormat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__mssURIType(soap, "mss:mssFormat", &a->mssFormat, "mss:mssURIType"))
				{	soap_flag_mssFormat--;
					continue;
				}
			if (soap_flag_KeyReference && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__KeyReferenceType(soap, "mss:KeyReference", &a->KeyReference, "mss:KeyReferenceType"))
				{	soap_flag_KeyReference--;
					continue;
				}
			if (soap_flag_mss__SignatureProfileComparison && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__SignatureProfileComparisonType(soap, "mss:SignatureProfileComparison", &a->mss__SignatureProfileComparison, "mss:SignatureProfileComparisonType"))
				{	soap_flag_mss__SignatureProfileComparison--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AP_USCOREInfo > 0 || soap_flag_MSSP_USCOREInfo > 0 || soap_flag_MobileUser > 0 || soap_flag_DataToBeSigned > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCORESignatureReq *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSS_USCORESignatureReq, 0, sizeof(struct mss__MSS_USCORESignatureReq), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSS_USCORESignatureResp(struct soap *soap, const struct mss__MSS_USCORESignatureResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_serialize_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_serialize_mss__MobileUserType(soap, &a->MobileUser);
	soap_serialize_mss__StatusType(soap, &a->Status);
	soap_serialize_PointerTomss__mssURIType(soap, &a->SignatureProfile);
	soap_serialize_PointerTomss__SignatureType(soap, &a->MSS_USCORESignature);
	soap_embedded(soap, &a->MSSP_USCORETransID, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSS_USCORESignatureResp(struct soap *soap, struct mss__MSS_USCORESignatureResp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_mss__AP_InfoType(soap, &a->AP_USCOREInfo);
	soap_default_mss__MSSP_InfoType(soap, &a->MSSP_USCOREInfo);
	soap_default_xsd__positiveInteger(soap, &a->MajorVersion);
	soap_default_xsd__positiveInteger(soap, &a->MinorVersion);
	soap_default_mss__MobileUserType(soap, &a->MobileUser);
	soap_default_mss__StatusType(soap, &a->Status);
	a->SignatureProfile = NULL;
	a->MSS_USCORESignature = NULL;
	soap_default_xsd__positiveInteger(soap, &a->MSSP_USCORETransID);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSS_USCORESignatureResp(struct soap *soap, const struct mss__MSS_USCORESignatureResp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSS_USCORESignatureResp);
	if (soap_out_mss__MSS_USCORESignatureResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSS_USCORESignatureResp(struct soap *soap, const char *tag, int id, const struct mss__MSS_USCORESignatureResp *a, const char *type)
{
	soap_set_attr(soap, "mss:MajorVersion", soap_unsignedLong2s(soap, a->MajorVersion));
	soap_set_attr(soap, "mss:MinorVersion", soap_unsignedLong2s(soap, a->MinorVersion));
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSS_USCORESignatureResp), type);
	soap_element_result(soap, "mss:AP_Info");
	soap_out_mss__AP_InfoType(soap, "mss:AP_Info", -1, &a->AP_USCOREInfo, "");
	soap_out_mss__MSSP_InfoType(soap, "mss:MSSP_Info", -1, &a->MSSP_USCOREInfo, "");
	soap_out_mss__MobileUserType(soap, "mss:MobileUser", -1, &a->MobileUser, "");
	soap_out_mss__StatusType(soap, "mss:Status", -1, &a->Status, "");
	soap_out_PointerTomss__mssURIType(soap, "mss:SignatureProfile", -1, &a->SignatureProfile, "");
	soap_out_PointerTomss__SignatureType(soap, "mss:MSS_Signature", -1, &a->MSS_USCORESignature, "");
	soap_out_xsd__positiveInteger(soap, "mss:MSSP_TransID", -1, &a->MSSP_USCORETransID, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureResp * SOAP_FMAC4 soap_get_mss__MSS_USCORESignatureResp(struct soap *soap, struct mss__MSS_USCORESignatureResp *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSS_USCORESignatureResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureResp * SOAP_FMAC4 soap_in_mss__MSS_USCORESignatureResp(struct soap *soap, const char *tag, struct mss__MSS_USCORESignatureResp *a, const char *type)
{
	short soap_flag_AP_USCOREInfo = 1, soap_flag_MSSP_USCOREInfo = 1, soap_flag_MobileUser = 1, soap_flag_Status = 1, soap_flag_SignatureProfile = 1, soap_flag_MSS_USCORESignature = 1, soap_flag_MSSP_USCORETransID = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSS_USCORESignatureResp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSS_USCORESignatureResp, sizeof(struct mss__MSS_USCORESignatureResp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSS_USCORESignatureResp(soap, a);
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MajorVersion", 0), &a->MajorVersion))
		return NULL;
	if (soap_s2unsignedLong(soap, soap_attr_value(soap, "mss:MinorVersion", 0), &a->MinorVersion))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__AP_InfoType(soap, "mss:AP_Info", &a->AP_USCOREInfo, "mss:AP-InfoType"))
				{	soap_flag_AP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MSSP_USCOREInfo && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MSSP_InfoType(soap, "mss:MSSP_Info", &a->MSSP_USCOREInfo, "mss:MSSP-InfoType"))
				{	soap_flag_MSSP_USCOREInfo--;
					continue;
				}
			if (soap_flag_MobileUser && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MobileUserType(soap, "mss:MobileUser", &a->MobileUser, "mss:MobileUserType"))
				{	soap_flag_MobileUser--;
					continue;
				}
			if (soap_flag_Status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__StatusType(soap, "mss:Status", &a->Status, "mss:StatusType"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_SignatureProfile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__mssURIType(soap, "mss:SignatureProfile", &a->SignatureProfile, "mss:mssURIType"))
				{	soap_flag_SignatureProfile--;
					continue;
				}
			if (soap_flag_MSS_USCORESignature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__SignatureType(soap, "mss:MSS_Signature", &a->MSS_USCORESignature, "mss:SignatureType"))
				{	soap_flag_MSS_USCORESignature--;
					continue;
				}
			if (soap_flag_MSSP_USCORETransID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__positiveInteger(soap, "mss:MSSP_TransID", &a->MSSP_USCORETransID, "xsd:positiveInteger"))
				{	soap_flag_MSSP_USCORETransID--;
					continue;
				}
			soap_check_result(soap, "mss:AP_Info");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_AP_USCOREInfo > 0 || soap_flag_MSSP_USCOREInfo > 0 || soap_flag_MobileUser > 0 || soap_flag_Status > 0 || soap_flag_MSSP_USCORETransID > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCORESignatureResp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSS_USCORESignatureResp, 0, sizeof(struct mss__MSS_USCORESignatureResp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__SignatureType(struct soap *soap, const struct mss__SignatureType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->XMLSignature);
	soap_serialize_PointerToxsd__base64Binary(soap, &a->Base64Signature);
	soap_serialize_xsd__string(soap, &a->XAdESSignature);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__SignatureType(struct soap *soap, struct mss__SignatureType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->XMLSignature);
	a->Base64Signature = NULL;
	soap_default_xsd__string(soap, &a->XAdESSignature);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__SignatureType(struct soap *soap, const struct mss__SignatureType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__SignatureType);
	if (soap_out_mss__SignatureType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__SignatureType(struct soap *soap, const char *tag, int id, const struct mss__SignatureType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__SignatureType), type);
	soap_out_xsd__string(soap, "mss:XMLSignature", -1, &a->XMLSignature, "");
	soap_out_PointerToxsd__base64Binary(soap, "mss:Base64Signature", -1, &a->Base64Signature, "");
	soap_out_xsd__string(soap, "mss:XAdESSignature", -1, &a->XAdESSignature, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__SignatureType * SOAP_FMAC4 soap_get_mss__SignatureType(struct soap *soap, struct mss__SignatureType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__SignatureType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__SignatureType * SOAP_FMAC4 soap_in_mss__SignatureType(struct soap *soap, const char *tag, struct mss__SignatureType *a, const char *type)
{
	short soap_flag_XMLSignature = 1, soap_flag_Base64Signature = 1, soap_flag_XAdESSignature = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__SignatureType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__SignatureType, sizeof(struct mss__SignatureType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__SignatureType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_XMLSignature && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:XMLSignature", &a->XMLSignature, "xsd:string"))
				{	soap_flag_XMLSignature--;
					continue;
				}
			if (soap_flag_Base64Signature && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "mss:Base64Signature", &a->Base64Signature, "xsd:base64Binary"))
				{	soap_flag_Base64Signature--;
					continue;
				}
			if (soap_flag_XAdESSignature && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:XAdESSignature", &a->XAdESSignature, "xsd:string"))
				{	soap_flag_XAdESSignature--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__SignatureType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__SignatureType, 0, sizeof(struct mss__SignatureType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__StatusType(struct soap *soap, const struct mss__StatusType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__StatusCodeType(soap, &a->StatusCode);
	soap_serialize_xsd__string(soap, &a->StatusMessage);
	soap_serialize_xsd__string(soap, &a->StatusDetail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__StatusType(struct soap *soap, struct mss__StatusType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_mss__StatusCodeType(soap, &a->StatusCode);
	soap_default_xsd__string(soap, &a->StatusMessage);
	soap_default_xsd__string(soap, &a->StatusDetail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__StatusType(struct soap *soap, const struct mss__StatusType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__StatusType);
	if (soap_out_mss__StatusType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__StatusType(struct soap *soap, const char *tag, int id, const struct mss__StatusType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__StatusType), type);
	soap_out_mss__StatusCodeType(soap, "mss:StatusCode", -1, &a->StatusCode, "");
	soap_out_xsd__string(soap, "mss:StatusMessage", -1, &a->StatusMessage, "");
	soap_out_xsd__string(soap, "mss:StatusDetail", -1, &a->StatusDetail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__StatusType * SOAP_FMAC4 soap_get_mss__StatusType(struct soap *soap, struct mss__StatusType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__StatusType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__StatusType * SOAP_FMAC4 soap_in_mss__StatusType(struct soap *soap, const char *tag, struct mss__StatusType *a, const char *type)
{
	short soap_flag_StatusCode = 1, soap_flag_StatusMessage = 1, soap_flag_StatusDetail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__StatusType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__StatusType, sizeof(struct mss__StatusType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__StatusType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_StatusCode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__StatusCodeType(soap, "mss:StatusCode", &a->StatusCode, "mss:StatusCodeType"))
				{	soap_flag_StatusCode--;
					continue;
				}
			if (soap_flag_StatusMessage && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:StatusMessage", &a->StatusMessage, "xsd:string"))
				{	soap_flag_StatusMessage--;
					continue;
				}
			if (soap_flag_StatusDetail && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:StatusDetail", &a->StatusDetail, "xsd:string"))
				{	soap_flag_StatusDetail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_StatusCode > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__StatusType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__StatusType, 0, sizeof(struct mss__StatusType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__StatusCodeType(struct soap *soap, const struct mss__StatusCodeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__StatusCodeType(struct soap *soap, struct mss__StatusCodeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->__item);
	soap_default_int(soap, &a->Value);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__StatusCodeType(struct soap *soap, const struct mss__StatusCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__StatusCodeType);
	if (soap_out_mss__StatusCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__StatusCodeType(struct soap *soap, const char *tag, int id, const struct mss__StatusCodeType *a, const char *type)
{
	soap_set_attr(soap, "mss:Value", soap_int2s(soap, a->Value));
	return soap_out_xsd__string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct mss__StatusCodeType * SOAP_FMAC4 soap_get_mss__StatusCodeType(struct soap *soap, struct mss__StatusCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__StatusCodeType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__StatusCodeType * SOAP_FMAC4 soap_in_mss__StatusCodeType(struct soap *soap, const char *tag, struct mss__StatusCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct mss__StatusCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__StatusCodeType, sizeof(struct mss__StatusCodeType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_mss__StatusCodeType(soap, a);
	if (soap_s2int(soap, soap_attr_value(soap, "mss:Value", 0), &a->Value))
		return NULL;
	if (!soap_in_xsd__string(soap, tag, &a->__item, "mss:StatusCodeType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__KeyReferenceType(struct soap *soap, const struct mss__KeyReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->CertificateURL);
	soap_serialize_xsd__string(soap, &a->CertificateIssuerDN);
	soap_serialize_PointerTomss__DigestAlgAndValueType(soap, &a->HashOfUsersPublicKey);
	soap_serialize_PointerTomss__DigestAlgAndValueType(soap, &a->HashOfCAPublicKey);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__KeyReferenceType(struct soap *soap, struct mss__KeyReferenceType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->CertificateURL);
	soap_default_xsd__string(soap, &a->CertificateIssuerDN);
	a->HashOfUsersPublicKey = NULL;
	a->HashOfCAPublicKey = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__KeyReferenceType(struct soap *soap, const struct mss__KeyReferenceType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__KeyReferenceType);
	if (soap_out_mss__KeyReferenceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__KeyReferenceType(struct soap *soap, const char *tag, int id, const struct mss__KeyReferenceType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__KeyReferenceType), type);
	soap_out_xsd__string(soap, "mss:CertificateURL", -1, &a->CertificateURL, "");
	soap_out_xsd__string(soap, "mss:CertificateIssuerDN", -1, &a->CertificateIssuerDN, "");
	soap_out_PointerTomss__DigestAlgAndValueType(soap, "mss:HashOfUsersPublicKey", -1, &a->HashOfUsersPublicKey, "");
	soap_out_PointerTomss__DigestAlgAndValueType(soap, "mss:HashOfCAPublicKey", -1, &a->HashOfCAPublicKey, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__KeyReferenceType * SOAP_FMAC4 soap_get_mss__KeyReferenceType(struct soap *soap, struct mss__KeyReferenceType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__KeyReferenceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__KeyReferenceType * SOAP_FMAC4 soap_in_mss__KeyReferenceType(struct soap *soap, const char *tag, struct mss__KeyReferenceType *a, const char *type)
{
	short soap_flag_CertificateURL = 1, soap_flag_CertificateIssuerDN = 1, soap_flag_HashOfUsersPublicKey = 1, soap_flag_HashOfCAPublicKey = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__KeyReferenceType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__KeyReferenceType, sizeof(struct mss__KeyReferenceType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__KeyReferenceType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CertificateURL && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:CertificateURL", &a->CertificateURL, "xsd:string"))
				{	soap_flag_CertificateURL--;
					continue;
				}
			if (soap_flag_CertificateIssuerDN && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:CertificateIssuerDN", &a->CertificateIssuerDN, "xsd:string"))
				{	soap_flag_CertificateIssuerDN--;
					continue;
				}
			if (soap_flag_HashOfUsersPublicKey && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__DigestAlgAndValueType(soap, "mss:HashOfUsersPublicKey", &a->HashOfUsersPublicKey, "mss:DigestAlgAndValueType"))
				{	soap_flag_HashOfUsersPublicKey--;
					continue;
				}
			if (soap_flag_HashOfCAPublicKey && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__DigestAlgAndValueType(soap, "mss:HashOfCAPublicKey", &a->HashOfCAPublicKey, "mss:DigestAlgAndValueType"))
				{	soap_flag_HashOfCAPublicKey--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__KeyReferenceType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__KeyReferenceType, 0, sizeof(struct mss__KeyReferenceType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MSSP_InfoType(struct soap *soap, const struct mss__MSSP_InfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__MeshMemberType(soap, &a->MSSP_USCOREID);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MSSP_InfoType(struct soap *soap, struct mss__MSSP_InfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_mss__MeshMemberType(soap, &a->MSSP_USCOREID);
	soap_default_xsd__dateTime(soap, &a->Instant);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MSSP_InfoType(struct soap *soap, const struct mss__MSSP_InfoType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MSSP_InfoType);
	if (soap_out_mss__MSSP_InfoType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MSSP_InfoType(struct soap *soap, const char *tag, int id, const struct mss__MSSP_InfoType *a, const char *type)
{
	if (a->Instant)
		soap_set_attr(soap, "mss:Instant", a->Instant);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MSSP_InfoType), type);
	soap_out_mss__MeshMemberType(soap, "mss:MSSP_ID", -1, &a->MSSP_USCOREID, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MSSP_InfoType * SOAP_FMAC4 soap_get_mss__MSSP_InfoType(struct soap *soap, struct mss__MSSP_InfoType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MSSP_InfoType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSSP_InfoType * SOAP_FMAC4 soap_in_mss__MSSP_InfoType(struct soap *soap, const char *tag, struct mss__MSSP_InfoType *a, const char *type)
{
	short soap_flag_MSSP_USCOREID = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MSSP_InfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MSSP_InfoType, sizeof(struct mss__MSSP_InfoType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MSSP_InfoType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "mss:Instant", 0), &a->Instant))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MSSP_USCOREID && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MeshMemberType(soap, "mss:MSSP_ID", &a->MSSP_USCOREID, "mss:MeshMemberType"))
				{	soap_flag_MSSP_USCOREID--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_MSSP_USCOREID > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MSSP_InfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MSSP_InfoType, 0, sizeof(struct mss__MSSP_InfoType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__AP_InfoType(struct soap *soap, const struct mss__AP_InfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__AP_InfoType(struct soap *soap, struct mss__AP_InfoType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->AP_USCOREID);
	soap_default_xsd__string(soap, &a->AP_USCORETransID);
	soap_default_xsd__string(soap, &a->AP_USCOREPWD);
	soap_default_xsd__dateTime(soap, &a->Instant);
	soap_default_xsd__string(soap, &a->AP_USCOREURL);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__AP_InfoType(struct soap *soap, const struct mss__AP_InfoType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__AP_InfoType);
	if (soap_out_mss__AP_InfoType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__AP_InfoType(struct soap *soap, const char *tag, int id, const struct mss__AP_InfoType *a, const char *type)
{
	if (a->AP_USCOREID)
		soap_set_attr(soap, "mss:AP_ID", a->AP_USCOREID);
	if (a->AP_USCORETransID)
		soap_set_attr(soap, "mss:AP_TransID", a->AP_USCORETransID);
	if (a->AP_USCOREPWD)
		soap_set_attr(soap, "mss:AP_PWD", a->AP_USCOREPWD);
	if (a->Instant)
		soap_set_attr(soap, "mss:Instant", a->Instant);
	if (a->AP_USCOREURL)
		soap_set_attr(soap, "mss:AP_URL", a->AP_USCOREURL);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__AP_InfoType), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__AP_InfoType * SOAP_FMAC4 soap_get_mss__AP_InfoType(struct soap *soap, struct mss__AP_InfoType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__AP_InfoType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__AP_InfoType * SOAP_FMAC4 soap_in_mss__AP_InfoType(struct soap *soap, const char *tag, struct mss__AP_InfoType *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__AP_InfoType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__AP_InfoType, sizeof(struct mss__AP_InfoType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__AP_InfoType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "mss:AP_ID", 0), &a->AP_USCOREID))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:AP_TransID", 0), &a->AP_USCORETransID))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:AP_PWD", 0), &a->AP_USCOREPWD))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:Instant", 0), &a->Instant))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:AP_URL", 0), &a->AP_USCOREURL))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__AP_InfoType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__AP_InfoType, 0, sizeof(struct mss__AP_InfoType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__mssURIType(struct soap *soap, const struct mss__mssURIType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->mss__mssUri);
	soap_serialize_PointerTomss__DigestAlgAndValueType(soap, &a->DigestAlgAndValue);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__mssURIType(struct soap *soap, struct mss__mssURIType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->mss__mssUri);
	a->DigestAlgAndValue = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__mssURIType(struct soap *soap, const struct mss__mssURIType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__mssURIType);
	if (soap_out_mss__mssURIType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__mssURIType(struct soap *soap, const char *tag, int id, const struct mss__mssURIType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__mssURIType), type);
	soap_out_xsd__string(soap, "mss:mssUri", -1, &a->mss__mssUri, "");
	soap_out_PointerTomss__DigestAlgAndValueType(soap, "mss:DigestAlgAndValue", -1, &a->DigestAlgAndValue, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__mssURIType * SOAP_FMAC4 soap_get_mss__mssURIType(struct soap *soap, struct mss__mssURIType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__mssURIType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__mssURIType * SOAP_FMAC4 soap_in_mss__mssURIType(struct soap *soap, const char *tag, struct mss__mssURIType *a, const char *type)
{
	short soap_flag_mss__mssUri = 1, soap_flag_DigestAlgAndValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__mssURIType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__mssURIType, sizeof(struct mss__mssURIType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__mssURIType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mss__mssUri && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:mssUri", &a->mss__mssUri, "xsd:string"))
				{	soap_flag_mss__mssUri--;
					continue;
				}
			if (soap_flag_DigestAlgAndValue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTomss__DigestAlgAndValueType(soap, "mss:DigestAlgAndValue", &a->DigestAlgAndValue, "mss:DigestAlgAndValueType"))
				{	soap_flag_DigestAlgAndValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__mssURIType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__mssURIType, 0, sizeof(struct mss__mssURIType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__DigestAlgAndValueType(struct soap *soap, const struct mss__DigestAlgAndValueType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_DigestMethodType(soap, &a->DigestMethod);
	soap_embedded(soap, &a->DigestValue, SOAP_TYPE_xsd__base64Binary);
	soap_serialize_xsd__base64Binary(soap, &a->DigestValue);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__DigestAlgAndValueType(struct soap *soap, struct mss__DigestAlgAndValueType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_DigestMethodType(soap, &a->DigestMethod);
	soap_default_xsd__base64Binary(soap, &a->DigestValue);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__DigestAlgAndValueType(struct soap *soap, const struct mss__DigestAlgAndValueType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__DigestAlgAndValueType);
	if (soap_out_mss__DigestAlgAndValueType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__DigestAlgAndValueType(struct soap *soap, const char *tag, int id, const struct mss__DigestAlgAndValueType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__DigestAlgAndValueType), type);
	soap_out_DigestMethodType(soap, "mss:DigestMethod", -1, &a->DigestMethod, "");
	soap_out_xsd__base64Binary(soap, "mss:DigestValue", -1, &a->DigestValue, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__DigestAlgAndValueType * SOAP_FMAC4 soap_get_mss__DigestAlgAndValueType(struct soap *soap, struct mss__DigestAlgAndValueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__DigestAlgAndValueType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__DigestAlgAndValueType * SOAP_FMAC4 soap_in_mss__DigestAlgAndValueType(struct soap *soap, const char *tag, struct mss__DigestAlgAndValueType *a, const char *type)
{
	short soap_flag_DigestMethod = 1, soap_flag_DigestValue = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__DigestAlgAndValueType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__DigestAlgAndValueType, sizeof(struct mss__DigestAlgAndValueType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__DigestAlgAndValueType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DigestMethod && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_DigestMethodType(soap, "mss:DigestMethod", &a->DigestMethod, "DigestMethodType"))
				{	soap_flag_DigestMethod--;
					continue;
				}
			if (soap_flag_DigestValue && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__base64Binary(soap, "mss:DigestValue", &a->DigestValue, "xsd:base64Binary"))
				{	soap_flag_DigestValue--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_DigestMethod > 0 || soap_flag_DigestValue > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__DigestAlgAndValueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__DigestAlgAndValueType, 0, sizeof(struct mss__DigestAlgAndValueType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_DigestMethodType(struct soap *soap, const struct DigestMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_DigestMethodType(struct soap *soap, struct DigestMethodType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->Algorithm);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_DigestMethodType(struct soap *soap, const struct DigestMethodType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_DigestMethodType);
	if (soap_out_DigestMethodType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_DigestMethodType(struct soap *soap, const char *tag, int id, const struct DigestMethodType *a, const char *type)
{
	if (a->Algorithm)
		soap_set_attr(soap, "Algorithm", a->Algorithm);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_DigestMethodType), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct DigestMethodType * SOAP_FMAC4 soap_get_DigestMethodType(struct soap *soap, struct DigestMethodType *p, const char *tag, const char *type)
{
	if ((p = soap_in_DigestMethodType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct DigestMethodType * SOAP_FMAC4 soap_in_DigestMethodType(struct soap *soap, const char *tag, struct DigestMethodType *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct DigestMethodType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_DigestMethodType, sizeof(struct DigestMethodType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_DigestMethodType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Algorithm", 0), &a->Algorithm))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct DigestMethodType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_DigestMethodType, 0, sizeof(struct DigestMethodType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MobileUserType(struct soap *soap, const struct mss__MobileUserType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_mss__MeshMemberType(soap, &a->mss__IdentityIssuer);
	soap_serialize_xsd__string(soap, &a->mss__UserIdentifier);
	soap_serialize_mss__MeshMemberType(soap, &a->mss__HomeMSSP);
	soap_serialize_xsd__string(soap, &a->mss__MSISDN);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MobileUserType(struct soap *soap, struct mss__MobileUserType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_mss__MeshMemberType(soap, &a->mss__IdentityIssuer);
	soap_default_xsd__string(soap, &a->mss__UserIdentifier);
	soap_default_mss__MeshMemberType(soap, &a->mss__HomeMSSP);
	soap_default_xsd__string(soap, &a->mss__MSISDN);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MobileUserType(struct soap *soap, const struct mss__MobileUserType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MobileUserType);
	if (soap_out_mss__MobileUserType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MobileUserType(struct soap *soap, const char *tag, int id, const struct mss__MobileUserType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MobileUserType), type);
	soap_out_mss__MeshMemberType(soap, "mss:IdentityIssuer", -1, &a->mss__IdentityIssuer, "");
	soap_out_xsd__string(soap, "mss:UserIdentifier", -1, &a->mss__UserIdentifier, "");
	soap_out_mss__MeshMemberType(soap, "mss:HomeMSSP", -1, &a->mss__HomeMSSP, "");
	soap_out_xsd__string(soap, "mss:MSISDN", -1, &a->mss__MSISDN, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MobileUserType * SOAP_FMAC4 soap_get_mss__MobileUserType(struct soap *soap, struct mss__MobileUserType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MobileUserType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MobileUserType * SOAP_FMAC4 soap_in_mss__MobileUserType(struct soap *soap, const char *tag, struct mss__MobileUserType *a, const char *type)
{
	short soap_flag_mss__IdentityIssuer = 1, soap_flag_mss__UserIdentifier = 1, soap_flag_mss__HomeMSSP = 1, soap_flag_mss__MSISDN = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MobileUserType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MobileUserType, sizeof(struct mss__MobileUserType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MobileUserType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mss__IdentityIssuer && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MeshMemberType(soap, "mss:IdentityIssuer", &a->mss__IdentityIssuer, "mss:MeshMemberType"))
				{	soap_flag_mss__IdentityIssuer--;
					continue;
				}
			if (soap_flag_mss__UserIdentifier && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:UserIdentifier", &a->mss__UserIdentifier, "xsd:string"))
				{	soap_flag_mss__UserIdentifier--;
					continue;
				}
			if (soap_flag_mss__HomeMSSP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_mss__MeshMemberType(soap, "mss:HomeMSSP", &a->mss__HomeMSSP, "mss:MeshMemberType"))
				{	soap_flag_mss__HomeMSSP--;
					continue;
				}
			if (soap_flag_mss__MSISDN && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:MSISDN", &a->mss__MSISDN, "xsd:string"))
				{	soap_flag_mss__MSISDN--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_mss__IdentityIssuer > 0 || soap_flag_mss__HomeMSSP > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MobileUserType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MobileUserType, 0, sizeof(struct mss__MobileUserType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__MeshMemberType(struct soap *soap, const struct mss__MeshMemberType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->mss__DNSName);
	soap_serialize_xsd__string(soap, &a->mss__IPAddress);
	soap_serialize_xsd__string(soap, &a->mss__URI);
	soap_serialize_xsd__string(soap, &a->mss__IdentifierString);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__MeshMemberType(struct soap *soap, struct mss__MeshMemberType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->mss__DNSName);
	soap_default_xsd__string(soap, &a->mss__IPAddress);
	soap_default_xsd__string(soap, &a->mss__URI);
	soap_default_xsd__string(soap, &a->mss__IdentifierString);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__MeshMemberType(struct soap *soap, const struct mss__MeshMemberType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__MeshMemberType);
	if (soap_out_mss__MeshMemberType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__MeshMemberType(struct soap *soap, const char *tag, int id, const struct mss__MeshMemberType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_mss__MeshMemberType), type);
	soap_out_xsd__string(soap, "mss:DNSName", -1, &a->mss__DNSName, "");
	soap_out_xsd__string(soap, "mss:IPAddress", -1, &a->mss__IPAddress, "");
	soap_out_xsd__string(soap, "mss:URI", -1, &a->mss__URI, "");
	soap_out_xsd__string(soap, "mss:IdentifierString", -1, &a->mss__IdentifierString, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct mss__MeshMemberType * SOAP_FMAC4 soap_get_mss__MeshMemberType(struct soap *soap, struct mss__MeshMemberType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__MeshMemberType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MeshMemberType * SOAP_FMAC4 soap_in_mss__MeshMemberType(struct soap *soap, const char *tag, struct mss__MeshMemberType *a, const char *type)
{
	short soap_flag_mss__DNSName = 1, soap_flag_mss__IPAddress = 1, soap_flag_mss__URI = 1, soap_flag_mss__IdentifierString = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct mss__MeshMemberType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__MeshMemberType, sizeof(struct mss__MeshMemberType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_mss__MeshMemberType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mss__DNSName && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:DNSName", &a->mss__DNSName, "xsd:string"))
				{	soap_flag_mss__DNSName--;
					continue;
				}
			if (soap_flag_mss__IPAddress && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:IPAddress", &a->mss__IPAddress, "xsd:string"))
				{	soap_flag_mss__IPAddress--;
					continue;
				}
			if (soap_flag_mss__URI && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:URI", &a->mss__URI, "xsd:string"))
				{	soap_flag_mss__URI--;
					continue;
				}
			if (soap_flag_mss__IdentifierString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "mss:IdentifierString", &a->mss__IdentifierString, "xsd:string"))
				{	soap_flag_mss__IdentifierString--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct mss__MeshMemberType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_mss__MeshMemberType, 0, sizeof(struct mss__MeshMemberType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__DataType(struct soap *soap, const struct mss__DataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__DataType(struct soap *soap, struct mss__DataType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_xsd__string(soap, &a->mss__MimeType);
	soap_default_xsd__string(soap, &a->mss__Encoding);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__DataType(struct soap *soap, const struct mss__DataType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__DataType);
	if (soap_out_mss__DataType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__DataType(struct soap *soap, const char *tag, int id, const struct mss__DataType *a, const char *type)
{
	if (a->mss__MimeType)
		soap_set_attr(soap, "mss:MimeType", a->mss__MimeType);
	if (a->mss__Encoding)
		soap_set_attr(soap, "mss:Encoding", a->mss__Encoding);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct mss__DataType * SOAP_FMAC4 soap_get_mss__DataType(struct soap *soap, struct mss__DataType *p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__DataType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__DataType * SOAP_FMAC4 soap_in_mss__DataType(struct soap *soap, const char *tag, struct mss__DataType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct mss__DataType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_mss__DataType, sizeof(struct mss__DataType), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default_mss__DataType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "mss:MimeType", 0), &a->mss__MimeType))
		return NULL;
	if (soap_s2string(soap, soap_attr_value(soap, "mss:Encoding", 0), &a->mss__Encoding))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, "mss:DataType"))
		return NULL;
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr)
		soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__MSS_USCOREStatusResp(struct soap *soap, struct mss__MSS_USCOREStatusResp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__MSS_USCOREStatusResp))
		soap_serialize_mss__MSS_USCOREStatusResp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__MSS_USCOREStatusResp(struct soap *soap, struct mss__MSS_USCOREStatusResp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__MSS_USCOREStatusResp);
	if (soap_out_PointerTomss__MSS_USCOREStatusResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__MSS_USCOREStatusResp(struct soap *soap, const char *tag, int id, struct mss__MSS_USCOREStatusResp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__MSS_USCOREStatusResp);
	if (id < 0)
		return soap->error;
	return soap_out_mss__MSS_USCOREStatusResp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusResp ** SOAP_FMAC4 soap_get_PointerTomss__MSS_USCOREStatusResp(struct soap *soap, struct mss__MSS_USCOREStatusResp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__MSS_USCOREStatusResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCOREStatusResp ** SOAP_FMAC4 soap_in_PointerTomss__MSS_USCOREStatusResp(struct soap *soap, const char *tag, struct mss__MSS_USCOREStatusResp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__MSS_USCOREStatusResp **)soap_malloc(soap, sizeof(struct mss__MSS_USCOREStatusResp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__MSS_USCOREStatusResp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCOREStatusResp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__MSS_USCOREStatusResp, sizeof(struct mss__MSS_USCOREStatusResp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__MSS_USCORESignatureResp(struct soap *soap, struct mss__MSS_USCORESignatureResp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__MSS_USCORESignatureResp))
		soap_serialize_mss__MSS_USCORESignatureResp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__MSS_USCORESignatureResp(struct soap *soap, struct mss__MSS_USCORESignatureResp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__MSS_USCORESignatureResp);
	if (soap_out_PointerTomss__MSS_USCORESignatureResp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__MSS_USCORESignatureResp(struct soap *soap, const char *tag, int id, struct mss__MSS_USCORESignatureResp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__MSS_USCORESignatureResp);
	if (id < 0)
		return soap->error;
	return soap_out_mss__MSS_USCORESignatureResp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureResp ** SOAP_FMAC4 soap_get_PointerTomss__MSS_USCORESignatureResp(struct soap *soap, struct mss__MSS_USCORESignatureResp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__MSS_USCORESignatureResp(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__MSS_USCORESignatureResp ** SOAP_FMAC4 soap_in_PointerTomss__MSS_USCORESignatureResp(struct soap *soap, const char *tag, struct mss__MSS_USCORESignatureResp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__MSS_USCORESignatureResp **)soap_malloc(soap, sizeof(struct mss__MSS_USCORESignatureResp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__MSS_USCORESignatureResp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__MSS_USCORESignatureResp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__MSS_USCORESignatureResp, sizeof(struct mss__MSS_USCORESignatureResp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__SignatureProfileComparisonType(struct soap *soap, enum mss__SignatureProfileComparisonType *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_mss__SignatureProfileComparisonType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__SignatureProfileComparisonType(struct soap *soap, enum mss__SignatureProfileComparisonType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__SignatureProfileComparisonType);
	if (soap_out_PointerTomss__SignatureProfileComparisonType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__SignatureProfileComparisonType(struct soap *soap, const char *tag, int id, enum mss__SignatureProfileComparisonType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__SignatureProfileComparisonType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__SignatureProfileComparisonType(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum mss__SignatureProfileComparisonType ** SOAP_FMAC4 soap_get_PointerTomss__SignatureProfileComparisonType(struct soap *soap, enum mss__SignatureProfileComparisonType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__SignatureProfileComparisonType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum mss__SignatureProfileComparisonType ** SOAP_FMAC4 soap_in_PointerTomss__SignatureProfileComparisonType(struct soap *soap, const char *tag, enum mss__SignatureProfileComparisonType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (enum mss__SignatureProfileComparisonType **)soap_malloc(soap, sizeof(enum mss__SignatureProfileComparisonType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__SignatureProfileComparisonType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum mss__SignatureProfileComparisonType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__SignatureProfileComparisonType, sizeof(enum mss__SignatureProfileComparisonType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__KeyReferenceType(struct soap *soap, struct mss__KeyReferenceType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__KeyReferenceType))
		soap_serialize_mss__KeyReferenceType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__KeyReferenceType(struct soap *soap, struct mss__KeyReferenceType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__KeyReferenceType);
	if (soap_out_PointerTomss__KeyReferenceType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__KeyReferenceType(struct soap *soap, const char *tag, int id, struct mss__KeyReferenceType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__KeyReferenceType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__KeyReferenceType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__KeyReferenceType ** SOAP_FMAC4 soap_get_PointerTomss__KeyReferenceType(struct soap *soap, struct mss__KeyReferenceType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__KeyReferenceType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__KeyReferenceType ** SOAP_FMAC4 soap_in_PointerTomss__KeyReferenceType(struct soap *soap, const char *tag, struct mss__KeyReferenceType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__KeyReferenceType **)soap_malloc(soap, sizeof(struct mss__KeyReferenceType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__KeyReferenceType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__KeyReferenceType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__KeyReferenceType, sizeof(struct mss__KeyReferenceType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__DataType(struct soap *soap, struct mss__DataType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__DataType))
		soap_serialize_mss__DataType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__DataType(struct soap *soap, struct mss__DataType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__DataType);
	if (soap_out_PointerTomss__DataType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__DataType(struct soap *soap, const char *tag, int id, struct mss__DataType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__DataType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__DataType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__DataType ** SOAP_FMAC4 soap_get_PointerTomss__DataType(struct soap *soap, struct mss__DataType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__DataType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__DataType ** SOAP_FMAC4 soap_in_PointerTomss__DataType(struct soap *soap, const char *tag, struct mss__DataType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__DataType **)soap_malloc(soap, sizeof(struct mss__DataType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__DataType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__DataType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__DataType, sizeof(struct mss__DataType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__positiveInteger(struct soap *soap, unsigned long *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__positiveInteger);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__positiveInteger(struct soap *soap, unsigned long *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__positiveInteger);
	if (soap_out_PointerToxsd__positiveInteger(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__positiveInteger(struct soap *soap, const char *tag, int id, unsigned long *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__positiveInteger);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__positiveInteger(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned long ** SOAP_FMAC4 soap_get_PointerToxsd__positiveInteger(struct soap *soap, unsigned long **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__positiveInteger(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned long ** SOAP_FMAC4 soap_in_PointerToxsd__positiveInteger(struct soap *soap, const char *tag, unsigned long **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned long **)soap_malloc(soap, sizeof(unsigned long *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__positiveInteger(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned long **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__positiveInteger, sizeof(unsigned long), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__SignatureType(struct soap *soap, struct mss__SignatureType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__SignatureType))
		soap_serialize_mss__SignatureType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__SignatureType(struct soap *soap, struct mss__SignatureType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__SignatureType);
	if (soap_out_PointerTomss__SignatureType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__SignatureType(struct soap *soap, const char *tag, int id, struct mss__SignatureType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__SignatureType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__SignatureType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__SignatureType ** SOAP_FMAC4 soap_get_PointerTomss__SignatureType(struct soap *soap, struct mss__SignatureType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__SignatureType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__SignatureType ** SOAP_FMAC4 soap_in_PointerTomss__SignatureType(struct soap *soap, const char *tag, struct mss__SignatureType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__SignatureType **)soap_malloc(soap, sizeof(struct mss__SignatureType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__SignatureType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__SignatureType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__SignatureType, sizeof(struct mss__SignatureType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__mssURIType(struct soap *soap, struct mss__mssURIType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__mssURIType))
		soap_serialize_mss__mssURIType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__mssURIType(struct soap *soap, struct mss__mssURIType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__mssURIType);
	if (soap_out_PointerTomss__mssURIType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__mssURIType(struct soap *soap, const char *tag, int id, struct mss__mssURIType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__mssURIType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__mssURIType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__mssURIType ** SOAP_FMAC4 soap_get_PointerTomss__mssURIType(struct soap *soap, struct mss__mssURIType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__mssURIType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__mssURIType ** SOAP_FMAC4 soap_in_PointerTomss__mssURIType(struct soap *soap, const char *tag, struct mss__mssURIType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__mssURIType **)soap_malloc(soap, sizeof(struct mss__mssURIType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__mssURIType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__mssURIType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__mssURIType, sizeof(struct mss__mssURIType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a)
{
	if (*a)
		soap_serialize_xsd__base64Binary(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__base64Binary);
	if (soap_out_PointerToxsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__base64Binary(struct soap *soap, const char *tag, int id, struct xsd__base64Binary *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, (struct soap_array*)&(*a)->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__base64Binary(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_get_PointerToxsd__base64Binary(struct soap *soap, struct xsd__base64Binary **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__base64Binary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary ** SOAP_FMAC4 soap_in_PointerToxsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct xsd__base64Binary **)soap_malloc(soap, sizeof(struct xsd__base64Binary *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__base64Binary(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_mss__StatusDetailType(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_mss__StatusDetailType(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_mss__StatusDetailType(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_mss__StatusDetailType);
	if (soap_out_mss__StatusDetailType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_mss__StatusDetailType(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_mss__StatusDetailType);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_mss__StatusDetailType(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_mss__StatusDetailType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_mss__StatusDetailType(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_mss__StatusDetailType, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTomss__DigestAlgAndValueType(struct soap *soap, struct mss__DigestAlgAndValueType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_mss__DigestAlgAndValueType))
		soap_serialize_mss__DigestAlgAndValueType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTomss__DigestAlgAndValueType(struct soap *soap, struct mss__DigestAlgAndValueType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTomss__DigestAlgAndValueType);
	if (soap_out_PointerTomss__DigestAlgAndValueType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTomss__DigestAlgAndValueType(struct soap *soap, const char *tag, int id, struct mss__DigestAlgAndValueType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_mss__DigestAlgAndValueType);
	if (id < 0)
		return soap->error;
	return soap_out_mss__DigestAlgAndValueType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct mss__DigestAlgAndValueType ** SOAP_FMAC4 soap_get_PointerTomss__DigestAlgAndValueType(struct soap *soap, struct mss__DigestAlgAndValueType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTomss__DigestAlgAndValueType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct mss__DigestAlgAndValueType ** SOAP_FMAC4 soap_in_PointerTomss__DigestAlgAndValueType(struct soap *soap, const char *tag, struct mss__DigestAlgAndValueType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct mss__DigestAlgAndValueType **)soap_malloc(soap, sizeof(struct mss__DigestAlgAndValueType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_mss__DigestAlgAndValueType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct mss__DigestAlgAndValueType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_mss__DigestAlgAndValueType, sizeof(struct mss__DigestAlgAndValueType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__dateTime(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__dateTime(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__dateTime(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__dateTime);
	if (soap_out_xsd__dateTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__dateTime(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__dateTime);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__dateTime(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__dateTime(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__dateTime(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__dateTime, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__string(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__string(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__string);
	if (soap_out_xsd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of soapC.c */
