PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE IF NOT EXISTS "mini_buildd_aptkey" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "key_id" varchar(100) NOT NULL, "key" text NOT NULL, "key_long_id" varchar(254) NOT NULL, "key_created" varchar(254) NOT NULL, "key_expires" varchar(254) NOT NULL, "key_name" varchar(254) NOT NULL, "key_fingerprint" varchar(254) NOT NULL);
INSERT INTO mini_buildd_aptkey VALUES(1,'','',2,'2024-01-08 18:02:42.471080',0,'73A4F27B8DD47936',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n1UKhwK2BVhqTmCWb\n=svWP\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'73A4F27B8DD47936','1610882316','1863170316','Debian Archive Automatic Signing Key (11/bullseye) <ftpmaster@debian.org>','1F89983E0081FDE018F3CC9673A4F27B8DD47936');
INSERT INTO mini_buildd_aptkey VALUES(2,'','',2,'2024-01-08 17:55:27.678978',0,'B7C5D7D6350947F8',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nNlB2T6bKGcYGqL7L\n=UUyy\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'B7C5D7D6350947F8','1674301461','1926589461','Debian Archive Automatic Signing Key (12/bookworm) <ftpmaster@debian.org>','B8B80B5B623EAB6AD8775C45B7C5D7D6350947F8');
INSERT INTO mini_buildd_aptkey VALUES(3,'','',2,'2024-01-08 17:45:22.009618',0,'A48449044AAD5C5D',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nTT9yj35WJXkuIZ7GV189g3gogTpu\n=Xxba\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'A48449044AAD5C5D','1610882224','1863170224','Debian Security Archive Automatic Signing Key (11/bullseye) <ftpmaster@debian.org>','AC530D520F2F3269F5E98313A48449044AAD5C5D');
INSERT INTO mini_buildd_aptkey VALUES(4,'','',2,'2024-01-08 17:43:19.736704',0,'254CF3B5AEC0A8F0',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nbn5U7DwupeFEycZrqQEKsjwFjLxa\n=QzR4\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'254CF3B5AEC0A8F0','1674301533','1926589533','Debian Security Archive Automatic Signing Key (12/bookworm) <ftpmaster@debian.org>','05AB90340C0C5E797F44A8C8254CF3B5AEC0A8F0');
INSERT INTO mini_buildd_aptkey VALUES(5,'','',2,'2024-01-08 18:02:42.482007',0,'DC30D7C23CBBABEE',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nqn8+ouVQUr65+xcIST13Ffg80zc=\n=5Cty\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'DC30D7C23CBBABEE','1555228135','1807516135','Debian Archive Automatic Signing Key (10/buster) <ftpmaster@debian.org>','80D15823B7FD1561F9F7BCDDDC30D7C23CBBABEE');
INSERT INTO mini_buildd_aptkey VALUES(6,'','',2,'2024-01-08 17:57:24.140647',0,'F8D2585B8783D481',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmDMEY865UxYJKwYBBAHaRw8BAQdAd7Z0srwuhlB6JKFkcf4HU4SSS/xcRfwEQWzr\ncrf6AEq0SURlYmlhbiBTdGFibGUgUmVsZWFzZSBLZXkgKDEyL2Jvb2t3b3JtKSA8\nZGViaWFuLXJlbGVhc2VAbGlzdHMuZGViaWFuLm9yZz6IlgQTFggAPhYhBE1k/sEZ\nwgKQZ9bnkfjSWFuHg9SBBQJjzrlTAhsDBQkPCZwABQsJCAcCBhUKCQgLAgQWAgMB\nAh4BAheAAAoJEPjSWFuHg9SBSgwBAP9qpeO5z1s5m4D4z3TcqDo1wez6DNya27QW\nWoG/4oBsAQCEN8Z00DXagPHbwrvsY2t9BCsT+PgnSn9biobwX7bDDg==\n=5NZE\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'F8D2585B8783D481','1674492243','1926780243','Debian Stable Release Key (12/bookworm) <debian-release@lists.debian.org>','4D64FEC119C2029067D6E791F8D2585B8783D481');
INSERT INTO mini_buildd_aptkey VALUES(7,'','',2,'2024-01-08 17:59:19.113159',0,'605C66F00D6C9793',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBGAoEk4BEADG6NQ0Ex5gy0OlnGlFZsTpiZV2LiUhACFj6ZHVEYQQNWgEgRnZ\nuZeAXbTnFywzrJUYhx51pNjxfoViN/4Jyn2oMrmaBEuDxEwhVZDsMTzb9dx0MNnm\njMr45z/4EGjln07tFzes+J+0eVizJOWehQ40IEwyCZIG9QOfsC1e1estm0KLZKWb\n4gTihGFSahM4zeD6XlZ8krTlkWV9i7+oatCkNziuOTf8+ZXEqoNm/dJxG6pGWcal\no+DiTE3l4HCFr6MZoiCoWVaKYn1jtIUeioDVW8zPalt3VcPmjvYb6ZNHhFK8d3DD\nV17wv7TFJIOn1j2n82jzbDZwQAWIA6iKPjXDJJqmv4qcZ5a5l8qirhjZhQEemftY\nsGBLTjx9ANfPcDFoQ69ojDw34Nchig2nJ+7ut9h5mjeB9QmOx10HDposRaZq8yPC\nhFpheHNlKwh9PYba0Z9Vb3mI04ywkw1oGc6YQD/VGhoGiMembzEK110DsCcZenD5\ndOWHug5LF7QTH+120eG4Qt0RcPLqI33+3FUOjzOQubw0QATYs8Dw2E36LVOUx1yr\ntDqjJs/ZXfr+LCfaZRshvYfcl3soHCXxVqEwoXUmxJK741RS4ej8w79clniZPMLc\n68XpFZ7qsKoKBHeoG1l8XvuAp9EpW4vujsehEwRudn1SNoc5fTFG9k8qlQARAQAB\ntElEZWJpYW4gU3RhYmxlIFJlbGVhc2UgS2V5ICgxMS9idWxsc2V5ZSkgPGRlYmlh\nbi1yZWxlYXNlQGxpc3RzLmRlYmlhbi5vcmc+iQJUBBMBCgA+FiEEpChSlfx7GoFg\nAGKpYFxm8A1sl5MFAmAoEk4CGwMFCQ8JnAAFCwkIBwIGFQoJCAsCBBYCAwECHgEC\nF4AACgkQYFxm8A1sl5OtbBAAuI9V8uztBX+gZhvI7LYRZkuWzmNa/qiDGHAF6DIA\nOYKqCZUDSrkF9qsIkeeZdEP7hLoIo6TkprvF5iLFTfzFWPT1VR9E/itBBzEZa2Vr\ngT0ye8gYrsRdNkso2vqZQd3muDJvg9UrT37+Nt0eOpFAfc3JYfqwjhVIngiNLwjG\nTC5oinEesdDCgqxo8Z6e6NyMLdDtS4W26q7GxcuG5YcBoYi3pjxJx8ZGsNHqEe6R\nvU3YGahEgWWY80xCRarm8RVYgfU4LZfm6D4o1ZO3B2UmK6+TgkTjYWzC/yMrcbK4\nlyumB36OCSg8byrJ3qUN7zKKU0DIxPqFFCLxxhYxf4QrMPik0BTgloWntP2VFLUo\n3DxJQKAqQULr+H/WEgbsgAuU8U0VLTlj9sCXn0iN0pHzNaEJJ4sz5mdIWOdJJobk\nbiQT+xAGwfoKDff9l9fu82p569sK9U+omHMuDfxTT0X13U/6d2m5nIFwf1MitshU\n8frYxuZs3Lp0Qi1Xsqtwc/wrIDt5c0M4wluypuz//eRLLwsMn6KEl1/Be/RebHSb\nFKOA2tdsc/hfABsVQCFpRHgBmpLfL/5Qwd/K7dKKpuh/7pV4B1cNgviKwMFhhR2e\nGzTfbXqxytnYmJkV++bKLtX1SkNx1TBb4lqICzdFOV5QjtjPBVZR7Ugx7sp7yZn4\nbw2JAjMEEAEIAB0WIQRyA2MOLI5yclFoT+vFzl3CxULNWQUCYCgSfgAKCRDFzl3C\nxULNWR3gD/wLYa1UBOMszWu/BTLt42QHcd6onTTboP4S9w1Gs/ak5iQiEN45CVVL\nbJ5wS1iaeuMZ85fOtcEvJ9KqMvwvGXlsCD/+O0QJJbEpeJpHarj4ZtxaL659ipci\nqeSIQAsAb6/9SKZZ7HGQFD6DAF9kzV9HpKnNvE8BGQ8I38Ez9lfRiQuD16r4cqNg\nS076Z1AoQU8ES5N8VO5v1fbAHsyLq9ZToE28BKGU4o59Fj5uqpfDrm0DrnSn053j\nUK942IGmIwKtUAn/j2sG9mcow47xjifVTKuMXyNGDM30n6ITRtiTaZsUZGIw/yKM\n3ZosuxobxvJoef8B43MpEHYV/xZHYxegT3xlu5h8FlUQrr/WR7FtT7Awlapm6llI\na/2G0nrPhQlX5nN5gJiKO92rOvKM4wTadBjL41jfYZb5EE44T51hCpJUB1g2GSQk\nUpYM/MgcNfqmq7+7bAxinej/iCzhziv925mUOhIGhAUEYCZMFI4tIEVFFAUb4pi1\nCtXo3V8DJRu5TkuETwDdK+FfBU2e3q7b0q/CTHdHfD8T7VuTaYm01meCqWG8HS3h\n2OSgtWrUgDBDKAU3O83KK7n6K+SAXW1iOaUzW9GErZnYqlEOMJVQn1pU+txUAAdT\nfQy05mUvCUvHo5VOcC3wybU5HCZJ3cWe6HCOviBheeIysa+iSvBAU4kCMwQQAQoA\nHRYhBApVt8USIzlChux0w1OUR53TUkxRBQJgNqemAAoJEFOUR53TUkxRYSUP/Rt9\nFTybIXwOW6FE3LPF7GvEWX//loxKRhiBSQ8Fwmkdchz3iJSAcZ8HgcISMH5P77Ip\n8U9z8GAucy46Bi7tsaisWOUVxu5gvh6zLui7PkCRubIxcCxA+JjX5oZm3LSy49s1\nSEC/o0MB4TRwpqRfuEots6H0Z9eHzvJKjoeX9Ku7SjfSSRWY3TWMMIjQBATRZGcT\nmgA3iJ4/9dFmBGsYhQq1WsY7bCmCahemAmAkdCxkB3hr8BA1Dm/GHgL0++txJhjC\nFwKj89yh+Or8l/C95qptS2uAxioDM9952DUm65oWtApsFs8VpcJxSdApmWmH4s8/\nB/ESPKv7apLq3BSgLy4UA4FdFz+XS9xw3GItcPunzGZQfI6Dd5jPUMwYYqcr1cVB\n2vTiQB//smNjWq2skWTKBtjk2xpPOMCKC5mdGI467RT8HpDMcKWUbg1kaPqCCzpQ\n9NJQuk+M9+jw78MELtUGVi8wIZSZCjR2zXduenyVUWmQTHSNfS2R3iWsYH6m7fL2\niA9j4Zi7sEjffGbLkQfQqH+c4XBDWNzJnC+/jQeWKG++zcYtEHv0mk37agw2qB9H\nQdTO2xGJcfNF+dervAj1O2fvasOMj9aptRZVpKVMs25zbkplBR5mqPXven+SraDO\nQb5fppcPrKPt88G3e+dBuBzElOXBWpIsMJuvutFniHUEEBYIAB0WIQTKYZ1lpyp7\nrfyW0oAZZBiq63TIoQUCYDaonAAKCRAZZBiq63TIoR41AQCLcs+WlaZTZ0rg/cWh\nvApi12mZpXQC60bxvmrtTyHH4AEA2pJLfGVHOualRCNbeGEYjfC0WiC+EYCC3NBV\ne18slw8=\n=7Dni\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'605C66F00D6C9793','1613238862','1865526862','Debian Stable Release Key (11/bullseye) <debian-release@lists.debian.org>','A4285295FC7B1A81600062A9605C66F00D6C9793');
INSERT INTO mini_buildd_aptkey VALUES(8,'','',2,'2024-01-08 17:45:22.022363',0,'4DFAB270CAA96DFA',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n8V9DmVt99tlJJvTXFUXZ7K2JMX0f8pDW7KtR0zI=\n=xBv7\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'4DFAB270CAA96DFA','1555228608','1807516608','Debian Security Archive Automatic Signing Key (10/buster) <ftpmaster@debian.org>','5E61B217265DA9807A23C5FF4DFAB270CAA96DFA');
INSERT INTO mini_buildd_aptkey VALUES(9,'','',2,'2024-01-08 18:01:03.990258',0,'DCC9EFBF77E11517',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nidjr8CGNeffTyeMJbSniGisGOkhiX9TLbz8ufw==\n=a2kx\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'DCC9EFBF77E11517','1549399120','1801687120','Debian Stable Release Key (10/buster) <debian-release@lists.debian.org>','6D33866EDD8FFA41C0143AEDDCC9EFBF77E11517');
INSERT INTO mini_buildd_aptkey VALUES(10,'','',2,'2024-01-08 18:02:42.492911',0,'E0B11894F66AEC98',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nk5Bh\n=3qWJ\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'E0B11894F66AEC98','1495478350','1747766350','Debian Archive Automatic Signing Key (9/stretch) <ftpmaster@debian.org>','E1CF20DDFFE4B89E802658F1E0B11894F66AEC98');
INSERT INTO mini_buildd_aptkey VALUES(11,'','',2,'2024-01-08 18:02:42.504891',0,'EF0F382A1A7B6500',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nHNbs0H9t4g==\n=DqiM\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'EF0F382A1A7B6500','1495304669','1747592669','Debian Stable Release Key (9/stretch) <debian-release@lists.debian.org>','067E3C456BAE240ACEE88F6FEF0F382A1A7B6500');
INSERT INTO mini_buildd_aptkey VALUES(12,'','',2,'2024-01-08 17:41:37.274092',0,'EDA0D2388AE22BA9',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nTLeFkkM3UnAOQN0p\n=1HGQ\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'EDA0D2388AE22BA9','1495478513','1747766513','Debian Security Archive Automatic Signing Key (9/stretch) <ftpmaster@debian.org>','6ED6F5CB5FA6FB2F460AE88EEDA0D2388AE22BA9');
INSERT INTO mini_buildd_aptkey VALUES(13,'','',2,'2024-01-08 18:06:23.561893',0,'8B48AD6246925553',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nDHcut3Yey8o=\n=id4q\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'8B48AD6246925553','1335553717','1587841717','Debian Archive Automatic Signing Key (7.0/wheezy) <ftpmaster@debian.org>','A1BD8E9D78F7FE5C3E65D8AF8B48AD6246925553');
INSERT INTO mini_buildd_aptkey VALUES(14,'','',2,'2024-01-08 18:04:36.961082',0,'CBF8D6FD518E17E1',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n2a65h59CeW4zAYbU/0t47ghTDi/ybqTVbcsp\n=kPlg\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'CBF8D6FD518E17E1','1376739416','1629027416','Jessie Stable Release Key <debian-release@lists.debian.org>','75DDC3C4A499F1A18CB5F3C8CBF8D6FD518E17E1');
INSERT INTO mini_buildd_aptkey VALUES(15,'','',2,'2024-01-08 18:06:23.572972',0,'7638D0442B90D010',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n3rRmtFrJQ50iIcnJX8TjzB9e\n=2Gih\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'7638D0442B90D010','1416603673','1668891673','Debian Archive Automatic Signing Key (8/jessie) <ftpmaster@debian.org>','126C0D24BD8A2942CC7DF8AC7638D0442B90D010');
INSERT INTO mini_buildd_aptkey VALUES(16,'','',2,'2024-01-08 17:42:21.036471',0,'9D6D8F6BC857C906',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nlc/RtZpF5uUq1yGf/TyOgm9X3tiS+mueTz36\n=pvO8\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'9D6D8F6BC857C906','1416604417','1668892417','Debian Security Archive Automatic Signing Key (8/jessie) <ftpmaster@debian.org>','D21169141CECD440F2EB8DDA9D6D8F6BC857C906');
INSERT INTO mini_buildd_aptkey VALUES(17,'','',2,'2024-01-08 18:06:23.584143',0,'6FB2A1C265FFB764',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nN5RQ\n=f+vN\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'6FB2A1C265FFB764','1336489909','1557241909','Wheezy Stable Release Key <debian-release@lists.debian.org>','ED6D65271AACF0FF15D123036FB2A1C265FFB764');
INSERT INTO mini_buildd_aptkey VALUES(18,'','',2,'2024-01-08 18:17:05.441567',0,'871920D1991BC93C',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBFufwdoBEADv/Gxytx/LcSXYuM0MwKojbBye81s0G1nEx+lz6VAUpIUZnbkq\ndXBHC+dwrGS/CeeLuAjPRLU8AoxE/jjvZVp8xFGEWHYdklqXGZ/gJfP5d3fIUBtZ\nHZEJl8B8m9pMHf/AQQdsC+YzizSG5t5Mhnotw044LXtdEEkx2t6Jz0OGrh+5Ioxq\nX7pZiq6Cv19BohaUioKMdp7ES6RYfN7ol6HSLFlrMXtVfh/ijpN9j3ZhVGVeRC8k\nKHQsJ5PkIbmvxBiUh7SJmfZUx0IQhNMaDHXfdZAGNtnhzzNReb1FqNLSVkrS/Pns\nAQzMhG1BDm2VOSF64jebKXffFqM5LXRQTeqTLsjUbbrqR6s/GCO8UF7jfUj6I7ta\nLygmsHO/JD4jpKRC0gbpUBfaiJyLvuepx3kWoqL3sN0LhlMI80+fA7GTvoOx4tpq\nVlzlE6TajYu+jfW3QpOFS5ewEMdL26hzxsZg/geZvTbArcP+OsJKRmhv4kNo6Ayd\nyHQ/3ZV/f3X9mT3/SPLbJaumkgp3Yzd6t5PeBu+ZQk/mN5WNNuaihNEV7llb1Zhv\nY0Fxu9BVd/BNl0rzuxp3rIinB2TX2SCg7wE5xXkwXuQ/2eTDE0v0HlGntkuZjGow\nDZkxHZQSxZVOzdZCRVaX/WEFLpKa2AQpw5RJrQ4oZ/OfifXyJzP27o03wQARAQAB\ntEJVYnVudHUgQXJjaGl2ZSBBdXRvbWF0aWMgU2lnbmluZyBLZXkgKDIwMTgpIDxm\ndHBtYXN0ZXJAdWJ1bnR1LmNvbT6JAjgEEwEKACIFAlufwdoCGwMGCwkIBwMCBhUI\nAgkKCwQWAgMBAh4BAheAAAoJEIcZINGZG8k8LHMQAKS2cnxz/5WaoCOWArf5g6UH\nbeOCgc5DBm0hCuFDZWWv427aGei3CPuLw0DGLCXZdyc5dqE8mvjMlOmmAKKlj1uG\ng3TYCbQWjWPeMnBPZbkFgkZoXJ7/6CB7bWRht1sHzpt1LTZ+SYDwOwJ68QRp7DRa\nZl9Y6QiUbeuhq2DUcTofVbBxbhrckN4ZteLvm+/nG9m/ciopc66LwRdkxqfJ32Cy\nq+1TS5VaIJDG7DWziG+Kbu6qCDM4QNlg3LH7p14CrRxAbc4lvohRgsV4eQqsIcdF\nkuVY5HPPj2K8TqpY6STe8Gh0aprG1RV8ZKay3KSMpnyV1fAKn4fM9byiLzQAovC0\nLZ9MMMsrAS/45AvC3IEKSShjLFn1X1dRCiO6/7jmZEoZtAp53hkf8SMBsi78hVNr\nBumZwfIdBA1v22+LY4xQK8q4XCoRcA9G+pvzU9YVW7cRnDZZGl0uwOw7z9PkQBF5\nKFKjWDz4fCk+K6+YtGpovGKekGBb8I7EA6UpvPgqA/QdI0t1IBP0N06RQcs1fUaA\nQEtz6DGy5zkRhR4pGSZn+dFET7PdAjEK84y7BdY4t+U1jcSIvBj0F2B7LwRL7xGp\nSpIKi/ekAXLs117bvFHaCvmUYN7JVp1GMmVFxhIdx6CFm3fxG8QjNb5tere/YqK+\nuOgcXny1UlwtCUzlrSaP\n=9AdM\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'871920D1991BC93C','1537196506','','Ubuntu Archive Automatic Signing Key (2018) <ftpmaster@ubuntu.com>','F6ECB3762474EDA9D21B7022871920D1991BC93C');
INSERT INTO mini_buildd_aptkey VALUES(19,'','',2,'2024-01-08 18:20:47.465333',0,'3B4FE6ACC0B21F32',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQINBE+tgXgBEADfiL1KNFHT4H4Dw0OR9LemR8ebsFl+b9E44IpGhgWYDufj0gaM\n/UJ1Ti3bHfRT39VVZ6cv1P4mQy0bnAKFbYz/wo+GhzjBWtn6dThYv7n+KL8bptSC\nXgg1a6en8dCCIA/pwtS2Ut/g4Eu6Z467dvYNlMgCqvg+prKIrXf5ibio48j3AFvd\n1dDJl2cHfyuON35/83vXKXz0FPohQ7N7kPfI+qrlGBYGWFzC/QEGje360Q2Yo+rf\nMoyDEXmPsoZVqf7EE8gjfnXiRqmz/Bg5YQb5bgnGbLGiHWtjS+ACIdLUq/h+jlSp\n57jw8oQktMh2xVMX4utDM0UENeZnPllVJSlR0b+ZmZz7paeSar8Yxn4wsNlL7GZb\npW5A/WmcmWfuMYoPhBo5Fq1V2/siKNU3UKuf1KH+X0p1oZ4oOcZ2bS0Zh3YEG8IQ\nce9Bferq4QMKsekcG9IKS6WBIU7BwaElI2ILD0gSwu8KzvNSEeIJhYSsBIEzrWxI\nBXoN2AC9PCqqXkWlI5Xr/86RWllB3CsoPwEfO8CLJW2LlXTen/Fkq4wT+apdhHei\nWiSsq/J5OEff0rKHBQ3fK7fyVuVNrJFb2CopaBLyCxTupvxs162jjUNopt0c7OqN\nBoPoUoVFAxUSpeEwAw6xrM5vROyLMSeh/YnTuRy8WviRapZCYo6naTCY5wARAQAB\ntEJVYnVudHUgQXJjaGl2ZSBBdXRvbWF0aWMgU2lnbmluZyBLZXkgKDIwMTIpIDxm\ndHBtYXN0ZXJAdWJ1bnR1LmNvbT6JAjgEEwECACIFAk+tgXgCGwMGCwkIBwMCBhUI\nAgkKCwQWAgMBAh4BAheAAAoJEDtP5qzAsh8yXX4QAJHUdK6eYMyJcrFP3yKXtUYQ\nMpaHRM/floqZtOFhlmcLVMgBNOr0eLvBU0JcZyZpHMvZciTDBMWX8ItCYVjRejf0\nK0lPvHHRGaE7t6JHVUCeznNbDMnOPYVwlVJdZLOa6PmE5WXVXpk8uTA8vm6RO2rS\n23vE7U0pQlV+1GVXMWH4ZLjaQs/Tm7wdvRxeqTbtfOEeHGLjmsoh0erHfzMV4wA/\n9Zq86WzuJS1HxXR6OYDC3/aQX7CxYT1MQxEw/PObnHtkl3PRMWdTW7fSQtulEXzp\nr2/JCev6Mfc8Uy0aD3jng9byVk9GpdNFEjGgaUqjqyZosvwAZ4/dmRjmMEibXeNU\nGC8HeWC3WOVV8L/DiA+miJlwPvwPiA1ZuKBI5A8VF0rNHW7QVsG8kQ+PDHgRdsmh\npzSRgykN1PgK6UxScKX8LqNKCtKpuEPApka7FQ1u4BoZKjjpBhY1R4TpfFkMIe7q\nW8XfqoaP99pED3xXch2zFRNHitNJr+yQJH4z/o+2UvnTA2niUTHlFSCBoU1MvSq1\nN2J3qU6oR2cOYJ4ZxqWyCoeQR1x8aPnLlcn4le6HU7TocYbHaImcIt7qnG4Ni0OW\nP4giEhjOpgxtrWgl36mdufvriwya+EHXzn36EvQ9O+bm3fyarsnhPe01rlsRxqBi\nK1JOw/g4GnpX8iLGEX1V\n=t8OL\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'3B4FE6ACC0B21F32','1336770936','','Ubuntu Archive Automatic Signing Key (2012) <ftpmaster@ubuntu.com>','790BC7277767219C42C86F933B4FE6ACC0B21F32');
INSERT INTO mini_buildd_aptkey VALUES(20,'','',2,'2024-01-08 18:20:47.476110',0,'40976EAF437D05B5',replace('-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQGiBEFEnz8RBAC7LstGsKD7McXZgd58oN68KquARLBl6rjA2vdhwl77KkPPOr3O\nYeSBH/voUsqausJfDNuTNivOfwceDe50lbhq52ODj4Mx9Jg+4aHn9fmRkIk41i2J\n3hZiIGPACY/FsSlRq1AhBH2wZG1lQ45W/p77AeARRehYKJP9HY+1h/uihwCgrVE2\nVzACJLuZWHbDsPoJaNQjiFcEAKbUF1rMyjd1xJM7bZeXbs8c+ohUo/ywSI/OIr8n\nOfUswy08tsCof1KU0JBGLBCn0lHAYkAAcSr2pQ+k/odwdLQSjgm/JcUbi2ll16Wy\n7qFbUAUJ5xO+iP61vL3z4pJGcK1pMH6kBLA4CPBchJU/hh3f7vtX2oFdWw8tWqvm\nm/W7BACE7h0p86OP2G3ZJBjNYNQTK1LFYa+3G0spsVi9wl+Ih49ImPbSsUc2CSMA\nfDlGpYU8FuUKCgQnS3UZz6e0NwrHbZTHBy0ksRwT9jf7qSAEKEN2ECxfwR5i1dU+\nYi4owkqGPhTLAbwkYdZZMcqfGgTXbiU4uy8DzMH/VhqP5wxdwbQ7VWJ1bnR1IEFy\nY2hpdmUgQXV0b21hdGljIFNpZ25pbmcgS2V5IDxmdHBtYXN0ZXJAdWJ1bnR1LmNv\nbT6IXgQTEQIAHgUCQUSfPwIbAwYLCQgHAwIDFQIDAxYCAQIeAQIXgAAKCRBAl26v\nQ30FtSTNAJ9TwRBI9/dXHqsyx5LkWrPxyO2H7wCfXDY77HnwSK3tTqJzC4m6KuDd\nRhe5Ag0EQUSfRxAIAMglvR9L60xR65i2QG4k2CnqZhmRUaTySxwOlNqKWtokUpzf\n8WmqA383uRLO8W9Tee1aF7KEMEUXgFiP7nns0kroKGLlcLbC+nEzkv51ao6Lcr5d\nWr0817LmlvCl2N1KeQDkpHIAiS0LTjuEFY1yosi2ECiOan6sgcLaVqJVbEUeIaYJ\nOiZ8O1INTAGGdpVoSPvgkuZVKhP2uMIhYq3qgs6sB5SshEaKAGYIiH3lZ6UJUIVE\nuyumxpNPqkJ1Jkpo4SxIwy8KYiQ9Uo1NPP8bmvyGGaeWbRObLPHCO+iqxHxMiE4x\nX08sVizxA1YLw9iwtdNPOWkQsM9rn8W/gieH0SsAAwYIAMLzDICy2IA1wcmf5XPp\ng4JBFuMjeg8pIuaQZMf/MO2u+RlOVrIXPVFtYOpxQR9C1gCg+Blg2qQXBNw19cNT\n2EtSGi0HtycTww2xnIOnaLOzq/eI/LnakdAMclaTVbNltraepkoRFE4Exvuq/tCd\nzssotnmAha1tzGf+O3QyxkIBJ6zHFTNCREGBPYi/Pe9iviWqNAIr3SPhlw7STFrV\nDgpne9VdpOZb3nVYYQHG6iwvVwzrE23+84RMFENq4Dhyx9L8R6+PMt347uT8dB03\nPXMovOpwXX06zMgfGwF60TZsmHqun/E3gE46YiME26rmUX5KSNTm9N2IZA8jz/sF\nXz2ISQQYEQIACQUCQUSfRwIbDAAKCRBAl26vQ30FtdxYAJsFjU+xbex7gevyGQ2/\nmhqidES4MwCggqQyo+w1Twx6DKLF+3rF5nf1F3Q=\n=2m5N\n-----END PGP PUBLIC KEY BLOCK-----\n','\n',char(10)),'40976EAF437D05B5','1095016255','','Ubuntu Archive Automatic Signing Key <ftpmaster@ubuntu.com>','630239CC130E1A7FD81A27B140976EAF437D05B5');
CREATE TABLE IF NOT EXISTS "mini_buildd_uploader" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "key_id" varchar(100) NOT NULL, "key" text NOT NULL, "key_long_id" varchar(254) NOT NULL, "key_created" varchar(254) NOT NULL, "key_expires" varchar(254) NOT NULL, "key_name" varchar(254) NOT NULL, "key_fingerprint" varchar(254) NOT NULL, "user_id" integer NOT NULL UNIQUE REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_uploader VALUES(1,'','',0,'0001-01-01 00:00:00',0,'','','','','','','',1);
CREATE TABLE IF NOT EXISTS "mini_buildd_uploader_may_upload_to" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "uploader_id" integer NOT NULL REFERENCES "mini_buildd_uploader" ("id") DEFERRABLE INITIALLY DEFERRED, "repository_id" varchar(50) NOT NULL REFERENCES "mini_buildd_repository" ("identity") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "mini_buildd_remote" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "key_id" varchar(100) NOT NULL, "key" text NOT NULL, "key_long_id" varchar(254) NOT NULL, "key_created" varchar(254) NOT NULL, "key_expires" varchar(254) NOT NULL, "key_name" varchar(254) NOT NULL, "key_fingerprint" varchar(254) NOT NULL, "http" varchar(255) NOT NULL PRIMARY KEY, "wake_command" varchar(255) NOT NULL);
CREATE TABLE IF NOT EXISTS "mini_buildd_archive" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "url" varchar(512) NOT NULL PRIMARY KEY, "ping" real NOT NULL);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian/',0.81899999999999995);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian-security/',0.560999999999999943);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian-ports/',0.769000000000000016);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian-archive/debian/',0.453000000000000013);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian-archive/debian-security/',0.631000000000000005);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/debian-archive/debian-backports/',1.29699999999999993);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/ubuntu/',1.99800000000000022);
INSERT INTO mini_buildd_archive VALUES('','','http://hostname.example.com:3142/ubuntu-old/',0.832999999999999962);
INSERT INTO mini_buildd_archive VALUES('','','http://ftp.debian.org/debian/',76.1310000000000002);
INSERT INTO mini_buildd_archive VALUES('','','http://deb.debian.org/debian/',88.7600000000000051);
INSERT INTO mini_buildd_archive VALUES('','','http://security.debian.org/debian-security/',79.0180000000000006);
INSERT INTO mini_buildd_archive VALUES('','','http://deb.debian.org/debian-security/',64.546999999999997);
INSERT INTO mini_buildd_archive VALUES('','','http://archive.debian.org/debian/',94.0890000000000128);
INSERT INTO mini_buildd_archive VALUES('','','http://archive.debian.org/debian-security/',66.7870000000000061);
INSERT INTO mini_buildd_archive VALUES('','','http://archive.debian.org/debian-backports/',68.1950000000000073);
INSERT INTO mini_buildd_archive VALUES('','','http://archive.ubuntu.com/ubuntu/',1185.78500000000008);
INSERT INTO mini_buildd_archive VALUES('','','http://security.ubuntu.com/ubuntu/',389.087999999999965);
INSERT INTO mini_buildd_archive VALUES('','','http://old-releases.ubuntu.com/ubuntu/',440.215000000000031);
CREATE TABLE IF NOT EXISTS "mini_buildd_architecture" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "name" varchar(50) NOT NULL PRIMARY KEY);
INSERT INTO mini_buildd_architecture VALUES('','','all');
INSERT INTO mini_buildd_architecture VALUES('','','amd64');
INSERT INTO mini_buildd_architecture VALUES('','','arm64');
INSERT INTO mini_buildd_architecture VALUES('','','armel');
INSERT INTO mini_buildd_architecture VALUES('','','armhf');
INSERT INTO mini_buildd_architecture VALUES('','','i386');
INSERT INTO mini_buildd_architecture VALUES('','','mips64el');
INSERT INTO mini_buildd_architecture VALUES('','','ppc64el');
INSERT INTO mini_buildd_architecture VALUES('','','riscv64');
INSERT INTO mini_buildd_architecture VALUES('','','s390x');
INSERT INTO mini_buildd_architecture VALUES('','','mipsel');
INSERT INTO mini_buildd_architecture VALUES('','','mips');
INSERT INTO mini_buildd_architecture VALUES('','','powerpc');
INSERT INTO mini_buildd_architecture VALUES('','','kfreebsd-amd64');
INSERT INTO mini_buildd_architecture VALUES('','','kfreebsd-i386');
INSERT INTO mini_buildd_architecture VALUES('','','ia64');
INSERT INTO mini_buildd_architecture VALUES('','','s390');
INSERT INTO mini_buildd_architecture VALUES('','','sparc');
CREATE TABLE IF NOT EXISTS "mini_buildd_component" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "name" varchar(50) NOT NULL PRIMARY KEY);
INSERT INTO mini_buildd_component VALUES('','','main');
INSERT INTO mini_buildd_component VALUES('','','contrib');
INSERT INTO mini_buildd_component VALUES('','','non-free-firmware');
INSERT INTO mini_buildd_component VALUES('','','non-free');
INSERT INTO mini_buildd_component VALUES('','','restricted');
INSERT INTO mini_buildd_component VALUES('','','universe');
INSERT INTO mini_buildd_component VALUES('','','multiverse');
CREATE TABLE IF NOT EXISTS "mini_buildd_source" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "origin" varchar(60) NOT NULL, "codename" varchar(60) NOT NULL, "description" varchar(100) NOT NULL, "codeversion" varchar(50) NOT NULL, "codeversion_override" varchar(50) NOT NULL);
INSERT INTO mini_buildd_source VALUES(1,'','',2,'2024-01-08 17:53:43.560233',0,'Debian','sid','Debian x.y Unstable - Not Released','~SID','~SID');
INSERT INTO mini_buildd_source VALUES(2,'','',2,'2024-01-08 17:55:32.358606',0,'Debian','trixie','Debian x.y Testing distribution - Not Released','~TRIXIE','~TRIXIE');
INSERT INTO mini_buildd_source VALUES(3,'X-Remove-From-Component: updates/','',2,'2024-01-08 17:40:01.499998',0,'Debian','trixie-security','Debian x.y Testing - Security Updates - Not Released','~TRIXIE-SECURITY','~TRIXIE-SECURITY');
INSERT INTO mini_buildd_source VALUES(4,'','',2,'2024-01-08 17:40:13.779641',0,'Debian Backports','trixie-backports','Debian X.Y - Backports','~TRIXIE-BACKPORTS','~TRIXIE-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(5,'','',2,'2024-01-08 17:57:27.965564',0,'Debian','bookworm','Debian 12.4 Released 10 December 2023','12','12');
INSERT INTO mini_buildd_source VALUES(6,'X-Remove-From-Component: updates/','',2,'2024-01-08 17:43:33.543844',0,'Debian','bookworm-security','Debian 12 - Security Updates','12','12');
INSERT INTO mini_buildd_source VALUES(7,'','',2,'2024-01-08 17:43:49.947241',0,'Debian Backports','bookworm-backports','Debian bookworm - Backports','~BOOKWORM-BACKPORTS','~BOOKWORM-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(8,'','',2,'2024-01-08 17:44:04.294404',0,'Debian Backports','bookworm-backports-sloppy','Debian 12 - Sloppy Backports','~BOOKWORM-BACKPORTS-SLOPPY','~BOOKWORM-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(9,'','',2,'2024-01-08 17:59:25.369504',0,'Debian','bullseye','Debian 11.8 Released 07 October 2023','11','11');
INSERT INTO mini_buildd_source VALUES(10,'X-Remove-From-Component: updates/','',2,'2024-01-08 17:44:40.126793',0,'Debian','bullseye-security','Debian 11 - Security Updates','11','11');
INSERT INTO mini_buildd_source VALUES(11,'','',2,'2024-01-08 17:44:52.207632',0,'Debian Backports','bullseye-backports','Debian 11 - Backports','~BULLSEYE-BACKPORTS','~BULLSEYE-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(12,'','',2,'2024-01-08 17:45:05.524371',0,'Debian Backports','bullseye-backports-sloppy','Debian 11 - Sloppy Backports','~BULLSEYE-BACKPORTS-SLOPPY','~BULLSEYE-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(13,'','',2,'2024-01-08 18:01:11.032944',0,'Debian','buster','Debian 10.13 Released 10 September 2022','10','10');
INSERT INTO mini_buildd_source VALUES(14,replace('Codename: buster\nLabel: Debian-Security\nX-Remove-From-Component: updates/','\n',char(10)),'',2,'2024-01-08 17:45:33.173728',0,'Debian','buster/updates','Debian 10 - Security Updates','10','10');
INSERT INTO mini_buildd_source VALUES(15,'','',2,'2024-01-08 17:45:46.642860',0,'Debian Backports','buster-backports','Backports for the Buster distribution','~BUSTER-BACKPORTS','~BUSTER-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(16,'','',2,'2024-01-08 17:46:00.183324',0,'Debian Backports','buster-backports-sloppy','Debian 10 - Sloppy Backports','~BUSTER-BACKPORTS-SLOPPY','~BUSTER-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(17,'','',2,'2024-01-08 18:02:51.564267',0,'Debian','stretch','Debian 9.13 Released 18 July 2020','9','9');
INSERT INTO mini_buildd_source VALUES(18,replace('Codename: stretch\nLabel: Debian-Security\nX-Remove-From-Component: updates/','\n',char(10)),'',2,'2024-01-08 17:40:52.737134',0,'Debian','stretch/updates','Debian 9 Security Updates','9','9');
INSERT INTO mini_buildd_source VALUES(19,'','',2,'2024-01-08 17:41:09.182504',0,'Debian Backports','stretch-backports','Backports for the Stretch distribution','~STRETCH-BACKPORTS','~STRETCH-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(20,'','',2,'2024-01-08 17:41:21.908444',0,'Debian Backports','stretch-backports-sloppy','Debian 9 - Sloppy Backports','~STRETCH-BACKPORTS-SLOPPY','~STRETCH-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(21,'','',2,'2024-01-08 18:04:45.310464',0,'Debian','jessie','Debian 8.11 Released 23 June 2018','8','8');
INSERT INTO mini_buildd_source VALUES(22,replace('Codename: jessie\nLabel: Debian-Security\nX-Remove-From-Component: updates/','\n',char(10)),'',2,'2024-01-08 17:41:45.188667',0,'Debian','jessie/updates','Debian 8 Security Updates','8','8');
INSERT INTO mini_buildd_source VALUES(23,'X-Check-Valid-Until: no','',2,'2024-01-08 17:41:55.066768',0,'Debian Backports','jessie-backports','Backports for the Jessie Distribution','~JESSIE-BACKPORTS','~JESSIE-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(24,'X-Check-Valid-Until: no','',2,'2024-01-08 17:42:06.737344',0,'Debian Backports','jessie-backports-sloppy','Backports for the Jessie distribution','~JESSIE-BACKPORTS-SLOPPY','~JESSIE-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(25,'','',2,'2024-01-08 18:06:29.193585',0,'Debian','wheezy','Debian 7.11 Released 04 June 2016','7','7');
INSERT INTO mini_buildd_source VALUES(26,replace('Codename: wheezy\nLabel: Debian-Security\nX-Remove-From-Component: updates/\nX-Check-Valid-Until: no','\n',char(10)),'',2,'2024-01-08 17:42:33.181245',0,'Debian','wheezy/updates','Long Term Support for Debian 7','7','7');
INSERT INTO mini_buildd_source VALUES(27,'','',2,'2024-01-08 17:42:50.315988',0,'Debian Backports','wheezy-backports','Backports for the Wheezy Distribution','~WHEEZY-BACKPORTS','~WHEEZY-BACKPORTS');
INSERT INTO mini_buildd_source VALUES(28,'','',2,'2024-01-08 17:43:00.414909',0,'Debian Backports','wheezy-backports-sloppy','Backports for the Wheezy Distribution','~WHEEZY-BACKPORTS-SLOPPY','~WHEEZY-BACKPORTS-SLOPPY');
INSERT INTO mini_buildd_source VALUES(29,'','',2,'2024-01-08 18:08:24.970071',0,'Ubuntu','kinetic','Ubuntu Kinetic 22.10','2210','2210');
INSERT INTO mini_buildd_source VALUES(30,replace('Codename: kinetic\nSuite: kinetic-security','\n',char(10)),'',2,'2024-01-08 17:46:39.291358',0,'Ubuntu','kinetic-security','Ubuntu Kinetic Security','2210','2210');
INSERT INTO mini_buildd_source VALUES(31,replace('Codename: kinetic\nSuite: kinetic-backports','\n',char(10)),'',2,'2024-01-08 17:46:51.374710',0,'Ubuntu','kinetic-backports','Ubuntu Kinetic Backports','2210','2210');
INSERT INTO mini_buildd_source VALUES(32,'','',2,'2024-01-08 18:10:00.184241',0,'Ubuntu','jammy','Ubuntu Jammy 22.04','2204','2204');
INSERT INTO mini_buildd_source VALUES(33,replace('Codename: jammy\nSuite: jammy-security','\n',char(10)),'',2,'2024-01-08 17:47:15.456856',0,'Ubuntu','jammy-security','Ubuntu Jammy Security','2204','2204');
INSERT INTO mini_buildd_source VALUES(34,replace('Codename: jammy\nSuite: jammy-backports','\n',char(10)),'',2,'2024-01-08 17:47:27.768817',0,'Ubuntu','jammy-backports','Ubuntu Jammy Backports','2204','2204');
INSERT INTO mini_buildd_source VALUES(35,'','',2,'2024-01-08 18:11:43.439304',0,'Ubuntu','impish','Ubuntu Impish 21.10','2110','2110');
INSERT INTO mini_buildd_source VALUES(36,replace('Codename: impish\nSuite: impish-security','\n',char(10)),'',2,'2024-01-08 17:47:53.326237',0,'Ubuntu','impish-security','Ubuntu Impish Security','2110','2110');
INSERT INTO mini_buildd_source VALUES(37,replace('Codename: impish\nSuite: impish-backports','\n',char(10)),'',2,'2024-01-08 17:48:11.558254',0,'Ubuntu','impish-backports','Ubuntu Impish Backports','2110','2110');
INSERT INTO mini_buildd_source VALUES(38,'','',2,'2024-01-08 18:13:37.062470',0,'Ubuntu','hirsute','Ubuntu Hirsute 21.04','2104','2104');
INSERT INTO mini_buildd_source VALUES(39,replace('Codename: hirsute\nSuite: hirsute-security','\n',char(10)),'',2,'2024-01-08 17:48:38.352982',0,'Ubuntu','hirsute-security','Ubuntu Hirsute Security','2104','2104');
INSERT INTO mini_buildd_source VALUES(40,replace('Codename: hirsute\nSuite: hirsute-backports','\n',char(10)),'',2,'2024-01-08 17:48:46.772827',0,'Ubuntu','hirsute-backports','Ubuntu Hirsute Backports','2104','2104');
INSERT INTO mini_buildd_source VALUES(41,'','',2,'2024-01-08 18:15:21.503922',0,'Ubuntu','groovy','Ubuntu Groovy 20.10','2010','2010');
INSERT INTO mini_buildd_source VALUES(42,replace('Codename: groovy\nSuite: groovy-security','\n',char(10)),'',2,'2024-01-08 17:49:10.373113',0,'Ubuntu','groovy-security','Ubuntu Groovy Security','2010','2010');
INSERT INTO mini_buildd_source VALUES(43,replace('Codename: groovy\nSuite: groovy-backports','\n',char(10)),'',2,'2024-01-08 17:49:29.186306',0,'Ubuntu','groovy-backports','Ubuntu Groovy Backports','2010','2010');
INSERT INTO mini_buildd_source VALUES(44,'','',2,'2024-01-08 18:17:17.822329',0,'Ubuntu','focal','Ubuntu Focal 20.04','2004','2004');
INSERT INTO mini_buildd_source VALUES(45,replace('Codename: focal\nSuite: focal-security','\n',char(10)),'',2,'2024-01-08 17:49:57.804171',0,'Ubuntu','focal-security','Ubuntu Focal Security','2004','2004');
INSERT INTO mini_buildd_source VALUES(46,replace('Codename: focal\nSuite: focal-backports','\n',char(10)),'',2,'2024-01-08 17:50:07.815792',0,'Ubuntu','focal-backports','Ubuntu Focal Backports','2004','2004');
INSERT INTO mini_buildd_source VALUES(47,'','',2,'2024-01-08 18:19:02.462223',0,'Ubuntu','bionic','Ubuntu Bionic 18.04','1804','1804');
INSERT INTO mini_buildd_source VALUES(48,replace('Codename: bionic\nSuite: bionic-security','\n',char(10)),'',2,'2024-01-08 17:50:27.232564',0,'Ubuntu','bionic-security','Ubuntu Bionic Security','1804','1804');
INSERT INTO mini_buildd_source VALUES(49,replace('Codename: bionic\nSuite: bionic-backports','\n',char(10)),'',2,'2024-01-08 17:50:53.538638',0,'Ubuntu','bionic-backports','Ubuntu Bionic Backports','1804','1804');
INSERT INTO mini_buildd_source VALUES(50,'','',2,'2024-01-08 18:20:55.019376',0,'Ubuntu','xenial','Ubuntu Xenial 16.04','1604','1604');
INSERT INTO mini_buildd_source VALUES(51,replace('Codename: xenial\nSuite: xenial-security','\n',char(10)),'',2,'2024-01-08 17:51:26.875858',0,'Ubuntu','xenial-security','Ubuntu Xenial Security','1604','1604');
INSERT INTO mini_buildd_source VALUES(52,replace('Codename: xenial\nSuite: xenial-backports','\n',char(10)),'',2,'2024-01-08 17:51:48.504917',0,'Ubuntu','xenial-backports','Ubuntu Xenial Backports','1604','1604');
CREATE TABLE IF NOT EXISTS "mini_buildd_source_apt_keys" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "aptkey_id" integer NOT NULL REFERENCES "mini_buildd_aptkey" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_source_apt_keys VALUES(1,1,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(2,1,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(3,2,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(4,2,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(5,3,3);
INSERT INTO mini_buildd_source_apt_keys VALUES(6,3,4);
INSERT INTO mini_buildd_source_apt_keys VALUES(7,4,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(8,4,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(9,5,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(10,5,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(11,5,6);
INSERT INTO mini_buildd_source_apt_keys VALUES(12,6,3);
INSERT INTO mini_buildd_source_apt_keys VALUES(13,6,4);
INSERT INTO mini_buildd_source_apt_keys VALUES(14,7,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(15,7,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(16,8,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(17,8,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(18,9,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(19,9,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(20,9,7);
INSERT INTO mini_buildd_source_apt_keys VALUES(21,10,8);
INSERT INTO mini_buildd_source_apt_keys VALUES(22,10,3);
INSERT INTO mini_buildd_source_apt_keys VALUES(23,11,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(24,11,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(25,11,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(26,12,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(27,12,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(28,12,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(29,13,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(30,13,9);
INSERT INTO mini_buildd_source_apt_keys VALUES(31,13,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(32,14,8);
INSERT INTO mini_buildd_source_apt_keys VALUES(33,14,3);
INSERT INTO mini_buildd_source_apt_keys VALUES(34,15,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(35,15,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(36,15,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(37,16,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(38,16,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(39,16,2);
INSERT INTO mini_buildd_source_apt_keys VALUES(40,17,10);
INSERT INTO mini_buildd_source_apt_keys VALUES(41,17,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(42,17,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(43,17,11);
INSERT INTO mini_buildd_source_apt_keys VALUES(44,18,12);
INSERT INTO mini_buildd_source_apt_keys VALUES(45,18,8);
INSERT INTO mini_buildd_source_apt_keys VALUES(46,19,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(47,19,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(48,20,5);
INSERT INTO mini_buildd_source_apt_keys VALUES(49,20,1);
INSERT INTO mini_buildd_source_apt_keys VALUES(50,21,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(51,21,14);
INSERT INTO mini_buildd_source_apt_keys VALUES(52,21,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(53,22,16);
INSERT INTO mini_buildd_source_apt_keys VALUES(54,22,12);
INSERT INTO mini_buildd_source_apt_keys VALUES(55,23,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(56,23,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(57,24,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(58,24,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(59,25,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(60,25,17);
INSERT INTO mini_buildd_source_apt_keys VALUES(61,25,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(62,26,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(63,26,16);
INSERT INTO mini_buildd_source_apt_keys VALUES(64,27,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(65,27,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(66,28,13);
INSERT INTO mini_buildd_source_apt_keys VALUES(67,28,15);
INSERT INTO mini_buildd_source_apt_keys VALUES(68,29,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(69,30,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(70,31,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(71,32,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(72,33,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(73,34,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(74,35,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(75,36,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(76,37,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(77,38,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(78,39,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(79,40,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(80,41,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(81,42,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(82,43,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(83,44,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(84,44,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(85,45,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(86,45,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(87,46,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(88,46,18);
INSERT INTO mini_buildd_source_apt_keys VALUES(89,47,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(90,48,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(91,49,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(92,50,20);
INSERT INTO mini_buildd_source_apt_keys VALUES(93,50,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(94,51,20);
INSERT INTO mini_buildd_source_apt_keys VALUES(95,51,19);
INSERT INTO mini_buildd_source_apt_keys VALUES(96,52,20);
INSERT INTO mini_buildd_source_apt_keys VALUES(97,52,19);
CREATE TABLE IF NOT EXISTS "mini_buildd_source_archives" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "archive_id" varchar(512) NOT NULL REFERENCES "mini_buildd_archive" ("url") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_source_archives VALUES(135,3,'http://deb.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(136,3,'http://security.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(137,3,'http://hostname.example.com:3142/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(138,4,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(139,4,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(140,4,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(146,18,'http://archive.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(147,18,'http://hostname.example.com:3142/debian-archive/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(148,19,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(149,19,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(150,20,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(151,20,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(154,22,'http://archive.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(155,22,'http://hostname.example.com:3142/debian-archive/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(156,23,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(157,23,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(158,24,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(159,24,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(162,26,'http://archive.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(163,26,'http://hostname.example.com:3142/debian-archive/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(164,27,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(165,27,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(166,28,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(167,28,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(171,6,'http://deb.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(172,6,'http://security.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(173,6,'http://hostname.example.com:3142/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(174,7,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(175,7,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(176,7,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(177,8,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(178,8,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(179,8,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(183,10,'http://deb.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(184,10,'http://security.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(185,10,'http://hostname.example.com:3142/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(186,11,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(187,11,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(188,11,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(189,12,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(190,12,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(191,12,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(195,14,'http://deb.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(196,14,'http://security.debian.org/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(197,14,'http://hostname.example.com:3142/debian-security/');
INSERT INTO mini_buildd_source_archives VALUES(198,15,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(199,15,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(200,15,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(201,16,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(202,16,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(203,16,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(206,30,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(207,30,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(208,31,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(209,31,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(213,33,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(214,33,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(215,33,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(216,34,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(217,34,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(218,34,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(221,36,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(222,36,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(223,37,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(224,37,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(227,39,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(228,39,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(229,40,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(230,40,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(233,42,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(234,42,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(235,43,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(236,43,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(240,45,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(241,45,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(242,45,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(243,46,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(244,46,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(245,46,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(249,48,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(250,48,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(251,48,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(252,49,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(253,49,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(254,49,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(258,51,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(259,51,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(260,51,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(261,52,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(262,52,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(263,52,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(267,1,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(268,1,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(269,1,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(273,2,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(274,2,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(275,2,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(279,5,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(280,5,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(281,5,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(285,9,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(286,9,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(287,9,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(291,13,'http://deb.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(292,13,'http://ftp.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(293,13,'http://hostname.example.com:3142/debian/');
INSERT INTO mini_buildd_source_archives VALUES(296,17,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(297,17,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(300,21,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(301,21,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(304,25,'http://archive.debian.org/debian/');
INSERT INTO mini_buildd_source_archives VALUES(305,25,'http://hostname.example.com:3142/debian-archive/debian/');
INSERT INTO mini_buildd_source_archives VALUES(308,29,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(309,29,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(313,32,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(314,32,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(315,32,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(318,35,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(319,35,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(322,38,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(323,38,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(326,41,'http://old-releases.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(327,41,'http://hostname.example.com:3142/ubuntu-old/');
INSERT INTO mini_buildd_source_archives VALUES(331,44,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(332,44,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(333,44,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(337,47,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(338,47,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(339,47,'http://hostname.example.com:3142/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(343,50,'http://archive.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(344,50,'http://security.ubuntu.com/ubuntu/');
INSERT INTO mini_buildd_source_archives VALUES(345,50,'http://hostname.example.com:3142/ubuntu/');
CREATE TABLE IF NOT EXISTS "mini_buildd_source_components" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "component_id" varchar(50) NOT NULL REFERENCES "mini_buildd_component" ("name") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_source_components VALUES(1,1,'main');
INSERT INTO mini_buildd_source_components VALUES(2,1,'contrib');
INSERT INTO mini_buildd_source_components VALUES(3,1,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(4,1,'non-free');
INSERT INTO mini_buildd_source_components VALUES(13,2,'main');
INSERT INTO mini_buildd_source_components VALUES(14,2,'contrib');
INSERT INTO mini_buildd_source_components VALUES(15,2,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(16,2,'non-free');
INSERT INTO mini_buildd_source_components VALUES(25,3,'main');
INSERT INTO mini_buildd_source_components VALUES(26,3,'contrib');
INSERT INTO mini_buildd_source_components VALUES(27,3,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(28,3,'non-free');
INSERT INTO mini_buildd_source_components VALUES(37,4,'main');
INSERT INTO mini_buildd_source_components VALUES(38,4,'contrib');
INSERT INTO mini_buildd_source_components VALUES(39,4,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(40,4,'non-free');
INSERT INTO mini_buildd_source_components VALUES(49,5,'main');
INSERT INTO mini_buildd_source_components VALUES(50,5,'contrib');
INSERT INTO mini_buildd_source_components VALUES(51,5,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(52,5,'non-free');
INSERT INTO mini_buildd_source_components VALUES(61,6,'main');
INSERT INTO mini_buildd_source_components VALUES(62,6,'contrib');
INSERT INTO mini_buildd_source_components VALUES(63,6,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(64,6,'non-free');
INSERT INTO mini_buildd_source_components VALUES(73,7,'main');
INSERT INTO mini_buildd_source_components VALUES(74,7,'contrib');
INSERT INTO mini_buildd_source_components VALUES(75,7,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(76,7,'non-free');
INSERT INTO mini_buildd_source_components VALUES(85,8,'main');
INSERT INTO mini_buildd_source_components VALUES(86,8,'contrib');
INSERT INTO mini_buildd_source_components VALUES(87,8,'non-free-firmware');
INSERT INTO mini_buildd_source_components VALUES(88,8,'non-free');
INSERT INTO mini_buildd_source_components VALUES(97,9,'main');
INSERT INTO mini_buildd_source_components VALUES(98,9,'contrib');
INSERT INTO mini_buildd_source_components VALUES(99,9,'non-free');
INSERT INTO mini_buildd_source_components VALUES(106,10,'main');
INSERT INTO mini_buildd_source_components VALUES(107,10,'contrib');
INSERT INTO mini_buildd_source_components VALUES(108,10,'non-free');
INSERT INTO mini_buildd_source_components VALUES(115,11,'main');
INSERT INTO mini_buildd_source_components VALUES(116,11,'contrib');
INSERT INTO mini_buildd_source_components VALUES(117,11,'non-free');
INSERT INTO mini_buildd_source_components VALUES(124,12,'main');
INSERT INTO mini_buildd_source_components VALUES(125,12,'contrib');
INSERT INTO mini_buildd_source_components VALUES(126,12,'non-free');
INSERT INTO mini_buildd_source_components VALUES(133,13,'main');
INSERT INTO mini_buildd_source_components VALUES(134,13,'contrib');
INSERT INTO mini_buildd_source_components VALUES(135,13,'non-free');
INSERT INTO mini_buildd_source_components VALUES(142,14,'main');
INSERT INTO mini_buildd_source_components VALUES(143,14,'contrib');
INSERT INTO mini_buildd_source_components VALUES(144,14,'non-free');
INSERT INTO mini_buildd_source_components VALUES(151,15,'main');
INSERT INTO mini_buildd_source_components VALUES(152,15,'contrib');
INSERT INTO mini_buildd_source_components VALUES(153,15,'non-free');
INSERT INTO mini_buildd_source_components VALUES(160,16,'main');
INSERT INTO mini_buildd_source_components VALUES(161,16,'contrib');
INSERT INTO mini_buildd_source_components VALUES(162,16,'non-free');
INSERT INTO mini_buildd_source_components VALUES(169,17,'main');
INSERT INTO mini_buildd_source_components VALUES(170,17,'contrib');
INSERT INTO mini_buildd_source_components VALUES(171,17,'non-free');
INSERT INTO mini_buildd_source_components VALUES(175,18,'main');
INSERT INTO mini_buildd_source_components VALUES(176,18,'contrib');
INSERT INTO mini_buildd_source_components VALUES(177,18,'non-free');
INSERT INTO mini_buildd_source_components VALUES(181,19,'main');
INSERT INTO mini_buildd_source_components VALUES(182,19,'contrib');
INSERT INTO mini_buildd_source_components VALUES(183,19,'non-free');
INSERT INTO mini_buildd_source_components VALUES(187,20,'main');
INSERT INTO mini_buildd_source_components VALUES(188,20,'contrib');
INSERT INTO mini_buildd_source_components VALUES(189,20,'non-free');
INSERT INTO mini_buildd_source_components VALUES(193,21,'main');
INSERT INTO mini_buildd_source_components VALUES(194,21,'contrib');
INSERT INTO mini_buildd_source_components VALUES(195,21,'non-free');
INSERT INTO mini_buildd_source_components VALUES(199,22,'main');
INSERT INTO mini_buildd_source_components VALUES(200,22,'contrib');
INSERT INTO mini_buildd_source_components VALUES(201,22,'non-free');
INSERT INTO mini_buildd_source_components VALUES(205,23,'main');
INSERT INTO mini_buildd_source_components VALUES(206,23,'contrib');
INSERT INTO mini_buildd_source_components VALUES(207,23,'non-free');
INSERT INTO mini_buildd_source_components VALUES(211,24,'main');
INSERT INTO mini_buildd_source_components VALUES(212,24,'contrib');
INSERT INTO mini_buildd_source_components VALUES(213,24,'non-free');
INSERT INTO mini_buildd_source_components VALUES(217,25,'main');
INSERT INTO mini_buildd_source_components VALUES(218,25,'contrib');
INSERT INTO mini_buildd_source_components VALUES(219,25,'non-free');
INSERT INTO mini_buildd_source_components VALUES(223,26,'main');
INSERT INTO mini_buildd_source_components VALUES(224,26,'contrib');
INSERT INTO mini_buildd_source_components VALUES(225,26,'non-free');
INSERT INTO mini_buildd_source_components VALUES(229,27,'main');
INSERT INTO mini_buildd_source_components VALUES(230,27,'contrib');
INSERT INTO mini_buildd_source_components VALUES(231,27,'non-free');
INSERT INTO mini_buildd_source_components VALUES(235,28,'main');
INSERT INTO mini_buildd_source_components VALUES(236,28,'contrib');
INSERT INTO mini_buildd_source_components VALUES(237,28,'non-free');
INSERT INTO mini_buildd_source_components VALUES(241,29,'main');
INSERT INTO mini_buildd_source_components VALUES(242,29,'restricted');
INSERT INTO mini_buildd_source_components VALUES(243,29,'universe');
INSERT INTO mini_buildd_source_components VALUES(244,29,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(249,30,'main');
INSERT INTO mini_buildd_source_components VALUES(250,30,'restricted');
INSERT INTO mini_buildd_source_components VALUES(251,30,'universe');
INSERT INTO mini_buildd_source_components VALUES(252,30,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(257,31,'main');
INSERT INTO mini_buildd_source_components VALUES(258,31,'restricted');
INSERT INTO mini_buildd_source_components VALUES(259,31,'universe');
INSERT INTO mini_buildd_source_components VALUES(260,31,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(265,32,'main');
INSERT INTO mini_buildd_source_components VALUES(266,32,'restricted');
INSERT INTO mini_buildd_source_components VALUES(267,32,'universe');
INSERT INTO mini_buildd_source_components VALUES(268,32,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(277,33,'main');
INSERT INTO mini_buildd_source_components VALUES(278,33,'restricted');
INSERT INTO mini_buildd_source_components VALUES(279,33,'universe');
INSERT INTO mini_buildd_source_components VALUES(280,33,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(289,34,'main');
INSERT INTO mini_buildd_source_components VALUES(290,34,'restricted');
INSERT INTO mini_buildd_source_components VALUES(291,34,'universe');
INSERT INTO mini_buildd_source_components VALUES(292,34,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(301,35,'main');
INSERT INTO mini_buildd_source_components VALUES(302,35,'restricted');
INSERT INTO mini_buildd_source_components VALUES(303,35,'universe');
INSERT INTO mini_buildd_source_components VALUES(304,35,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(309,36,'main');
INSERT INTO mini_buildd_source_components VALUES(310,36,'restricted');
INSERT INTO mini_buildd_source_components VALUES(311,36,'universe');
INSERT INTO mini_buildd_source_components VALUES(312,36,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(317,37,'main');
INSERT INTO mini_buildd_source_components VALUES(318,37,'restricted');
INSERT INTO mini_buildd_source_components VALUES(319,37,'universe');
INSERT INTO mini_buildd_source_components VALUES(320,37,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(325,38,'main');
INSERT INTO mini_buildd_source_components VALUES(326,38,'restricted');
INSERT INTO mini_buildd_source_components VALUES(327,38,'universe');
INSERT INTO mini_buildd_source_components VALUES(328,38,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(333,39,'main');
INSERT INTO mini_buildd_source_components VALUES(334,39,'restricted');
INSERT INTO mini_buildd_source_components VALUES(335,39,'universe');
INSERT INTO mini_buildd_source_components VALUES(336,39,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(341,40,'main');
INSERT INTO mini_buildd_source_components VALUES(342,40,'restricted');
INSERT INTO mini_buildd_source_components VALUES(343,40,'universe');
INSERT INTO mini_buildd_source_components VALUES(344,40,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(349,41,'main');
INSERT INTO mini_buildd_source_components VALUES(350,41,'restricted');
INSERT INTO mini_buildd_source_components VALUES(351,41,'universe');
INSERT INTO mini_buildd_source_components VALUES(352,41,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(357,42,'main');
INSERT INTO mini_buildd_source_components VALUES(358,42,'restricted');
INSERT INTO mini_buildd_source_components VALUES(359,42,'universe');
INSERT INTO mini_buildd_source_components VALUES(360,42,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(365,43,'main');
INSERT INTO mini_buildd_source_components VALUES(366,43,'restricted');
INSERT INTO mini_buildd_source_components VALUES(367,43,'universe');
INSERT INTO mini_buildd_source_components VALUES(368,43,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(373,44,'main');
INSERT INTO mini_buildd_source_components VALUES(374,44,'restricted');
INSERT INTO mini_buildd_source_components VALUES(375,44,'universe');
INSERT INTO mini_buildd_source_components VALUES(376,44,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(385,45,'main');
INSERT INTO mini_buildd_source_components VALUES(386,45,'restricted');
INSERT INTO mini_buildd_source_components VALUES(387,45,'universe');
INSERT INTO mini_buildd_source_components VALUES(388,45,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(397,46,'main');
INSERT INTO mini_buildd_source_components VALUES(398,46,'restricted');
INSERT INTO mini_buildd_source_components VALUES(399,46,'universe');
INSERT INTO mini_buildd_source_components VALUES(400,46,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(409,47,'main');
INSERT INTO mini_buildd_source_components VALUES(410,47,'restricted');
INSERT INTO mini_buildd_source_components VALUES(411,47,'universe');
INSERT INTO mini_buildd_source_components VALUES(412,47,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(417,48,'main');
INSERT INTO mini_buildd_source_components VALUES(418,48,'restricted');
INSERT INTO mini_buildd_source_components VALUES(419,48,'universe');
INSERT INTO mini_buildd_source_components VALUES(420,48,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(429,49,'main');
INSERT INTO mini_buildd_source_components VALUES(430,49,'restricted');
INSERT INTO mini_buildd_source_components VALUES(431,49,'universe');
INSERT INTO mini_buildd_source_components VALUES(432,49,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(441,50,'main');
INSERT INTO mini_buildd_source_components VALUES(442,50,'restricted');
INSERT INTO mini_buildd_source_components VALUES(443,50,'universe');
INSERT INTO mini_buildd_source_components VALUES(444,50,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(453,51,'main');
INSERT INTO mini_buildd_source_components VALUES(454,51,'restricted');
INSERT INTO mini_buildd_source_components VALUES(455,51,'universe');
INSERT INTO mini_buildd_source_components VALUES(456,51,'multiverse');
INSERT INTO mini_buildd_source_components VALUES(465,52,'main');
INSERT INTO mini_buildd_source_components VALUES(466,52,'restricted');
INSERT INTO mini_buildd_source_components VALUES(467,52,'universe');
INSERT INTO mini_buildd_source_components VALUES(468,52,'multiverse');
CREATE TABLE IF NOT EXISTS "mini_buildd_source_architectures" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "architecture_id" varchar(50) NOT NULL REFERENCES "mini_buildd_architecture" ("name") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_source_architectures VALUES(1,1,'all');
INSERT INTO mini_buildd_source_architectures VALUES(2,1,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(3,1,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(4,1,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(5,1,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(6,1,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(7,1,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(8,1,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(9,1,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(10,1,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(31,2,'all');
INSERT INTO mini_buildd_source_architectures VALUES(32,2,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(33,2,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(34,2,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(35,2,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(36,2,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(37,2,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(38,2,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(39,2,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(58,3,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(59,3,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(60,3,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(61,3,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(62,3,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(63,3,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(64,3,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(65,3,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(82,4,'all');
INSERT INTO mini_buildd_source_architectures VALUES(83,4,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(84,4,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(85,4,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(86,4,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(87,4,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(88,4,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(89,4,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(90,4,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(109,5,'all');
INSERT INTO mini_buildd_source_architectures VALUES(110,5,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(111,5,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(112,5,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(113,5,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(114,5,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(115,5,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(116,5,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(117,5,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(118,5,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(139,6,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(140,6,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(141,6,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(142,6,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(143,6,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(144,6,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(145,6,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(146,6,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(147,6,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(166,7,'all');
INSERT INTO mini_buildd_source_architectures VALUES(167,7,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(168,7,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(169,7,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(170,7,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(171,7,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(172,7,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(173,7,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(174,7,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(175,7,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(196,8,'all');
INSERT INTO mini_buildd_source_architectures VALUES(197,8,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(198,8,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(199,8,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(200,8,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(201,8,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(202,8,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(203,8,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(204,8,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(205,8,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(226,9,'all');
INSERT INTO mini_buildd_source_architectures VALUES(227,9,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(228,9,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(229,9,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(230,9,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(231,9,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(232,9,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(233,9,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(234,9,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(235,9,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(256,10,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(257,10,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(258,10,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(259,10,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(260,10,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(261,10,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(262,10,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(263,10,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(264,10,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(283,11,'all');
INSERT INTO mini_buildd_source_architectures VALUES(284,11,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(285,11,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(286,11,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(287,11,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(288,11,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(289,11,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(290,11,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(291,11,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(292,11,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(313,12,'all');
INSERT INTO mini_buildd_source_architectures VALUES(314,12,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(315,12,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(316,12,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(317,12,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(318,12,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(319,12,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(320,12,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(321,12,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(322,12,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(343,13,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(344,13,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(345,13,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(346,13,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(347,13,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(348,13,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(349,13,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(350,13,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(351,13,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(352,13,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(373,14,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(374,14,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(375,14,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(376,14,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(385,15,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(386,15,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(387,15,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(388,15,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(389,15,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(390,15,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(391,15,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(392,15,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(393,15,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(394,15,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(415,16,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(416,16,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(417,16,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(418,16,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(419,16,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(420,16,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(421,16,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(422,16,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(423,16,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(424,16,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(445,17,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(446,17,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(447,17,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(448,17,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(449,17,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(450,17,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(451,17,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(452,17,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(453,17,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(454,17,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(465,18,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(466,18,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(467,18,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(468,18,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(469,18,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(475,19,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(476,19,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(477,19,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(478,19,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(479,19,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(480,19,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(481,19,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(482,19,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(483,19,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(484,19,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(495,20,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(496,20,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(497,20,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(498,20,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(499,20,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(500,20,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(501,20,'mips64el');
INSERT INTO mini_buildd_source_architectures VALUES(502,20,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(503,20,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(504,20,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(515,21,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(516,21,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(517,21,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(518,21,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(519,21,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(520,21,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(521,21,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(522,21,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(523,21,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(524,21,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(535,22,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(536,22,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(537,22,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(538,22,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(543,23,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(544,23,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(545,23,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(546,23,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(547,23,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(548,23,'kfreebsd-amd64');
INSERT INTO mini_buildd_source_architectures VALUES(549,23,'kfreebsd-i386');
INSERT INTO mini_buildd_source_architectures VALUES(550,23,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(551,23,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(552,23,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(553,23,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(554,23,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(567,24,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(568,24,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(569,24,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(570,24,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(571,24,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(572,24,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(573,24,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(574,24,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(575,24,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(576,24,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(587,25,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(588,25,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(589,25,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(590,25,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(591,25,'ia64');
INSERT INTO mini_buildd_source_architectures VALUES(592,25,'kfreebsd-amd64');
INSERT INTO mini_buildd_source_architectures VALUES(593,25,'kfreebsd-i386');
INSERT INTO mini_buildd_source_architectures VALUES(594,25,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(595,25,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(596,25,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(597,25,'s390');
INSERT INTO mini_buildd_source_architectures VALUES(598,25,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(599,25,'sparc');
INSERT INTO mini_buildd_source_architectures VALUES(613,26,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(614,26,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(615,26,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(616,26,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(621,27,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(622,27,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(623,27,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(624,27,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(625,27,'ia64');
INSERT INTO mini_buildd_source_architectures VALUES(626,27,'kfreebsd-amd64');
INSERT INTO mini_buildd_source_architectures VALUES(627,27,'kfreebsd-i386');
INSERT INTO mini_buildd_source_architectures VALUES(628,27,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(629,27,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(630,27,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(631,27,'s390');
INSERT INTO mini_buildd_source_architectures VALUES(632,27,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(633,27,'sparc');
INSERT INTO mini_buildd_source_architectures VALUES(647,28,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(648,28,'armel');
INSERT INTO mini_buildd_source_architectures VALUES(649,28,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(650,28,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(651,28,'ia64');
INSERT INTO mini_buildd_source_architectures VALUES(652,28,'kfreebsd-amd64');
INSERT INTO mini_buildd_source_architectures VALUES(653,28,'kfreebsd-i386');
INSERT INTO mini_buildd_source_architectures VALUES(654,28,'mips');
INSERT INTO mini_buildd_source_architectures VALUES(655,28,'mipsel');
INSERT INTO mini_buildd_source_architectures VALUES(656,28,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(657,28,'s390');
INSERT INTO mini_buildd_source_architectures VALUES(658,28,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(659,28,'sparc');
INSERT INTO mini_buildd_source_architectures VALUES(673,29,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(674,29,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(675,29,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(676,29,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(677,29,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(678,29,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(679,29,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(687,30,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(688,30,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(689,30,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(690,30,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(691,30,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(692,30,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(693,30,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(701,31,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(702,31,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(703,31,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(704,31,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(705,31,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(706,31,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(707,31,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(715,32,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(716,32,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(717,32,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(718,32,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(719,32,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(720,32,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(721,32,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(736,33,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(737,33,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(738,33,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(739,33,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(740,33,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(741,33,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(742,33,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(757,34,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(758,34,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(759,34,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(760,34,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(761,34,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(762,34,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(763,34,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(778,35,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(779,35,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(780,35,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(781,35,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(782,35,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(783,35,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(784,35,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(792,36,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(793,36,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(794,36,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(795,36,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(796,36,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(797,36,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(798,36,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(806,37,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(807,37,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(808,37,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(809,37,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(810,37,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(811,37,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(812,37,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(820,38,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(821,38,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(822,38,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(823,38,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(824,38,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(825,38,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(826,38,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(834,39,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(835,39,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(836,39,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(837,39,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(838,39,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(839,39,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(840,39,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(848,40,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(849,40,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(850,40,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(851,40,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(852,40,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(853,40,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(854,40,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(862,41,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(863,41,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(864,41,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(865,41,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(866,41,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(867,41,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(868,41,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(876,42,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(877,42,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(878,42,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(879,42,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(880,42,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(881,42,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(882,42,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(890,43,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(891,43,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(892,43,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(893,43,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(894,43,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(895,43,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(896,43,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(904,44,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(905,44,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(906,44,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(907,44,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(908,44,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(909,44,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(910,44,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(925,45,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(926,45,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(927,45,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(928,45,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(929,45,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(930,45,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(931,45,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(946,46,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(947,46,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(948,46,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(949,46,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(950,46,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(951,46,'riscv64');
INSERT INTO mini_buildd_source_architectures VALUES(952,46,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(967,47,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(968,47,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(969,47,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(970,47,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(971,47,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(972,47,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(979,48,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(980,48,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(981,48,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(982,48,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(983,48,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(984,48,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(997,49,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(998,49,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(999,49,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(1000,49,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(1001,49,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(1002,49,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(1015,50,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(1016,50,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(1017,50,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(1018,50,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(1019,50,'powerpc');
INSERT INTO mini_buildd_source_architectures VALUES(1020,50,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(1021,50,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(1036,51,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(1037,51,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(1038,51,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(1039,51,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(1040,51,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(1041,51,'s390x');
INSERT INTO mini_buildd_source_architectures VALUES(1054,52,'amd64');
INSERT INTO mini_buildd_source_architectures VALUES(1055,52,'arm64');
INSERT INTO mini_buildd_source_architectures VALUES(1056,52,'armhf');
INSERT INTO mini_buildd_source_architectures VALUES(1057,52,'i386');
INSERT INTO mini_buildd_source_architectures VALUES(1058,52,'ppc64el');
INSERT INTO mini_buildd_source_architectures VALUES(1059,52,'s390x');
CREATE TABLE IF NOT EXISTS "mini_buildd_prioritysource" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "priority" integer NOT NULL);
INSERT INTO mini_buildd_prioritysource VALUES(1,'','',3,500);
INSERT INTO mini_buildd_prioritysource VALUES(2,'','',4,1);
INSERT INTO mini_buildd_prioritysource VALUES(3,'','',6,500);
INSERT INTO mini_buildd_prioritysource VALUES(4,'','',7,1);
INSERT INTO mini_buildd_prioritysource VALUES(5,'','',8,1);
INSERT INTO mini_buildd_prioritysource VALUES(6,'','',10,500);
INSERT INTO mini_buildd_prioritysource VALUES(7,'','',11,1);
INSERT INTO mini_buildd_prioritysource VALUES(8,'','',12,1);
INSERT INTO mini_buildd_prioritysource VALUES(9,'','',14,500);
INSERT INTO mini_buildd_prioritysource VALUES(10,'','',15,1);
INSERT INTO mini_buildd_prioritysource VALUES(11,'','',16,1);
INSERT INTO mini_buildd_prioritysource VALUES(12,'','',18,500);
INSERT INTO mini_buildd_prioritysource VALUES(13,'','',19,1);
INSERT INTO mini_buildd_prioritysource VALUES(14,'','',20,1);
INSERT INTO mini_buildd_prioritysource VALUES(15,'','',22,500);
INSERT INTO mini_buildd_prioritysource VALUES(16,'','',23,1);
INSERT INTO mini_buildd_prioritysource VALUES(17,'','',24,1);
INSERT INTO mini_buildd_prioritysource VALUES(18,'','',26,500);
INSERT INTO mini_buildd_prioritysource VALUES(19,'','',27,1);
INSERT INTO mini_buildd_prioritysource VALUES(20,'','',28,1);
INSERT INTO mini_buildd_prioritysource VALUES(21,'','',30,500);
INSERT INTO mini_buildd_prioritysource VALUES(22,'','',31,1);
INSERT INTO mini_buildd_prioritysource VALUES(23,'','',33,500);
INSERT INTO mini_buildd_prioritysource VALUES(24,'','',34,1);
INSERT INTO mini_buildd_prioritysource VALUES(25,'','',36,500);
INSERT INTO mini_buildd_prioritysource VALUES(26,'','',37,1);
INSERT INTO mini_buildd_prioritysource VALUES(27,'','',39,500);
INSERT INTO mini_buildd_prioritysource VALUES(28,'','',40,1);
INSERT INTO mini_buildd_prioritysource VALUES(29,'','',42,500);
INSERT INTO mini_buildd_prioritysource VALUES(30,'','',43,1);
INSERT INTO mini_buildd_prioritysource VALUES(31,'','',45,500);
INSERT INTO mini_buildd_prioritysource VALUES(32,'','',46,1);
INSERT INTO mini_buildd_prioritysource VALUES(33,'','',48,500);
INSERT INTO mini_buildd_prioritysource VALUES(34,'','',49,1);
INSERT INTO mini_buildd_prioritysource VALUES(35,'','',51,500);
INSERT INTO mini_buildd_prioritysource VALUES(36,'','',52,1);
CREATE TABLE IF NOT EXISTS "mini_buildd_suite" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "name" varchar(100) NOT NULL);
INSERT INTO mini_buildd_suite VALUES(1,'','','stable');
INSERT INTO mini_buildd_suite VALUES(2,'','','hotfix');
INSERT INTO mini_buildd_suite VALUES(3,'','','testing');
INSERT INTO mini_buildd_suite VALUES(4,'','','unstable');
INSERT INTO mini_buildd_suite VALUES(5,'','','snapshot');
INSERT INTO mini_buildd_suite VALUES(6,'','','experimental');
CREATE TABLE IF NOT EXISTS "mini_buildd_suiteoption" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "layout_id" varchar(100) NOT NULL REFERENCES "mini_buildd_layout" ("name") DEFERRABLE INITIALLY DEFERRED, "suite_id" integer NOT NULL REFERENCES "mini_buildd_suite" ("id") DEFERRABLE INITIALLY DEFERRED, "uploadable" bool NOT NULL, "experimental" bool NOT NULL, "migrates_to_id" integer NULL REFERENCES "mini_buildd_suiteoption" ("id") DEFERRABLE INITIALLY DEFERRED, "build_keyring_package" bool NOT NULL, "auto_migrate_after" integer NOT NULL, "not_automatic" bool NOT NULL, "but_automatic_upgrades" bool NOT NULL);
INSERT INTO mini_buildd_suiteoption VALUES(1,replace('Rollback: 6\n','\n',char(10)),'','Default',1,0,0,NULL,0,0,1,1);
INSERT INTO mini_buildd_suiteoption VALUES(2,replace('Rollback: 4\n','\n',char(10)),'','Default',2,1,0,1,0,0,1,1);
INSERT INTO mini_buildd_suiteoption VALUES(3,replace('Rollback: 3\n','\n',char(10)),'','Default',3,0,0,1,0,0,1,1);
INSERT INTO mini_buildd_suiteoption VALUES(4,replace('Rollback: 9\n','\n',char(10)),'','Default',4,1,0,3,1,0,1,1);
INSERT INTO mini_buildd_suiteoption VALUES(5,replace('Rollback: 12\n','\n',char(10)),'','Default',5,1,1,NULL,0,0,1,1);
INSERT INTO mini_buildd_suiteoption VALUES(6,replace('Rollback: 6\n','\n',char(10)),'','Default',6,1,1,NULL,0,0,1,0);
CREATE TABLE IF NOT EXISTS "mini_buildd_layout" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "name" varchar(100) NOT NULL PRIMARY KEY, "default_version" varchar(100) NOT NULL, "mandatory_version_regex" varchar(100) NOT NULL, "experimental_default_version" varchar(30) NOT NULL, "experimental_mandatory_version_regex" varchar(100) NOT NULL);
INSERT INTO mini_buildd_layout VALUES('','','Default','~%IDENTITY%%CODEVERSION%+1','~%IDENTITY%%CODEVERSION%\+[1-9]','~%IDENTITY%%CODEVERSION%+0','~%IDENTITY%%CODEVERSION%\+0');
CREATE TABLE IF NOT EXISTS "mini_buildd_architectureoption" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "architecture_id" varchar(50) NOT NULL REFERENCES "mini_buildd_architecture" ("name") DEFERRABLE INITIALLY DEFERRED, "distribution_id" integer NOT NULL REFERENCES "mini_buildd_distribution" ("id") DEFERRABLE INITIALLY DEFERRED, "optional" bool NOT NULL, "build_architecture_all" bool NOT NULL);
INSERT INTO mini_buildd_architectureoption VALUES(1,'','','amd64',1,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(2,'','','i386',1,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(3,'','','amd64',2,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(4,'','','i386',2,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(5,'','','amd64',3,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(6,'','','i386',3,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(7,'','','amd64',4,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(8,'','','i386',4,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(9,'','','amd64',5,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(10,'','','i386',5,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(11,'','','amd64',6,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(12,'','','i386',6,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(13,'','','amd64',7,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(14,'','','i386',7,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(15,'','','amd64',8,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(16,'','','i386',8,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(17,'','','amd64',9,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(18,'','','i386',9,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(19,'','','amd64',10,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(20,'','','i386',10,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(21,'','','amd64',11,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(22,'','','i386',11,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(23,'','','amd64',12,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(24,'','','i386',12,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(25,'','','amd64',13,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(26,'','','i386',13,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(27,'','','amd64',14,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(28,'','','i386',14,1,0);
INSERT INTO mini_buildd_architectureoption VALUES(29,'','','amd64',15,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(30,'','','i386',15,0,0);
INSERT INTO mini_buildd_architectureoption VALUES(31,'','','amd64',16,0,1);
INSERT INTO mini_buildd_architectureoption VALUES(32,'','','i386',16,0,0);
CREATE TABLE IF NOT EXISTS "mini_buildd_distribution" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "base_source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "build_dep_resolver" integer NOT NULL, "apt_allow_unauthenticated" bool NOT NULL, "lintian_mode" integer NOT NULL, "lintian_extra_options" varchar(200) NOT NULL, "piuparts_mode" integer NOT NULL, "piuparts_extra_options" varchar(200) NOT NULL, "piuparts_root_arg" varchar(200) NOT NULL, "chroot_setup_script" text NOT NULL, "sbuildrc_snippet" text NOT NULL);
INSERT INTO mini_buildd_distribution VALUES(1,'','',1,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(2,'','',2,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(3,'','',5,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(4,'','',9,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(5,'','',13,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(6,'','',17,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(7,'Sbuild-Setup-Blocks: apt-allow-unauthenticated apt-setup apt-key-binary apt-update ccache eatmydata','',21,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(8,'Sbuild-Setup-Blocks: apt-allow-unauthenticated apt-setup apt-key-binary apt-update ccache eatmydata','',25,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(9,'Deb-Build-Options: noddebs','',29,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(10,'Deb-Build-Options: noddebs','',32,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(11,'Deb-Build-Options: noddebs','',35,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(12,'Deb-Build-Options: noddebs','',38,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(13,'Deb-Build-Options: noddebs','',41,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(14,'Deb-Build-Options: noddebs','',44,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(15,'Deb-Build-Options: noddebs','',47,1,0,2,'--info',0,'--info','sudo','','');
INSERT INTO mini_buildd_distribution VALUES(16,'Sbuild-Setup-Blocks: apt-setup apt-key-add apt-update ccache eatmydata','',50,1,0,2,'--info',0,'--info','sudo','','');
CREATE TABLE IF NOT EXISTS "mini_buildd_distribution_extra_sources" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "distribution_id" integer NOT NULL REFERENCES "mini_buildd_distribution" ("id") DEFERRABLE INITIALLY DEFERRED, "prioritysource_id" integer NOT NULL REFERENCES "mini_buildd_prioritysource" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(1,2,1);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(2,2,2);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(3,3,3);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(4,3,4);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(5,3,5);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(6,4,6);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(7,4,7);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(8,4,8);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(9,5,9);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(10,5,10);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(11,5,11);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(12,6,12);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(13,6,13);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(14,6,14);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(15,7,15);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(16,7,16);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(17,7,17);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(18,8,18);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(19,8,19);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(20,8,20);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(21,9,21);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(22,9,22);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(23,10,23);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(24,10,24);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(25,11,25);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(26,11,26);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(27,12,27);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(28,12,28);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(29,13,29);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(30,13,30);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(31,14,31);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(32,14,32);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(33,15,33);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(34,15,34);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(35,16,35);
INSERT INTO mini_buildd_distribution_extra_sources VALUES(36,16,36);
CREATE TABLE IF NOT EXISTS "mini_buildd_distribution_components" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "distribution_id" integer NOT NULL REFERENCES "mini_buildd_distribution" ("id") DEFERRABLE INITIALLY DEFERRED, "component_id" varchar(50) NOT NULL REFERENCES "mini_buildd_component" ("name") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_distribution_components VALUES(1,1,'main');
INSERT INTO mini_buildd_distribution_components VALUES(2,1,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(3,1,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(4,1,'non-free-firmware');
INSERT INTO mini_buildd_distribution_components VALUES(5,2,'main');
INSERT INTO mini_buildd_distribution_components VALUES(6,2,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(7,2,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(8,2,'non-free-firmware');
INSERT INTO mini_buildd_distribution_components VALUES(9,3,'main');
INSERT INTO mini_buildd_distribution_components VALUES(10,3,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(11,3,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(12,3,'non-free-firmware');
INSERT INTO mini_buildd_distribution_components VALUES(13,4,'main');
INSERT INTO mini_buildd_distribution_components VALUES(14,4,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(15,4,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(16,5,'main');
INSERT INTO mini_buildd_distribution_components VALUES(17,5,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(18,5,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(19,6,'main');
INSERT INTO mini_buildd_distribution_components VALUES(20,6,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(21,6,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(22,7,'main');
INSERT INTO mini_buildd_distribution_components VALUES(23,7,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(24,7,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(25,8,'main');
INSERT INTO mini_buildd_distribution_components VALUES(26,8,'contrib');
INSERT INTO mini_buildd_distribution_components VALUES(27,8,'non-free');
INSERT INTO mini_buildd_distribution_components VALUES(28,9,'main');
INSERT INTO mini_buildd_distribution_components VALUES(29,9,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(30,9,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(31,9,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(32,10,'main');
INSERT INTO mini_buildd_distribution_components VALUES(33,10,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(34,10,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(35,10,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(36,11,'main');
INSERT INTO mini_buildd_distribution_components VALUES(37,11,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(38,11,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(39,11,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(40,12,'main');
INSERT INTO mini_buildd_distribution_components VALUES(41,12,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(42,12,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(43,12,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(44,13,'main');
INSERT INTO mini_buildd_distribution_components VALUES(45,13,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(46,13,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(47,13,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(48,14,'main');
INSERT INTO mini_buildd_distribution_components VALUES(49,14,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(50,14,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(51,14,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(52,15,'main');
INSERT INTO mini_buildd_distribution_components VALUES(53,15,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(54,15,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(55,15,'multiverse');
INSERT INTO mini_buildd_distribution_components VALUES(56,16,'main');
INSERT INTO mini_buildd_distribution_components VALUES(57,16,'universe');
INSERT INTO mini_buildd_distribution_components VALUES(58,16,'restricted');
INSERT INTO mini_buildd_distribution_components VALUES(59,16,'multiverse');
CREATE TABLE IF NOT EXISTS "mini_buildd_emailaddress" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "address" varchar(255) NOT NULL PRIMARY KEY, "name" varchar(255) NOT NULL);
CREATE TABLE IF NOT EXISTS "mini_buildd_repository" ("extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "identity" varchar(50) NOT NULL PRIMARY KEY, "layout_id" varchar(100) NOT NULL REFERENCES "mini_buildd_layout" ("name") DEFERRABLE INITIALLY DEFERRED, "allow_unauthenticated_uploads" bool NOT NULL, "extra_uploader_keyrings" text NOT NULL, "notify_changed_by" bool NOT NULL, "notify_maintainer" bool NOT NULL, "reprepro_morguedir" bool NOT NULL, "external_home_url" varchar(200) NOT NULL);
INSERT INTO mini_buildd_repository VALUES('','',2,'2024-01-08 17:51:50.387006',0,'test','Default',1,'',0,0,0,'');
CREATE TABLE IF NOT EXISTS "mini_buildd_repository_distributions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repository_id" varchar(50) NOT NULL REFERENCES "mini_buildd_repository" ("identity") DEFERRABLE INITIALLY DEFERRED, "distribution_id" integer NOT NULL REFERENCES "mini_buildd_distribution" ("id") DEFERRABLE INITIALLY DEFERRED);
INSERT INTO mini_buildd_repository_distributions VALUES(1,'test',1);
INSERT INTO mini_buildd_repository_distributions VALUES(2,'test',2);
INSERT INTO mini_buildd_repository_distributions VALUES(3,'test',3);
INSERT INTO mini_buildd_repository_distributions VALUES(4,'test',4);
INSERT INTO mini_buildd_repository_distributions VALUES(5,'test',5);
INSERT INTO mini_buildd_repository_distributions VALUES(6,'test',6);
INSERT INTO mini_buildd_repository_distributions VALUES(7,'test',7);
INSERT INTO mini_buildd_repository_distributions VALUES(8,'test',8);
INSERT INTO mini_buildd_repository_distributions VALUES(9,'test',9);
INSERT INTO mini_buildd_repository_distributions VALUES(10,'test',10);
INSERT INTO mini_buildd_repository_distributions VALUES(11,'test',11);
INSERT INTO mini_buildd_repository_distributions VALUES(12,'test',12);
INSERT INTO mini_buildd_repository_distributions VALUES(13,'test',13);
INSERT INTO mini_buildd_repository_distributions VALUES(14,'test',14);
INSERT INTO mini_buildd_repository_distributions VALUES(15,'test',15);
INSERT INTO mini_buildd_repository_distributions VALUES(16,'test',16);
CREATE TABLE IF NOT EXISTS "mini_buildd_repository_notify" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "repository_id" varchar(50) NOT NULL REFERENCES "mini_buildd_repository" ("identity") DEFERRABLE INITIALLY DEFERRED, "emailaddress_id" varchar(255) NOT NULL REFERENCES "mini_buildd_emailaddress" ("address") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "mini_buildd_daemon" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "identity" varchar(50) NOT NULL, "hostname" varchar(200) NOT NULL, "email_address" varchar(255) NOT NULL, "gnupg_template" text NOT NULL, "gnupg_keyserver" varchar(200) NOT NULL, "ftpd_bind" varchar(200) NOT NULL, "ftpd_options" varchar(255) NOT NULL, "build_queue_size" integer NOT NULL, "sbuild_jobs" integer NOT NULL, "smtp_server" varchar(254) NOT NULL, "allow_emails_to" varchar(254) NOT NULL, "custom_hooks_directory" varchar(255) NOT NULL, "show_last_packages" integer NOT NULL, "show_last_builds" integer NOT NULL, "wait_for_build_results" integer NOT NULL, "keep_build_results" integer NOT NULL);
INSERT INTO mini_buildd_daemon VALUES(1,'','',2,'2024-01-08 17:27:49.946261',0,'hostname','','mini-buildd@hostname.example.com',replace('Key-Type: RSA\nKey-Length: 4096\nExpire-Date: 0','\n',char(10)),'keyserver.ubuntu.com','tcp6:port=8067','',16,1,'localhost:25','.*@hostname.example.com','',500,100,5,5);
CREATE TABLE IF NOT EXISTS "mini_buildd_daemon_notify" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "daemon_id" integer NOT NULL REFERENCES "mini_buildd_daemon" ("id") DEFERRABLE INITIALLY DEFERRED, "emailaddress_id" varchar(255) NOT NULL REFERENCES "mini_buildd_emailaddress" ("address") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "mini_buildd_chroot" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "status" integer NOT NULL, "last_checked" datetime NOT NULL, "auto_reactivate" bool NOT NULL, "source_id" integer NOT NULL REFERENCES "mini_buildd_source" ("id") DEFERRABLE INITIALLY DEFERRED, "architecture_id" varchar(50) NOT NULL REFERENCES "mini_buildd_architecture" ("name") DEFERRABLE INITIALLY DEFERRED, "personality" varchar(50) NOT NULL, "personality_override" varchar(50) NOT NULL);
INSERT INTO mini_buildd_chroot VALUES(1,'','',2,'2024-01-08 17:52:50.365184',0,1,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(2,'','',2,'2024-01-08 17:53:44.794618',0,1,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(3,'','',2,'2024-01-08 17:54:41.260351',0,2,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(4,'','',2,'2024-01-08 17:55:33.477848',0,2,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(5,'','',2,'2024-01-08 17:56:35.027189',0,5,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(6,'','',2,'2024-01-08 17:57:29.085477',0,5,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(7,'','',2,'2024-01-08 17:58:30.487686',0,9,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(8,'','',2,'2024-01-08 17:59:26.321618',0,9,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(9,'','',2,'2024-01-08 18:00:20.459527',0,13,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(10,'','',2,'2024-01-08 18:01:12.078840',0,13,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(11,'','',2,'2024-01-08 18:02:03.796953',0,17,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(12,'','',2,'2024-01-08 18:02:52.472861',0,17,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(13,'','',2,'2024-01-08 18:03:49.213780',0,21,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(14,'','',2,'2024-01-08 18:04:48.136021',0,21,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(15,'Debootstrap-Extra-Options: --include=realpath','',2,'2024-01-08 18:05:41.252028',0,25,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(16,'Debootstrap-Extra-Options: --include=realpath','',2,'2024-01-08 18:06:35.722870',0,25,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(17,'','',2,'2024-01-08 18:07:33.232798',0,29,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(18,'','',2,'2024-01-08 18:08:25.480763',0,29,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(19,'','',2,'2024-01-08 18:09:14.762176',0,32,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(20,'','',2,'2024-01-08 18:10:00.638030',0,32,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(21,'','',2,'2024-01-08 18:10:54.424753',0,35,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(22,'','',2,'2024-01-08 18:11:43.965551',0,35,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(23,'','',2,'2024-01-08 18:12:47.845744',0,38,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(24,'','',2,'2024-01-08 18:13:37.598235',0,38,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(25,'','',2,'2024-01-08 18:14:33.005511',0,41,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(26,'','',2,'2024-01-08 18:15:22.033953',0,41,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(27,'','',2,'2024-01-08 18:16:24.867254',0,44,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(28,'','',2,'2024-01-08 18:17:18.278481',0,44,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(29,'','',2,'2024-01-08 18:18:12.788232',0,47,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(30,'','',2,'2024-01-08 18:19:02.937117',0,47,'i386','linux32','');
INSERT INTO mini_buildd_chroot VALUES(31,'','',2,'2024-01-08 18:20:01.087468',0,50,'amd64','linux','');
INSERT INTO mini_buildd_chroot VALUES(32,'','',2,'2024-01-08 18:20:55.467629',0,50,'i386','linux32','');
CREATE TABLE IF NOT EXISTS "mini_buildd_dirchroot" ("chroot_ptr_id" integer NOT NULL PRIMARY KEY REFERENCES "mini_buildd_chroot" ("id") DEFERRABLE INITIALLY DEFERRED, "union_type" integer NOT NULL);
INSERT INTO mini_buildd_dirchroot VALUES(1,3);
INSERT INTO mini_buildd_dirchroot VALUES(2,3);
INSERT INTO mini_buildd_dirchroot VALUES(3,3);
INSERT INTO mini_buildd_dirchroot VALUES(4,3);
INSERT INTO mini_buildd_dirchroot VALUES(5,3);
INSERT INTO mini_buildd_dirchroot VALUES(6,3);
INSERT INTO mini_buildd_dirchroot VALUES(7,3);
INSERT INTO mini_buildd_dirchroot VALUES(8,3);
INSERT INTO mini_buildd_dirchroot VALUES(9,3);
INSERT INTO mini_buildd_dirchroot VALUES(10,3);
INSERT INTO mini_buildd_dirchroot VALUES(11,3);
INSERT INTO mini_buildd_dirchroot VALUES(12,3);
INSERT INTO mini_buildd_dirchroot VALUES(13,3);
INSERT INTO mini_buildd_dirchroot VALUES(14,3);
INSERT INTO mini_buildd_dirchroot VALUES(15,3);
INSERT INTO mini_buildd_dirchroot VALUES(16,3);
INSERT INTO mini_buildd_dirchroot VALUES(17,3);
INSERT INTO mini_buildd_dirchroot VALUES(18,3);
INSERT INTO mini_buildd_dirchroot VALUES(19,3);
INSERT INTO mini_buildd_dirchroot VALUES(20,3);
INSERT INTO mini_buildd_dirchroot VALUES(21,3);
INSERT INTO mini_buildd_dirchroot VALUES(22,3);
INSERT INTO mini_buildd_dirchroot VALUES(23,3);
INSERT INTO mini_buildd_dirchroot VALUES(24,3);
INSERT INTO mini_buildd_dirchroot VALUES(25,3);
INSERT INTO mini_buildd_dirchroot VALUES(26,3);
INSERT INTO mini_buildd_dirchroot VALUES(27,3);
INSERT INTO mini_buildd_dirchroot VALUES(28,3);
INSERT INTO mini_buildd_dirchroot VALUES(29,3);
INSERT INTO mini_buildd_dirchroot VALUES(30,3);
INSERT INTO mini_buildd_dirchroot VALUES(31,3);
INSERT INTO mini_buildd_dirchroot VALUES(32,3);
CREATE TABLE IF NOT EXISTS "mini_buildd_filechroot" ("chroot_ptr_id" integer NOT NULL PRIMARY KEY REFERENCES "mini_buildd_chroot" ("id") DEFERRABLE INITIALLY DEFERRED, "compression" integer NOT NULL);
CREATE TABLE IF NOT EXISTS "mini_buildd_lvmchroot" ("chroot_ptr_id" integer NOT NULL PRIMARY KEY REFERENCES "mini_buildd_chroot" ("id") DEFERRABLE INITIALLY DEFERRED, "volume_group" varchar(80) NOT NULL, "filesystem" varchar(10) NOT NULL, "snapshot_size" integer NOT NULL);
CREATE TABLE IF NOT EXISTS "mini_buildd_looplvmchroot" ("lvmchroot_ptr_id" integer NOT NULL PRIMARY KEY REFERENCES "mini_buildd_lvmchroot" ("chroot_ptr_id") DEFERRABLE INITIALLY DEFERRED, "loop_size" integer NOT NULL);
CREATE TABLE IF NOT EXISTS "mini_buildd_btrfssnapshotchroot" ("chroot_ptr_id" integer NOT NULL PRIMARY KEY REFERENCES "mini_buildd_chroot" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "mini_buildd_subscription" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "extra_options" text NOT NULL, "pickled_data" text NOT NULL, "subscriber_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "package" varchar(100) NOT NULL, "distribution" varchar(100) NOT NULL);
CREATE TABLE IF NOT EXISTS "django_migrations" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app" varchar(255) NOT NULL, "name" varchar(255) NOT NULL, "applied" datetime NOT NULL);
INSERT INTO django_migrations VALUES(1,'contenttypes','0001_initial','2024-01-08 17:27:40.828648');
INSERT INTO django_migrations VALUES(2,'auth','0001_initial','2024-01-08 17:27:40.869368');
INSERT INTO django_migrations VALUES(3,'admin','0001_initial','2024-01-08 17:27:40.902825');
INSERT INTO django_migrations VALUES(4,'admin','0002_logentry_remove_auto_add','2024-01-08 17:27:40.921839');
INSERT INTO django_migrations VALUES(5,'admin','0003_logentry_add_action_flag_choices','2024-01-08 17:27:40.941782');
INSERT INTO django_migrations VALUES(6,'contenttypes','0002_remove_content_type_name','2024-01-08 17:27:40.968331');
INSERT INTO django_migrations VALUES(7,'auth','0002_alter_permission_name_max_length','2024-01-08 17:27:40.985835');
INSERT INTO django_migrations VALUES(8,'auth','0003_alter_user_email_max_length','2024-01-08 17:27:41.002843');
INSERT INTO django_migrations VALUES(9,'auth','0004_alter_user_username_opts','2024-01-08 17:27:41.023433');
INSERT INTO django_migrations VALUES(10,'auth','0005_alter_user_last_login_null','2024-01-08 17:27:41.041023');
INSERT INTO django_migrations VALUES(11,'auth','0006_require_contenttypes_0002','2024-01-08 17:27:41.052430');
INSERT INTO django_migrations VALUES(12,'auth','0007_alter_validators_add_error_messages','2024-01-08 17:27:41.068097');
INSERT INTO django_migrations VALUES(13,'auth','0008_alter_user_username_max_length','2024-01-08 17:27:41.084466');
INSERT INTO django_migrations VALUES(14,'auth','0009_alter_user_last_name_max_length','2024-01-08 17:27:41.100413');
INSERT INTO django_migrations VALUES(15,'auth','0010_alter_group_name_max_length','2024-01-08 17:27:41.116468');
INSERT INTO django_migrations VALUES(16,'auth','0011_update_proxy_permissions','2024-01-08 17:27:41.137433');
INSERT INTO django_migrations VALUES(17,'auth','0012_alter_user_first_name_max_length','2024-01-08 17:27:41.153422');
INSERT INTO django_migrations VALUES(18,'sessions','0001_initial','2024-01-08 17:27:41.180790');
CREATE TABLE IF NOT EXISTS "auth_group_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "auth_user_groups" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "group_id" integer NOT NULL REFERENCES "auth_group" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "auth_user_user_permissions" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "permission_id" integer NOT NULL REFERENCES "auth_permission" ("id") DEFERRABLE INITIALLY DEFERRED);
CREATE TABLE IF NOT EXISTS "django_admin_log" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "object_id" text NULL, "object_repr" varchar(200) NOT NULL, "action_flag" smallint unsigned NOT NULL CHECK ("action_flag" >= 0), "change_message" text NOT NULL, "content_type_id" integer NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "user_id" integer NOT NULL REFERENCES "auth_user" ("id") DEFERRABLE INITIALLY DEFERRED, "action_time" datetime NOT NULL);
CREATE TABLE IF NOT EXISTS "django_content_type" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "app_label" varchar(100) NOT NULL, "model" varchar(100) NOT NULL);
INSERT INTO django_content_type VALUES(1,'auth','permission');
INSERT INTO django_content_type VALUES(2,'auth','group');
INSERT INTO django_content_type VALUES(3,'auth','user');
INSERT INTO django_content_type VALUES(4,'contenttypes','contenttype');
INSERT INTO django_content_type VALUES(5,'admin','logentry');
INSERT INTO django_content_type VALUES(6,'sessions','session');
INSERT INTO django_content_type VALUES(7,'mini_buildd','aptkey');
INSERT INTO django_content_type VALUES(8,'mini_buildd','uploader');
INSERT INTO django_content_type VALUES(9,'mini_buildd','remote');
INSERT INTO django_content_type VALUES(10,'mini_buildd','archive');
INSERT INTO django_content_type VALUES(11,'mini_buildd','architecture');
INSERT INTO django_content_type VALUES(12,'mini_buildd','component');
INSERT INTO django_content_type VALUES(13,'mini_buildd','source');
INSERT INTO django_content_type VALUES(14,'mini_buildd','prioritysource');
INSERT INTO django_content_type VALUES(15,'mini_buildd','suite');
INSERT INTO django_content_type VALUES(16,'mini_buildd','suiteoption');
INSERT INTO django_content_type VALUES(17,'mini_buildd','layout');
INSERT INTO django_content_type VALUES(18,'mini_buildd','architectureoption');
INSERT INTO django_content_type VALUES(19,'mini_buildd','distribution');
INSERT INTO django_content_type VALUES(20,'mini_buildd','emailaddress');
INSERT INTO django_content_type VALUES(21,'mini_buildd','repository');
INSERT INTO django_content_type VALUES(22,'mini_buildd','daemon');
INSERT INTO django_content_type VALUES(23,'mini_buildd','chroot');
INSERT INTO django_content_type VALUES(24,'mini_buildd','dirchroot');
INSERT INTO django_content_type VALUES(25,'mini_buildd','filechroot');
INSERT INTO django_content_type VALUES(26,'mini_buildd','lvmchroot');
INSERT INTO django_content_type VALUES(27,'mini_buildd','looplvmchroot');
INSERT INTO django_content_type VALUES(28,'mini_buildd','btrfssnapshotchroot');
INSERT INTO django_content_type VALUES(29,'mini_buildd','subscription');
CREATE TABLE IF NOT EXISTS "auth_permission" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "content_type_id" integer NOT NULL REFERENCES "django_content_type" ("id") DEFERRABLE INITIALLY DEFERRED, "codename" varchar(100) NOT NULL, "name" varchar(255) NOT NULL);
INSERT INTO auth_permission VALUES(1,1,'add_permission','Can add permission');
INSERT INTO auth_permission VALUES(2,1,'change_permission','Can change permission');
INSERT INTO auth_permission VALUES(3,1,'delete_permission','Can delete permission');
INSERT INTO auth_permission VALUES(4,1,'view_permission','Can view permission');
INSERT INTO auth_permission VALUES(5,2,'add_group','Can add group');
INSERT INTO auth_permission VALUES(6,2,'change_group','Can change group');
INSERT INTO auth_permission VALUES(7,2,'delete_group','Can delete group');
INSERT INTO auth_permission VALUES(8,2,'view_group','Can view group');
INSERT INTO auth_permission VALUES(9,3,'add_user','Can add user');
INSERT INTO auth_permission VALUES(10,3,'change_user','Can change user');
INSERT INTO auth_permission VALUES(11,3,'delete_user','Can delete user');
INSERT INTO auth_permission VALUES(12,3,'view_user','Can view user');
INSERT INTO auth_permission VALUES(13,4,'add_contenttype','Can add content type');
INSERT INTO auth_permission VALUES(14,4,'change_contenttype','Can change content type');
INSERT INTO auth_permission VALUES(15,4,'delete_contenttype','Can delete content type');
INSERT INTO auth_permission VALUES(16,4,'view_contenttype','Can view content type');
INSERT INTO auth_permission VALUES(17,5,'add_logentry','Can add log entry');
INSERT INTO auth_permission VALUES(18,5,'change_logentry','Can change log entry');
INSERT INTO auth_permission VALUES(19,5,'delete_logentry','Can delete log entry');
INSERT INTO auth_permission VALUES(20,5,'view_logentry','Can view log entry');
INSERT INTO auth_permission VALUES(21,6,'add_session','Can add session');
INSERT INTO auth_permission VALUES(22,6,'change_session','Can change session');
INSERT INTO auth_permission VALUES(23,6,'delete_session','Can delete session');
INSERT INTO auth_permission VALUES(24,6,'view_session','Can view session');
INSERT INTO auth_permission VALUES(25,7,'add_aptkey','Can add apt key');
INSERT INTO auth_permission VALUES(26,7,'change_aptkey','Can change apt key');
INSERT INTO auth_permission VALUES(27,7,'delete_aptkey','Can delete apt key');
INSERT INTO auth_permission VALUES(28,7,'view_aptkey','Can view apt key');
INSERT INTO auth_permission VALUES(29,8,'add_uploader','Can add uploader');
INSERT INTO auth_permission VALUES(30,8,'change_uploader','Can change uploader');
INSERT INTO auth_permission VALUES(31,8,'delete_uploader','Can delete uploader');
INSERT INTO auth_permission VALUES(32,8,'view_uploader','Can view uploader');
INSERT INTO auth_permission VALUES(33,9,'add_remote','Can add remote');
INSERT INTO auth_permission VALUES(34,9,'change_remote','Can change remote');
INSERT INTO auth_permission VALUES(35,9,'delete_remote','Can delete remote');
INSERT INTO auth_permission VALUES(36,9,'view_remote','Can view remote');
INSERT INTO auth_permission VALUES(37,10,'add_archive','Can add archive');
INSERT INTO auth_permission VALUES(38,10,'change_archive','Can change archive');
INSERT INTO auth_permission VALUES(39,10,'delete_archive','Can delete archive');
INSERT INTO auth_permission VALUES(40,10,'view_archive','Can view archive');
INSERT INTO auth_permission VALUES(41,11,'add_architecture','Can add architecture');
INSERT INTO auth_permission VALUES(42,11,'change_architecture','Can change architecture');
INSERT INTO auth_permission VALUES(43,11,'delete_architecture','Can delete architecture');
INSERT INTO auth_permission VALUES(44,11,'view_architecture','Can view architecture');
INSERT INTO auth_permission VALUES(45,12,'add_component','Can add component');
INSERT INTO auth_permission VALUES(46,12,'change_component','Can change component');
INSERT INTO auth_permission VALUES(47,12,'delete_component','Can delete component');
INSERT INTO auth_permission VALUES(48,12,'view_component','Can view component');
INSERT INTO auth_permission VALUES(49,13,'add_source','Can add source');
INSERT INTO auth_permission VALUES(50,13,'change_source','Can change source');
INSERT INTO auth_permission VALUES(51,13,'delete_source','Can delete source');
INSERT INTO auth_permission VALUES(52,13,'view_source','Can view source');
INSERT INTO auth_permission VALUES(53,14,'add_prioritysource','Can add priority source');
INSERT INTO auth_permission VALUES(54,14,'change_prioritysource','Can change priority source');
INSERT INTO auth_permission VALUES(55,14,'delete_prioritysource','Can delete priority source');
INSERT INTO auth_permission VALUES(56,14,'view_prioritysource','Can view priority source');
INSERT INTO auth_permission VALUES(57,15,'add_suite','Can add suite');
INSERT INTO auth_permission VALUES(58,15,'change_suite','Can change suite');
INSERT INTO auth_permission VALUES(59,15,'delete_suite','Can delete suite');
INSERT INTO auth_permission VALUES(60,15,'view_suite','Can view suite');
INSERT INTO auth_permission VALUES(61,16,'add_suiteoption','Can add suite option');
INSERT INTO auth_permission VALUES(62,16,'change_suiteoption','Can change suite option');
INSERT INTO auth_permission VALUES(63,16,'delete_suiteoption','Can delete suite option');
INSERT INTO auth_permission VALUES(64,16,'view_suiteoption','Can view suite option');
INSERT INTO auth_permission VALUES(65,17,'add_layout','Can add layout');
INSERT INTO auth_permission VALUES(66,17,'change_layout','Can change layout');
INSERT INTO auth_permission VALUES(67,17,'delete_layout','Can delete layout');
INSERT INTO auth_permission VALUES(68,17,'view_layout','Can view layout');
INSERT INTO auth_permission VALUES(69,18,'add_architectureoption','Can add architecture option');
INSERT INTO auth_permission VALUES(70,18,'change_architectureoption','Can change architecture option');
INSERT INTO auth_permission VALUES(71,18,'delete_architectureoption','Can delete architecture option');
INSERT INTO auth_permission VALUES(72,18,'view_architectureoption','Can view architecture option');
INSERT INTO auth_permission VALUES(73,19,'add_distribution','Can add distribution');
INSERT INTO auth_permission VALUES(74,19,'change_distribution','Can change distribution');
INSERT INTO auth_permission VALUES(75,19,'delete_distribution','Can delete distribution');
INSERT INTO auth_permission VALUES(76,19,'view_distribution','Can view distribution');
INSERT INTO auth_permission VALUES(77,20,'add_emailaddress','Can add email address');
INSERT INTO auth_permission VALUES(78,20,'change_emailaddress','Can change email address');
INSERT INTO auth_permission VALUES(79,20,'delete_emailaddress','Can delete email address');
INSERT INTO auth_permission VALUES(80,20,'view_emailaddress','Can view email address');
INSERT INTO auth_permission VALUES(81,21,'add_repository','Can add repository');
INSERT INTO auth_permission VALUES(82,21,'change_repository','Can change repository');
INSERT INTO auth_permission VALUES(83,21,'delete_repository','Can delete repository');
INSERT INTO auth_permission VALUES(84,21,'view_repository','Can view repository');
INSERT INTO auth_permission VALUES(85,22,'add_daemon','Can add daemon');
INSERT INTO auth_permission VALUES(86,22,'change_daemon','Can change daemon');
INSERT INTO auth_permission VALUES(87,22,'delete_daemon','Can delete daemon');
INSERT INTO auth_permission VALUES(88,22,'view_daemon','Can view daemon');
INSERT INTO auth_permission VALUES(89,23,'add_chroot','Can add chroot');
INSERT INTO auth_permission VALUES(90,23,'change_chroot','Can change chroot');
INSERT INTO auth_permission VALUES(91,23,'delete_chroot','Can delete chroot');
INSERT INTO auth_permission VALUES(92,23,'view_chroot','Can view chroot');
INSERT INTO auth_permission VALUES(93,24,'add_dirchroot','Can add dir chroot');
INSERT INTO auth_permission VALUES(94,24,'change_dirchroot','Can change dir chroot');
INSERT INTO auth_permission VALUES(95,24,'delete_dirchroot','Can delete dir chroot');
INSERT INTO auth_permission VALUES(96,24,'view_dirchroot','Can view dir chroot');
INSERT INTO auth_permission VALUES(97,25,'add_filechroot','Can add file chroot');
INSERT INTO auth_permission VALUES(98,25,'change_filechroot','Can change file chroot');
INSERT INTO auth_permission VALUES(99,25,'delete_filechroot','Can delete file chroot');
INSERT INTO auth_permission VALUES(100,25,'view_filechroot','Can view file chroot');
INSERT INTO auth_permission VALUES(101,26,'add_lvmchroot','Can add lvm chroot');
INSERT INTO auth_permission VALUES(102,26,'change_lvmchroot','Can change lvm chroot');
INSERT INTO auth_permission VALUES(103,26,'delete_lvmchroot','Can delete lvm chroot');
INSERT INTO auth_permission VALUES(104,26,'view_lvmchroot','Can view lvm chroot');
INSERT INTO auth_permission VALUES(105,27,'add_looplvmchroot','Can add loop lvm chroot');
INSERT INTO auth_permission VALUES(106,27,'change_looplvmchroot','Can change loop lvm chroot');
INSERT INTO auth_permission VALUES(107,27,'delete_looplvmchroot','Can delete loop lvm chroot');
INSERT INTO auth_permission VALUES(108,27,'view_looplvmchroot','Can view loop lvm chroot');
INSERT INTO auth_permission VALUES(109,28,'add_btrfssnapshotchroot','Can add btrfs snapshot chroot');
INSERT INTO auth_permission VALUES(110,28,'change_btrfssnapshotchroot','Can change btrfs snapshot chroot');
INSERT INTO auth_permission VALUES(111,28,'delete_btrfssnapshotchroot','Can delete btrfs snapshot chroot');
INSERT INTO auth_permission VALUES(112,28,'view_btrfssnapshotchroot','Can view btrfs snapshot chroot');
INSERT INTO auth_permission VALUES(113,29,'add_subscription','Can add subscription');
INSERT INTO auth_permission VALUES(114,29,'change_subscription','Can change subscription');
INSERT INTO auth_permission VALUES(115,29,'delete_subscription','Can delete subscription');
INSERT INTO auth_permission VALUES(116,29,'view_subscription','Can view subscription');
CREATE TABLE IF NOT EXISTS "auth_group" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "name" varchar(150) NOT NULL UNIQUE);
CREATE TABLE IF NOT EXISTS "auth_user" ("id" integer NOT NULL PRIMARY KEY AUTOINCREMENT, "password" varchar(128) NOT NULL, "last_login" datetime NULL, "is_superuser" bool NOT NULL, "username" varchar(150) NOT NULL UNIQUE, "last_name" varchar(150) NOT NULL, "email" varchar(254) NOT NULL, "is_staff" bool NOT NULL, "is_active" bool NOT NULL, "date_joined" datetime NOT NULL, "first_name" varchar(150) NOT NULL);
INSERT INTO auth_user VALUES(1,'pbkdf2_sha256$600000$lyXqIH0jcJHlLXAaHE99d7$gLRs+Dbw8A3ZVB+SA9RuPE/gdLoQmuXF6P3MADvkulw=','2024-01-08 18:44:31.495251',1,'admin','','root@localhost',1,1,'2024-01-08 17:27:41.380631','');
CREATE TABLE IF NOT EXISTS "django_session" ("session_key" varchar(40) NOT NULL PRIMARY KEY, "session_data" text NOT NULL, "expire_date" datetime NOT NULL);
INSERT INTO django_session VALUES('4snebv7ela9tkxw7y292rs7htymsmtgn','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMtPc:mGGsjvjHG3ahmHQ9OMQQtJchzIiYb00ki78-q3IckaY','2024-01-22 17:27:44.399676');
INSERT INTO django_session VALUES('7m850xc0etl5yg2f8c8vmyloolhekjf2','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMtPc:mGGsjvjHG3ahmHQ9OMQQtJchzIiYb00ki78-q3IckaY','2024-01-22 17:27:44.864644');
INSERT INTO django_session VALUES('scsvxj2qi2655v6y6dhk814iu7uicalo','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuFu:wTrgS4MfpUqHFpocv22NtvLdsM4wMx4Lo6LSo-72KWM','2024-01-22 18:21:46.108767');
INSERT INTO django_session VALUES('2199aej73lios011oculp9kbr51iaevn','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuK0:tX1GE6IZQXVinEvmVC7XuYrj8nUBnh3uoYvDJq3Fyjw','2024-01-22 18:26:00.529501');
INSERT INTO django_session VALUES('co36xa1unfo9zf09r19l7h2nmchi8o8y','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuU1:1j35MQRWktzd40F7ydP-tbLWFr8T6-sW2CAJcwgFry8','2024-01-22 18:36:21.872150');
INSERT INTO django_session VALUES('lu8dp0u94j6lcc1i3g0xvg3u5tu5mny0','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuU3:WjYZAbsEJj3z1xfmiIiNdf-bkmNxBBKuSTeOPhu6eWc','2024-01-22 18:36:23.133925');
INSERT INTO django_session VALUES('kt4wcg55xdf901kp4j6isnko8lwbzpue','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuUU:wbBcN48cM46e48kQzeIX8VjwbrDUo-yl-b1swIztjbI','2024-01-22 18:36:50.716163');
INSERT INTO django_session VALUES('hwztywervcqx8c63fd9qkuj51zhzkptz','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuUV:TyHCG1ZGgYDgNLVWC6obv059CXFXloP1Qw2pp1-lpSQ','2024-01-22 18:36:51.962773');
INSERT INTO django_session VALUES('uv0u1n7d48o89jsg9cjezawn16p6g8mu','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuUx:WMc2nZfhzUqPaGcjSi89A8pgqnXnF0sZK355_1xxu_U','2024-01-22 18:37:19.050793');
INSERT INTO django_session VALUES('cwc0pyebi5cfzi4vo1rmd9gb648oqrct','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuUy:YFCMEmnU-A9JGRz9z3whttfvPiKZwsG6asC9bkv4_k0','2024-01-22 18:37:20.305502');
INSERT INTO django_session VALUES('0i3m1kx38ep2alids2aou2lm2bq5qgbr','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuVO:PFju_5XAkLrvGCLnd9WUNrphz4YHPQ1bSiMm5AY4iZk','2024-01-22 18:37:46.570122');
INSERT INTO django_session VALUES('8v2h5eu4rh583abkffb6k3qy27oglaiv','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuVP:CCNa-v5UOQ8aiJ7cdpXCgyDsS4Ew_thkBNr77P8zl3w','2024-01-22 18:37:47.773106');
INSERT INTO django_session VALUES('notjyqa2d8h02ki8887cheryikzggyve','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuWb:W4Tn3RHBJO8gQuiXfheRQyMd2fhKN_APqZKZRaPIIwY','2024-01-22 18:39:01.449707');
INSERT INTO django_session VALUES('7by0sg36kxp6ovea4caryz1q7aqoscwz','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuWn:ysCNxRUctKNv5buhsMO9FDKPA2EwpwChUW5loz7N9fE','2024-01-22 18:39:13.004297');
INSERT INTO django_session VALUES('we05mqzpq1qbh6qclleekkirpcdbbt34','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuWo:qTX7KM3TqdlVnsM2x2c9I8NDX9Mf-e72y0uzZms9tgY','2024-01-22 18:39:14.990076');
INSERT INTO django_session VALUES('pl6qozrm0yohxsudhbj2wpu5i65wqwh5','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuWq:W7adEtaGiLB1ktl_O2PEX4xEDcDBzzw0z4uqOcBywno','2024-01-22 18:39:16.215118');
INSERT INTO django_session VALUES('lfrduw3yuvi0m1s1dht5iat90rbslyoc','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuXG:8i16IlR2qDCIf35j0GLlLJhGTtOZxwK415YLLkyJQCY','2024-01-22 18:39:42.920905');
INSERT INTO django_session VALUES('fko96tma4ejq53ydbl5l9rw3el40c7i5','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuXI:9Nua0DKU1cORokHW6bcfrJbIxEgiVayz4ygcM3PceHM','2024-01-22 18:39:44.153744');
INSERT INTO django_session VALUES('tao7yd4hwcsf374fploeije3cflvhz1z','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYC:TN8vpDP9y9W5HeRn7Gob02jPhSZQZh29LJwtXNVWCts','2024-01-22 18:40:40.812329');
INSERT INTO django_session VALUES('qhxcur3c4cge9whrcod9cvfjykyaan7r','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYD:BGmIgtpqRVmEK9caSjeVYVpEHnBfz4EtV8B31ToR4UM','2024-01-22 18:40:41.992679');
INSERT INTO django_session VALUES('rl94frsf9s9yym5ek9kroa3id0ygphqu','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYF:xsIrQYY7U9aXoiV8J41uEO8SUPlTP86k3zJYhv1U2ss','2024-01-22 18:40:43.167646');
INSERT INTO django_session VALUES('dc3m0o04mtbee8l6vh4jgalk3325rwrv','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYG:gKOAksSrvFgwhFTVfIv6m9GENOPxDuq5SITMECYhEtw','2024-01-22 18:40:44.392502');
INSERT INTO django_session VALUES('axgzj066c0dhg37trfk848lw9e3nvahj','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYH:kjwYugfOJaP9IIGrnFYK1tJfNtqeH7oVmQxoCHqnGf0','2024-01-22 18:40:45.557944');
INSERT INTO django_session VALUES('cg9jbs2qpcpqs7qcv1ltlzg7nb4w5098','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuYI:EqgcgrU86yhRtOnpZx3uZmKsso57IgXd0VEDWNo_zT8','2024-01-22 18:40:46.741885');
INSERT INTO django_session VALUES('01xg9w7lew75dzszgttfgtkizcb8hcln','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuZz:BrbUk5bFsqLcYqH--a_L81sMi7XqA3_rVJcIAXWE3MI','2024-01-22 18:42:31.519919');
INSERT INTO django_session VALUES('82iit71l6l0o0mdn5dvq0djp1to8b552','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuaU:dJ2Sl5jrgc8jDLY8KkmsGpAQoolH2iyQDAaGtljtcps','2024-01-22 18:43:02.446895');
INSERT INTO django_session VALUES('pt1f3k0pqx3hs1v9yw6mdiucpnkepmdt','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMuaZ:qI2P3LWNYtAEYqA2w9JCfdeD5o7HrhA1Qk62j5Ehxe8','2024-01-22 18:43:07.626268');
INSERT INTO django_session VALUES('gzqkr33qxw8w5o3r2hz4ortecikwjr63','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubC:W6VYqiVGCG4ggBr4l1eyfLJH_u5z4JleS65cdqmijl8','2024-01-22 18:43:46.636224');
INSERT INTO django_session VALUES('v4bscj3brzzag0jbjfxji06p32d0nbpn','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubP:7h7ZoOOz8n9kxE6dj0gOlBH9Sq-yzxVoeJvu9xudZ5E','2024-01-22 18:43:59.308018');
INSERT INTO django_session VALUES('bat078foo170svahgz1vx8nfh082p5hh','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubQ:iHnKBQMatudzdyxr-AvJiiR4XPkh3T_hFjs0UlxcAbs','2024-01-22 18:44:00.890653');
INSERT INTO django_session VALUES('ueaqe74d11s4a2ix9l788warx1esjw9f','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubR:PPQAzh7boy7xSh2g9uYNRhh8hSQbPDsKoZ_z2AbRFbc','2024-01-22 18:44:01.410647');
INSERT INTO django_session VALUES('xykure55on78s73ugkheyvuew8s9tudr','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubR:PPQAzh7boy7xSh2g9uYNRhh8hSQbPDsKoZ_z2AbRFbc','2024-01-22 18:44:01.917479');
INSERT INTO django_session VALUES('tqhofm92puysxoba087juxralpog57k7','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubS:641xA7KqxqIqOUXCfnckgALWS-XZiyDFdc1pqBj8frU','2024-01-22 18:44:02.447074');
INSERT INTO django_session VALUES('0hl4855fvj243eaxs54uukze2w7r2ioq','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubT:F7ooZ6eiQKAaYZNAYKVms2tD61jirSfuhChi8KrxW0o','2024-01-22 18:44:03.340038');
INSERT INTO django_session VALUES('q26m3eao71pii8klmyvo2biz57jhoz92','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubU:yhgMmq8zxQki17K0_pJozohRtCbq0pyi6J29xOq3QeE','2024-01-22 18:44:04.577557');
INSERT INTO django_session VALUES('1thwndjmr5vokgr20anm55n1gfus8z6d','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubV:COv3xvDl7WVNeZsbK5NBBX2lCZJSmgseHakdJANObAs','2024-01-22 18:44:05.801195');
INSERT INTO django_session VALUES('s3mtwvmf2vzmge8m7ygomgardpqadfyk','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubW:zsyMEBAMO9JzXFr3uCJ0HzG7bJmzgp-4nv5uv5idlcQ','2024-01-22 18:44:06.304065');
INSERT INTO django_session VALUES('mpjeav8ihrmnqd13bjcmywm9knobf66v','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubW:zsyMEBAMO9JzXFr3uCJ0HzG7bJmzgp-4nv5uv5idlcQ','2024-01-22 18:44:06.842514');
INSERT INTO django_session VALUES('xisd50lgqb2vus30obrnwlfj7x2ly7jo','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubb:wOeQZ-u0BNJSK6OOfON8RH1aQRqquDuzvkNwxJjetgQ','2024-01-22 18:44:11.207002');
INSERT INTO django_session VALUES('fe9uawfa4m7fvvu3nk5zj0ix242zn4xz','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubd:35g3gR_IlEidL7u3ODROZgT8r9C7HYtrwXV-efzNICo','2024-01-22 18:44:13.576550');
INSERT INTO django_session VALUES('ovpu5d8gw8g9kq4ruupv74wkgs1riwib','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMube:r8wV6CnPcdNBa5sTJiayb7bsn8iZpq3Gsb5FoLRNCKY','2024-01-22 18:44:14.792624');
INSERT INTO django_session VALUES('j0pt1lzi3vuiiyfnlms2jsmipufl1vix','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubg:wRl90tNL8pXMX5XAXiZvPCSlbZq2fsqJiGpqU3TPwgE','2024-01-22 18:44:16.275392');
INSERT INTO django_session VALUES('hnqh9y97b7w64ce76w0j2u1kyhwvdddk','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubh:mv5oWzZzF7NdaBFol-zg7jwwfLVjjMGRRJNqDXBA8L8','2024-01-22 18:44:17.490937');
INSERT INTO django_session VALUES('v2zp6kptnh3bpey1b7ln1m9khi8799ka','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubi:MhwwaRYdQEY7s4_rhfQgsCxU3iz6s6JNvztChsuvXWw','2024-01-22 18:44:18.003447');
INSERT INTO django_session VALUES('dykkxjpl7cin81rhls9gxi9hiti17ea9','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubi:MhwwaRYdQEY7s4_rhfQgsCxU3iz6s6JNvztChsuvXWw','2024-01-22 18:44:18.274989');
INSERT INTO django_session VALUES('smc3etnfzss0p1lcmnouj6f0h1rvpx92','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubi:MhwwaRYdQEY7s4_rhfQgsCxU3iz6s6JNvztChsuvXWw','2024-01-22 18:44:18.575966');
INSERT INTO django_session VALUES('lebhry000m56kt141x2jp8xc6lqv3l5n','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubj:TfNVfrq-PKpqVq1oVSexT3gkS_wrXIGWkzPmbVNY5PQ','2024-01-22 18:44:19.316111');
INSERT INTO django_session VALUES('j5t469kjm2xwfe2pptxzq4aiqrvpr7ba','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubj:TfNVfrq-PKpqVq1oVSexT3gkS_wrXIGWkzPmbVNY5PQ','2024-01-22 18:44:19.570590');
INSERT INTO django_session VALUES('8nyn67zkf7meh4wdlyc4mssx6sju1s6k','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubk:KWgN4Iq0crTLj8U-KnsjnyHenBQKYi6tufPRGTcqxj0','2024-01-22 18:44:20.820201');
INSERT INTO django_session VALUES('qqf1kastdz3kxc01av6rbkq3qdb4xbhp','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubp:60_XQHl6RGB4zv-Uxs6hFm_ADrwiSJX57J79nAA5EDM','2024-01-22 18:44:25.553129');
INSERT INTO django_session VALUES('vbx7b47eb0y6lsl8rj5l69mb9wqedj7j','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubp:60_XQHl6RGB4zv-Uxs6hFm_ADrwiSJX57J79nAA5EDM','2024-01-22 18:44:25.831828');
INSERT INTO django_session VALUES('n693prlywug08srxq0o4i0skf3p133as','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubq:5UtCEUEEE08uqNxtp4pSR_aQOdqwUsB10kJtoilfGx4','2024-01-22 18:44:26.369358');
INSERT INTO django_session VALUES('evwwga7pyon16sqsptmp29bv548uz7jj','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubq:5UtCEUEEE08uqNxtp4pSR_aQOdqwUsB10kJtoilfGx4','2024-01-22 18:44:26.634498');
INSERT INTO django_session VALUES('nd00l22lj7jm6ijwr2i4q15o1y47jost','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubq:5UtCEUEEE08uqNxtp4pSR_aQOdqwUsB10kJtoilfGx4','2024-01-22 18:44:26.875106');
INSERT INTO django_session VALUES('lz6pwgi2ko6xkkdz1f27aa34qdjaoosf','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubr:2qFBvKD_ceFP4Xuc_9gmy5ym9061mblTpRZsGegDF3w','2024-01-22 18:44:27.104613');
INSERT INTO django_session VALUES('y87qymqbt3z203o6oicv46hgond8yz39','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubr:2qFBvKD_ceFP4Xuc_9gmy5ym9061mblTpRZsGegDF3w','2024-01-22 18:44:27.844178');
INSERT INTO django_session VALUES('tk08ilphy4dvrtnthagj7679w7hh9tsv','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubs:RwoJw_qPHngykSQ6Z85ZlBv_epWC0ngmykTQB2llTFs','2024-01-22 18:44:28.067553');
INSERT INTO django_session VALUES('defsg6wzrndbxui4r8eu042a69dltp42','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubs:RwoJw_qPHngykSQ6Z85ZlBv_epWC0ngmykTQB2llTFs','2024-01-22 18:44:28.304339');
INSERT INTO django_session VALUES('wres2s0k6brlal6fv37z1zpd9nl2cbif','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubt:Z2wPBPcrWsddleUyMuFM3memxwUvif9_EEGz912CTxw','2024-01-22 18:44:29.162966');
INSERT INTO django_session VALUES('uz3ihhha3huvymnsdasij8bcx7xuzq7o','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubt:Z2wPBPcrWsddleUyMuFM3memxwUvif9_EEGz912CTxw','2024-01-22 18:44:29.393677');
INSERT INTO django_session VALUES('ljg3js4pjtgut4qf91pcxosdfizbw46x','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubt:Z2wPBPcrWsddleUyMuFM3memxwUvif9_EEGz912CTxw','2024-01-22 18:44:29.615780');
INSERT INTO django_session VALUES('qso2nvggvbgg6zzr301vkp08m8dx6lie','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubt:Z2wPBPcrWsddleUyMuFM3memxwUvif9_EEGz912CTxw','2024-01-22 18:44:29.815204');
INSERT INTO django_session VALUES('ptav90elomq5pzi4atbi46u45juayoif','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubu:9NGyfeS20zNJBDGg72bIRZQgRzkhrQM_iltvQwJLse0','2024-01-22 18:44:30.082502');
INSERT INTO django_session VALUES('fcr184tl9fy74n8150pcghn2hhc5g5o3','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubu:9NGyfeS20zNJBDGg72bIRZQgRzkhrQM_iltvQwJLse0','2024-01-22 18:44:30.312287');
INSERT INTO django_session VALUES('decjh47r437mggz7suhwv19jenedqetv','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubu:9NGyfeS20zNJBDGg72bIRZQgRzkhrQM_iltvQwJLse0','2024-01-22 18:44:30.505779');
INSERT INTO django_session VALUES('lc56eej3vfpz0ke0qpqg8b8qdjpzwnfl','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubu:9NGyfeS20zNJBDGg72bIRZQgRzkhrQM_iltvQwJLse0','2024-01-22 18:44:30.705137');
INSERT INTO django_session VALUES('lwtlzzmtzirz11esmq6p8e8xgxgbwgvz','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubu:9NGyfeS20zNJBDGg72bIRZQgRzkhrQM_iltvQwJLse0','2024-01-22 18:44:30.911936');
INSERT INTO django_session VALUES('c9a5tt40o16lwwkebt9ha65kx16p6eal','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubv:lXcDNr4JxbKyFVJuwTOfzbv0zilEYTjEDuY-igRJRbE','2024-01-22 18:44:31.113957');
INSERT INTO django_session VALUES('ry6b7lq7msxnsblpj1hzs7odt4uk25no','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubv:lXcDNr4JxbKyFVJuwTOfzbv0zilEYTjEDuY-igRJRbE','2024-01-22 18:44:31.310559');
INSERT INTO django_session VALUES('d3wpx7jt4zm97ciyvvjcaufvih17lhjp','.eJxVjDsOwjAQBe_iGllerb-U9JzBWttrHECOFCcV4u4QKQW0b2beS0Ta1ha3wUucijgLEKffLVF-cN9BuVO_zTLPfV2mJHdFHnTI61z4eTncv4NGo31rZHTW5YDAmDQUbWrW2igMlQyi8hxAsVcMDKaaXICU81S5KJsQrXh_AMgHN2g:1rMubv:lXcDNr4JxbKyFVJuwTOfzbv0zilEYTjEDuY-igRJRbE','2024-01-22 18:44:31.506744');
DELETE FROM sqlite_sequence;
INSERT INTO sqlite_sequence VALUES('django_migrations',18);
INSERT INTO sqlite_sequence VALUES('django_admin_log',0);
INSERT INTO sqlite_sequence VALUES('django_content_type',29);
INSERT INTO sqlite_sequence VALUES('auth_permission',116);
INSERT INTO sqlite_sequence VALUES('auth_group',0);
INSERT INTO sqlite_sequence VALUES('auth_user',1);
INSERT INTO sqlite_sequence VALUES('mini_buildd_uploader',1);
INSERT INTO sqlite_sequence VALUES('mini_buildd_daemon',1);
INSERT INTO sqlite_sequence VALUES('mini_buildd_aptkey',20);
INSERT INTO sqlite_sequence VALUES('mini_buildd_source',52);
INSERT INTO sqlite_sequence VALUES('mini_buildd_source_apt_keys',97);
INSERT INTO sqlite_sequence VALUES('mini_buildd_source_archives',345);
INSERT INTO sqlite_sequence VALUES('mini_buildd_source_architectures',2848);
INSERT INTO sqlite_sequence VALUES('mini_buildd_source_components',1260);
INSERT INTO sqlite_sequence VALUES('mini_buildd_distribution',16);
INSERT INTO sqlite_sequence VALUES('mini_buildd_distribution_components',59);
INSERT INTO sqlite_sequence VALUES('mini_buildd_architectureoption',32);
INSERT INTO sqlite_sequence VALUES('mini_buildd_prioritysource',36);
INSERT INTO sqlite_sequence VALUES('mini_buildd_distribution_extra_sources',36);
INSERT INTO sqlite_sequence VALUES('mini_buildd_suite',6);
INSERT INTO sqlite_sequence VALUES('mini_buildd_suiteoption',6);
INSERT INTO sqlite_sequence VALUES('mini_buildd_repository_distributions',16);
INSERT INTO sqlite_sequence VALUES('mini_buildd_chroot',32);
CREATE UNIQUE INDEX "mini_buildd_uploader_may_upload_to_uploader_id_repository_id_830e70a2_uniq" ON "mini_buildd_uploader_may_upload_to" ("uploader_id", "repository_id");
CREATE INDEX "mini_buildd_uploader_may_upload_to_uploader_id_d1a7bc9d" ON "mini_buildd_uploader_may_upload_to" ("uploader_id");
CREATE INDEX "mini_buildd_uploader_may_upload_to_repository_id_2f80eb0d" ON "mini_buildd_uploader_may_upload_to" ("repository_id");
CREATE UNIQUE INDEX "mini_buildd_source_origin_codename_b20c124d_uniq" ON "mini_buildd_source" ("origin", "codename");
CREATE UNIQUE INDEX "mini_buildd_source_apt_keys_source_id_aptkey_id_b7c54560_uniq" ON "mini_buildd_source_apt_keys" ("source_id", "aptkey_id");
CREATE INDEX "mini_buildd_source_apt_keys_source_id_3bfda2cf" ON "mini_buildd_source_apt_keys" ("source_id");
CREATE INDEX "mini_buildd_source_apt_keys_aptkey_id_4795b60f" ON "mini_buildd_source_apt_keys" ("aptkey_id");
CREATE UNIQUE INDEX "mini_buildd_source_archives_source_id_archive_id_d746fe1e_uniq" ON "mini_buildd_source_archives" ("source_id", "archive_id");
CREATE INDEX "mini_buildd_source_archives_source_id_04eff3d2" ON "mini_buildd_source_archives" ("source_id");
CREATE INDEX "mini_buildd_source_archives_archive_id_6b732ebb" ON "mini_buildd_source_archives" ("archive_id");
CREATE UNIQUE INDEX "mini_buildd_source_components_source_id_component_id_dd6d1bcb_uniq" ON "mini_buildd_source_components" ("source_id", "component_id");
CREATE INDEX "mini_buildd_source_components_source_id_3e71a6ae" ON "mini_buildd_source_components" ("source_id");
CREATE INDEX "mini_buildd_source_components_component_id_f2d392d4" ON "mini_buildd_source_components" ("component_id");
CREATE UNIQUE INDEX "mini_buildd_source_architectures_source_id_architecture_id_9e23c3db_uniq" ON "mini_buildd_source_architectures" ("source_id", "architecture_id");
CREATE INDEX "mini_buildd_source_architectures_source_id_9dc3a1fa" ON "mini_buildd_source_architectures" ("source_id");
CREATE INDEX "mini_buildd_source_architectures_architecture_id_8d413e4f" ON "mini_buildd_source_architectures" ("architecture_id");
CREATE UNIQUE INDEX "mini_buildd_prioritysource_source_id_priority_88d88fa6_uniq" ON "mini_buildd_prioritysource" ("source_id", "priority");
CREATE INDEX "mini_buildd_prioritysource_source_id_51d06fa8" ON "mini_buildd_prioritysource" ("source_id");
CREATE UNIQUE INDEX "mini_buildd_suiteoption_suite_id_layout_id_e0f599d4_uniq" ON "mini_buildd_suiteoption" ("suite_id", "layout_id");
CREATE INDEX "mini_buildd_suiteoption_layout_id_094a5448" ON "mini_buildd_suiteoption" ("layout_id");
CREATE INDEX "mini_buildd_suiteoption_suite_id_08cef7f5" ON "mini_buildd_suiteoption" ("suite_id");
CREATE INDEX "mini_buildd_suiteoption_migrates_to_id_ad7bc47d" ON "mini_buildd_suiteoption" ("migrates_to_id");
CREATE UNIQUE INDEX "mini_buildd_architectureoption_architecture_id_distribution_id_ded3a919_uniq" ON "mini_buildd_architectureoption" ("architecture_id", "distribution_id");
CREATE INDEX "mini_buildd_architectureoption_architecture_id_60608e37" ON "mini_buildd_architectureoption" ("architecture_id");
CREATE INDEX "mini_buildd_architectureoption_distribution_id_a19941b7" ON "mini_buildd_architectureoption" ("distribution_id");
CREATE INDEX "mini_buildd_distribution_base_source_id_7c498cce" ON "mini_buildd_distribution" ("base_source_id");
CREATE UNIQUE INDEX "mini_buildd_distribution_extra_sources_distribution_id_prioritysource_id_2befd0b5_uniq" ON "mini_buildd_distribution_extra_sources" ("distribution_id", "prioritysource_id");
CREATE INDEX "mini_buildd_distribution_extra_sources_distribution_id_c75ba648" ON "mini_buildd_distribution_extra_sources" ("distribution_id");
CREATE INDEX "mini_buildd_distribution_extra_sources_prioritysource_id_3bcc26d7" ON "mini_buildd_distribution_extra_sources" ("prioritysource_id");
CREATE UNIQUE INDEX "mini_buildd_distribution_components_distribution_id_component_id_ae37805a_uniq" ON "mini_buildd_distribution_components" ("distribution_id", "component_id");
CREATE INDEX "mini_buildd_distribution_components_distribution_id_e6a43345" ON "mini_buildd_distribution_components" ("distribution_id");
CREATE INDEX "mini_buildd_distribution_components_component_id_b45b7ff1" ON "mini_buildd_distribution_components" ("component_id");
CREATE INDEX "mini_buildd_repository_layout_id_88fbde5b" ON "mini_buildd_repository" ("layout_id");
CREATE UNIQUE INDEX "mini_buildd_repository_distributions_repository_id_distribution_id_f8f07b90_uniq" ON "mini_buildd_repository_distributions" ("repository_id", "distribution_id");
CREATE INDEX "mini_buildd_repository_distributions_repository_id_4b7523f4" ON "mini_buildd_repository_distributions" ("repository_id");
CREATE INDEX "mini_buildd_repository_distributions_distribution_id_0dcaa3df" ON "mini_buildd_repository_distributions" ("distribution_id");
CREATE UNIQUE INDEX "mini_buildd_repository_notify_repository_id_emailaddress_id_3a56a54f_uniq" ON "mini_buildd_repository_notify" ("repository_id", "emailaddress_id");
CREATE INDEX "mini_buildd_repository_notify_repository_id_2b350da1" ON "mini_buildd_repository_notify" ("repository_id");
CREATE INDEX "mini_buildd_repository_notify_emailaddress_id_f3eb9564" ON "mini_buildd_repository_notify" ("emailaddress_id");
CREATE UNIQUE INDEX "mini_buildd_daemon_notify_daemon_id_emailaddress_id_e8d61b72_uniq" ON "mini_buildd_daemon_notify" ("daemon_id", "emailaddress_id");
CREATE INDEX "mini_buildd_daemon_notify_daemon_id_cf28d405" ON "mini_buildd_daemon_notify" ("daemon_id");
CREATE INDEX "mini_buildd_daemon_notify_emailaddress_id_4246dc89" ON "mini_buildd_daemon_notify" ("emailaddress_id");
CREATE UNIQUE INDEX "mini_buildd_chroot_source_id_architecture_id_a441b1e8_uniq" ON "mini_buildd_chroot" ("source_id", "architecture_id");
CREATE INDEX "mini_buildd_chroot_source_id_0da39310" ON "mini_buildd_chroot" ("source_id");
CREATE INDEX "mini_buildd_chroot_architecture_id_b41bc83c" ON "mini_buildd_chroot" ("architecture_id");
CREATE INDEX "mini_buildd_subscription_subscriber_id_2eee73e1" ON "mini_buildd_subscription" ("subscriber_id");
CREATE UNIQUE INDEX "auth_group_permissions_group_id_permission_id_0cd325b0_uniq" ON "auth_group_permissions" ("group_id", "permission_id");
CREATE INDEX "auth_group_permissions_group_id_b120cbf9" ON "auth_group_permissions" ("group_id");
CREATE INDEX "auth_group_permissions_permission_id_84c5c92e" ON "auth_group_permissions" ("permission_id");
CREATE UNIQUE INDEX "auth_user_groups_user_id_group_id_94350c0c_uniq" ON "auth_user_groups" ("user_id", "group_id");
CREATE INDEX "auth_user_groups_user_id_6a12ed8b" ON "auth_user_groups" ("user_id");
CREATE INDEX "auth_user_groups_group_id_97559544" ON "auth_user_groups" ("group_id");
CREATE UNIQUE INDEX "auth_user_user_permissions_user_id_permission_id_14a6b632_uniq" ON "auth_user_user_permissions" ("user_id", "permission_id");
CREATE INDEX "auth_user_user_permissions_user_id_a95ead1b" ON "auth_user_user_permissions" ("user_id");
CREATE INDEX "auth_user_user_permissions_permission_id_1fbb5f2c" ON "auth_user_user_permissions" ("permission_id");
CREATE INDEX "django_admin_log_content_type_id_c4bce8eb" ON "django_admin_log" ("content_type_id");
CREATE INDEX "django_admin_log_user_id_c564eba6" ON "django_admin_log" ("user_id");
CREATE UNIQUE INDEX "django_content_type_app_label_model_76bd3d3b_uniq" ON "django_content_type" ("app_label", "model");
CREATE UNIQUE INDEX "auth_permission_content_type_id_codename_01ab375a_uniq" ON "auth_permission" ("content_type_id", "codename");
CREATE INDEX "auth_permission_content_type_id_2f476e4b" ON "auth_permission" ("content_type_id");
CREATE INDEX "django_session_expire_date_a5c62663" ON "django_session" ("expire_date");
COMMIT;
