/* moonshot-server-linux.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-server-linux.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <gee.h>


#define TYPE_MOONSHOT_SERVER (moonshot_server_get_type ())
#define MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_SERVER, MoonshotServer))
#define MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_SERVER, MoonshotServerClass))
#define IS_MOONSHOT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_SERVER))
#define IS_MOONSHOT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_SERVER))
#define MOONSHOT_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_SERVER, MoonshotServerClass))

typedef struct _MoonshotServer MoonshotServer;
typedef struct _MoonshotServerClass MoonshotServerClass;
typedef struct _MoonshotServerPrivate MoonshotServerPrivate;

#define TYPE_IDENTITY_MANAGER_APP (identity_manager_app_get_type ())
#define IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerApp))
#define IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))
#define IS_IDENTITY_MANAGER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_APP))
#define IS_IDENTITY_MANAGER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_APP))
#define IDENTITY_MANAGER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_APP, IdentityManagerAppClass))

typedef struct _IdentityManagerApp IdentityManagerApp;
typedef struct _IdentityManagerAppClass IdentityManagerAppClass;

#define TYPE_MOONSHOT_LOGGER (moonshot_logger_get_type ())
#define MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLogger))
#define MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))
#define IS_MOONSHOT_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOONSHOT_LOGGER))
#define IS_MOONSHOT_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOONSHOT_LOGGER))
#define MOONSHOT_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOONSHOT_LOGGER, MoonshotLoggerClass))

typedef struct _MoonshotLogger MoonshotLogger;
typedef struct _MoonshotLoggerClass MoonshotLoggerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _identity_manager_app_unref0(var) ((var == NULL) ? NULL : (var = (identity_manager_app_unref (var), NULL)))
typedef struct _IdentityManagerAppPrivate IdentityManagerAppPrivate;

#define TYPE_IDENTITY_MANAGER_MODEL (identity_manager_model_get_type ())
#define IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModel))
#define IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))
#define IS_IDENTITY_MANAGER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_MODEL))
#define IS_IDENTITY_MANAGER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_MODEL))
#define IDENTITY_MANAGER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_MODEL, IdentityManagerModelClass))

typedef struct _IdentityManagerModel IdentityManagerModel;
typedef struct _IdentityManagerModelClass IdentityManagerModelClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;

#define TYPE_IDENTITY_REQUEST (identity_request_get_type ())
#define IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_REQUEST, IdentityRequest))
#define IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_REQUEST, IdentityRequestClass))
#define IS_IDENTITY_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_REQUEST))
#define IS_IDENTITY_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_REQUEST))
#define IDENTITY_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_REQUEST, IdentityRequestClass))

typedef struct _IdentityRequest IdentityRequest;
typedef struct _IdentityRequestClass IdentityRequestClass;
typedef struct _IdentityRequestPrivate IdentityRequestPrivate;

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;
typedef struct _MoonshotServerGetIdentityData MoonshotServerGetIdentityData;
typedef struct _Block8Data Block8Data;
typedef struct _MoonshotServerGetDefaultIdentityData MoonshotServerGetDefaultIdentityData;

#define TYPE_RULE (rule_get_type ())
typedef struct _Rule Rule;

#define WEB_PROVISIONING_TYPE_PARSER (web_provisioning_parser_get_type ())
#define WEB_PROVISIONING_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParser))
#define WEB_PROVISIONING_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))
#define WEB_PROVISIONING_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WEB_PROVISIONING_TYPE_PARSER))
#define WEB_PROVISIONING_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WEB_PROVISIONING_TYPE_PARSER, WebProvisioningParserClass))

typedef struct _WebProvisioningParser WebProvisioningParser;
typedef struct _WebProvisioningParserClass WebProvisioningParserClass;
typedef struct _Block9Data Block9Data;

#define TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST (trust_anchor_confirmation_request_get_type ())
#define TRUST_ANCHOR_CONFIRMATION_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequest))
#define TRUST_ANCHOR_CONFIRMATION_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequestClass))
#define IS_TRUST_ANCHOR_CONFIRMATION_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST))
#define IS_TRUST_ANCHOR_CONFIRMATION_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST))
#define TRUST_ANCHOR_CONFIRMATION_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR_CONFIRMATION_REQUEST, TrustAnchorConfirmationRequestClass))

typedef struct _TrustAnchorConfirmationRequest TrustAnchorConfirmationRequest;
typedef struct _TrustAnchorConfirmationRequestClass TrustAnchorConfirmationRequestClass;
typedef struct _TrustAnchorConfirmationRequestPrivate TrustAnchorConfirmationRequestPrivate;
typedef struct _MoonshotServerConfirmCaCertificateData MoonshotServerConfirmCaCertificateData;

struct _MoonshotServer {
	GObject parent_instance;
	MoonshotServerPrivate * priv;
};

struct _MoonshotServerClass {
	GObjectClass parent_class;
};

struct _MoonshotServerPrivate {
	gchar* app_name;
	IdentityManagerApp* parent_app;
};

struct _IdentityManagerApp {
	GTypeInstance parent_instance;
	volatile int ref_count;
	IdentityManagerAppPrivate * priv;
	IdentityManagerModel* model;
	IdCard* default_id_card;
	gboolean explicitly_launched;
	IdentityManagerView* view;
};

struct _IdentityManagerAppClass {
	GTypeClass parent_class;
	void (*finalize) (IdentityManagerApp *self);
};

struct _Block7Data {
	int _ref_count_;
	MoonshotServer* self;
	gpointer _async_data_;
};

typedef void (*ReturnIdentityCallback) (IdentityRequest* request, void* user_data);
struct _IdentityRequest {
	GObject parent_instance;
	IdentityRequestPrivate * priv;
	IdCard* id_card;
	gboolean complete;
	gboolean select_default;
	gchar* nai;
	gchar* password;
	gchar* service;
	GSList* candidates;
};

struct _IdentityRequestClass {
	GObjectClass parent_class;
};

struct _MoonshotServerGetIdentityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MoonshotServer* self;
	gchar* nai;
	gchar* password;
	gchar* service;
	gchar* nai_out;
	gchar* password_out;
	gchar* server_certificate_hash;
	gchar* ca_certificate;
	gchar* subject_name_constraint;
	gchar* subject_alt_name_constraint;
	gboolean result;
	Block7Data* _data7_;
	MoonshotLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	IdentityRequest* request;
	IdentityManagerApp* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	IdentityRequest* _tmp11_;
	MoonshotLogger* _tmp12_;
	IdentityRequest* _tmp13_;
	IdentityRequest* _tmp14_;
	MoonshotLogger* _tmp15_;
	MoonshotLogger* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	IdCard* id_card;
	IdentityRequest* _tmp23_;
	IdCard* _tmp24_;
	IdCard* _tmp25_;
	gboolean _tmp26_;
	IdCard* _tmp27_;
	IdCard* _tmp28_;
	gboolean _tmp29_;
	IdCard* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean _tmp34_;
	IdentityRequest* _tmp35_;
	const gchar* _tmp36_;
	IdentityRequest* _tmp37_;
	const gchar* _tmp38_;
	IdentityRequest* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	IdCard* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	IdCard* _tmp46_;
	TrustAnchor* _tmp47_;
	TrustAnchor* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	IdCard* _tmp52_;
	TrustAnchor* _tmp53_;
	TrustAnchor* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	IdCard* _tmp58_;
	TrustAnchor* _tmp59_;
	TrustAnchor* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	IdCard* _tmp64_;
	TrustAnchor* _tmp65_;
	TrustAnchor* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	MoonshotLogger* _tmp82_;
	const gchar* _tmp83_;
	const gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	MoonshotLogger* _tmp87_;
};

struct _Block8Data {
	int _ref_count_;
	MoonshotServer* self;
	gpointer _async_data_;
};

struct _MoonshotServerGetDefaultIdentityData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MoonshotServer* self;
	gchar* nai_out;
	gchar* password_out;
	gchar* server_certificate_hash;
	gchar* ca_certificate;
	gchar* subject_name_constraint;
	gchar* subject_alt_name_constraint;
	gboolean result;
	Block8Data* _data8_;
	MoonshotLogger* _tmp0_;
	IdentityRequest* request;
	IdentityManagerApp* _tmp1_;
	IdentityRequest* _tmp2_;
	IdentityRequest* _tmp3_;
	IdentityRequest* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	IdentityRequest* _tmp11_;
	IdCard* _tmp12_;
	IdentityRequest* _tmp13_;
	IdCard* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	IdentityRequest* _tmp18_;
	IdCard* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	IdentityRequest* _tmp23_;
	IdCard* _tmp24_;
	TrustAnchor* _tmp25_;
	TrustAnchor* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	IdentityRequest* _tmp30_;
	IdCard* _tmp31_;
	TrustAnchor* _tmp32_;
	TrustAnchor* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	IdentityRequest* _tmp37_;
	IdCard* _tmp38_;
	TrustAnchor* _tmp39_;
	TrustAnchor* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	IdentityRequest* _tmp44_;
	IdCard* _tmp45_;
	TrustAnchor* _tmp46_;
	TrustAnchor* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	MoonshotLogger* _tmp63_;
};

struct _Rule {
	gchar* pattern;
	gchar* always_confirm;
};

struct _Block9Data {
	int _ref_count_;
	MoonshotServer* self;
	gpointer _async_data_;
};

typedef void (*TrustAnchorConfirmationCallback) (TrustAnchorConfirmationRequest* request, void* user_data);
struct _TrustAnchorConfirmationRequest {
	GObject parent_instance;
	TrustAnchorConfirmationRequestPrivate * priv;
	gboolean confirmed;
};

struct _TrustAnchorConfirmationRequestClass {
	GObjectClass parent_class;
};

struct _MoonshotServerConfirmCaCertificateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MoonshotServer* self;
	gchar* nai;
	gchar* realm;
	gchar* ca_hash;
	gint confirmed;
	gboolean result;
	Block9Data* _data9_;
	MoonshotLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	TrustAnchorConfirmationRequest* request;
	IdentityManagerApp* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	TrustAnchorConfirmationRequest* _tmp13_;
	TrustAnchorConfirmationRequest* _tmp14_;
	TrustAnchorConfirmationRequest* _tmp15_;
	gint _tmp16_;
	TrustAnchorConfirmationRequest* _tmp17_;
	gboolean _tmp18_;
	MoonshotLogger* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
};


static gpointer moonshot_server_parent_class = NULL;
static MoonshotLogger* moonshot_server_logger;
static MoonshotLogger* moonshot_server_logger = NULL;

GType moonshot_server_get_type (void) G_GNUC_CONST;
guint moonshot_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gpointer identity_manager_app_ref (gpointer instance);
void identity_manager_app_unref (gpointer instance);
GParamSpec* param_spec_identity_manager_app (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_identity_manager_app (GValue* value, gpointer v_object);
void value_take_identity_manager_app (GValue* value, gpointer v_object);
gpointer value_get_identity_manager_app (const GValue* value);
GType identity_manager_app_get_type (void) G_GNUC_CONST;
#define MOONSHOT_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOONSHOT_SERVER, MoonshotServerPrivate))
enum  {
	MOONSHOT_SERVER_DUMMY_PROPERTY
};
GType moonshot_logger_get_type (void) G_GNUC_CONST;
MoonshotLogger* get_logger (const gchar* name);
MoonshotServer* moonshot_server_new (IdentityManagerApp* app);
MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app);
void moonshot_logger_trace (MoonshotLogger* self, const gchar* message, GError* e);
gboolean moonshot_server_show_ui (MoonshotServer* self);
GType identity_manager_model_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
void moonshot_logger_warn (MoonshotLogger* self, const gchar* message, GError* e);
void identity_manager_app_show (IdentityManagerApp* self);
static void moonshot_server_get_identity_data_free (gpointer _data);
void moonshot_server_get_identity (MoonshotServer* self, const gchar* nai, const gchar* password, const gchar* service, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean moonshot_server_get_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint);
static gboolean moonshot_server_get_identity_co (MoonshotServerGetIdentityData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GType identity_request_get_type (void) G_GNUC_CONST;
IdentityRequest* identity_request_new (IdentityManagerApp* app, const gchar* nai, const gchar* password, const gchar* service);
IdentityRequest* identity_request_construct (GType object_type, IdentityManagerApp* app, const gchar* nai, const gchar* password, const gchar* service);
void identity_request_set_callback (IdentityRequest* self, ReturnIdentityCallback cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda19_ (Block7Data* _data7_, IdentityRequest* IdentityRequest);
static void ___lambda19__return_identity_callback (IdentityRequest* request, gpointer self);
gboolean identity_request_execute (IdentityRequest* self);
gboolean id_card_is_no_identity (IdCard* self);
const gchar* id_card_get_nai (IdCard* self);
const gchar* id_card_get_password (IdCard* self);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
const gchar* trust_anchor_get_server_cert (TrustAnchor* self);
const gchar* trust_anchor_get_ca_cert (TrustAnchor* self);
const gchar* trust_anchor_get_subject (TrustAnchor* self);
const gchar* trust_anchor_get_subject_alt (TrustAnchor* self);
static void moonshot_server_get_default_identity_data_free (gpointer _data);
void moonshot_server_get_default_identity (MoonshotServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean moonshot_server_get_default_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint);
static gboolean moonshot_server_get_default_identity_co (MoonshotServerGetDefaultIdentityData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
IdentityRequest* identity_request_new_default (IdentityManagerApp* app);
IdentityRequest* identity_request_construct_default (GType object_type, IdentityManagerApp* app);
static void __lambda20_ (Block8Data* _data8_, IdentityRequest* IdentityRequest);
static void ___lambda20__return_identity_callback (IdentityRequest* request, gpointer self);
gboolean moonshot_server_install_id_card (MoonshotServer* self, const gchar* display_name, const gchar* user_name, const gchar* password, const gchar* realm, gchar** rules_patterns, int rules_patterns_length1, gchar** rules_always_confirm, int rules_always_confirm_length1, gchar** services, int services_length1, const gchar* ca_cert, const gchar* subject, const gchar* subject_alt, const gchar* server_cert, gint force_flat_file_store);
IdCard* id_card_new (void);
IdCard* id_card_construct (GType object_type);
void id_card_set_display_name (IdCard* self, const gchar* value);
void id_card_set_username (IdCard* self, const gchar* value);
void id_card_set_password (IdCard* self, const gchar* value);
void id_card_set_store_password (IdCard* self, gboolean value);
void id_card_set_issuer (IdCard* self, const gchar* value);
void id_card_update_services (IdCard* self, gchar** services, int services_length1);
TrustAnchor* trust_anchor_new (const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
TrustAnchor* trust_anchor_construct (GType object_type, const gchar* ca_cert, const gchar* server_cert, const gchar* subject, const gchar* subject_alt);
gboolean trust_anchor_is_empty (TrustAnchor* self);
gchar* trust_anchor_format_datetime_now (void);
void trust_anchor_set_datetime_added (TrustAnchor* self, const gchar* datetime);
const gchar* id_card_get_display_name (IdCard* self);
const gchar* trust_anchor_get_datetime_added (TrustAnchor* self);
void id_card_set_trust_anchor_from_store (IdCard* self, TrustAnchor* ta);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
GType rule_get_type (void) G_GNUC_CONST;
Rule* rule_dup (const Rule* self);
void rule_free (Rule* self);
void rule_copy (const Rule* self, Rule* dest);
void rule_destroy (Rule* self);
void id_card_set_rules (IdCard* self, Rule* value, int value_length1);
static void _vala_Rule_array_free (Rule* array, gint array_length);
gboolean identity_manager_app_add_identity (IdentityManagerApp* self, IdCard* id, gboolean force_flat_file_store, GeeArrayList** old_duplicates);
gint moonshot_server_install_from_file (MoonshotServer* self, const gchar* file_name);
GType web_provisioning_parser_get_type (void) G_GNUC_CONST;
WebProvisioningParser* web_provisioning_parser_new (const gchar* path);
WebProvisioningParser* web_provisioning_parser_construct (GType object_type, const gchar* path);
void web_provisioning_parser_parse (WebProvisioningParser* self);
IdCard** web_provisioning_parser_get_cards (WebProvisioningParser* self, int* result_length1);
Rule* id_card_get_rules (IdCard* self, int* result_length1);
GeeArrayList* id_card_get_services (IdCard* self);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
static void moonshot_server_confirm_ca_certificate_data_free (gpointer _data);
void moonshot_server_confirm_ca_certificate (MoonshotServer* self, const gchar* nai, const gchar* realm, const gchar* ca_hash, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean moonshot_server_confirm_ca_certificate_finish (MoonshotServer* self, GAsyncResult* _res_, gint* confirmed);
static gboolean moonshot_server_confirm_ca_certificate_co (MoonshotServerConfirmCaCertificateData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
GType trust_anchor_confirmation_request_get_type (void) G_GNUC_CONST;
TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_new (IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint);
TrustAnchorConfirmationRequest* trust_anchor_confirmation_request_construct (GType object_type, IdentityManagerApp* parent_app, const gchar* userid, const gchar* realm, const gchar* fingerprint);
void trust_anchor_confirmation_request_set_callback (TrustAnchorConfirmationRequest* self, TrustAnchorConfirmationCallback cb, void* cb_target, GDestroyNotify cb_target_destroy_notify);
static void __lambda22_ (Block9Data* _data9_, TrustAnchorConfirmationRequest* TrustAnchorConfirmationRequest);
static void ___lambda22__trust_anchor_confirmation_callback (TrustAnchorConfirmationRequest* request, gpointer self);
gboolean trust_anchor_confirmation_request_execute (TrustAnchorConfirmationRequest* self);
static void moonshot_server_finalize (GObject* obj);
static void _dbus_moonshot_server_show_ui (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_moonshot_server_get_default_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_get_default_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_moonshot_server_install_id_card (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_install_from_file (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_confirm_ca_certificate (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_moonshot_server_confirm_ca_certificate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void moonshot_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* moonshot_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean moonshot_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _moonshot_server_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _moonshot_server_dbus_arg_info_show_ui_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_show_ui_in[] = {NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_show_ui_out[] = {&_moonshot_server_dbus_arg_info_show_ui_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_show_ui = {-1, "ShowUi", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_show_ui_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_show_ui_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_nai = {-1, "nai", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_password = {-1, "password", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_service = {-1, "service", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_nai_out = {-1, "nai_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_password_out = {-1, "password_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_server_certificate_hash = {-1, "server_certificate_hash", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_ca_certificate = {-1, "ca_certificate", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_subject_name_constraint = {-1, "subject_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_subject_alt_name_constraint = {-1, "subject_alt_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_identity_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_identity_in[] = {&_moonshot_server_dbus_arg_info_get_identity_nai, &_moonshot_server_dbus_arg_info_get_identity_password, &_moonshot_server_dbus_arg_info_get_identity_service, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_identity_out[] = {&_moonshot_server_dbus_arg_info_get_identity_nai_out, &_moonshot_server_dbus_arg_info_get_identity_password_out, &_moonshot_server_dbus_arg_info_get_identity_server_certificate_hash, &_moonshot_server_dbus_arg_info_get_identity_ca_certificate, &_moonshot_server_dbus_arg_info_get_identity_subject_name_constraint, &_moonshot_server_dbus_arg_info_get_identity_subject_alt_name_constraint, &_moonshot_server_dbus_arg_info_get_identity_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_get_identity = {-1, "GetIdentity", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_identity_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_identity_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_nai_out = {-1, "nai_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_password_out = {-1, "password_out", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_server_certificate_hash = {-1, "server_certificate_hash", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_ca_certificate = {-1, "ca_certificate", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_subject_name_constraint = {-1, "subject_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_subject_alt_name_constraint = {-1, "subject_alt_name_constraint", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_get_default_identity_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_default_identity_in[] = {NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_get_default_identity_out[] = {&_moonshot_server_dbus_arg_info_get_default_identity_nai_out, &_moonshot_server_dbus_arg_info_get_default_identity_password_out, &_moonshot_server_dbus_arg_info_get_default_identity_server_certificate_hash, &_moonshot_server_dbus_arg_info_get_default_identity_ca_certificate, &_moonshot_server_dbus_arg_info_get_default_identity_subject_name_constraint, &_moonshot_server_dbus_arg_info_get_default_identity_subject_alt_name_constraint, &_moonshot_server_dbus_arg_info_get_default_identity_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_get_default_identity = {-1, "GetDefaultIdentity", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_default_identity_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_get_default_identity_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_display_name = {-1, "display_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_user_name = {-1, "user_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_password = {-1, "password", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_realm = {-1, "realm", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_rules_patterns = {-1, "rules_patterns", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_rules_always_confirm = {-1, "rules_always_confirm", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_services = {-1, "services", "as"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_ca_cert = {-1, "ca_cert", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_subject = {-1, "subject", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_subject_alt = {-1, "subject_alt", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_server_cert = {-1, "server_cert", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_force_flat_file_store = {-1, "force_flat_file_store", "i"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_id_card_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_id_card_in[] = {&_moonshot_server_dbus_arg_info_install_id_card_display_name, &_moonshot_server_dbus_arg_info_install_id_card_user_name, &_moonshot_server_dbus_arg_info_install_id_card_password, &_moonshot_server_dbus_arg_info_install_id_card_realm, &_moonshot_server_dbus_arg_info_install_id_card_rules_patterns, &_moonshot_server_dbus_arg_info_install_id_card_rules_always_confirm, &_moonshot_server_dbus_arg_info_install_id_card_services, &_moonshot_server_dbus_arg_info_install_id_card_ca_cert, &_moonshot_server_dbus_arg_info_install_id_card_subject, &_moonshot_server_dbus_arg_info_install_id_card_subject_alt, &_moonshot_server_dbus_arg_info_install_id_card_server_cert, &_moonshot_server_dbus_arg_info_install_id_card_force_flat_file_store, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_id_card_out[] = {&_moonshot_server_dbus_arg_info_install_id_card_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_install_id_card = {-1, "InstallIdCard", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_id_card_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_id_card_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_from_file_file_name = {-1, "file_name", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_install_from_file_result = {-1, "result", "i"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_from_file_in[] = {&_moonshot_server_dbus_arg_info_install_from_file_file_name, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_install_from_file_out[] = {&_moonshot_server_dbus_arg_info_install_from_file_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_install_from_file = {-1, "InstallFromFile", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_from_file_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_install_from_file_out)};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_confirm_ca_certificate_nai = {-1, "nai", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_confirm_ca_certificate_realm = {-1, "realm", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_confirm_ca_certificate_ca_hash = {-1, "ca_hash", "s"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_confirm_ca_certificate_confirmed = {-1, "confirmed", "i"};
static const GDBusArgInfo _moonshot_server_dbus_arg_info_confirm_ca_certificate_result = {-1, "result", "b"};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_confirm_ca_certificate_in[] = {&_moonshot_server_dbus_arg_info_confirm_ca_certificate_nai, &_moonshot_server_dbus_arg_info_confirm_ca_certificate_realm, &_moonshot_server_dbus_arg_info_confirm_ca_certificate_ca_hash, NULL};
static const GDBusArgInfo * const _moonshot_server_dbus_arg_info_confirm_ca_certificate_out[] = {&_moonshot_server_dbus_arg_info_confirm_ca_certificate_confirmed, &_moonshot_server_dbus_arg_info_confirm_ca_certificate_result, NULL};
static const GDBusMethodInfo _moonshot_server_dbus_method_info_confirm_ca_certificate = {-1, "ConfirmCaCertificate", (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_confirm_ca_certificate_in), (GDBusArgInfo **) (&_moonshot_server_dbus_arg_info_confirm_ca_certificate_out)};
static const GDBusMethodInfo * const _moonshot_server_dbus_method_info[] = {&_moonshot_server_dbus_method_info_show_ui, &_moonshot_server_dbus_method_info_get_identity, &_moonshot_server_dbus_method_info_get_default_identity, &_moonshot_server_dbus_method_info_install_id_card, &_moonshot_server_dbus_method_info_install_from_file, &_moonshot_server_dbus_method_info_confirm_ca_certificate, NULL};
static const GDBusSignalInfo * const _moonshot_server_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _moonshot_server_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _moonshot_server_dbus_interface_info = {-1, "org.janet.Moonshot", (GDBusMethodInfo **) (&_moonshot_server_dbus_method_info), (GDBusSignalInfo **) (&_moonshot_server_dbus_signal_info), (GDBusPropertyInfo **) (&_moonshot_server_dbus_property_info)};
static const GDBusInterfaceVTable _moonshot_server_dbus_interface_vtable = {moonshot_server_dbus_interface_method_call, moonshot_server_dbus_interface_get_property, moonshot_server_dbus_interface_set_property};

static gpointer _identity_manager_app_ref0 (gpointer self) {
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return self ? identity_manager_app_ref (self) : NULL;
#line 664 "moonshot-server-linux.c"
}


MoonshotServer* moonshot_server_construct (GType object_type, IdentityManagerApp* app) {
	MoonshotServer * self = NULL;
	const gchar* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	MoonshotLogger* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	IdentityManagerApp* _tmp5_ = NULL;
	IdentityManagerApp* _tmp6_ = NULL;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self = (MoonshotServer*) g_object_new (object_type, NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = app;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp1_ == NULL) {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp0_ = "null";
#line 687 "moonshot-server-linux.c"
	} else {
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp0_ = "non-null";
#line 691 "moonshot-server-linux.c"
	}
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = moonshot_server_logger;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp3_ = g_strconcat ("MoonshotServer.<constructor>; app=", _tmp0_, NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp4_ = _tmp3_;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_tmp2_, _tmp4_, NULL);
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_tmp4_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5_ = app;
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp6_ = _identity_manager_app_ref0 (_tmp5_);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self->priv->parent_app = _tmp6_;
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return self;
#line 713 "moonshot-server-linux.c"
}


MoonshotServer* moonshot_server_new (IdentityManagerApp* app) {
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return moonshot_server_construct (TYPE_MOONSHOT_SERVER, app);
#line 720 "moonshot-server-linux.c"
}


gboolean moonshot_server_show_ui (MoonshotServer* self) {
	gboolean result = FALSE;
	MoonshotLogger* _tmp0_ = NULL;
	IdentityManagerApp* _tmp1_ = NULL;
	IdentityManagerView* _tmp2_ = NULL;
	IdentityManagerApp* _tmp6_ = NULL;
	IdentityManagerApp* _tmp7_ = NULL;
	MoonshotLogger* _tmp8_ = NULL;
#line 50 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = moonshot_server_logger;
#line 52 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_tmp0_, "MoonshotServer.show_ui", NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = self->priv->parent_app;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = _tmp1_->view;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp2_ == NULL) {
#line 744 "moonshot-server-linux.c"
		FILE* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		MoonshotLogger* _tmp5_ = NULL;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp3_ = stderr;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp4_ = self->priv->app_name;
#line 55 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		fprintf (_tmp3_, _tmp4_, "show_ui: parent_app.view is null!\n");
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp5_ = moonshot_server_logger;
#line 56 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		moonshot_logger_warn (_tmp5_, "show_ui: parent_app.view is null!", NULL);
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		result = FALSE;
#line 57 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		return result;
#line 762 "moonshot-server-linux.c"
	}
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp6_ = self->priv->parent_app;
#line 59 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	identity_manager_app_show (_tmp6_);
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp7_ = self->priv->parent_app;
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp7_->explicitly_launched = TRUE;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp8_ = moonshot_server_logger;
#line 61 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_tmp8_, "MoonshotServer.show_ui: returning true", NULL);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = TRUE;
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 780 "moonshot-server-linux.c"
}


static void moonshot_server_get_identity_data_free (gpointer _data) {
	MoonshotServerGetIdentityData* _data_;
	_data_ = _data;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->password);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->service);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_slice_free (MoonshotServerGetIdentityData, _data_);
#line 797 "moonshot-server-linux.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return self ? g_object_ref (self) : NULL;
#line 804 "moonshot-server-linux.c"
}


void moonshot_server_get_identity (MoonshotServer* self, const gchar* nai, const gchar* password, const gchar* service, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MoonshotServerGetIdentityData* _data_;
	MoonshotServer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_slice_new0 (MoonshotServerGetIdentityData);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, moonshot_server_get_identity);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, moonshot_server_get_identity_data_free);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->self = _tmp0_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = nai;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai = _tmp2_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp3_ = password;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->password);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->password = _tmp4_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5_ = service;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->service);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->service = _tmp6_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_get_identity_co (_data_);
#line 853 "moonshot-server-linux.c"
}


gboolean moonshot_server_get_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint) {
	gboolean result;
	MoonshotServerGetIdentityData* _data_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (nai_out) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*nai_out = _data_->nai_out;
#line 866 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->nai_out);
#line 870 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai_out = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (password_out) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*password_out = _data_->password_out;
#line 878 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->password_out);
#line 882 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->password_out = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (server_certificate_hash) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*server_certificate_hash = _data_->server_certificate_hash;
#line 890 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 894 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->server_certificate_hash = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (ca_certificate) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*ca_certificate = _data_->ca_certificate;
#line 902 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->ca_certificate);
#line 906 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->ca_certificate = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (subject_name_constraint) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*subject_name_constraint = _data_->subject_name_constraint;
#line 914 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 918 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_name_constraint = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (subject_alt_name_constraint) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*subject_alt_name_constraint = _data_->subject_alt_name_constraint;
#line 926 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 930 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_alt_name_constraint = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = _data_->result;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 938 "moonshot-server-linux.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return _data7_;
#line 947 "moonshot-server-linux.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 956 "moonshot-server-linux.c"
		MoonshotServer* self;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		self = _data7_->self;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (self);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_slice_free (Block7Data, _data7_);
#line 964 "moonshot-server-linux.c"
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1420 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = self;
#line 1421 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 977 "moonshot-server-linux.c"
}


static void __lambda19_ (Block7Data* _data7_, IdentityRequest* IdentityRequest) {
	MoonshotServer* self;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self = _data7_->self;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_if_fail (IdentityRequest != NULL);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_get_identity_co (_data7_->_async_data_);
#line 989 "moonshot-server-linux.c"
}


static void ___lambda19__return_identity_callback (IdentityRequest* request, gpointer self) {
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	__lambda19_ (self, request);
#line 996 "moonshot-server-linux.c"
}


static gboolean moonshot_server_get_identity_co (MoonshotServerGetIdentityData* _data_) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	switch (_data_->_state_) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 0:
#line 1005 "moonshot-server-linux.c"
		goto _state_0;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 1:
#line 1009 "moonshot-server-linux.c"
		goto _state_1;
		default:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_assert_not_reached ();
#line 1014 "moonshot-server-linux.c"
	}
	_state_0:
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_ = g_slice_new0 (Block7Data);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_->_ref_count_ = 1;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_->self = g_object_ref (_data_->self);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_->_async_data_ = _data_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = moonshot_server_logger;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = _data_->nai;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = string_to_string (_data_->_tmp1_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = _data_->service;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = g_strconcat ("MoonshotServer.get_identity: nai='", _data_->_tmp2_, "'; service='", _data_->_tmp4_, "'", NULL);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = NULL;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp0_, _data_->_tmp6_, NULL);
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->_tmp6_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = _data_->self->priv->parent_app;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = _data_->nai;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = _data_->password;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = _data_->service;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = NULL;
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = identity_request_new (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_);
#line 76 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->request = _data_->_tmp11_;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = NULL;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = moonshot_server_logger;
#line 80 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp12_, "MoonshotServer.get_identity: Calling request.execute()", NULL);
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp13_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp13_ = _data_->request;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	identity_request_set_callback (_data_->_tmp13_, ___lambda19__return_identity_callback, block7_data_ref (_data_->_data7_), block7_data_unref);
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp14_ = NULL;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp14_ = _data_->request;
#line 82 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	identity_request_execute (_data_->_tmp14_);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp15_ = NULL;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp15_ = moonshot_server_logger;
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp15_, "MoonshotServer.get_identity: Back from request.execute()", NULL);
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_state_ = 1;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 1107 "moonshot-server-linux.c"
	_state_1:
	;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp16_ = NULL;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp16_ = moonshot_server_logger;
#line 85 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp16_, "MoonshotServer.get_identity: back from yield", NULL);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp17_ = NULL;
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp17_ = g_strdup ("");
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai_out);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai_out = _data_->_tmp17_;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp18_ = NULL;
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp18_ = g_strdup ("");
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->password_out);
#line 88 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->password_out = _data_->_tmp18_;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp19_ = NULL;
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp19_ = g_strdup ("");
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->server_certificate_hash);
#line 89 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->server_certificate_hash = _data_->_tmp19_;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp20_ = NULL;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp20_ = g_strdup ("");
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->ca_certificate);
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->ca_certificate = _data_->_tmp20_;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp21_ = NULL;
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp21_ = g_strdup ("");
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->subject_name_constraint);
#line 91 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_name_constraint = _data_->_tmp21_;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp22_ = NULL;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp22_ = g_strdup ("");
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->subject_alt_name_constraint);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_alt_name_constraint = _data_->_tmp22_;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp23_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp23_ = _data_->request;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp24_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp24_ = _data_->_tmp23_->id_card;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp25_ = NULL;
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp25_ = _g_object_ref0 (_data_->_tmp24_);
#line 94 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->id_card = _data_->_tmp25_;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp27_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp27_ = _data_->id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_tmp27_ != NULL) {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp28_ = NULL;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp28_ = _data_->id_card;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp29_ = FALSE;
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp29_ = id_card_is_no_identity (_data_->_tmp28_);
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp26_ = !_data_->_tmp29_;
#line 1194 "moonshot-server-linux.c"
	} else {
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp26_ = FALSE;
#line 1198 "moonshot-server-linux.c"
	}
#line 96 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_tmp26_) {
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp30_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp30_ = _data_->id_card;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp31_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp31_ = id_card_get_nai (_data_->_tmp30_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp32_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp32_ = _data_->_tmp31_;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp33_ = NULL;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp33_ = g_strdup (_data_->_tmp32_);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->nai_out);
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->nai_out = _data_->_tmp33_;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp35_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp35_ = _data_->request;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp36_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp36_ = _data_->_tmp35_->password;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp36_ != NULL) {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp37_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp37_ = _data_->request;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp38_ = NULL;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp38_ = _data_->_tmp37_->password;
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp34_ = g_strcmp0 (_data_->_tmp38_, "") != 0;
#line 1242 "moonshot-server-linux.c"
		} else {
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp34_ = FALSE;
#line 1246 "moonshot-server-linux.c"
		}
#line 98 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp34_) {
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp39_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp39_ = _data_->request;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp40_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp40_ = _data_->_tmp39_->password;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp41_ = NULL;
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->password_out);
#line 99 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->password_out = _data_->_tmp41_;
#line 1266 "moonshot-server-linux.c"
		} else {
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp42_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp42_ = _data_->id_card;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp43_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp43_ = id_card_get_password (_data_->_tmp42_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp44_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp44_ = _data_->_tmp43_;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp45_ = NULL;
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp45_ = g_strdup (_data_->_tmp44_);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->password_out);
#line 101 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->password_out = _data_->_tmp45_;
#line 1288 "moonshot-server-linux.c"
		}
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp46_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp46_ = _data_->id_card;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp47_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp47_ = id_card_get_trust_anchor (_data_->_tmp46_);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp48_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp48_ = _data_->_tmp47_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp49_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp49_ = trust_anchor_get_server_cert (_data_->_tmp48_);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp50_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp50_ = _data_->_tmp49_;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp51_ = NULL;
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp51_ = g_strdup (_data_->_tmp50_);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 103 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->server_certificate_hash = _data_->_tmp51_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp52_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp52_ = _data_->id_card;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp53_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp53_ = id_card_get_trust_anchor (_data_->_tmp52_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp54_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp54_ = _data_->_tmp53_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp55_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp55_ = trust_anchor_get_ca_cert (_data_->_tmp54_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp56_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp56_ = _data_->_tmp55_;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp57_ = NULL;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp57_ = g_strdup (_data_->_tmp56_);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->ca_certificate);
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->ca_certificate = _data_->_tmp57_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp58_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp58_ = _data_->id_card;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp59_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp59_ = id_card_get_trust_anchor (_data_->_tmp58_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp60_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp60_ = _data_->_tmp59_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp61_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp61_ = trust_anchor_get_subject (_data_->_tmp60_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp62_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp62_ = _data_->_tmp61_;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp63_ = NULL;
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp63_ = g_strdup (_data_->_tmp62_);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 105 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->subject_name_constraint = _data_->_tmp63_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp64_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp64_ = _data_->id_card;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp65_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp65_ = id_card_get_trust_anchor (_data_->_tmp64_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp66_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp66_ = _data_->_tmp65_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp67_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp67_ = trust_anchor_get_subject_alt (_data_->_tmp66_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp68_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp68_ = _data_->_tmp67_;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp69_ = NULL;
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp69_ = g_strdup (_data_->_tmp68_);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->subject_alt_name_constraint = _data_->_tmp69_;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp70_ = NULL;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp70_ = _data_->nai_out;
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp70_ == NULL) {
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp71_ = NULL;
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp71_ = g_strdup ("");
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->nai_out);
#line 109 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->nai_out = _data_->_tmp71_;
#line 1416 "moonshot-server-linux.c"
		}
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp72_ = NULL;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp72_ = _data_->password_out;
#line 110 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp72_ == NULL) {
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp73_ = NULL;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp73_ = g_strdup ("");
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->password_out);
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->password_out = _data_->_tmp73_;
#line 1432 "moonshot-server-linux.c"
		}
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp74_ = NULL;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp74_ = _data_->server_certificate_hash;
#line 112 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp74_ == NULL) {
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp75_ = NULL;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp75_ = g_strdup ("");
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->server_certificate_hash);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->server_certificate_hash = _data_->_tmp75_;
#line 1448 "moonshot-server-linux.c"
		}
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp76_ = NULL;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp76_ = _data_->ca_certificate;
#line 114 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp76_ == NULL) {
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp77_ = NULL;
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp77_ = g_strdup ("");
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->ca_certificate);
#line 115 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->ca_certificate = _data_->_tmp77_;
#line 1464 "moonshot-server-linux.c"
		}
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp78_ = NULL;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp78_ = _data_->subject_name_constraint;
#line 116 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp78_ == NULL) {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp79_ = NULL;
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp79_ = g_strdup ("");
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->subject_name_constraint);
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->subject_name_constraint = _data_->_tmp79_;
#line 1480 "moonshot-server-linux.c"
		}
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp80_ = NULL;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp80_ = _data_->subject_alt_name_constraint;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp80_ == NULL) {
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp81_ = NULL;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp81_ = g_strdup ("");
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->subject_alt_name_constraint);
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->subject_alt_name_constraint = _data_->_tmp81_;
#line 1496 "moonshot-server-linux.c"
		}
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp82_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp82_ = moonshot_server_logger;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp83_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp83_ = _data_->nai_out;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp84_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp84_ = string_to_string (_data_->_tmp83_);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp85_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp85_ = g_strconcat ("MoonshotServer.get_identity: returning with nai_out=", _data_->_tmp84_, NULL);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp86_ = NULL;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp86_ = _data_->_tmp85_;
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		moonshot_logger_trace (_data_->_tmp82_, _data_->_tmp86_, NULL);
#line 121 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->_tmp86_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->result = TRUE;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (_data_->id_card);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (_data_->request);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		block7_data_unref (_data_->_data7_);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_data7_ = NULL;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_state_ == 0) {
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1536 "moonshot-server-linux.c"
		} else {
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1540 "moonshot-server-linux.c"
		}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_object_unref (_data_->_async_result);
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		return FALSE;
#line 1546 "moonshot-server-linux.c"
	}
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp87_ = NULL;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp87_ = moonshot_server_logger;
#line 126 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp87_, "MoonshotServer.get_identity: returning false", NULL);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->result = FALSE;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->id_card);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block7_data_unref (_data_->_data7_);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1568 "moonshot-server-linux.c"
	} else {
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1572 "moonshot-server-linux.c"
	}
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->id_card);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block7_data_unref (_data_->_data7_);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data7_ = NULL;
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1590 "moonshot-server-linux.c"
	} else {
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1594 "moonshot-server-linux.c"
	}
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 1600 "moonshot-server-linux.c"
}


static void moonshot_server_get_default_identity_data_free (gpointer _data) {
	MoonshotServerGetDefaultIdentityData* _data_;
	_data_ = _data;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_slice_free (MoonshotServerGetDefaultIdentityData, _data_);
#line 1611 "moonshot-server-linux.c"
}


void moonshot_server_get_default_identity (MoonshotServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MoonshotServerGetDefaultIdentityData* _data_;
	MoonshotServer* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_slice_new0 (MoonshotServerGetDefaultIdentityData);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, moonshot_server_get_default_identity);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, moonshot_server_get_default_identity_data_free);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->self = _tmp0_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_get_default_identity_co (_data_);
#line 1630 "moonshot-server-linux.c"
}


gboolean moonshot_server_get_default_identity_finish (MoonshotServer* self, GAsyncResult* _res_, gchar** nai_out, gchar** password_out, gchar** server_certificate_hash, gchar** ca_certificate, gchar** subject_name_constraint, gchar** subject_alt_name_constraint) {
	gboolean result;
	MoonshotServerGetDefaultIdentityData* _data_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (nai_out) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*nai_out = _data_->nai_out;
#line 1643 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->nai_out);
#line 1647 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai_out = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (password_out) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*password_out = _data_->password_out;
#line 1655 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->password_out);
#line 1659 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->password_out = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (server_certificate_hash) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*server_certificate_hash = _data_->server_certificate_hash;
#line 1667 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 1671 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->server_certificate_hash = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (ca_certificate) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*ca_certificate = _data_->ca_certificate;
#line 1679 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->ca_certificate);
#line 1683 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->ca_certificate = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (subject_name_constraint) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*subject_name_constraint = _data_->subject_name_constraint;
#line 1691 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 1695 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_name_constraint = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (subject_alt_name_constraint) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*subject_alt_name_constraint = _data_->subject_alt_name_constraint;
#line 1703 "moonshot-server-linux.c"
	} else {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 1707 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_alt_name_constraint = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = _data_->result;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 1715 "moonshot-server-linux.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return _data8_;
#line 1724 "moonshot-server-linux.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1733 "moonshot-server-linux.c"
		MoonshotServer* self;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		self = _data8_->self;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (self);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_slice_free (Block8Data, _data8_);
#line 1741 "moonshot-server-linux.c"
	}
}


static void __lambda20_ (Block8Data* _data8_, IdentityRequest* IdentityRequest) {
	MoonshotServer* self;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self = _data8_->self;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_if_fail (IdentityRequest != NULL);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_get_default_identity_co (_data8_->_async_data_);
#line 1754 "moonshot-server-linux.c"
}


static void ___lambda20__return_identity_callback (IdentityRequest* request, gpointer self) {
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	__lambda20_ (self, request);
#line 1761 "moonshot-server-linux.c"
}


static gboolean moonshot_server_get_default_identity_co (MoonshotServerGetDefaultIdentityData* _data_) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	switch (_data_->_state_) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 0:
#line 1770 "moonshot-server-linux.c"
		goto _state_0;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 1:
#line 1774 "moonshot-server-linux.c"
		goto _state_1;
		default:
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_assert_not_reached ();
#line 1779 "moonshot-server-linux.c"
	}
	_state_0:
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_ = g_slice_new0 (Block8Data);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_->_ref_count_ = 1;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_->self = g_object_ref (_data_->self);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_->_async_data_ = _data_;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = moonshot_server_logger;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp0_, "MoonshotServer.get_default_identity", NULL);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = _data_->self->priv->parent_app;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = NULL;
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = identity_request_new_default (_data_->_tmp1_);
#line 138 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->request = _data_->_tmp2_;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = NULL;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = _data_->request;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	identity_request_set_callback (_data_->_tmp3_, ___lambda20__return_identity_callback, block8_data_ref (_data_->_data8_), block8_data_unref);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = NULL;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = _data_->request;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	identity_request_execute (_data_->_tmp4_);
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_state_ = 1;
#line 141 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 1822 "moonshot-server-linux.c"
	_state_1:
	;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = NULL;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = g_strdup ("");
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai_out);
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai_out = _data_->_tmp5_;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = NULL;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = g_strdup ("");
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->password_out);
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->password_out = _data_->_tmp6_;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = NULL;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = g_strdup ("");
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->server_certificate_hash);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->server_certificate_hash = _data_->_tmp7_;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = NULL;
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = g_strdup ("");
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->ca_certificate);
#line 146 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->ca_certificate = _data_->_tmp8_;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = NULL;
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = g_strdup ("");
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->subject_name_constraint);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_name_constraint = _data_->_tmp9_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = NULL;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = g_strdup ("");
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->subject_alt_name_constraint);
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->subject_alt_name_constraint = _data_->_tmp10_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = _data_->request;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = NULL;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = _data_->_tmp11_->id_card;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_tmp12_ != NULL) {
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp13_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp13_ = _data_->request;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp14_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp14_ = _data_->_tmp13_->id_card;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp15_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp15_ = id_card_get_nai (_data_->_tmp14_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp16_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp16_ = _data_->_tmp15_;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp17_ = NULL;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->nai_out);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->nai_out = _data_->_tmp17_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp18_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp18_ = _data_->request;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp19_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp19_ = _data_->_tmp18_->id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp20_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp20_ = id_card_get_password (_data_->_tmp19_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp21_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp22_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->password_out);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->password_out = _data_->_tmp22_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp23_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp23_ = _data_->request;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp24_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp24_ = _data_->_tmp23_->id_card;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp25_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp25_ = id_card_get_trust_anchor (_data_->_tmp24_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp26_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp27_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp27_ = trust_anchor_get_server_cert (_data_->_tmp26_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp28_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp28_ = _data_->_tmp27_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp29_ = NULL;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->server_certificate_hash);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->server_certificate_hash = _data_->_tmp29_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp30_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp30_ = _data_->request;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp31_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp31_ = _data_->_tmp30_->id_card;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp32_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp32_ = id_card_get_trust_anchor (_data_->_tmp31_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp33_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp33_ = _data_->_tmp32_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp34_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp34_ = trust_anchor_get_ca_cert (_data_->_tmp33_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp35_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp35_ = _data_->_tmp34_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp36_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->ca_certificate);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->ca_certificate = _data_->_tmp36_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp37_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp37_ = _data_->request;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp38_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp38_ = _data_->_tmp37_->id_card;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp39_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp39_ = id_card_get_trust_anchor (_data_->_tmp38_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp40_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp40_ = _data_->_tmp39_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp41_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp41_ = trust_anchor_get_subject (_data_->_tmp40_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp42_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp42_ = _data_->_tmp41_;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp43_ = NULL;
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp43_ = g_strdup (_data_->_tmp42_);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_name_constraint);
#line 157 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->subject_name_constraint = _data_->_tmp43_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp44_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp44_ = _data_->request;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp45_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp45_ = _data_->_tmp44_->id_card;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp46_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp46_ = id_card_get_trust_anchor (_data_->_tmp45_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp47_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp47_ = _data_->_tmp46_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp48_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp48_ = trust_anchor_get_subject_alt (_data_->_tmp47_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp49_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp49_ = _data_->_tmp48_;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp50_ = NULL;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp50_ = g_strdup (_data_->_tmp49_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_data_->subject_alt_name_constraint);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->subject_alt_name_constraint = _data_->_tmp50_;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp51_ = NULL;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp51_ = _data_->nai_out;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp51_ == NULL) {
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp52_ = NULL;
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp52_ = g_strdup ("");
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->nai_out);
#line 161 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->nai_out = _data_->_tmp52_;
#line 2073 "moonshot-server-linux.c"
		}
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp53_ = NULL;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp53_ = _data_->password_out;
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp53_ == NULL) {
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp54_ = NULL;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp54_ = g_strdup ("");
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->password_out);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->password_out = _data_->_tmp54_;
#line 2089 "moonshot-server-linux.c"
		}
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp55_ = NULL;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp55_ = _data_->server_certificate_hash;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp55_ == NULL) {
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp56_ = NULL;
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp56_ = g_strdup ("");
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->server_certificate_hash);
#line 165 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->server_certificate_hash = _data_->_tmp56_;
#line 2105 "moonshot-server-linux.c"
		}
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp57_ = NULL;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp57_ = _data_->ca_certificate;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp57_ == NULL) {
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp58_ = NULL;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp58_ = g_strdup ("");
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->ca_certificate);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->ca_certificate = _data_->_tmp58_;
#line 2121 "moonshot-server-linux.c"
		}
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp59_ = NULL;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp59_ = _data_->subject_name_constraint;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp59_ == NULL) {
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp60_ = NULL;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp60_ = g_strdup ("");
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->subject_name_constraint);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->subject_name_constraint = _data_->_tmp60_;
#line 2137 "moonshot-server-linux.c"
		}
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp61_ = NULL;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp61_ = _data_->subject_alt_name_constraint;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_tmp61_ == NULL) {
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp62_ = NULL;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->_tmp62_ = g_strdup ("");
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_free0 (_data_->subject_alt_name_constraint);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_data_->subject_alt_name_constraint = _data_->_tmp62_;
#line 2153 "moonshot-server-linux.c"
		}
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp63_ = NULL;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp63_ = moonshot_server_logger;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		moonshot_logger_trace (_data_->_tmp63_, "MoonshotServer.get_default_identity: returning true", NULL);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->result = TRUE;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (_data_->request);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		block8_data_unref (_data_->_data8_);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_data8_ = NULL;
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		if (_data_->_state_ == 0) {
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2173 "moonshot-server-linux.c"
		} else {
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2177 "moonshot-server-linux.c"
		}
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_object_unref (_data_->_async_result);
#line 174 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		return FALSE;
#line 2183 "moonshot-server-linux.c"
	}
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->result = FALSE;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block8_data_unref (_data_->_data8_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_ = NULL;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2197 "moonshot-server-linux.c"
	} else {
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2201 "moonshot-server-linux.c"
	}
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block8_data_unref (_data_->_data8_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data8_ = NULL;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2217 "moonshot-server-linux.c"
	} else {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2221 "moonshot-server-linux.c"
	}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 2227 "moonshot-server-linux.c"
}


static void _vala_Rule_array_free (Rule* array, gint array_length) {
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (array != NULL) {
#line 2234 "moonshot-server-linux.c"
		int i;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			rule_destroy (&array[i]);
#line 2240 "moonshot-server-linux.c"
		}
	}
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_free (array);
#line 2245 "moonshot-server-linux.c"
}


gboolean moonshot_server_install_id_card (MoonshotServer* self, const gchar* display_name, const gchar* user_name, const gchar* password, const gchar* realm, gchar** rules_patterns, int rules_patterns_length1, gchar** rules_always_confirm, int rules_always_confirm_length1, gchar** services, int services_length1, const gchar* ca_cert, const gchar* subject, const gchar* subject_alt, const gchar* server_cert, gint force_flat_file_store) {
	gboolean result = FALSE;
	IdCard* idcard = NULL;
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IdCard* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	IdCard* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	IdCard* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	TrustAnchor* ta = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	TrustAnchor* _tmp19_ = NULL;
	TrustAnchor* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	IdCard* _tmp40_ = NULL;
	TrustAnchor* _tmp41_ = NULL;
	MoonshotLogger* _tmp42_ = NULL;
	IdCard* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	IdCard* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	MoonshotLogger* _tmp51_ = NULL;
	IdCard* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	IdCard* _tmp56_ = NULL;
	TrustAnchor* _tmp57_ = NULL;
	TrustAnchor* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	IdCard* _tmp62_ = NULL;
	TrustAnchor* _tmp63_ = NULL;
	TrustAnchor* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gchar** _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	GeeArrayList* old_duplicates = NULL;
	gboolean ret = FALSE;
	IdentityManagerApp* _tmp92_ = NULL;
	IdCard* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	GeeArrayList* _tmp95_ = NULL;
	gboolean _tmp96_ = FALSE;
	GeeArrayList* _tmp97_ = NULL;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (display_name != NULL, FALSE);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (user_name != NULL, FALSE);
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = id_card_new ();
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	idcard = _tmp0_;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = idcard;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = display_name;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_set_display_name (_tmp1_, _tmp2_);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp3_ = idcard;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp4_ = user_name;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_set_username (_tmp3_, _tmp4_);
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5_ = idcard;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp6_ = password;
#line 197 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_set_password (_tmp5_, _tmp6_);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp8_ = password;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp8_ != NULL) {
#line 2348 "moonshot-server-linux.c"
		const gchar* _tmp9_ = NULL;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp9_ = password;
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, "") != 0;
#line 2354 "moonshot-server-linux.c"
	} else {
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp7_ = FALSE;
#line 2358 "moonshot-server-linux.c"
	}
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp7_) {
#line 2362 "moonshot-server-linux.c"
		IdCard* _tmp10_ = NULL;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp10_ = idcard;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		id_card_set_store_password (_tmp10_, TRUE);
#line 2368 "moonshot-server-linux.c"
	}
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp11_ = idcard;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp12_ = realm;
#line 200 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_set_issuer (_tmp11_, _tmp12_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp13_ = idcard;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp14_ = services;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp14__length1 = services_length1;
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_update_services (_tmp13_, _tmp14_, _tmp14__length1);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp15_ = ca_cert;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp16_ = server_cert;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp17_ = subject;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp18_ = subject_alt;
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp19_ = trust_anchor_new (_tmp15_, _tmp16_, _tmp17_, _tmp18_);
#line 202 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	ta = _tmp19_;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp20_ = ta;
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp21_ = trust_anchor_is_empty (_tmp20_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (!_tmp21_) {
#line 2402 "moonshot-server-linux.c"
		gchar* ta_datetime_added = NULL;
		gchar* _tmp22_ = NULL;
		TrustAnchor* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		MoonshotLogger* _tmp25_ = NULL;
		IdCard* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		TrustAnchor* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		TrustAnchor* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		TrustAnchor* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp22_ = trust_anchor_format_datetime_now ();
#line 206 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		ta_datetime_added = _tmp22_;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp23_ = ta;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp24_ = ta_datetime_added;
#line 207 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		trust_anchor_set_datetime_added (_tmp23_, _tmp24_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp25_ = moonshot_server_logger;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp26_ = idcard;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp27_ = id_card_get_display_name (_tmp26_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp28_ = _tmp27_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp29_ = ta;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp30_ = trust_anchor_get_datetime_added (_tmp29_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp31_ = _tmp30_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp32_ = ta;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp33_ = trust_anchor_get_ca_cert (_tmp32_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp34_ = _tmp33_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp35_ = ta;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp36_ = trust_anchor_get_server_cert (_tmp35_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp37_ = _tmp36_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp38_ = g_strdup_printf ("install_id_card : Set ta_datetime_added for '%s' to '%s'; ca_cert='%s'" \
"; server_cert='%s'", _tmp28_, _tmp31_, _tmp34_, _tmp37_);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp39_ = _tmp38_;
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		moonshot_logger_trace (_tmp25_, _tmp39_, NULL);
#line 208 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (_tmp39_);
#line 204 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_free0 (ta_datetime_added);
#line 2468 "moonshot-server-linux.c"
	}
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp40_ = idcard;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp41_ = ta;
#line 210 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	id_card_set_trust_anchor_from_store (_tmp40_, _tmp41_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp42_ = moonshot_server_logger;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp43_ = idcard;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp44_ = id_card_get_display_name (_tmp43_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp45_ = _tmp44_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp46_ = idcard;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp47_ = id_card_get_services_string (_tmp46_, "; ");
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp48_ = _tmp47_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp49_ = g_strdup_printf ("install_id_card: Card '%s' has services: '%s'", _tmp45_, _tmp48_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp50_ = _tmp49_;
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_tmp42_, _tmp50_, NULL);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_tmp50_);
#line 212 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_tmp48_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp51_ = moonshot_server_logger;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp52_ = idcard;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp53_ = id_card_get_display_name (_tmp52_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp54_ = _tmp53_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp55_ = string_to_string (_tmp54_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp56_ = idcard;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp57_ = id_card_get_trust_anchor (_tmp56_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp58_ = _tmp57_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp59_ = trust_anchor_get_ca_cert (_tmp58_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp60_ = _tmp59_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp61_ = string_to_string (_tmp60_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp62_ = idcard;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp63_ = id_card_get_trust_anchor (_tmp62_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp64_ = _tmp63_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp65_ = trust_anchor_get_server_cert (_tmp64_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp66_ = _tmp65_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp67_ = string_to_string (_tmp66_);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp68_ = g_strconcat ("Installing IdCard named '", _tmp55_, "'; ca_cert='", _tmp61_, "'; server_cert='", _tmp67_, "'", NULL);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp69_ = _tmp68_;
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_tmp51_, _tmp69_, NULL);
#line 215 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_tmp69_);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp70_ = rules_patterns;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp70__length1 = rules_patterns_length1;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp71_ = rules_always_confirm;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp71__length1 = rules_always_confirm_length1;
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp70__length1 == _tmp71__length1) {
#line 2552 "moonshot-server-linux.c"
		Rule* rules = NULL;
		gchar** _tmp72_ = NULL;
		gint _tmp72__length1 = 0;
		Rule* _tmp73_ = NULL;
		gint rules_length1 = 0;
		gint _rules_size_ = 0;
		IdCard* _tmp90_ = NULL;
		Rule* _tmp91_ = NULL;
		gint _tmp91__length1 = 0;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp72_ = rules_patterns;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp72__length1 = rules_patterns_length1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp73_ = g_new0 (Rule, _tmp72__length1);
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		rules = _tmp73_;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		rules_length1 = _tmp72__length1;
#line 221 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_rules_size_ = rules_length1;
#line 2574 "moonshot-server-linux.c"
		{
			gint i = 0;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			i = 0;
#line 2579 "moonshot-server-linux.c"
			{
				gboolean _tmp74_ = FALSE;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp74_ = TRUE;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				while (TRUE) {
#line 2586 "moonshot-server-linux.c"
					gint _tmp76_ = 0;
					Rule* _tmp77_ = NULL;
					gint _tmp77__length1 = 0;
					Rule* _tmp78_ = NULL;
					gint _tmp78__length1 = 0;
					gint _tmp79_ = 0;
					gchar** _tmp80_ = NULL;
					gint _tmp80__length1 = 0;
					gint _tmp81_ = 0;
					const gchar* _tmp82_ = NULL;
					gchar* _tmp83_ = NULL;
					Rule* _tmp84_ = NULL;
					gint _tmp84__length1 = 0;
					gint _tmp85_ = 0;
					gchar** _tmp86_ = NULL;
					gint _tmp86__length1 = 0;
					gint _tmp87_ = 0;
					const gchar* _tmp88_ = NULL;
					gchar* _tmp89_ = NULL;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					if (!_tmp74_) {
#line 2608 "moonshot-server-linux.c"
						gint _tmp75_ = 0;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						_tmp75_ = i;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						i = _tmp75_ + 1;
#line 2614 "moonshot-server-linux.c"
					}
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp74_ = FALSE;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp76_ = i;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp77_ = rules;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp77__length1 = rules_length1;
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					if (!(_tmp76_ < _tmp77__length1)) {
#line 223 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						break;
#line 2628 "moonshot-server-linux.c"
					}
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp78_ = rules;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp78__length1 = rules_length1;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp79_ = i;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp80_ = rules_patterns;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp80__length1 = rules_patterns_length1;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp81_ = i;
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp82_ = _tmp80_[_tmp81_];
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp83_ = g_strdup (_tmp82_);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_g_free0 (_tmp78_[_tmp79_].pattern);
#line 225 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp78_[_tmp79_].pattern = _tmp83_;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp84_ = rules;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp84__length1 = rules_length1;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp85_ = i;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp86_ = rules_always_confirm;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp86__length1 = rules_always_confirm_length1;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp87_ = i;
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp88_ = _tmp86_[_tmp87_];
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp89_ = g_strdup (_tmp88_);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_g_free0 (_tmp84_[_tmp85_].always_confirm);
#line 226 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp84_[_tmp85_].always_confirm = _tmp89_;
#line 2670 "moonshot-server-linux.c"
				}
			}
		}
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp90_ = idcard;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp91_ = rules;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_tmp91__length1 = rules_length1;
#line 228 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		id_card_set_rules (_tmp90_, _tmp91_, _tmp91__length1);
#line 218 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		rules = (_vala_Rule_array_free (rules, rules_length1), NULL);
#line 2684 "moonshot-server-linux.c"
	}
#line 231 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	old_duplicates = NULL;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp92_ = self->priv->parent_app;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp93_ = idcard;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp94_ = force_flat_file_store;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp96_ = identity_manager_app_add_identity (_tmp92_, _tmp93_, _tmp94_ != 0, &_tmp95_);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (old_duplicates);
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	old_duplicates = _tmp95_;
#line 232 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	ret = _tmp96_;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp97_ = old_duplicates;
#line 234 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_tmp97_ != NULL) {
#line 2706 "moonshot-server-linux.c"
		{
			GeeArrayList* _id_card_list = NULL;
			GeeArrayList* _tmp98_ = NULL;
			GeeArrayList* _tmp99_ = NULL;
			gint _id_card_size = 0;
			GeeArrayList* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			gint _tmp102_ = 0;
			gint _id_card_index = 0;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp98_ = old_duplicates;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp99_ = _g_object_ref0 (_tmp98_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_id_card_list = _tmp99_;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp100_ = _id_card_list;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp102_ = _tmp101_;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_id_card_size = _tmp102_;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_id_card_index = -1;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			while (TRUE) {
#line 2734 "moonshot-server-linux.c"
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
				IdCard* id_card = NULL;
				GeeArrayList* _tmp106_ = NULL;
				gint _tmp107_ = 0;
				gpointer _tmp108_ = NULL;
				FILE* _tmp109_ = NULL;
				IdCard* _tmp110_ = NULL;
				const gchar* _tmp111_ = NULL;
				const gchar* _tmp112_ = NULL;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp103_ = _id_card_index;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_id_card_index = _tmp103_ + 1;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp104_ = _id_card_index;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp105_ = _id_card_size;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				if (!(_tmp104_ < _tmp105_)) {
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					break;
#line 2758 "moonshot-server-linux.c"
				}
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp106_ = _id_card_list;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp107_ = _id_card_index;
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp108_ = gee_abstract_list_get ((GeeAbstractList*) _tmp106_, _tmp107_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				id_card = (IdCard*) _tmp108_;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp109_ = stdout;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp110_ = id_card;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp111_ = id_card_get_nai (_tmp110_);
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp112_ = _tmp111_;
#line 238 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				fprintf (_tmp109_, "removed duplicate id for '%s'\n", _tmp112_);
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_g_object_unref0 (id_card);
#line 2780 "moonshot-server-linux.c"
			}
#line 237 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_g_object_unref0 (_id_card_list);
#line 2784 "moonshot-server-linux.c"
		}
	}
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = ret;
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (old_duplicates);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (ta);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (idcard);
#line 241 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 2797 "moonshot-server-linux.c"
}


gint moonshot_server_install_from_file (MoonshotServer* self, const gchar* file_name) {
	gint result = 0;
	WebProvisioningParser* webp = NULL;
	const gchar* _tmp0_ = NULL;
	WebProvisioningParser* _tmp1_ = NULL;
	WebProvisioningParser* _tmp2_ = NULL;
	gboolean _result_ = FALSE;
	gint installed_cards = 0;
	WebProvisioningParser* _tmp3_ = NULL;
	IdCard** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	IdCard** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 245 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_val_if_fail (file_name != NULL, 0);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = file_name;
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = web_provisioning_parser_new (_tmp0_);
#line 247 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	webp = _tmp1_;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = webp;
#line 249 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	web_provisioning_parser_parse (_tmp2_);
#line 250 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_result_ = FALSE;
#line 251 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	installed_cards = 0;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp3_ = webp;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp4_ = web_provisioning_parser_get_cards (_tmp3_, &_tmp4__length1);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5_ = _tmp4_;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5__length1 = _tmp4__length1;
#line 2840 "moonshot-server-linux.c"
	{
		IdCard** card_collection = NULL;
		gint card_collection_length1 = 0;
		gint _card_collection_size_ = 0;
		gint card_it = 0;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		card_collection = _tmp5_;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		card_collection_length1 = _tmp5__length1;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		for (card_it = 0; card_it < _tmp5__length1; card_it = card_it + 1) {
#line 2852 "moonshot-server-linux.c"
			IdCard* _tmp6_ = NULL;
			IdCard* card = NULL;
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			_tmp6_ = _g_object_ref0 (card_collection[card_it]);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
			card = _tmp6_;
#line 2859 "moonshot-server-linux.c"
			{
				gchar** rules_patterns = NULL;
				gchar** _tmp7_ = NULL;
				gint rules_patterns_length1 = 0;
				gint _rules_patterns_size_ = 0;
				gchar** rules_always_confirm = NULL;
				gchar** _tmp8_ = NULL;
				gint rules_always_confirm_length1 = 0;
				gint _rules_always_confirm_size_ = 0;
				IdCard* _tmp9_ = NULL;
				Rule* _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				Rule* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar** svcs = NULL;
				IdCard* _tmp37_ = NULL;
				GeeArrayList* _tmp38_ = NULL;
				GeeArrayList* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gchar** _tmp42_ = NULL;
				gint svcs_length1 = 0;
				gint _svcs_size_ = 0;
				MoonshotLogger* _tmp59_ = NULL;
				IdCard* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				IdCard* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
				const gchar* _tmp68_ = NULL;
				IdCard* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				IdCard* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				IdCard* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				gchar** _tmp78_ = NULL;
				gint _tmp78__length1 = 0;
				gchar** _tmp79_ = NULL;
				gint _tmp79__length1 = 0;
				gchar** _tmp80_ = NULL;
				gint _tmp80__length1 = 0;
				IdCard* _tmp81_ = NULL;
				TrustAnchor* _tmp82_ = NULL;
				TrustAnchor* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				const gchar* _tmp85_ = NULL;
				IdCard* _tmp86_ = NULL;
				TrustAnchor* _tmp87_ = NULL;
				TrustAnchor* _tmp88_ = NULL;
				const gchar* _tmp89_ = NULL;
				const gchar* _tmp90_ = NULL;
				IdCard* _tmp91_ = NULL;
				TrustAnchor* _tmp92_ = NULL;
				TrustAnchor* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				const gchar* _tmp95_ = NULL;
				IdCard* _tmp96_ = NULL;
				TrustAnchor* _tmp97_ = NULL;
				TrustAnchor* _tmp98_ = NULL;
				const gchar* _tmp99_ = NULL;
				const gchar* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp7_ = g_new0 (gchar*, 0 + 1);
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_patterns = _tmp7_;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_patterns_length1 = 0;
#line 254 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_rules_patterns_size_ = rules_patterns_length1;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp8_ = g_new0 (gchar*, 0 + 1);
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_always_confirm = _tmp8_;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_always_confirm_length1 = 0;
#line 255 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp9_ = card;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp10_ = id_card_get_rules (_tmp9_, &_tmp10__length1);
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp11_ = _tmp10_;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp11__length1 = _tmp10__length1;
#line 257 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				if (_tmp11__length1 > 0) {
#line 2956 "moonshot-server-linux.c"
					gint i = 0;
					IdCard* _tmp12_ = NULL;
					Rule* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					Rule* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gchar** _tmp15_ = NULL;
					IdCard* _tmp16_ = NULL;
					Rule* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					Rule* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					gchar** _tmp19_ = NULL;
					IdCard* _tmp20_ = NULL;
					Rule* _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					Rule* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
#line 259 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					i = 0;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp12_ = card;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp13_ = id_card_get_rules (_tmp12_, &_tmp13__length1);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp14_ = _tmp13_;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp14__length1 = _tmp13__length1;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp15_ = g_new0 (gchar*, _tmp14__length1 + 1);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_patterns = _tmp15_;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_patterns_length1 = _tmp14__length1;
#line 260 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_rules_patterns_size_ = rules_patterns_length1;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp16_ = card;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp17_ = id_card_get_rules (_tmp16_, &_tmp17__length1);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp18_ = _tmp17_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp18__length1 = _tmp17__length1;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp19_ = g_new0 (gchar*, _tmp18__length1 + 1);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_always_confirm = _tmp19_;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					rules_always_confirm_length1 = _tmp18__length1;
#line 261 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_rules_always_confirm_size_ = rules_always_confirm_length1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp20_ = card;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp21_ = id_card_get_rules (_tmp20_, &_tmp21__length1);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp22_ = _tmp21_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp22__length1 = _tmp21__length1;
#line 3021 "moonshot-server-linux.c"
					{
						Rule* r_collection = NULL;
						gint r_collection_length1 = 0;
						gint _r_collection_size_ = 0;
						gint r_it = 0;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						r_collection = _tmp22_;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						r_collection_length1 = _tmp22__length1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						for (r_it = 0; r_it < _tmp22__length1; r_it = r_it + 1) {
#line 3033 "moonshot-server-linux.c"
							Rule _tmp23_ = {0};
							Rule r = {0};
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							rule_copy (&r_collection[r_it], &_tmp23_);
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							r = _tmp23_;
#line 3040 "moonshot-server-linux.c"
							{
								gchar** _tmp24_ = NULL;
								gint _tmp24__length1 = 0;
								gint _tmp25_ = 0;
								Rule _tmp26_ = {0};
								const gchar* _tmp27_ = NULL;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								gchar** _tmp30_ = NULL;
								gint _tmp30__length1 = 0;
								gint _tmp31_ = 0;
								Rule _tmp32_ = {0};
								const gchar* _tmp33_ = NULL;
								gchar* _tmp34_ = NULL;
								gchar* _tmp35_ = NULL;
								gint _tmp36_ = 0;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp24_ = rules_patterns;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp24__length1 = rules_patterns_length1;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp25_ = i;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp26_ = r;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp27_ = _tmp26_.pattern;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp28_ = g_strdup (_tmp27_);
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_g_free0 (_tmp24_[_tmp25_]);
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp24_[_tmp25_] = _tmp28_;
#line 264 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp29_ = _tmp24_[_tmp25_];
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp30_ = rules_always_confirm;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp30__length1 = rules_always_confirm_length1;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp31_ = i;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp32_ = r;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp33_ = _tmp32_.always_confirm;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp34_ = g_strdup (_tmp33_);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_g_free0 (_tmp30_[_tmp31_]);
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp30_[_tmp31_] = _tmp34_;
#line 265 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp35_ = _tmp30_[_tmp31_];
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp36_ = i;
#line 266 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								i = _tmp36_ + 1;
#line 262 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								rule_destroy (&r);
#line 3099 "moonshot-server-linux.c"
							}
						}
					}
				}
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp37_ = card;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp38_ = id_card_get_services (_tmp37_);
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp39_ = _tmp38_;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp41_ = _tmp40_;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp42_ = g_new0 (gchar*, _tmp41_ + 1);
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				svcs = _tmp42_;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				svcs_length1 = _tmp41_;
#line 276 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_svcs_size_ = svcs_length1;
#line 3122 "moonshot-server-linux.c"
				{
					gint i = 0;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					i = 0;
#line 3127 "moonshot-server-linux.c"
					{
						gboolean _tmp43_ = FALSE;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						_tmp43_ = TRUE;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
						while (TRUE) {
#line 3134 "moonshot-server-linux.c"
							gint _tmp45_ = 0;
							IdCard* _tmp46_ = NULL;
							GeeArrayList* _tmp47_ = NULL;
							GeeArrayList* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gchar** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp52_ = 0;
							IdCard* _tmp53_ = NULL;
							GeeArrayList* _tmp54_ = NULL;
							GeeArrayList* _tmp55_ = NULL;
							gint _tmp56_ = 0;
							gpointer _tmp57_ = NULL;
							gchar* _tmp58_ = NULL;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							if (!_tmp43_) {
#line 3152 "moonshot-server-linux.c"
								gint _tmp44_ = 0;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								_tmp44_ = i;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								i = _tmp44_ + 1;
#line 3158 "moonshot-server-linux.c"
							}
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp43_ = FALSE;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp45_ = i;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp46_ = card;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp47_ = id_card_get_services (_tmp46_);
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp48_ = _tmp47_;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp50_ = _tmp49_;
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							if (!(_tmp45_ < _tmp50_)) {
#line 277 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
								break;
#line 3178 "moonshot-server-linux.c"
							}
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp51_ = svcs;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp51__length1 = svcs_length1;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp52_ = i;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp53_ = card;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp54_ = id_card_get_services (_tmp53_);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp55_ = _tmp54_;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp56_ = i;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _tmp56_);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_g_free0 (_tmp51_[_tmp52_]);
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp51_[_tmp52_] = (gchar*) _tmp57_;
#line 278 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
							_tmp58_ = _tmp51_[_tmp52_];
#line 3202 "moonshot-server-linux.c"
						}
					}
				}
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp59_ = moonshot_server_logger;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp60_ = card;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp61_ = id_card_get_display_name (_tmp60_);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp62_ = _tmp61_;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp63_ = string_to_string (_tmp62_);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp64_ = g_strconcat ("install_from_file: Adding card with display name '", _tmp63_, "'", NULL);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp65_ = _tmp64_;
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				moonshot_logger_trace (_tmp59_, _tmp65_, NULL);
#line 281 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_g_free0 (_tmp65_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp66_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp67_ = id_card_get_display_name (_tmp66_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp68_ = _tmp67_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp69_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp70_ = id_card_get_username (_tmp69_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp71_ = _tmp70_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp72_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp73_ = id_card_get_password (_tmp72_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp74_ = _tmp73_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp75_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp76_ = id_card_get_issuer (_tmp75_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp77_ = _tmp76_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp78_ = rules_patterns;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp78__length1 = rules_patterns_length1;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp79_ = rules_always_confirm;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp79__length1 = rules_always_confirm_length1;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp80_ = svcs;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp80__length1 = svcs_length1;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp81_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp82_ = id_card_get_trust_anchor (_tmp81_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp83_ = _tmp82_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp84_ = trust_anchor_get_ca_cert (_tmp83_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp85_ = _tmp84_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp86_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp87_ = id_card_get_trust_anchor (_tmp86_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp88_ = _tmp87_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp89_ = trust_anchor_get_subject (_tmp88_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp90_ = _tmp89_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp91_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp92_ = id_card_get_trust_anchor (_tmp91_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp93_ = _tmp92_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp94_ = trust_anchor_get_subject_alt (_tmp93_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp95_ = _tmp94_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp96_ = card;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp97_ = id_card_get_trust_anchor (_tmp96_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp98_ = _tmp97_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp99_ = trust_anchor_get_server_cert (_tmp98_);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp100_ = _tmp99_;
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp101_ = moonshot_server_install_id_card (self, _tmp68_, _tmp71_, _tmp74_, _tmp77_, _tmp78_, _tmp78__length1, _tmp79_, _tmp79__length1, _tmp80_, _tmp80__length1, _tmp85_, _tmp90_, _tmp95_, _tmp100_, 0);
#line 282 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_result_ = _tmp101_;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_tmp102_ = _result_;
#line 294 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				if (_tmp102_) {
#line 3308 "moonshot-server-linux.c"
					gint _tmp103_ = 0;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					_tmp103_ = installed_cards;
#line 295 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
					installed_cards = _tmp103_ + 1;
#line 3314 "moonshot-server-linux.c"
				}
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				svcs = (_vala_array_free (svcs, svcs_length1, (GDestroyNotify) g_free), NULL);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
#line 252 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
				_g_object_unref0 (card);
#line 3324 "moonshot-server-linux.c"
			}
		}
	}
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = installed_cards;
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (webp);
#line 298 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 3334 "moonshot-server-linux.c"
}


static void moonshot_server_confirm_ca_certificate_data_free (gpointer _data) {
	MoonshotServerConfirmCaCertificateData* _data_;
	_data_ = _data;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->realm);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->ca_hash);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_slice_free (MoonshotServerConfirmCaCertificateData, _data_);
#line 3351 "moonshot-server-linux.c"
}


void moonshot_server_confirm_ca_certificate (MoonshotServer* self, const gchar* nai, const gchar* realm, const gchar* ca_hash, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MoonshotServerConfirmCaCertificateData* _data_;
	MoonshotServer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_slice_new0 (MoonshotServerConfirmCaCertificateData);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, moonshot_server_confirm_ca_certificate);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, moonshot_server_confirm_ca_certificate_data_free);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->self = _tmp0_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp1_ = nai;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->nai);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->nai = _tmp2_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp3_ = realm;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->realm);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->realm = _tmp4_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp5_ = ca_hash;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->ca_hash);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->ca_hash = _tmp6_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_confirm_ca_certificate_co (_data_);
#line 3400 "moonshot-server-linux.c"
}


gboolean moonshot_server_confirm_ca_certificate_finish (MoonshotServer* self, GAsyncResult* _res_, gint* confirmed) {
	gboolean result;
	MoonshotServerConfirmCaCertificateData* _data_;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (confirmed) {
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		*confirmed = _data_->confirmed;
#line 3413 "moonshot-server-linux.c"
	}
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	result = _data_->result;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return result;
#line 3419 "moonshot-server-linux.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return _data9_;
#line 3428 "moonshot-server-linux.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 3437 "moonshot-server-linux.c"
		MoonshotServer* self;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		self = _data9_->self;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_g_object_unref0 (self);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_slice_free (Block9Data, _data9_);
#line 3445 "moonshot-server-linux.c"
	}
}


static void __lambda22_ (Block9Data* _data9_, TrustAnchorConfirmationRequest* TrustAnchorConfirmationRequest) {
	MoonshotServer* self;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self = _data9_->self;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_return_if_fail (TrustAnchorConfirmationRequest != NULL);
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_confirm_ca_certificate_co (_data9_->_async_data_);
#line 3458 "moonshot-server-linux.c"
}


static void ___lambda22__trust_anchor_confirmation_callback (TrustAnchorConfirmationRequest* request, gpointer self) {
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	__lambda22_ (self, request);
#line 3465 "moonshot-server-linux.c"
}


static gboolean moonshot_server_confirm_ca_certificate_co (MoonshotServerConfirmCaCertificateData* _data_) {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	switch (_data_->_state_) {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 0:
#line 3474 "moonshot-server-linux.c"
		goto _state_0;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		case 1:
#line 3478 "moonshot-server-linux.c"
		goto _state_1;
		default:
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_assert_not_reached ();
#line 3483 "moonshot-server-linux.c"
	}
	_state_0:
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_ = g_slice_new0 (Block9Data);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_->_ref_count_ = 1;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_->self = g_object_ref (_data_->self);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_->_async_data_ = _data_;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp0_ = moonshot_server_logger;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp1_ = _data_->nai;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp2_ = string_to_string (_data_->_tmp1_);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp3_ = _data_->realm;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp5_ = _data_->ca_hash;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp7_ = g_strconcat ("MoonshotServer.confirm_ca_certificate: nai='", _data_->_tmp2_, "'; realm='", _data_->_tmp4_, "'; ca_hash='", _data_->_tmp6_, "'", NULL);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = NULL;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp0_, _data_->_tmp8_, NULL);
#line 306 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->_tmp8_);
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = NULL;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp9_ = _data_->self->priv->parent_app;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = NULL;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp10_ = _data_->nai;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = NULL;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp11_ = _data_->realm;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = NULL;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp12_ = _data_->ca_hash;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp13_ = NULL;
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp13_ = trust_anchor_confirmation_request_new (_data_->_tmp9_, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_);
#line 308 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->request = _data_->_tmp13_;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp14_ = NULL;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp14_ = _data_->request;
#line 309 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	trust_anchor_confirmation_request_set_callback (_data_->_tmp14_, ___lambda22__trust_anchor_confirmation_callback, block9_data_ref (_data_->_data9_), block9_data_unref);
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp15_ = NULL;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp15_ = _data_->request;
#line 310 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	trust_anchor_confirmation_request_execute (_data_->_tmp15_);
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_state_ = 1;
#line 311 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 3572 "moonshot-server-linux.c"
	_state_1:
	;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp17_ = NULL;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp17_ = _data_->request;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp18_ = FALSE;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp18_ = _data_->_tmp17_->confirmed;
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_tmp18_) {
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp16_ = 1;
#line 3587 "moonshot-server-linux.c"
	} else {
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		_data_->_tmp16_ = 0;
#line 3591 "moonshot-server-linux.c"
	}
#line 313 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->confirmed = _data_->_tmp16_;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp19_ = NULL;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp19_ = moonshot_server_logger;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp20_ = NULL;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp20_ = g_strdup_printf ("%i", _data_->confirmed);
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp21_ = NULL;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp22_ = NULL;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp22_ = g_strconcat ("MoonshotServer.confirm_ca_certificate: confirmed=", _data_->_tmp21_, NULL);
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp23_ = NULL;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_tmp23_ = _data_->_tmp22_;
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_logger_trace (_data_->_tmp19_, _data_->_tmp23_, NULL);
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->_tmp23_);
#line 314 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (_data_->_tmp21_);
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->result = TRUE;
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block9_data_unref (_data_->_data9_);
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_ = NULL;
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3633 "moonshot-server-linux.c"
	} else {
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3637 "moonshot-server-linux.c"
	}
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 315 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_object_unref0 (_data_->request);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	block9_data_unref (_data_->_data9_);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_data_->_data9_ = NULL;
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	if (_data_->_state_ == 0) {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3653 "moonshot-server-linux.c"
	} else {
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3657 "moonshot-server-linux.c"
	}
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_object_unref (_data_->_async_result);
#line 301 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	return FALSE;
#line 3663 "moonshot-server-linux.c"
}


static void moonshot_server_class_init (MoonshotServerClass * klass) {
	MoonshotLogger* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	g_type_class_add_private (klass, sizeof (MoonshotServerPrivate));
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	G_OBJECT_CLASS (klass)->finalize = moonshot_server_finalize;
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = get_logger ("MoonshotServer");
#line 38 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	moonshot_server_logger = _tmp0_;
#line 3679 "moonshot-server-linux.c"
}


static void moonshot_server_instance_init (MoonshotServer * self) {
	gchar* _tmp0_ = NULL;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self->priv = MOONSHOT_SERVER_GET_PRIVATE (self);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_tmp0_ = g_strdup ("Moonshot");
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self->priv->app_name = _tmp0_;
#line 3691 "moonshot-server-linux.c"
}


static void moonshot_server_finalize (GObject* obj) {
	MoonshotServer * self;
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOONSHOT_SERVER, MoonshotServer);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_g_free0 (self->priv->app_name);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	_identity_manager_app_unref0 (self->priv->parent_app);
#line 36 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-server-linux.vala"
	G_OBJECT_CLASS (moonshot_server_parent_class)->finalize (obj);
#line 3705 "moonshot-server-linux.c"
}


GType moonshot_server_get_type (void) {
	static volatile gsize moonshot_server_type_id__volatile = 0;
	if (g_once_init_enter (&moonshot_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MoonshotServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moonshot_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MoonshotServer), 0, (GInstanceInitFunc) moonshot_server_instance_init, NULL };
		GType moonshot_server_type_id;
		moonshot_server_type_id = g_type_register_static (G_TYPE_OBJECT, "MoonshotServer", &g_define_type_info, 0);
		g_type_set_qdata (moonshot_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) moonshot_server_register_object);
		g_once_init_leave (&moonshot_server_type_id__volatile, moonshot_server_type_id);
	}
	return moonshot_server_type_id__volatile;
}


static void _dbus_moonshot_server_show_ui (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = moonshot_server_show_ui (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_moonshot_server_get_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* nai = NULL;
	GVariant* _tmp3_;
	gchar* password = NULL;
	GVariant* _tmp4_;
	gchar* service = NULL;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	nai = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	service = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	moonshot_server_get_identity (self, nai, password, service, (GAsyncReadyCallback) _dbus_moonshot_server_get_identity_ready, invocation);
	_g_free0 (nai);
	_g_free0 (password);
	_g_free0 (service);
}


static void _dbus_moonshot_server_get_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* nai_out = NULL;
	gchar* password_out = NULL;
	gchar* server_certificate_hash = NULL;
	gchar* ca_certificate = NULL;
	gchar* subject_name_constraint = NULL;
	gchar* subject_alt_name_constraint = NULL;
	gboolean result;
	invocation = _user_data_;
	result = moonshot_server_get_identity_finish ((MoonshotServer*) source_object, _res_, &nai_out, &password_out, &server_certificate_hash, &ca_certificate, &subject_name_constraint, &subject_alt_name_constraint);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (nai_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (password_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (server_certificate_hash));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (ca_certificate));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_alt_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (nai_out);
	_g_free0 (password_out);
	_g_free0 (server_certificate_hash);
	_g_free0 (ca_certificate);
	_g_free0 (subject_name_constraint);
	_g_free0 (subject_alt_name_constraint);
}


static void _dbus_moonshot_server_get_default_identity (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	moonshot_server_get_default_identity (self, (GAsyncReadyCallback) _dbus_moonshot_server_get_default_identity_ready, invocation);
}


static void _dbus_moonshot_server_get_default_identity_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* nai_out = NULL;
	gchar* password_out = NULL;
	gchar* server_certificate_hash = NULL;
	gchar* ca_certificate = NULL;
	gchar* subject_name_constraint = NULL;
	gchar* subject_alt_name_constraint = NULL;
	gboolean result;
	invocation = _user_data_;
	result = moonshot_server_get_default_identity_finish ((MoonshotServer*) source_object, _res_, &nai_out, &password_out, &server_certificate_hash, &ca_certificate, &subject_name_constraint, &subject_alt_name_constraint);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (nai_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (password_out));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (server_certificate_hash));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (ca_certificate));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (subject_alt_name_constraint));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (nai_out);
	_g_free0 (password_out);
	_g_free0 (server_certificate_hash);
	_g_free0 (ca_certificate);
	_g_free0 (subject_name_constraint);
	_g_free0 (subject_alt_name_constraint);
}


static void _dbus_moonshot_server_install_id_card (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* display_name = NULL;
	GVariant* _tmp6_;
	gchar* user_name = NULL;
	GVariant* _tmp7_;
	gchar* password = NULL;
	GVariant* _tmp8_;
	gchar* realm = NULL;
	GVariant* _tmp9_;
	gchar** rules_patterns = NULL;
	int rules_patterns_length1 = 0;
	GVariant* _tmp10_;
	gchar** _tmp11_;
	int _tmp11__length;
	int _tmp11__size;
	int _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	gchar** rules_always_confirm = NULL;
	int rules_always_confirm_length1 = 0;
	GVariant* _tmp14_;
	gchar** _tmp15_;
	int _tmp15__length;
	int _tmp15__size;
	int _tmp15__length1;
	GVariantIter _tmp16_;
	GVariant* _tmp17_;
	gchar** services = NULL;
	int services_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	int _tmp19__length;
	int _tmp19__size;
	int _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	gchar* ca_cert = NULL;
	GVariant* _tmp22_;
	gchar* subject = NULL;
	GVariant* _tmp23_;
	gchar* subject_alt = NULL;
	GVariant* _tmp24_;
	gchar* server_cert = NULL;
	GVariant* _tmp25_;
	gint force_flat_file_store = 0;
	GVariant* _tmp26_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	display_name = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	user_name = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	password = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	realm = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_new (gchar*, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (gchar*, _tmp11_, _tmp11__size + 1);
		}
		_tmp11_[_tmp11__length++] = g_variant_dup_string (_tmp13_, NULL);
		g_variant_unref (_tmp13_);
	}
	rules_patterns_length1 = _tmp11__length1;
	_tmp11_[_tmp11__length] = NULL;
	rules_patterns = _tmp11_;
	g_variant_unref (_tmp10_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp15_ = g_new (gchar*, 5);
	_tmp15__length = 0;
	_tmp15__size = 4;
	_tmp15__length1 = 0;
	g_variant_iter_init (&_tmp16_, _tmp14_);
	for (; (_tmp17_ = g_variant_iter_next_value (&_tmp16_)) != NULL; _tmp15__length1++) {
		if (_tmp15__size == _tmp15__length) {
			_tmp15__size = 2 * _tmp15__size;
			_tmp15_ = g_renew (gchar*, _tmp15_, _tmp15__size + 1);
		}
		_tmp15_[_tmp15__length++] = g_variant_dup_string (_tmp17_, NULL);
		g_variant_unref (_tmp17_);
	}
	rules_always_confirm_length1 = _tmp15__length1;
	_tmp15_[_tmp15__length] = NULL;
	rules_always_confirm = _tmp15_;
	g_variant_unref (_tmp14_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	services_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	services = _tmp19_;
	g_variant_unref (_tmp18_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	ca_cert = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	subject = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	subject_alt = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	server_cert = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	force_flat_file_store = g_variant_get_int32 (_tmp26_);
	g_variant_unref (_tmp26_);
	result = moonshot_server_install_id_card (self, display_name, user_name, password, realm, rules_patterns, rules_patterns_length1, rules_always_confirm, rules_always_confirm_length1, services, services_length1, ca_cert, subject, subject_alt, server_cert, force_flat_file_store);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (display_name);
	_g_free0 (user_name);
	_g_free0 (password);
	_g_free0 (realm);
	rules_patterns = (_vala_array_free (rules_patterns, rules_patterns_length1, (GDestroyNotify) g_free), NULL);
	rules_always_confirm = (_vala_array_free (rules_always_confirm, rules_always_confirm_length1, (GDestroyNotify) g_free), NULL);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ca_cert);
	_g_free0 (subject);
	_g_free0 (subject_alt);
	_g_free0 (server_cert);
}


static void _dbus_moonshot_server_install_from_file (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* file_name = NULL;
	GVariant* _tmp27_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	file_name = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	result = moonshot_server_install_from_file (self, file_name);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (file_name);
}


static void _dbus_moonshot_server_confirm_ca_certificate (MoonshotServer* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* nai = NULL;
	GVariant* _tmp28_;
	gchar* realm = NULL;
	GVariant* _tmp29_;
	gchar* ca_hash = NULL;
	GVariant* _tmp30_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	nai = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	realm = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	ca_hash = g_variant_dup_string (_tmp30_, NULL);
	g_variant_unref (_tmp30_);
	moonshot_server_confirm_ca_certificate (self, nai, realm, ca_hash, (GAsyncReadyCallback) _dbus_moonshot_server_confirm_ca_certificate_ready, invocation);
	_g_free0 (nai);
	_g_free0 (realm);
	_g_free0 (ca_hash);
}


static void _dbus_moonshot_server_confirm_ca_certificate_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint confirmed = 0;
	gboolean result;
	invocation = _user_data_;
	result = moonshot_server_confirm_ca_certificate_finish ((MoonshotServer*) source_object, _res_, &confirmed);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (confirmed));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void moonshot_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowUi") == 0) {
		_dbus_moonshot_server_show_ui (object, parameters, invocation);
	} else if (strcmp (method_name, "GetIdentity") == 0) {
		_dbus_moonshot_server_get_identity (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDefaultIdentity") == 0) {
		_dbus_moonshot_server_get_default_identity (object, parameters, invocation);
	} else if (strcmp (method_name, "InstallIdCard") == 0) {
		_dbus_moonshot_server_install_id_card (object, parameters, invocation);
	} else if (strcmp (method_name, "InstallFromFile") == 0) {
		_dbus_moonshot_server_install_from_file (object, parameters, invocation);
	} else if (strcmp (method_name, "ConfirmCaCertificate") == 0) {
		_dbus_moonshot_server_confirm_ca_certificate (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* moonshot_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean moonshot_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint moonshot_server_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_moonshot_server_dbus_interface_info), &_moonshot_server_dbus_interface_vtable, data, _moonshot_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _moonshot_server_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



