gchar morla_rdfs[] ="<?xml version=\"1.0\"?>\n"
"\n"
"<!DOCTYPE rdf:RDF [\n"
"   <!ENTITY rdf   \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" >\n"
"   <!ENTITY rdfs  \"http://www.w3.org/2000/01/rdf-schema#\" >\n"
"   <!ENTITY dc    \"http://purl.org/dc/elements/1.1/\" >\n"
"   <!ENTITY foaf  \"http://xmlns.com/foaf/0.1/\" >\n"
"   <!ENTITY morla \"http://www.morlardf.net/morla#\" >\n"
"   <!ENTITY mc    \"http://www.morlardf.net/templates/category#\" >\n"
"]>\n"
"\n"
"<rdf:RDF\n"
"   xmlns:rdf=\"&rdf;\"\n"
"   xmlns:rdfs=\"&rdfs;\"\n"
"   xmlns:dc=\"&dc;\"\n"
"   xmlns:foaf=\"&foaf;\"\n"
"   xmlns:morla=\"&morla;\"\n"
">\n"
"\n"
"  <rdf:Description rdf:nodeID=\"me\">\n"
"    <foaf:name>Andrea Marchesini</foaf:name>\n"
"    <rdfs:seeAlso rdf:resource=\"http://www.autistici.org/bakunin/foaf.rdf\" />\n"
"    <rdf:type rdf:resource=\"&foaf;Person\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"tt_category\">\n"
"    <rdfs:label>Category</rdfs:label>\n"
"    <rdfs:comment>Set the category for this subject.</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Resource\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;category\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"tt_input\">\n"
"    <rdfs:label>Input</rdfs:label>\n"
"    <rdfs:comment>Set the inputs for this subject.</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&morla;input\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;hasInput\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"    <morla:maxCardinality>0</morla:maxCardinality>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_comment\">\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&rdfs;comment\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>yes</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:comment>set a comment a this subject</rdfs:comment>\n"
"    <morla:longText>yes</morla:longText>\n"
"    <rdfs:label>Comment</rdfs:label>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_default\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Default value</rdfs:label>\n"
"    <rdfs:comment>Set a default value for this input</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Resource\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;defaultValue\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_type\">\n"
"    <morla:defaultValue rdf:resource=\"&morla;Input\" />\n"
"    <morla:visible>no</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&rdf;type\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Resource\" />\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>empty_type</rdfs:label>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"tt_version\">\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;hasVersion\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Has Version</rdfs:label>\n"
"    <rdfs:comment>Set the version of this template</rdfs:comment>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_visible\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Visible</rdfs:label>\n"
"    <rdfs:comment>Is this input visible?</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_visible_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;visible\" />\n"
"    <morla:defaultValue>yes</morla:defaultValue>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_language\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Language</rdfs:label>\n"
"    <rdfs:comment>Does this input need of a language value?</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_language_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;language\" />\n"
"    <morla:defaultValue>yes</morla:defaultValue>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_long_text\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Long Text</rdfs:label>\n"
"    <rdfs:comment>Does this input have a long text?</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_long_text_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;longText\" />\n"
"    <morla:defaultValue>yes</morla:defaultValue>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_default_language\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Default Language</rdfs:label>\n"
"    <rdfs:comment>Insert a default language value</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;defaultLanguage\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_datatype\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Datatype</rdfs:label>\n"
"    <rdfs:comment>Does this input need of a datatype value?</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_datatype_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;datatype\" />\n"
"    <morla:defaultValue>yes</morla:defaultValue>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_default_datatype\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Default Language</rdfs:label>\n"
"    <rdfs:comment>Insert a default datatype value</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_detatype_default_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;defaultDatatype\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_detatype_default_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltResource\" />\n"
"    <rdf:_1 rdf:resource=\"http://www.w3.org/2001/XMLSchema#string\" />\n"
"    <rdf:_2 rdf:resource=\"http://www.w3.org/2001/XMLSchema#boolean\" />\n"
"    <rdf:_3 rdf:resource=\"http://www.w3.org/2001/XMLSchema#decimal\" />\n"
"    <rdf:_4 rdf:resource=\"http://www.w3.org/2001/XMLSchema#float\" />\n"
"    <rdf:_5 rdf:resource=\"http://www.w3.org/2001/XMLSchema#double\" />\n"
"    <rdf:_6 rdf:resource=\"http://www.w3.org/2001/XMLSchema#duration\" />\n"
"    <rdf:_7 rdf:resource=\"http://www.w3.org/2001/XMLSchema#dateTime\"/>\n"
"    <rdf:_8 rdf:resource=\"http://www.w3.org/2001/XMLSchema#time\" />\n"
"    <rdf:_9 rdf:resource=\"http://www.w3.org/2001/XMLSchema#date\" />\n"
"    <rdf:_10 rdf:resource=\"http://www.w3.org/2001/XMLSchema#gYearMonth\" />\n"
"    <rdf:_11 rdf:resource=\"http://www.w3.org/2001/XMLSchema#gYear\" />\n"
"    <rdf:_12 rdf:resource=\"http://www.w3.org/2001/XMLSchema#gMonthDay\" />\n"
"    <rdf:_13 rdf:resource=\"http://www.w3.org/2001/XMLSchema#gDay\" />\n"
"    <rdf:_14 rdf:resource=\"http://www.w3.org/2001/XMLSchema#gMonth\" />\n"
"    <rdf:_15 rdf:resource=\"http://www.w3.org/2001/XMLSchema#hexBinary\" />\n"
"    <rdf:_16 rdf:resource=\"http://www.w3.org/2001/XMLSchema#base64Binary\" />\n"
"    <rdf:_17 rdf:resource=\"http://www.w3.org/2001/XMLSchema#anyURI\" />\n"
"    <rdf:_18 rdf:resource=\"http://www.w3.org/2001/XMLSchema#QName\" />\n"
"    <rdf:_19 rdf:resource=\"http://www.w3.org/2001/XMLSchema#NOTATION\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_rdfs\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>RDFS</rdfs:label>\n"
"    <rdfs:comment>The RDFS for this input</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Resource\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;hasRDFS\" />\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_typevalue\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Type Value</rdfs:label>\n"
"    <rdfs:comment>The type of values for this input</rdfs:comment>\n"
"    <morla:typeValue rdf:nodeID=\"ti_typevalue_list\" />\n"
"    <morla:hasRDFS rdf:resource=\"&morla;typeValue\" />\n"
"    <morla:defaultValue rdf:resource=\"&rdfs;Resource\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_typevalue_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltResource\" />\n"
"    <rdf:_1 rdf:resource=\"&rdfs;Resource\" />\n"
"    <rdf:_2 rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_mincardinality\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Minimum Cardinality</rdfs:label>\n"
"    <morla:defaultValue>0</morla:defaultValue>\n"
"    <rdfs:comment>Minimum Cardinality value for this subject</rdfs:comment>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;minCardinality\" />\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_maxcardinality\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Maximum Cardinality</rdfs:label>\n"
"    <rdfs:comment>Maximum Cardinality value for this subject (0 for infinite)</rdfs:comment>\n"
"    <morla:defaultValue>1</morla:defaultValue>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;maxCardinality\" />\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_label\">\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&rdfs;label\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>yes</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Label</rdfs:label>\n"
"    <rdfs:comment>Set the label for this subject.</rdfs:comment>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_function_init\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;functionInput\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <rdfs:label>Function Init</rdfs:label>\n"
"    <rdfs:comment>The javascript code for the initialize procedure.</rdfs:comment>\n"
"    <morla:longText>yes</morla:longText>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_function_check\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;functionCheck\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <rdfs:label>Function Check</rdfs:label>\n"
"    <rdfs:comment>The javascript code for the checking procedure.</rdfs:comment>\n"
"    <morla:longText>yes</morla:longText>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_function_destroy\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;functionDestroy\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <rdfs:label>Function Destroy</rdfs:label>\n"
"    <rdfs:comment>The javascript code for the destroy procedure.</rdfs:comment>\n"
"    <morla:longText>yes</morla:longText>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_function_save\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <morla:visible>yes</morla:visible>\n"
"    <morla:hasRDFS rdf:resource=\"&morla;functionSave\" />\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <rdfs:label>Function Save</rdfs:label>\n"
"    <rdfs:comment>The javascript code for the saving procedure.</rdfs:comment>\n"
"    <morla:longText>yes</morla:longText>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"tt_name\">\n"
"    <rdfs:label>Name</rdfs:label>\n"
"    <rdfs:comment>Name of this template</rdfs:comment>\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Literal\" />\n"
"    <morla:language>no</morla:language>\n"
"    <morla:datatype>no</morla:datatype>\n"
"    <morla:hasRDFS rdf:resource=\"&rdfs;label\" />\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_visible_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltLiteral\" />\n"
"    <rdf:_1>yes</rdf:_1>\n"
"    <rdf:_2>no</rdf:_2>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_long_text_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltLiteral\" />\n"
"    <rdf:_1>yes</rdf:_1>\n"
"    <rdf:_2>no</rdf:_2>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_language_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltLiteral\" />\n"
"    <rdf:_1>yes</rdf:_1>\n"
"    <rdf:_2>no</rdf:_2>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"ti_datatype_list\">\n"
"    <rdf:type rdf:resource=\"&morla;AltLiteral\" />\n"
"    <rdf:_1>yes</rdf:_1>\n"
"    <rdf:_2>no</rdf:_2>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:nodeID=\"tt_type\">\n"
"    <rdf:type rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:label>Empty widget for rdf:type</rdfs:label>\n"
"    <morla:typeValue rdf:resource=\"&rdfs;Resource\" />\n"
"    <morla:hasRDFS rdf:resource=\"&rdf;type\" />\n"
"    <morla:defaultValue rdf:resource=\"&morla;Template\" />\n"
"    <morla:visible>no</morla:visible>\n"
"    <morla:minCardinality>1</morla:minCardinality>\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;\">\n"
"    <dc:creator>Andrea Marchesini</dc:creator>\n"
"    <dc:rights>Copyright © 2005-2007 Andrea Marchesini</dc:rights>\n"
"    <dc:title>Model for template of morla</dc:title>\n"
"    <dc:format>application/dc+xml</dc:format>\n"
"    <foaf:maker rdf:nodeID=\"me\" />\n"
"    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Ontology\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;AltLiteral\">\n"
"    <rdfs:label>A list of alternative literals</rdfs:label>\n"
"    <rdfs:comment>List of Alternative Literals.</rdfs:comment>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdf:type rdf:resource=\"&rdfs;Class\" />\n"
"    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Class\" />\n"
"    <rdfs:subClassOf rdf:resource=\"&rdf;Property\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;AltResource\">\n"
"    <rdfs:label>A list of alternative resources</rdfs:label>\n"
"    <rdfs:comment>List of Alternative Resources.</rdfs:comment>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdf:type rdf:resource=\"&rdfs;Class\" />\n"
"    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Class\" />\n"
"    <rdfs:subClassOf rdf:resource=\"&rdf;Property\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;category\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The category of this template</rdfs:comment>\n"
"    <rdfs:label>Category</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Template\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Resource\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;defaultValue\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:comment>Default value for this property</rdfs:comment>\n"
"    <rdfs:label>Default Value</rdfs:label>\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;hasInput\">\n"
"    <rdfs:label>Has Input</rdfs:label>\n"
"    <rdfs:comment>Set a input for this template.</rdfs:comment>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:range rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Template\" />\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;hasRDFS\">\n"
"    <rdfs:comment>Set this RDFS for the subject resource.</rdfs:comment>\n"
"    <rdfs:label>Has RDFS</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Resource\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;hasVersion\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The version of this template</rdfs:comment>\n"
"    <rdfs:label>Has Version</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Template\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;Input\">\n"
"    <rdfs:comment>An input for the subject resource.</rdfs:comment>\n"
"    <rdfs:label>Input</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdf:type rdf:resource=\"&rdfs;Class\" />\n"
"    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Class\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;minCardinality\">\n"
"    <rdfs:comment>Minimum Cardinality value for this subject resource?</rdfs:comment>\n"
"    <rdfs:label>Minimum Cardinality</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;maxCardinality\">\n"
"    <rdfs:comment>Maximum Cardinality value for this subject resource?</rdfs:comment>\n"
"    <rdfs:label>Maximum Cardinality</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;Template\">\n"
"    <rdfs:label>Template</rdfs:label>\n"
"    <rdfs:comment>The template.</rdfs:comment>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdf:type rdf:resource=\"&rdfs;Class\" />\n"
"    <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Class\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;typeValue\">\n"
"    <rdfs:label>Type Value</rdfs:label>\n"
"    <rdfs:comment>Type of this input.</rdfs:comment>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;visible\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>Is this resource visible? (yes or no)</rdfs:comment>\n"
"    <rdfs:label>Visible</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;language\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>Does this literal input need a language? (yes or no)</rdfs:comment>\n"
"    <rdfs:label>Language</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;datatype\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>Does this literal input need a datatype? (yes or no)</rdfs:comment>\n"
"    <rdfs:label>Datatype</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;defaultDatatype\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The default datatype for this input</rdfs:comment>\n"
"    <rdfs:label>Default Datatype</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Resource\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;defaultLanguage\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The default language for this input</rdfs:comment>\n"
"    <rdfs:label>Default Language</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;functionInit\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The javascript code for the init procedure</rdfs:comment>\n"
"    <rdfs:label>Function Init</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;functionCheck\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The javascript code for the checking procedure</rdfs:comment>\n"
"    <rdfs:label>Function Check</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;functionDestroy\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The javascript code for the destroy procedure</rdfs:comment>\n"
"    <rdfs:label>Function Destroy</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;functionSave\">\n"
"    <rdf:type rdf:resource=\"&rdf;Property\" />\n"
"    <rdfs:comment>The javascript code for the saving procedure</rdfs:comment>\n"
"    <rdfs:label>Function Save</rdfs:label>\n"
"    <rdfs:isDefinedBy rdf:resource=\"&morla;\" />\n"
"    <rdfs:domain rdf:resource=\"&morla;Input\" />\n"
"    <rdfs:range rdf:resource=\"&rdfs;Literal\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;input\">\n"
"    <rdf:type rdf:resource=\"&morla;Template\" />\n"
"    <rdfs:label>Template for inputs</rdfs:label>\n"
"    <morla:hasVersion>0.7</morla:hasVersion>\n"
"    <morla:category rdf:resource=\"&mc;templates\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_label\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_comment\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_language\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_default_language\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_datatype\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_default_datatype\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_visible\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_rdfs\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_mincardinality\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_maxcardinality\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_type\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_typevalue\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_default\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_long_text\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_function_init\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_function_check\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_function_destroy\" />\n"
"    <morla:hasInput rdf:nodeID=\"ti_function_save\" />\n"
"  </rdf:Description>\n"
"\n"
"  <rdf:Description rdf:about=\"&morla;template\">\n"
"    <rdf:type rdf:resource=\"&morla;Template\" />\n"
"    <rdfs:label>Template for templates</rdfs:label>\n"
"    <morla:category rdf:resource=\"&mc;templates\" />\n"
"    <morla:hasVersion>0.7</morla:hasVersion>\n"
"    <morla:hasInput rdf:nodeID=\"tt_type\" />\n"
"    <morla:hasInput rdf:nodeID=\"tt_version\" />\n"
"    <morla:hasInput rdf:nodeID=\"tt_name\" />\n"
"    <morla:hasInput rdf:nodeID=\"tt_category\" />\n"
"    <morla:hasInput rdf:nodeID=\"tt_input\" />\n"
"  </rdf:Description>\n"
"\n"
"</rdf:RDF>\n"
"\n"
;
