/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization.test;

import com.sourceforge.knecs.dsm.authorization.DSIAuthService;
import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.CMCSProperties;
import org.apache.webdav.lib.Privilege;

public class TestIsAuthorized {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: TestIsAuthorized <priv> <url> <userID>");
            System.exit(-1);
        }
        String priv = args[0];
        String url = args[1];
        String userID = args[2];
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String serverURL = (String)props.get("samserver");
        if (!url.startsWith("http://")) {
            url = serverURL + url;
        }
        DialogAuthListener dal = new DialogAuthListener();
        DSI dsi = new DSI(url, dal);
        DSIAuthService authService = new DSIAuthService(dsi);
        Privilege privilege = null;
        if (priv.startsWith("read-acl")) {
            privilege = Privilege.READ_ACL;
        } else if (priv.startsWith("read")) {
            privilege = Privilege.READ;
        } else if (priv.startsWith("write-acl")) {
            privilege = Privilege.WRITE_ACL;
        } else if (priv.startsWith("w")) {
            privilege = Privilege.WRITE;
        } else if (priv.startsWith("a")) {
            privilege = Privilege.ALL;
        } else {
            System.out.println("UNRECOGNIZABLE PRIVILEGE: " + privilege);
            return;
        }
        try {
            System.out.println("-----------------");
            System.out.println("checking authorization ");
            System.out.println("-----------------");
            boolean isAuth = authService.isAuthorized(privilege, url, userID);
            if (isAuth) {
                System.out.println("Authorized!");
            } else {
                System.out.println("Not Authorized!");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        System.out.println("-----------------");
        System.out.println("Finished");
        System.out.println("-----------------");
        System.exit(0);
    }
}

