# Copyright (c) 2011,  Percona Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to the
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston
# MA  02110-1301  USA.

%define src_dir percona-xtradb-cluster-galera
%define docs /usr/share/doc/%{src_dir}

%define rhelver %(rpm -qf --qf '%%{version}\\n' /etc/redhat-release | sed -e 's/^\\([0-9]*\\).*/\\1/g')
%if "%rhelver" == "5"
 %define boost_req boost141-devel
 %define gcc_req gcc44-c++
%else
 %define boost_req boost-devel
 %define gcc_req gcc-c++
%endif

%if %{undefined scons_args}
 %define scons_args %{nil}
%endif

%if %{undefined galera_revision}
 %define galera_revision %{revision}
%endif

%if %{undefined galera_mflags}
 %define galera_mflags 8
%endif

%if %{undefined pxcg_revision}
 %define pxcg_revision %{revno}
%endif

%ifarch i686
 %define scons_arch arch=i686
%else
 %define scons_arch %{nil}
%endif

%define redhatversion %(lsb_release -rs | awk -F. '{ print $1}')
%define distribution  rhel%{redhatversion}

Name:		Percona-XtraDB-Cluster-galera-2
Version:	2.8
Release:	1.%{pxcg_revision}.%{?distribution}
Summary:	Galera components of Percona XtraDB Cluster

Group:		Applications/Databases
License:	GPLv3
URL:		http://www.percona.com/
Source0:        percona-xtradb-cluster-galera.tar.gz
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
Prefix: %{_prefix}
Provides: Percona-XtraDB-Cluster-galera-25
Obsoletes: Percona-XtraDB-Cluster-galera
BuildRequires:	scons check-devel glibc-devel %{gcc_req} openssl-devel %{boost_req} check-devel

%description
This package contains the Galera components required by Percona XtraDB Cluster.

%prep
%setup -q -n %{src_dir}

%build
%if "%rhelver" == "5"
export CXX=g++44
%endif
export GALERA_REV=%{galera_revision}
export GALERA_VER=2.8
scons -j%{galera_mflags} revno=%{galera_revision} boost_pool=0 garb/garbd libgalera_smm.so %{scons_arch} %{scons_args}

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p "$RPM_BUILD_ROOT"

install -d $RPM_BUILD_ROOT%{_sysconfdir}/{init.d,sysconfig}
install -m 644 $RPM_BUILD_DIR/%{src_dir}/garb/files/garb.cnf \
    $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/garb
install -m 755 $RPM_BUILD_DIR/%{src_dir}/garb/files/garb.sh \
    $RPM_BUILD_ROOT%{_sysconfdir}/init.d/garb

install -d "$RPM_BUILD_ROOT/%{_bindir}"
install -d "$RPM_BUILD_ROOT/%{_libdir}"
install -m 755 "$RPM_BUILD_DIR/%{src_dir}/garb/garbd" \
	"$RPM_BUILD_ROOT/%{_bindir}/"
install -m 755 "$RPM_BUILD_DIR/%{src_dir}/libgalera_smm.so" \
	"$RPM_BUILD_ROOT/%{_libdir}/"

install -d $RPM_BUILD_ROOT%{docs}
install -m 644 $RPM_BUILD_DIR/%{src_dir}/COPYING                     \
    $RPM_BUILD_ROOT%{docs}/COPYING
install -m 644 $RPM_BUILD_DIR/%{src_dir}/scripts/packages/README     \
    $RPM_BUILD_ROOT%{docs}/README
install -m 644 $RPM_BUILD_DIR/%{src_dir}/scripts/packages/README-MySQL \
    $RPM_BUILD_ROOT%{docs}/README-MySQL

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config(noreplace,missingok) %{_sysconfdir}/sysconfig/garb
%attr(0755,root,root) %{_sysconfdir}/init.d/garb

%attr(0755,root,root) %{_bindir}/garbd
%attr(0755,root,root) %{_libdir}/libgalera_smm.so

%attr(0755,root,root) %dir %{docs}
%doc %attr(0644,root,root) %{docs}/COPYING
%doc %attr(0644,root,root) %{docs}/README
%doc %attr(0644,root,root) %{docs}/README-MySQL

%changelog
