#include "rxfunctions.h"
#include "qsstvglobal.h"
#include "configparams.h"
#include "rxwidget.h"
#include "sound/soundio.h"
#include "dsp/filterparam.h"
#include "dsp/filter.h"
#include "dsp/downsamplefilter.h"
#ifndef QT_NO_DEBUG
#include "scope/scopeview.h"
#include "scope/scopeoffset.h"
#endif
#include "configparams.h"
#include "utils/supportfunctions.h"
#include "dispatcher.h"
#include "sstv/modes/modes.h"

#include "drmrx/drm.h"
#include "drmrx/drmproto.h"
#include "drmrx/demodulator.h"

#define DRMNEW

const QString stateStr[rxFunctions::WAIT+1]=
{
  "Hunting",
  "SlantAdjust",
  "Processing",
  "Restart",
  "Sync Lost",
  "End",
  "Wait"
};

rxFunctions::rxFunctions(QObject *parent) :
  QThread(parent)
{
  rxState=RXIDLE;
  downSampleFilter=NULL;
  rxFilter=NULL;
  syncFilter=NULL;
  dataInputPtr=new drmDataInput(RXSTRIPE);
  currentMode=0;

#ifndef QT_NO_DEBUG
  scopeViewerData->setCurveName("Volume",SCDATA1);
  scopeViewerData->setCurveName("FM Demod",SCDATA2);
  scopeViewerData->setCurveName("raw Input",SCDATA3);
  scopeViewerData->setCurveName("none",SCDATA4);
  scopeViewerData->setAxisTitles("Samples","int","demod");
#endif
  demodulatorPtr=new demodulator;

}

rxFunctions::~rxFunctions()
{
  if(downSampleFilter==NULL) delete downSampleFilter;
  if(rxFilter==NULL) delete rxFilter;
  if(syncFilter==NULL) delete syncFilter;
}


void rxFunctions::run()
{
  addToLog("starting rxfunctions run",LOGRXFUNC);
  int count;
  bool done=false;
  init();
  addToLog("end init rxfunctions run",LOGRXFUNC);
  abort=false;
  while(!abort)
    {
      switch(rxState)
        {
        case RXIDLE:
          msleep(200);
        break;
        case RXRUNNING:
          if((count=soundIOPtr->rxBuffer.count())<SAMPLINGSTRIPE)
            {
              msleep((250*RXSTRIPE)/rxClock);
              if(!soundIOPtr->isCapturing())
                {
                  rxState=RXINIT;
                }
            }
          else
            {
              //              addToLog(QString("LoadTempBuf count=%1").arg(count),LOGRXFUNC);
              soundIOPtr->rxBuffer.copyNoCheck(tempBuf,SAMPLINGSTRIPE);
              //              addToLog("LoadTempBuf",LOGRXFUNC);
              downSampleFilter->downSample4(tempBuf);
              displayFFTEvent* ce = new displayFFTEvent(downSampleFilter->filteredDataPtr());
              ce->waitFor(&done);
              QApplication::postEvent(dispatcherPtr, ce);
              while(!done) {usleep(10);}

              switch (transmissionModeIndex)
                {
                case DRM:
                  runDRM();
                break;
                case SSTV:
                  rxHoldingBuffer.putNoCheck(downSampleFilter->filteredDataPtr(),RXSTRIPE);
                  bufferCounter++;
                  getData();
                  processSSTV();
                  sampleCounter+=RXSTRIPE;
                  rxHoldingBuffer.skip(RXSTRIPE);
                  demodBuffer.skip(RXSTRIPE);
                break;
                  //                case FAX:
                  //                break;
                case NOMODE:
                break;
                }
            }
        break;
        case RXINIT:
          if(transmissionModeIndex==SSTV) syncProc.init(); //reset meters
          rxState=RXIDLE;
        break;

        }
    }
  abort=false;
}

void rxFunctions::init()
{
  //  rxMode=rxModeIndex;
  setFilters(rxWidgetPtr->getFilterIndex()); // setup SSTV Filters
  avgSNR=0;
  if(transmissionModeIndex==DRM)
    {
      n = DRMBUFSIZE;
      /* initialisations */
      demodulatorPtr->init();
      dataInputPtr->init(RXSTRIPE);
      initGetmode( n / 4);
      rRation = 1.000;
      samplerate_offset_estimation = 0.0;
      runstate = RUN_STATE_POWER_ON;		/* POWER_ON */
      channel_decoding();
      runstate = RUN_STATE_INIT;		/* INIT */
      channel_decoding();
      runstate = RUN_STATE_FIRST;			/* FIRSTRUN */
      runstate = RUN_STATE_NORMAL;			/* NORMAL RUN */
    }
  else
    {
      SSTVState=HUNTING;
      syncProc.init();
    }
  if(downSampleFilter==NULL)  downSampleFilter=new downsampleFilter(SAMPLINGSTRIPE,downSampleFilterParam,DSAMPLEFILTERLEN,false);
  else downSampleFilter->init();
  sampleCounter=0;
  bufferCounter=0;
  rxHoldingBuffer.reset();
}

void rxFunctions::getData()
{
  //  addToLog(QString("GetData readIndex: %1,sampleCounter: %2").arg(rxHoldingBuffer.getReadIndex()).arg(sampleCounter),LOGRXFUNC);
  rxFilter->processFM(rxHoldingBuffer.readPointer());
  demodBuffer.putNoCheck(rxFilter->filteredDataPtr(),RXSTRIPE);
  syncFilter->processFM(rxHoldingBuffer.readPointer());
  syncProc.process();
  displaySyncEvent* ce;
  ce = new displaySyncEvent(syncProc.syncQuality,(rxFilter->volumePtr()[0]-500)/500);
  QApplication::postEvent(dispatcherPtr, ce);




  //  addToLog("EndFilter",LOGPERFORM);

#ifndef QT_NO_DEBUG
  scopeViewerData->addData(SCDATA3,rxHoldingBuffer.readPointer(),sampleCounter,RXSTRIPE);
  scopeViewerData->addData(SCDATA2,demodBuffer.readPointer(),sampleCounter,RXSTRIPE);
  scopeViewerData->addData(SCDATA1,rxFilter->volumePtr(),sampleCounter,RXSTRIPE);
#endif

}

#ifndef QT_NO_DEBUG

unsigned int rxFunctions::setOffset(unsigned int offset,bool ask)
{
  if(ask)
    {
      scopeOffset so;
      so.setOffset(offset);
      if(so.exec()==QDialog::Accepted)
        {
          xOffset=so.getOffset()*1000;
        }
    }
  else
    {
      xOffset=offset*1000;
    }
  syncProc.setOffset(xOffset);
  scopeViewerData->setOffset(xOffset);
  syncProc.setOffset(xOffset);
  return xOffset/1000;
}
#endif

void rxFunctions::processSSTV()
{
  rxSSTVStatusEvent *stce;
  endImageRXEvent *endce;
  bool done=false;
  int block;
  unsigned long sampleCounterLatch;
  switch(SSTVState)
    {
    case HUNTING:
      if(syncProc.isInSync()==0)
        {
          stce= new rxSSTVStatusEvent(QString("No sync"));
          QApplication::postEvent( dispatcherPtr, stce );  // Qt will delete it when done
          break; // no sync
        }
      if(!create(syncProc.getMode(),syncProc.getNewClock())) break;
      stce= new rxSSTVStatusEvent(QString("Receiving ")+getSSTVModeNameLong(syncProc.getMode()));
      lastUsedMode=getSSTVModeNameShort(syncProc.getMode());
      QApplication::postEvent( dispatcherPtr, stce );  // Qt will delete it when done
    case SLANTADJUST:
      syncPosition=syncProc.getSyncPosition();
      if(syncProc.isInSync()==1)
        {
          syncPosition=currentMode->adjustSyncPosition(syncPosition); // only execute if no retrace
          addToLog(QString("rxFunctions: adjusted syncPosition= %1").arg(syncPosition),LOGRXFUNC);
        }
      sampleCounterLatch=sampleCounter; //remember where we've got
      addToLog(QString("rxFunctions: sampleCounterLatch= %1").arg(sampleCounterLatch),LOGRXFUNC);
      block=(syncPosition)/RXSTRIPE;
      demodBuffer.rewind(sampleCounter-block*RXSTRIPE);
      addToLog(QString("sc_rewind: block=%1,rewind= %2").arg(block).arg(sampleCounter-block*RXSTRIPE+RXSTRIPE),LOGRXFUNC);
      sampleCounter=block*RXSTRIPE;
      currentMode->setRxSampleCounter(sampleCounter);
      currentMode->redrawFast(true);
      currentMode->process(demodBuffer.readPointer(),syncPosition-sampleCounter,true);
      addToLog(QString("rxFunctions: currentMode pos:=%1").arg(syncPosition-sampleCounter),LOGRXFUNC);
      //      addToLog(QString("after Current mode set: %1,sampleCounter: %2").arg(rxHoldingBuffer.getReadIndex()).arg(sampleCounter),LOGRXFUNC);
      while(sampleCounter<sampleCounterLatch)
        {
          demodBuffer.skip(RXSTRIPE);
          sampleCounter+=RXSTRIPE;
          //          addToLog(QString("loop readIndex: %1,sampleCounter: %2").arg(rxHoldingBuffer.getReadIndex()).arg(sampleCounter),LOGRXFUNC);
          currentMode->process(demodBuffer.readPointer());
        }
      addToLog(QString("end loop readIndex: %1,sampleCounter: %2").arg(rxHoldingBuffer.getReadIndex()).arg(sampleCounter),LOGRXFUNC);
      currentMode->redrawFast(false);
      setState(PROCESSING);

    break;
    case PROCESSING:

      if(currentMode->process(demodBuffer.readPointer())==modeBase::MBENDOFIMAGE)
        {
          setState(END);
        }
      if(syncProc.hasRetrace())
        {
          setState(END);
        }
      if(syncProc.isInSync()==0)
        {
          setState(END);
        }
      else if(syncProc.hasNewClock())
        {
          currentMode->init(syncProc.getNewClock());
          setState(SLANTADJUST);
        }

    break;
    case RESTART:
      block=(int) ceil((rxClock*0.3)/RXSTRIPE)+1; // rewind to position before the last detected retrace, + one because we will skip 1 on return of getData()
      addToLog(QString("rxFunction: retraceVertical: count=%1").arg(block*RXSTRIPE),LOGRXFUNC);
      rxHoldingBuffer.rewind(block*RXSTRIPE);
      init();
      sampleCounter=-RXSTRIPE; // will be incremented (will be 0) when returning from this function
    break;
    case SYNCLOST:
        addToLog(QString("rxFunction: synclost"),LOGRXFUNC);
    case END:
      addToLog("rxFunc state END",LOGRXFUNC);
      endce = new endImageRXEvent();
      endce->waitFor(&done);
      QApplication::postEvent(dispatcherPtr, endce);
      while(!done) { msleep(10);}
      setState(RESTART);
    break;
    case WAIT:

    break;
    }
}

void rxFunctions::setFilters(int fIndex)
{
  if(rxFilter==NULL) rxFilter= new filter(RXSTRIPE,filterStruct[fIndex].filterPtr,RXNUMTAPS,filterStruct[fIndex].centerFrequency,rxClock/SUBSAMPLINGRATIO,true,0.001);
  else rxFilter->setFilterParams(filterStruct[fIndex].filterPtr,RXNUMTAPS,filterStruct[fIndex].centerFrequency,rxClock/SUBSAMPLINGRATIO,true,0.001);
  if(syncFilter==NULL) syncFilter= new filter(RXSTRIPE,wide1200BP,RXNUMTAPS,1200,rxClock/SUBSAMPLINGRATIO,true,1);
  syncProc.setFilters(rxFilter,syncFilter);
}

void rxFunctions::stopAndWait()
{

  if(!isRunning()) return;
  rxState=RXINIT;
  while(rxState!=RXIDLE)
    {
      if(!isRunning()) return; // to avoid race conditions
      qApp->processEvents();
    }
}

bool  rxFunctions::create(esstvMode m,DSPFLOAT clock)
{
  bool done=false;
  if(currentMode) delete currentMode;
  currentMode=0;
  switch (m)
    {
    case M1:
    case M2:
      currentMode=new modeGBR(m,RXSTRIPE,false);
    break;
    case S1:
    case S2:
    case SDX:
      currentMode=new modeGBR2(m,RXSTRIPE,false);
    break;
    case R36:
      currentMode=new modeRobot1(m,RXSTRIPE,false);
    break;
    case R24:
    case R72:
      currentMode=new modeRobot2(m,RXSTRIPE,false);
    break;
    case SC2_60:
    case SC2_120:
    case SC2_180:
    case P3:
    case P5:
    case P7:
      currentMode=new modeRGB(m,RXSTRIPE,false);
    break;
    case FAX480:
    case BW8:
    case BW12:
      currentMode=new modeBW(m,RXSTRIPE,false);
    break;
    case AVT24:
    case AVT90:
    case AVT94:
      currentMode=new modeAVT(m,RXSTRIPE,false);
    break;
    case PD50:
    case PD90:
    case PD120:
    case PD160:
    case PD180:
    case PD240:
    case PD290:
    case MP73:
    case MP115:
    case MP140:
    case MP175:
      currentMode=new modePD(m,RXSTRIPE,false);
    break;
    default:
      m=NOTVALID;
    break;
    }
  if (m!=NOTVALID)
    {
      initializeSSTVParametersIndex(m,false);
      QString s=getSSTVModeNameLong(m);
      addToLog("rxFunction:create RX mode",LOGRXFUNC);
      currentMode->init(clock);
      startImageRXEvent* ce = new startImageRXEvent(QSize(currentMode->imagePixels(),currentMode->imageLines()));
      ce->waitFor(&done);
      QApplication::postEvent(dispatcherPtr, ce);
      while(!done) { msleep(10);}
      return true;
    }
  return false;
}

void rxFunctions::startRX()
{
  init();
  rxState=RXRUNNING;
}

void rxFunctions::setState(eSSTVState st)
{
  addToLog(QString("rxfunc: set SSTVState: from %1 to %2").arg(stateStr[SSTVState]).arg (stateStr[st]),LOGRXFUNC);
  SSTVState=st;

}

void rxFunctions::retraceVertical(void)
{
  setState(RESTART);
}

bool rxFunctions::saveOK()
{
  if(currentMode==0)
    {
      addToLog("saveOK called with currentMode==0",LOGRXFUNC);
      return false;
    }

  if(currentMode->receivedLines()>(currentMode->imageLines()/3)) return true;
  return false;
}

#define RATIONAVG 0.01
void rxFunctions::runDRM()
{
  bool done=false;
  DSPFLOAT temp;

  displayDRMStatEvent *ce1;
  displayDRMInfoEvent *ce2 ;
  temp=WMERFAC;
  if(temp<0) temp=0;
  if(demodulatorPtr->isFrameSync())
    {
      avgSNR=(1-0.05)*avgSNR+0.05*temp;
      ce1 = new displayDRMStatEvent(avgSNR,downSampleFilter->avgVolume);
    }
  else
    {
      ce1 = new displayDRMStatEvent(0,downSampleFilter->avgVolume);
    }
  QApplication::postEvent(dispatcherPtr, ce1);

  while(input_samples_buffer_request ==0)
    {
      demodulatorPtr->demodulate(resamp_signal,0);
    }
  im=0;
  im=dataInputPtr->getData(downSampleFilter->filteredDataPtr(),resamp_signal,rRation);
  //  arrayDump("resam",resamp_signal,RXSTRIPE,true);
  if(im==0)
    {
      msleep(10);
      return;
    }
  demodulatorPtr->demodulate(resamp_signal,im);
  ce2 = new displayDRMInfoEvent;
  ce2->waitFor(&done);
  QApplication::postEvent(dispatcherPtr, ce2);
  while(!done) { usleep(10);}
}
