% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progenySuppFunc.r
\name{progenyScatter}
\alias{progenyScatter}
\title{Calculate Progeny Scores with Permutations}
\usage{
progenyScatter(
  df,
  weight_matrix,
  dfID = 1,
  weightID = 1,
  statName = "gene stats",
  verbose = FALSE
)
}
\arguments{
\item{df}{an n*m data frame, where n is the number of omic features (genes). 
m isn't really important, as long as at least one column corresponds to a 
sample or contrast statistic. One of the columns should correspond to the gene 
symbols.}

\item{weight_matrix}{A progeny coefficient matrix. the first column should be
the identifiers of the omic features, and should be coherent with 
the identifiers provided in df.}

\item{dfID}{an integer corresponding to the column number of 
the gene identifiers of df.}

\item{weightID}{an integer corresponding to the column number of the gene 
identifiers of the weight matrix.}

\item{statName}{The name of the stat used, to be displayed on the plot}

\item{verbose}{Logical indicating whether we want to have the messages 
indicating the different computed weights.}
}
\value{
The function returns a list of list of arrangeGrob objects.
The first level list elements correspond to samples/contrasts. 
The second level correspond to pathways.
The plots can be saved in a pdf format using the saveProgenyPlots function.
}
\description{
This function generate a series of scatter plot with marginal distribution
(in the form of an arrangeGrob object), for each progeny pathway and
sample/contrast. Each scatter plot has progeny weights as x-axis and the gene
level stat used to compute progeny score as the y-axis. The marginal
distribution of the gene level stats is displayed on the right of the plot
to give visual support of the significance of each gene contributing to
the progeny pathway score. The green and red colors represent the positive
and negative contribution of genes to the progeny pathway, respectively.
For each gene contribution, 4 cases are possible, as the combinations of
the sign of the gene level stat and the sign of the gene level weight.
Positive weight will lead to a positive(green)/negative(red) gene contribution
if the gene level stat is positive/negative. Negative weight will lead to
a negative(red)/positive(green) gene contribution if the gene level stat
is positive/negative.
}
\examples{
# use example gene expression matrix

gene_expression <- read.csv(system.file("extdata", 
"human_input.csv", package = "progeny"))

# getting a model matrix with 100 top significant genes and converting to df
weight_matrix <- getModel("Human", top=100)
weight_matrix <- data.frame(names = row.names(weight_matrix), 
  row.names = NULL, weight_matrix)

#use progenyScatter function
plots <- progenyScatter(gene_expression, weight_matrix)
}
