% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAT-modcomp.R
\name{sat-modcomp}
\alias{sat-modcomp}
\alias{SATmodcomp}
\alias{SATmodcomp.lmerMod}
\title{F-test and degrees of freedom based on Satterthwaite approximation}
\usage{
SATmodcomp(
  largeModel,
  smallModel,
  details = 0,
  eps = sqrt(.Machine$double.eps)
)

\method{SATmodcomp}{lmerMod}(
  largeModel,
  smallModel,
  details = 0,
  eps = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{largeModel}{An \code{lmerMod} model.}

\item{smallModel}{An \code{lmerMod} model, a restriction matrix or
a model formula. See example section.}

\item{details}{If larger than 0 some timing details are printed.}

\item{eps}{A small number.}
}
\description{
An approximate F-test based on the Satterthwaite approach.
}
\details{
Notice: It cannot be guaranteed that the results agree with other
implementations of the Satterthwaite approach!
}
\examples{

(fm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
L1 <- cbind(0,1)
SATmodcomp(fm1, L1)

(fm2 <- lmer(Reaction ~ Days + I(Days^2) + (Days|Subject), sleepstudy))

## Test for no effect of Days. There are three ways of using the function:

## 1) Define 2-df contrast - since L has 2 (linearly independent) rows
## the F-test is on 2 (numerator) df:
L2 <- rbind(c(0, 1, 0), c(0, 0, 1))
SATmodcomp(fm2, L2)

## 2) Use two model objects 
fm3 <- update(fm2, ~. - Days - I(Days^2))
SATmodcomp(fm2, fm3)

## 3) Specify restriction as formula
SATmodcomp(fm2, ~. - Days - I(Days^2))
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
Models - The R Package pbkrtest., Journal of Statistical Software,
58(10), 1-30., \url{https://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{getKR}}, \code{\link{lmer}}, \code{\link{vcovAdj}},
\code{\link{PBmodcomp}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{model_comparison}
\keyword{inference}
\keyword{models}
