% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{subset.AnchorSet}
\alias{subset.AnchorSet}
\title{Subset an AnchorSet object}
\usage{
\method{subset}{AnchorSet}(
  x,
  score.threshold = NULL,
  disallowed.dataset.pairs = NULL,
  dataset.matrix = NULL,
  group.by = NULL,
  disallowed.ident.pairs = NULL,
  ident.matrix = NULL,
  ...
)
}
\arguments{
\item{x}{object to be subsetted.}

\item{score.threshold}{Only anchor pairs with scores greater than this value
are retained.}

\item{disallowed.dataset.pairs}{Remove any anchors formed between the
provided pairs. E.g. \code{list(c(1, 5), c(1, 2))} filters out any anchors between
datasets 1 and 5 and datasets 1 and 2.}

\item{dataset.matrix}{Provide a binary matrix specifying whether a dataset
pair is allowable (1) or not (0). Should be a dataset x dataset matrix.}

\item{group.by}{Grouping variable to determine allowable ident pairs}

\item{disallowed.ident.pairs}{Remove any anchors formed between provided
ident pairs. E.g. \code{list(c("CD4", "CD8"), c("B-cell", "T-cell"))}}

\item{ident.matrix}{Provide a binary matrix specifying whether an ident pair
is allowable (1) or not (0). Should be an ident x ident symmetric matrix}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
Returns an \code{\link{AnchorSet}} object with specified anchors
filtered out
}
\description{
Subset an AnchorSet object
}
\concept{objects}
