#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) 2021 Satpy developers
#
# This file is part of satpy.
#
# satpy is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# satpy is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# satpy.  If not, see <http://www.gnu.org/licenses/>.
"""Pytest configuration and setup functions."""
import pytest


def pytest_configure(config):
    """Set test configuration."""
    from satpy import aux_download
    aux_download.RUNNING_TESTS = True


def pytest_unconfigure(config):
    """Undo previous configurations."""
    from satpy import aux_download
    aux_download.RUNNING_TESTS = False


@pytest.fixture(scope="session")
def session_tmp_path(tmp_path_factory):
    """Generate a single temp path to use for the entire session."""
    return tmp_path_factory.mktemp("data")
