## TFSA-2022-155: `CHECK_EQ` fail in `tf.raw_ops.TensorListResize`

### CVE Number
CVE-2022-41893

### Impact
If [`tf.raw_ops.TensorListResize`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/kernels/list_kernels.cc) is given a nonscalar value for input `size`, it results `CHECK` fail which can be used to trigger a denial of service attack.
```python
import numpy as np
import tensorflow as tf

a = data_structures.tf_tensor_list_new(elements = tf.constant(value=[3, 4, 5]))
b = np.zeros([0, 2, 3, 3])

tf.raw_ops.TensorListResize(input_handle=a, size=b)
```

### Patches
We have patched the issue in GitHub commit [888e34b49009a4e734c27ab0c43b0b5102682c56](https://github.com/tensorflow/tensorflow/commit/888e34b49009a4e734c27ab0c43b0b5102682c56).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Pattarakrit Rattankul
