# TFSA-2022-166: Invalid char to bool conversion when printing a tensor

### CVE Number
CVE-2022-41911

### Impact
When [printing a tensor](https://github.com/tensorflow/tensorflow/blob/807cae8a807960fd7ac2313cde73a11fc15e7942/tensorflow/core/framework/tensor.cc#L1200-L1227), we get it's data as a `const char*` array (since that's the underlying storage) and then we typecast it to the element type. However, conversions from `char` to `bool` are undefined if the `char` is not `0` or `1`, so sanitizers/fuzzers will crash.

### Patches
We have patched the issue in GitHub commit [1be743703279782a357adbf9b77dcb994fe8b508](https://github.com/tensorflow/tensorflow/commit/1be743703279782a357adbf9b77dcb994fe8b508).

The fix will be included in TensorFlow 2.11.0. We will also cherrypick this commit on TensorFlow 2.10.1, TensorFlow 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability was discovered via internal fuzzing.
