// @HEADER
// *****************************************************************************
//            NOX: An Object-Oriented Nonlinear Solver Package
//
// Copyright 2002 NTESS and the NOX contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

// Finite Element Problem Class
/* Provides function (RHS) and Jacobian evaluations for the
 * 2 equation test for quadratic and cubic line searches
 * from Dennis & Schnabel's book, chp 6. example 6.5.1
 *
 *    U0**2 + U1**2 - 2 = 0
 *    exp(U0-1) + U1**3 -2 = 0
 */

#ifndef _NOX_EXAMPLE_DENNIS_SCHNABEL_651_H
#define _NOX_EXAMPLE_DENNIS_SCHNABEL_651_H

// Forward Declarations
#include "petscksp.h"

// Flag to tell the evaluate routine what objects to fill
enum FillType {RHS_ONLY, MATRIX_ONLY, ALL};

// Finite Element Problem Class
class DennisSchnabel {

public:

  // Constructor
  DennisSchnabel(int NumGlobalElements);

  // Destructor
  ~DennisSchnabel();

  // Evaluates the function (RHS) and/or the Jacobian using the solution
  // values in solnVector.
  bool evaluate(FillType f, const Vec *solnVector,
        Vec *rhsVector, Mat *matrix);

  // Return a reference to the Vec with the initial guess
  // that is generated by this class.
  Vec& getSolution();

  // Return a reference to the Vec with the Jacobian
  // that is generated by this class.
  Mat& getJacobian();

private:

  // inserts the global column indices into the Graph
  // Epetra_CrsGraph& generateGraph(Epetra_CrsGraph& AA);

private:

  FillType flag;
  Vec *initialSolution;
  Vec *overlapSolution;
  Vec *soln;
  Vec *rhs;
  Mat *A;
  VecScatter* petscMap;

  int MyPID;              // Process number
  int NumProc;            // Total number of processes
  int NumMyElements;      // Number of elements owned by this process
  int NumGlobalElements;  // Total Number of elements

};
#endif




