(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require HighOrd.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Definition unit := unit.

Axiom matrix : forall (a:Type), Type.
Parameter matrix_WhyType : forall (a:Type) {a_WT:WhyType a},
  WhyType (matrix a).
Existing Instance matrix_WhyType.

Parameter elts: forall {a:Type} {a_WT:WhyType a}, (matrix a) -> (Z -> (Z ->
  a)).

Parameter rows: forall {a:Type} {a_WT:WhyType a}, (matrix a) -> Z.

Parameter columns: forall {a:Type} {a_WT:WhyType a}, (matrix a) -> Z.

Axiom matrix'invariant : forall {a:Type} {a_WT:WhyType a},
  forall (self:(matrix a)), (0%Z <= (rows self))%Z /\
  (0%Z <= (columns self))%Z.

(* Why3 assumption *)
Definition valid_index {a:Type} {a_WT:WhyType a} (a1:(matrix a)) (r:Z)
  (c:Z): Prop := ((0%Z <= r)%Z /\ (r < (rows a1))%Z) /\ ((0%Z <= c)%Z /\
  (c < (columns a1))%Z).

(* Why3 assumption *)
Inductive path: (matrix bool) -> Z -> Z -> Z -> Prop :=
  | Path_empty : forall (m:(matrix bool)) (i:Z) (j:Z) (k:Z), ((((elts m) i)
      j) = true) -> (path m i j k)
  | Path_cons : forall (m:(matrix bool)) (i:Z) (x:Z) (j:Z) (k:Z),
      ((0%Z <= x)%Z /\ (x < k)%Z) -> ((path m i x k) -> ((path m x j k) ->
      (path m i j k))).

Axiom weakening : forall (m:(matrix bool)) (i:Z) (j:Z) (k1:Z) (k2:Z),
  ((0%Z <= k1)%Z /\ (k1 <= k2)%Z) -> ((path m i j k1) -> (path m i j k2)).

Hint Constructors path.

(* Why3 goal *)
Theorem decomposition : forall (m:(matrix bool)) (k:Z), (0%Z <= k)%Z ->
  forall (i:Z) (j:Z), (path m i j (k + 1%Z)%Z) -> ((path m i j k) \/ ((path m
  i k k) /\ (path m k j k))).
(* Why3 intros m k h1 i j h2. *)
intros m k hk i j h.
remember (k+1)%Z as t in h.
induction h.
left; apply Path_empty; auto.
subst k0; intuition.
assert (case: (x=k \/ x < k)%Z) by omega. destruct case.
subst; eauto.
left; eauto.
assert (case: (x=k \/ x < k)%Z) by omega. destruct case.
subst x.
right; eauto.
right; eauto.
assert (case: (x=k \/ x < k)%Z) by omega. destruct case.
subst; eauto.
right; eauto.
Qed.

