/*
 * $Id: pathname.c,v 1.1 2000/08/07 23:15:04 emmerson Exp $
 *
 * (C) Copyright 1992 UCAR/Unidata
 *  
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose without fee is hereby granted,
 * provided that the above copyright notice appear in all copies, that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of UCAR/Unidata not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  UCAR makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.  It is provided with no support and without obligation on
 * the part of UCAR or Unidata, to assist in its use, correction,
 * modification, or enhancement.
 * 
 * This file contains utility functions for manipulating pathnames.
 */

#include "udposix.h"
#include <limits.h>
#include <string.h>

#ifndef	PATH_MAX
#   define PATH_MAX	_POSIX_PATH_MAX
#endif

#define MIN(a,b)	((a) < (b) ? (a) : (b))

static char	buf[PATH_MAX+1];


/*
 * Return the basename of a pathname (i.e. the rightmost filename minus 
 * any extension).
 */
    char*
pnbase(pathname)
    const char	*pathname;
{
    const char	*start;
    size_t	nchr;

#ifdef MSDOS
    start	= (start = strrchr(pathname, '\\')) == NULL &&
		  (start = strchr(pathname, ':'))   == NULL
			? pathname
			: start + 1;
    nchr	= strcspn(start, ".");
#else   /* not MSDOS below */
#ifdef vms
    start	= (start = strchr(pathname, ']'))   == NULL ||
		  (start = strchr(pathname, '>'))   == NULL ||
		  (start = strchr(pathname, ':'))   == NULL
			? pathname
			: start + 1;
    nchr	= strcspn(start, ".;");
#else   /* not vms below */
    start	= (start = strrchr(pathname, '/'))  == NULL
			? pathname
			: start + 1;
    nchr	= strcspn(start, ".");
#endif  /* not vms above */
#endif  /* not MSDOS above */

    (void) strncpy(buf, start, MIN(nchr, sizeof(buf)-1));

    return buf;
}


/*
 * Return the directory portion of a pathname.
 */
    char*
pndir(pathname)
    const char	*pathname;
{
    char	*stop;
    size_t	nchr;

#ifdef MSDOS
    nchr	= (stop = strrchr(pathname, '\\')) == NULL &&
		  (stop = strchr(pathname, ':'))   == NULL
			? 0
			: stop - pathname + 1;
#else   /* not MSDOS below */
#ifdef vms
    nchr	= (stop = strchr(pathname, ']'))   == NULL ||
		  (stop = strchr(pathname, '>'))   == NULL ||
		  (stop = strchr(pathname, ':'))   == NULL
			? 0
			: stop - pathname + 1;
#else   /* not vms below */
    nchr	= (stop = strrchr(pathname, '/'))  == NULL
			? 0
			: stop - pathname + 1;
#endif  /* not vms above */
#endif  /* not MSDOS above */

    nchr	= MIN(nchr, sizeof(buf)-1);
    (void) strncpy(buf, pathname, nchr);
    buf[nchr]	= 0;

    return buf;
}


/*
 * Return the filename portion of a pathname.
 */
    char*
pnfile(pathname)
    const char	*pathname;
{
    const char	*start;
    size_t	nchr;

#ifdef MSDOS
    start	= (start = strrchr(pathname, '\\')) == NULL &&
		  (start = strchr(pathname, ':'))   == NULL
			? pathname
			: start + 1;
#else   /* not MSDOS below */
#ifdef vms
    start	= (start = strchr(pathname, ']'))   == NULL ||
		  (start = strchr(pathname, '>'))   == NULL ||
		  (start = strchr(pathname, ':'))   == NULL
			? pathname
			: start + 1;
#else   /* not vms below */
    start	= (start = strrchr(pathname, '/'))  == NULL
			? pathname
			: start + 1;
#endif  /* not vms above */
#endif  /* not MSDOS above */

    nchr	= MIN(strlen(start), sizeof(buf)-1);
    (void) strncpy(buf, start, nchr);
    buf[nchr]	= 0;

    return buf;
}
