/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : gksmc
 *
 * FILE     : tables.c
 *
 * CONTENTS : This file sets up the tables containing CGM item names and
 *	      'enumerations'. It also contains the routines to change
 *	      the contents of these tables to lower case, if requested.
 *
 * DATE     : 24th April 1988
 *
 *---------------------------------------------------------------------
 */

#include <stdio.h>
#include "annexe.h"
#include "defns.h"

/*
 *------------------------------------------------------------------
 * OpTable
 *    This holds the CGM item names which correspond to an Annexe E
 * metafile item number. Where "" occurs there is no Annex E item
 * with that number. A name beginning with an asterix means there
 * is no direct CGM equivalent for the Annex E item - the name
 * following is the Annex E function.
 *------------------------------------------------------------------
 */

char   *CtOpTable[96] = {
	"ENDMF", "CLEAR", "REDRAWALLSEG",
	"UPDATE", "DEFERMODE", "MESSAGE",
	"ESCAPE", "", "", "", "", "LINE",
	"MARKER", "TEXT", "POLYGON",
	"CELLARRAY", "GDP", "", "", "", "",
	"LINEINDEX", "LINETYPE", "LINEWIDTH",
	"LINECOLR", "MARKERINDEX", "MARKERTYPE",
	"MARKERSIZE", "MARKERCOLR", "TEXTINDEX",
	"TEXTFONTINDEX", "CHAREXPAN", "CHARSPACE",
	"TEXTCOLR", "CHARORI", "TEXTPATH",
	"TEXTALIGN", "FILLINDEX", "INTSTYLE",
	"PATINDEX", "FILLCOLR", "PATSIZE",
	"FILLREFPT", "ASF", "PICKID",
	"", "", "", "", "", "", "LINEREP",
	"MARKERREP", "TEXTREP", "FILLREP",
	"COLRTABLE", "PATTABLE", "", "", "", "",
	"CLIPRECT", "", "", "", "", "", "", "", "", "",
	"*WKSWINDOW", "DEVICEVIEWPORT", "", "", "", "",
	"", "", "", "", "BEGSEG", "ENDSEG",
	"RENAMESEG", "DELETESEG", "", "", "",
	"", "", "", "SEGTRANS", "SEGVIS",
"SEGHIGHLIGHT", "SEGDISPLAYPRI", "SEGDET"},

       *CeOpTable[96] = {
	"\060\041", "\0\0", "\070\045",
	"\063\054", "\063\051", "\067\041",
	"\067\040", "", "", "", "", "\040",
	"\042", "\043", "\046",
	"\050", "\051", "", "", "", "",
	"\065\040", "\065\041", "\065\042",
	"\065\043", "\065\044", "\065\045",
	"\065\046", "\065\047", "\065\060",
	"\065\061", "\065\063", "\065\064",
	"\065\065", "\065\067", "\065\070",
	"\065\071", "\066\040", "\066\041",
	"\066\044", "\066\042", "\066\054",
	"\066\052", "\066\061", "\066\062",
	"", "", "", "", "", "", "\065\050",
	"\065\051", "\065\074", "\066\055",
	"\066\060", "\066\053", "", "", "", "",
	"\063\044", "", "", "", "", "", "", "", "", "",
	"\0\0", "\063\046", "", "", "", "",
	"", "", "", "", "\060\045", "\060\046",
	"\070\044", "\070\042", "", "", "",
	"", "", "", "\071\040", "\071\041",
"\071\042", "\071\043", "\071\044"},

      **OpTable, **CgmTable,

       *CtCgmTable[64] = {
	"BEGMF", "BEGPIC", "BEGPICBODY",
	"ENDPIC", "MFVERSION", "MFDESC",
	"VDCTYPE", "INTEGERPREC", "REALPREC",
	"INDEXPREC", "COLRPREC", "COLRINDEXPREC",
	"MAXCOLRINDEX", "COLRVALUEEXT", "MFELEMLIST",
	"BEGMFDEFAULTS", "ENDMFDEFAULTS", "FONTLIST",
	"CHARSETLIST", "CHARCODING", "SCALEMODE",
	"COLRMODE", "LINEWIDTHMODE", "MARKERSIZEMODE",
	"EDGEWIDTHMODE", "VDCEXT", "BACKCOLR",
	"VDCINTEGERPREC", "VDCREALPREC", "AUXCOLR",
	"TRANSPARENCY", "CLIP", "MFCATEGORY",
	"MAXVDCEXT", "SEGPRIEXT", "DEVICEVIEWPORTMODE",
	"DEVICEVIEWPORTMAP", "MAKEPICCUR", "PREPAREVIEWSURFACE",
	"MODFONTLIST", "MODCHARSETLIST", "BEGFIGURE",
	"ENDFIGURE", "NEWREGION", "IMPLEDGEVIS",
	"SAVEPRIMATTR", "RESPRIMATTR", "DELETEATTRSET",
	"ARCCTRBACK", "PIXELARRAY", "EDGEREP",
	"DRAWINGMODE", "REOPENSEG", "COPYSEG",
	"DELETEALLSEG", "IMPLSEGREGENMODE", "INHFILTER",
	"SEGPICKPRI", "INCRLINE", "INCRMARKER",
	"TEXTPREC", "INCRPOLYGON", "HATCHINDEX",
"CHARHEIGHT"},

       *CeCgmTable[64] = {
	"\060\040", "\060\042", "\060\043",
	"\060\044", "\061\040", "\061\041",
	"\061\042", "\061\043", "\061\044",
	"\061\045", "\061\046", "\061\047",
	"\061\050", "\061\051", "\061\052",
	"\061\053", "\061\054", "\061\055",
	"\061\056", "\061\057", "\062\040",
	"\062\041", "\062\042", "\062\043",
	"\062\044", "\062\045", "\062\046",
	"\063\040", "\063\041", "\063\042",
	"\063\043", "\063\045", "\061\060",
	"\061\061", "\061\062", "\063\047",
	"\063\050", "\063\052", "\063\053",
	"\063\055", "\063\056", "\063\057",
	"\063\060", "\063\061", "\063\062",
	"\063\063", "\063\064", "\063\065",
	"\064\050", "\064\051", "\066\056",
	"\066\063", "\070\040", "\070\041",
	"\070\043", "\070\046", "\070\047",
	"\071\045", "\0", "\0",
	"\065\074", "\0", "\066\043",
"\065\066"},

/* Used in the Prepare View surface item, for the Clearing Control Flag. */
       *Clear[] = {"CONDITIONAL", "FORCEDHARDCOPY", NULL},

/* Used in the Update Workstation item, for the Update Regeneration Flag. */
       *Update[] = {"PERFORM", "POSTPONE", NULL},

/* Used in the Deferral Mode item. */
       *DefMode[] = {"ASAP", "BNI", "ASTI", NULL},

/* Used in the Implicit Segmment Regeneration Mode. */
       *DefRegen[] = {"ALLOWED", "SUPPRESSED", NULL},

/* Used in Message */
       *Mess[] = {"NOACTION", "ACTION", NULL},

/* Used in Text */
       *TextEnd[] = {"NOTFINAL", "FINAL", NULL},

       *TextPath[] = {"RIGHT", "LEFT", "UP", "DOWN", NULL},

/* Used to specify the precision for following text */
       *TextPrec[] = {"STRING", "CHAR", "STROKE", NULL},

/* Used to specify the horizontal alignment of text */
       *Horiz[] = {"NORMHORIZ", "LEFT", "CTR", "RIGHT", NULL},

/* Used to specify the vertical alignment of text */
       *Vert[] = {"NORMVERT", "TOP", "CAP", "HALF", "BASE", "BOTTOM", NULL},

/* Used to specify the interior style for fill area/polygon */
       *Interior[] = {"HOLLOW", "SOLID", "PAT", "HATCH", "EMPTY", NULL},

/* Segment visibility */
       *SegVis[] = {"VIS", "INVIS", NULL},

/* Segment highlighting */
       *SegHl[] = {"NORMAL", "HIGHLIGHTED", NULL},

/* Segment detectability */
       *SegDet[] = {"UNDET", "DET", NULL},

/* Aspect Source Flags */
       *AsfName[] = {"LINETYPE", "LINEWIDTH", "LINECOLR", "MARKERTYPE",
	"MARKERSIZE", "MARKERCOLR", "TEXTFONTINDEX", "CHAREXP",
	"CHARSPACE", "TEXTCOLR", "INTSTYLE", "PATINDEX",
"FILLCOLR", "TEXTPREC", "HATCHINDEX", NULL},

/* Settings for ASFs */
       *AsfType[] = {"BUNDLED", "INDIV", NULL},

/* Pseudo ASFs used for groups of related attributes */
       *PseudoAsf[] = {"ALL", "ALLLINE", "ALLMARKER", "ALLTEXT",
"ALLFILL", NULL},

/* Metafile category */
       *MfCat[] = {"CGM", "GKSM", "CGMEXT1", NULL},

/* Used in Vdc Type item. */
       *VdcType[] = {"INTEGER", "REAL", NULL},

/* Used in Scaling Mode item. */
       *ScaleSpec[] = {"ABSTRACT", "METRIC", NULL},

/* Colour selection mode */
       *ColrSel[] = {"INDEXED", "DIRECT", NULL},

/* Used in Line Width, Marker Size and Edge Width Specification mode items. */
       *Spec[] = {"ABSOLUTE", "SCALED", NULL},

/* Special specifiers for metafile element list item */
       *ElemGroup[] = {"DRAWINGSET", "DRAWINGPLUS", NULL},

/* Device viewport specification mode */
       *DvSpecMode[] = {"FRACTION", "MM", "PHYDEVICEUNITS", NULL},

/* Used in the Character Coding Announcer item */
       *CharCodAnn[] = {"BASIC7BIT", "BASIC8BIT", "EXTD7BIT", "EXTD8BIT", NULL};

/* Enumeration table used to hold all enumerations */
char  **Enum[] = {Clear, Update, DefMode, DefRegen, Mess, TextEnd,
	TextPath, TextPrec, Horiz, Vert, Interior, SegVis, SegHl,
	SegDet, AsfName, AsfType, PseudoAsf, MfCat, VdcType, ScaleSpec,
ColrSel, Spec, ElemGroup, DvSpecMode, CharCodAnn};

/* Array used to hold separator strings */
char   *SepStrings[5] = {
	" ",	/* SoftSep */
	" ",	/* OptSep */
	", ",	/* HardSep */
	", ",	/* Sep */
" ;\n"};	/* Terminator */

char   *picture_name = "Picture name",
       *mf_name = "Translated Annex E metafile",
       *mf_descr = "Description string";

int     mf_version = 1,	/* CGM version number */
        mf_category = CGMEXT1,	/* Metafile category - Addendum 1 */
        vdc_type = VDC_REAL,	/* VDC type - VDC_INT or VDC_REAL */
        max_colr = 127,	/* Largest colour index */
        colr_prec = 255,	/* Maximum RGN intensity value */
        include_mf_descr = 1,	/* Should descr. string be included */
        include_mf_cat = 1,	/* Should category item be included */
        DevSpM = UNKNOWN,	/* Device viewport spec mode */
        Encoding = CLEAR_TEXT,	/* CHARACTER or CLEAR_TEXT */
        PointListForm = LIST_ABSOLUTE,	/* ABSOLUTE or INCREMENTAL */
        SigPlaces = 0,	/* No. of decimal places for reals */
        NumColrDefs = 0,	/* No. of colour defs read so far */
        NumColrBits,	/* No. of bits for colour spec */
        NumExpBits,	/* No. of bits for exponent */
        MinRealCode,	/* No. of bits in exponent */
        MaxRealCode,	/* No. of bits to left of dec pt */
        DefaultExponent,	/* Default Exponent for char. enc. */
        MinInt,	/* Most negative integer */
        MaxInt,	/* Most positive integer */
        MaxIntBits;	/* No. of bits needed for MaxInt */

double  DevScale = 1.0,	/* Viewport metric scale factor */
        MinReal,	/* Most negative real number */
        MaxReal;	/* Most positive real number */

ColourDef *ColrDefList;	/* Used to hold colour definitions */

Point   VDC_lower = {0.0, 0.0},	/* define the VDC range or extent */
        VDC_upper = {1.0, 1.0};


/*
 *-------------------------------------------------------------------------
 * setup_item_tables:
 *	The OpTable and CgmTable pointers are used to reference the clear
 * text or character encoding tables, depending on the encoding requested.
 *-------------------------------------------------------------------------
 */
setup_item_tables()
{
	if (Encoding == CLEAR_TEXT)
	{
		CgmTable = (char **) &CtCgmTable[0];
		OpTable = (char **) &CtOpTable[0];
	}
	else if (Encoding == CHARACTER)
	{
		CgmTable = (char **) &CeCgmTable[0];
		OpTable = (char **) &CeOpTable[0];
	}
}


/*
 *-------------------------------------------------------------------------
 * lower_tables:
 *	Converts the two tables containing metafile items and the
 * enumeration table into lower case.
 *-------------------------------------------------------------------------
 */
lower_tables()
{
	int     i;

	conv_table_to_lcase(CtOpTable, 96);
	conv_table_to_lcase(CtCgmTable, 64);
	for (i = 0; i <= 24; i++)
		conv_table_to_lcase(Enum[i], 0);
}


/*
 *-------------------------------------------------------------------------
 * conv_table_to_lcase:
 *	Takes an array of pointers to strings (a table of item names)
 * and converts each string pointed to into lower case.
 *-------------------------------------------------------------------------
 */
conv_table_to_lcase(table, num_items)
	char   *table[];
int     num_items;
{
	int     i;

	for (i = 0; i < num_items || (num_items == 0 && table[i] != NULL); i++)
	{
		if (table[i] != NULL)	/* if string is not "" */
			conv_string_to_lcase(table[i]);
	}
}


/*
 *-------------------------------------------------------------------------
 * conv_string_to_lcase:
 *	Takes the referenced string and converts any upper case letters to
 * lower case.
 *-------------------------------------------------------------------------
 */
conv_string_to_lcase(string)
	char   *string;
{
	int     i = 0;
	char    ch;

	while ((ch = string[i]) != '\0')
	{
		if (ch >= 'A' && ch <= 'Z')
			string[i] = ch + 'a' - 'A';
		i++;
	}
}
