///////
   //    HtmlAttribute.h
   //    HtmlAttribute Class declaration
   //
   //    Class for HtmlAttribute storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: HtmlAttribute.h,v 1.10 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _HTMLATTRIBUTE_H
#define _HTMLATTRIBUTE_H

#include <Object.h>

#ifdef HAVE_STD
#include <iostream>
#include <string>
#include <map>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif
#else
#include <iostream.h>
#include <string.h>
#include <map.h>
#endif /* HAVE_STD */

class HtmlAttribute : public Object
{

   // Write the object to the output
   friend std::ostream& operator<<( std::ostream&, const HtmlAttribute& );
   
   public:
   
    // Useful predefined attributes
    enum AttributeLabel
    {
	Attr_Unknown,
	Attr_ALT,
	Attr_HREF,
	Attr_ID,
	Attr_NAME,
	Attr_CONTENT,
	Attr_LANG,
	Attr_XML_LANG,
	Attr_SRC,
	Attr_DATA,
	Attr_LOWSRC,
	Attr_TYPE,
	Attr_BACKGROUND
    };

      // Construction / Destruction
      HtmlAttribute();
      virtual ~HtmlAttribute();

///////
   //    Public Interface
///////

      void Reset();

      void SetIDUrl        (unsigned int id) { IDUrl = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetAttrPosition (unsigned int ap) { AttrPosition = ap; }
      void SetAttribute    (const std::string &a);
      void SetContent      (const std::string &c) { Content = c; }

      unsigned int GetIDUrl() const          { return IDUrl; }
      unsigned int GetTagPosition() const    { return TagPosition; }
      unsigned int GetAttrPosition() const   { return AttrPosition; }
      const std::string &GetAttribute() const     { return Attribute; }
      const std::string &GetLowercaseAttribute() const     { return LowercaseAttribute; }
      const std::string &GetContent() const       { return Content; }
      const AttributeLabel GetAttributeLabel() const           { return _attr_label; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

      // Initialise the map of attributes
      static void initAttributesMap();

///////
   //    Protected attributes
///////

   protected:

      unsigned int   IDUrl;
      unsigned int   TagPosition;
      unsigned int   AttrPosition;
      std::string         Attribute;
      std::string         LowercaseAttribute;
      std::string         Content;
      AttributeLabel _attr_label;
      
///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

      typedef std::map <std::string, AttributeLabel> AttributesMap;
      static AttributesMap AttrMap;

};

#endif
