/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) Rockchip Electronics Co., Ltd.
 *    Zheng Yang <zhengyang@rock-chips.com>
 */

#ifndef __RK3066_HDMI_H__
#define __RK3066_HDMI_H__

#define GRF_SOC_CON0				0x150
#define HDMI_VIDEO_SEL				BIT(14)

#define DDC_SEGMENT_ADDR			0x30
#define HDMI_SCL_RATE				(50 * 1000)
#define HDMI_MAXIMUM_INFO_FRAME_SIZE		0x11

#define N_32K					0x1000
#define N_441K					0x1880
#define N_882K					0x3100
#define N_1764K					0x6200
#define N_48K					0x1800
#define N_96K					0x3000
#define N_192K					0x6000

#define HDMI_SYS_CTRL				0x000
#define HDMI_LR_SWAP_N3				0x004
#define HDMI_N2					0x008
#define HDMI_N1					0x00c
#define HDMI_SPDIF_FS_CTS_INT3			0x010
#define HDMI_CTS_INT2				0x014
#define HDMI_CTS_INT1				0x018
#define HDMI_CTS_EXT3				0x01c
#define HDMI_CTS_EXT2				0x020
#define HDMI_CTS_EXT1				0x024
#define HDMI_AUDIO_CTRL1			0x028
#define HDMI_AUDIO_CTRL2			0x02c
#define HDMI_I2S_AUDIO_CTRL			0x030
#define HDMI_I2S_SWAP				0x040
#define HDMI_AUDIO_STA_BIT_CTRL1		0x044
#define HDMI_AUDIO_STA_BIT_CTRL2		0x048
#define HDMI_AUDIO_SRC_NUM_AND_LENGTH		0x050
#define HDMI_AV_CTRL1				0x054
#define HDMI_VIDEO_CTRL1			0x058
#define HDMI_DEEP_COLOR_MODE			0x05c

#define HDMI_EXT_VIDEO_PARA			0x0c0
#define HDMI_EXT_HTOTAL_L			0x0c4
#define HDMI_EXT_HTOTAL_H			0x0c8
#define HDMI_EXT_HBLANK_L			0x0cc
#define HDMI_EXT_HBLANK_H			0x0d0
#define HDMI_EXT_HDELAY_L			0x0d4
#define HDMI_EXT_HDELAY_H			0x0d8
#define HDMI_EXT_HDURATION_L			0x0dc
#define HDMI_EXT_HDURATION_H			0x0e0
#define HDMI_EXT_VTOTAL_L			0x0e4
#define HDMI_EXT_VTOTAL_H			0x0e8
#define HDMI_AV_CTRL2				0x0ec
#define HDMI_EXT_VBLANK_L			0x0f4
#define HDMI_EXT_VBLANK_H			0x10c
#define HDMI_EXT_VDELAY				0x0f8
#define HDMI_EXT_VDURATION			0x0fc

#define HDMI_CP_MANU_SEND_CTRL			0x100
#define HDMI_CP_AUTO_SEND_CTRL			0x104
#define HDMI_AUTO_CHECKSUM_OPT			0x108

#define HDMI_VIDEO_CTRL2			0x114

#define HDMI_PHY_OPTION				0x144

#define HDMI_CP_BUF_INDEX			0x17c
#define HDMI_CP_BUF_ACC_HB0			0x180
#define HDMI_CP_BUF_ACC_HB1			0x184
#define HDMI_CP_BUF_ACC_HB2			0x188
#define HDMI_CP_BUF_ACC_PB0			0x18c

#define HDMI_DDC_READ_FIFO_ADDR			0x200
#define HDMI_DDC_BUS_FREQ_L			0x204
#define HDMI_DDC_BUS_FREQ_H			0x208
#define HDMI_DDC_BUS_CTRL			0x2dc
#define HDMI_DDC_I2C_LEN			0x278
#define HDMI_DDC_I2C_OFFSET			0x280
#define HDMI_DDC_I2C_CTRL			0x284
#define HDMI_DDC_I2C_READ_BUF0			0x288
#define HDMI_DDC_I2C_READ_BUF1			0x28c
#define HDMI_DDC_I2C_READ_BUF2			0x290
#define HDMI_DDC_I2C_READ_BUF3			0x294
#define HDMI_DDC_I2C_WRITE_BUF0			0x298
#define HDMI_DDC_I2C_WRITE_BUF1			0x29c
#define HDMI_DDC_I2C_WRITE_BUF2			0x2a0
#define HDMI_DDC_I2C_WRITE_BUF3			0x2a4
#define HDMI_DDC_I2C_WRITE_BUF4			0x2ac
#define HDMI_DDC_I2C_WRITE_BUF5			0x2b0
#define HDMI_DDC_I2C_WRITE_BUF6			0x2b4

#define HDMI_INTR_MASK1				0x248
#define HDMI_INTR_MASK2				0x24c
#define HDMI_INTR_STATUS1			0x250
#define HDMI_INTR_STATUS2			0x254
#define HDMI_INTR_MASK3				0x258
#define HDMI_INTR_MASK4				0x25c
#define HDMI_INTR_STATUS3			0x260
#define HDMI_INTR_STATUS4			0x264

#define HDMI_HDCP_CTRL				0x2bc

#define HDMI_EDID_SEGMENT_POINTER		0x310
#define HDMI_EDID_WORD_ADDR			0x314
#define HDMI_EDID_FIFO_ADDR			0x318

#define HDMI_HPG_MENS_STA			0x37c

#define HDMI_INTERNAL_CLK_DIVIDER		0x800

enum {
	/* HDMI_SYS_CTRL */
	HDMI_SYS_POWER_MODE_MASK = 0xf0,
	HDMI_SYS_POWER_MODE_A = 0x10,
	HDMI_SYS_POWER_MODE_B = 0x20,
	HDMI_SYS_POWER_MODE_D = 0x40,
	HDMI_SYS_POWER_MODE_E = 0x80,
	HDMI_SYS_PLL_RESET_MASK = 0x0c,
	HDMI_SYS_PLL_RESET = 0x0c,
	HDMI_SYS_PLLB_RESET = 0x08,

	/* HDMI_LR_SWAP_N3 */
	HDMI_AUDIO_LR_SWAP_MASK = 0xf0,
	HDMI_AUDIO_LR_SWAP_SUBPACKET0 = 0x10,
	HDMI_AUDIO_LR_SWAP_SUBPACKET1 = 0x20,
	HDMI_AUDIO_LR_SWAP_SUBPACKET2 = 0x40,
	HDMI_AUDIO_LR_SWAP_SUBPACKET3 = 0x80,
	HDMI_AUDIO_N_19_16_MASK = 0x0f,

	/* HDMI_AUDIO_CTRL1 */
	HDMI_AUDIO_EXTERNAL_CTS = BIT(7),
	HDMI_AUDIO_INPUT_IIS = 0,
	HDMI_AUDIO_INPUT_SPDIF = 0x08,
	HDMI_AUDIO_INPUT_MCLK_ACTIVE = 0x04,
	HDMI_AUDIO_INPUT_MCLK_DEACTIVE = 0,
	HDMI_AUDIO_INPUT_MCLK_RATE_128X = 0,
	HDMI_AUDIO_INPUT_MCLK_RATE_256X = 1,
	HDMI_AUDIO_INPUT_MCLK_RATE_384X = 2,
	HDMI_AUDIO_INPUT_MCLK_RATE_512X = 3,

	/* HDMI_I2S_AUDIO_CTRL */
	HDMI_AUDIO_I2S_FORMAT_STANDARD = 0,
	HDMI_AUDIO_I2S_CHANNEL_1_2 = 0x04,
	HDMI_AUDIO_I2S_CHANNEL_3_4 = 0x0c,
	HDMI_AUDIO_I2S_CHANNEL_5_6 = 0x1c,
	HDMI_AUDIO_I2S_CHANNEL_7_8 = 0x3c,

	/* HDMI_AV_CTRL1 */
	HDMI_AUDIO_SAMPLE_FRE_MASK = 0xf0,
	HDMI_AUDIO_SAMPLE_FRE_32000 = 0x30,
	HDMI_AUDIO_SAMPLE_FRE_44100 = 0,
	HDMI_AUDIO_SAMPLE_FRE_48000 = 0x20,
	HDMI_AUDIO_SAMPLE_FRE_88200 = 0x80,
	HDMI_AUDIO_SAMPLE_FRE_96000 = 0xa0,
	HDMI_AUDIO_SAMPLE_FRE_176400 = 0xc0,
	HDMI_AUDIO_SAMPLE_FRE_192000 = 0xe0,
	HDMI_AUDIO_SAMPLE_FRE_768000 = 0x90,

	HDMI_VIDEO_INPUT_FORMAT_MASK = 0x0e,
	HDMI_VIDEO_INPUT_RGB_YCBCR444 = 0,
	HDMI_VIDEO_INPUT_YCBCR422 = 0x02,
	HDMI_VIDEO_DE_MASK = 0x1,
	HDMI_VIDEO_INTERNAL_DE = 0,
	HDMI_VIDEO_EXTERNAL_DE = 0x01,

	/* HDMI_VIDEO_CTRL1 */
	HDMI_VIDEO_OUTPUT_FORMAT_MASK = 0xc0,
	HDMI_VIDEO_OUTPUT_RGB444 = 0,
	HDMI_VIDEO_OUTPUT_YCBCR444 = 0x40,
	HDMI_VIDEO_OUTPUT_YCBCR422 = 0x80,
	HDMI_VIDEO_INPUT_DATA_DEPTH_MASK = 0x30,
	HDMI_VIDEO_INPUT_DATA_DEPTH_12BIT = 0,
	HDMI_VIDEO_INPUT_DATA_DEPTH_10BIT = 0x10,
	HDMI_VIDEO_INPUT_DATA_DEPTH_8BIT = 0x30,
	HDMI_VIDEO_INPUT_COLOR_MASK = 1,
	HDMI_VIDEO_INPUT_COLOR_RGB = 0,
	HDMI_VIDEO_INPUT_COLOR_YCBCR = 1,

	/* HDMI_EXT_VIDEO_PARA */
	HDMI_VIDEO_VSYNC_OFFSET_SHIFT = 4,
	HDMI_VIDEO_VSYNC_ACTIVE_HIGH = BIT(3),
	HDMI_VIDEO_VSYNC_ACTIVE_LOW = 0,
	HDMI_VIDEO_HSYNC_ACTIVE_HIGH = BIT(2),
	HDMI_VIDEO_HSYNC_ACTIVE_LOW = 0,
	HDMI_VIDEO_MODE_INTERLACE = BIT(1),
	HDMI_VIDEO_MODE_PROGRESSIVE = 0,
	HDMI_EXT_VIDEO_SET_EN = BIT(0),

	/* HDMI_CP_AUTO_SEND_CTRL */

	/* HDMI_VIDEO_CTRL2 */
	HDMI_VIDEO_AV_MUTE_MASK = 0xc0,
	HDMI_VIDEO_CLR_AV_MUTE = BIT(7),
	HDMI_VIDEO_SET_AV_MUTE = BIT(6),
	HDMI_AUDIO_CP_LOGIC_RESET_MASK = BIT(2),
	HDMI_AUDIO_CP_LOGIC_RESET = BIT(2),
	HDMI_VIDEO_AUDIO_DISABLE_MASK = 0x3,
	HDMI_AUDIO_DISABLE = BIT(1),
	HDMI_VIDEO_DISABLE = BIT(0),

	/* HDMI_CP_BUF_INDEX */
	HDMI_INFOFRAME_VSI = 0x05,
	HDMI_INFOFRAME_AVI = 0x06,
	HDMI_INFOFRAME_AAI = 0x08,

	/* HDMI_INTR_MASK1 */
	/* HDMI_INTR_STATUS1 */
	HDMI_INTR_HOTPLUG = BIT(7),
	HDMI_INTR_MSENS = BIT(6),
	HDMI_INTR_VSYNC = BIT(5),
	HDMI_INTR_AUDIO_FIFO_FULL = BIT(4),
	HDMI_INTR_EDID_MASK = 0x6,
	HDMI_INTR_EDID_READY = BIT(2),
	HDMI_INTR_EDID_ERR = BIT(1),

	/* HDMI_HDCP_CTRL */
	HDMI_VIDEO_MODE_MASK = BIT(1),
	HDMI_VIDEO_MODE_HDMI = BIT(1),

	/* HDMI_HPG_MENS_STA */
	HDMI_HPG_IN_STATUS_HIGH = BIT(7),
	HDMI_MSENS_IN_STATUS_HIGH = BIT(6),
};

#endif /* __RK3066_HDMI_H__ */
