/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.jarv;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import org.iso_relax.verifier.Verifier;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VerifierValidator
implements Validator {
    private final Verifier verifier;
    private ContentHandler handler;

    public VerifierValidator(Verifier verifier, PropertyMap propertyMap) {
        this.verifier = verifier;
        verifier.setErrorHandler(ValidateProperty.ERROR_HANDLER.get(propertyMap));
        EntityResolver entityResolver = ValidateProperty.ENTITY_RESOLVER.get(propertyMap);
        if (entityResolver != null) {
            verifier.setEntityResolver(entityResolver);
        }
        try {
            this.handler = verifier.getVerifierHandler();
        }
        catch (SAXException sAXException) {
            this.handler = new ExceptionReportHandler(sAXException);
        }
    }

    public void reset() {
        try {
            this.handler = this.verifier.getVerifierHandler();
        }
        catch (SAXException sAXException) {
            this.handler = new ExceptionReportHandler(sAXException);
        }
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    private static class ExceptionReportHandler
    extends DefaultHandler {
        private final SAXException storedException;

        ExceptionReportHandler(SAXException sAXException) {
            this.storedException = sAXException;
        }

        public void startDocument() throws SAXException {
            throw this.storedException;
        }
    }
}

