--Construction of the Horrocks-Mumford bundle on P4,
--and the abelian surfaceof degree 10 in P4 as 
--the vanishing locus of a section.

restart

needsPackage "BGG"
S = ZZ/32003[x_0..x_4];
E = ZZ/32003[e_0..e_4,SkewCommutative=>true];
alphad = matrix{{e_4*e_1, e_2*e_3},{e_0*e_2, e_3*e_4},
                {e_1*e_3, e_4*e_0},{e_2*e_4, e_0*e_1},
                {e_3*e_0, e_1*e_2}};
alphad=map(E^5,E^{-2,-2},alphad)
alpha=syz alphad
alphad=beilinson(alphad,S);
alpha=beilinson(alpha,S);

--presentation of the Horrocks-Mumford bundle
FHM = prune homology(alphad,alpha);
betti res FHM
regularity FHM
betti tateResolution(presentation FHM,E,-6,6)

--Now the abelian surface
--the following is a general-enough section:
sect =  map(S^1, S^4, {{1,1,1,1}}) | map(S^1,S^15,0)

--we compute the ideal where the section vanishes:
mapcone = sect || transpose presentation FHM;
fmapcone = res coker mapcone;
--the ideal of the abelian surface: 3 quintics and 15 sextics
IX =  trim ideal fmapcone.dd_2;
betti IX
codim IX
degree IX
codim singularLocus IX

--the following is from the package "ExampleIdeals"
toMagma = method()
toMagma Ring := (R) -> (
     -- note: R is assumed to be a polynomial ring.  Variables alowed: single letters, 
     -- letters indexed by a single non-negative integer.
     -- For now the base ring needs to be ZZ/p or QQ.
     kk := coefficientRing R;
     p := char kk;
     basering := if p === 0 then "RationalField()" else "GF("|p|")";
     "R<" | concatenate between(",", (gens R)/toString) | "> := PolynomialRing(" 
       | basering | "," | toString numgens R | ",\"grevlex\");"
     )
toMagma Ideal := (I) -> (
     a := "I := ideal< R | \n   ";
     g := concatenate between(",\n   ", apply(numgens I, i -> toString I_i));
     a | g | ">;\n" 
     )
toMagma ring IX
toMagma IX
--Are there fibers of a generic projection to P3 that
--have length 3, and thus regularity 3?
--A priori, we need to test the regularity of the
--p-th power of the ideal generated by 4 random linear
--forms, where p is the y-regularity of the Rees algebra.
--We GUESS that p =10, the y-reg of the special fiber,
-- and there it's ok:

R = S/IX -- homog coord ring of X
L = ideal random(R^1, R^{4:-1})
--L defines a generic projection to P3
basis(1,R^1)
for i from 4 to 10 do (
     print i;
     for j from 1 to 3 do print (0==compress(basis(i+j, R^1) % L^i))
     )

--to check the guess, we try to compute the regularity of the Rees algebra,
--but this seems to be too hard: M2 spent 3 days and 2.5 GB of memory trying
--before I ran low on memory and killed the process.
needsPackage "ReesAlgebra"     
reesIdeal(L,L_0);
IRX = oo;
T = ring IRX
(fT, ff) =  flattenRing T
(fI, ff) =  flattenRing IRX;
TIRX = fI;
time resTIRX =res TIRX
betti(resTIRX, Weights =>{1,1,1,1,0,0,0,0,0})

-- Code MES added
J = ideal ring TIRX
A = (coefficientRing ring J)[gens ring J, MonomialSize=>8]
J = sub(J,A)
B = A/J
IB = sub(TIRX, B);
isHomogeneous IB
gbTrace=1
time C = res IB;
gbTrace=3
time C = res(IB, Strategy=>3);
time C = res(IB, Strategy=>1);
