
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file SymbolPlottingAttributes.h
    \\brief Definition of SymbolPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "SymbolPlottingWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



SymbolPlottingWrapper::SymbolPlottingWrapper(): symbolplotting_(new SymbolPlotting())


{


	

}
SymbolPlottingWrapper::SymbolPlottingWrapper(SymbolPlotting* symbolplotting): symbolplotting_(symbolplotting)
{

	
}

SymbolPlottingWrapper::~SymbolPlottingWrapper()
{

}

void SymbolPlottingWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("LEGEND") ) {
		string legend_value = request("LEGEND");
		
		symbolplotting_->legend_ = MagTranslator<string, bool>()(legend_value);
		
		}
	if  (request.countValues("SYMBOL_HEIGHT_UNIT") ) {
		string unit_method_value = request("SYMBOL_HEIGHT_UNIT");
		symbolplotting_->unit_method_ = unit_method_value;
		}
	if  (request.countValues("SYMBOL_TYPE") ) {
		string type_value = request("SYMBOL_TYPE");
		symbolplotting_->type_ = type_value;
		}
	if  (request.countValues("SYMBOL_MARKER_MODE") ) {
		string marker_mode_value = request("SYMBOL_MARKER_MODE");
		symbolplotting_->marker_mode_ = marker_mode_value;
		}
	if  (request.countValues("SYMBOL_FORMAT") ) {
		string format_value = request("SYMBOL_FORMAT");
		symbolplotting_->format_ = format_value;
		}
	if  (request.countValues("SYMBOL_TEXT_BLANKING") ) {
		string text_blanking_value = request("SYMBOL_TEXT_BLANKING");
		
		symbolplotting_->text_blanking_ = MagTranslator<string, bool>()(text_blanking_value);
		
		}
	if  (request.countValues("SYMBOL_OUTLINE") ) {
		string outline_value = request("SYMBOL_OUTLINE");
		
		symbolplotting_->outline_ = MagTranslator<string, bool>()(outline_value);
		
		}
	if  (request.countValues("SYMBOL_OUTLINE_THICKNESS") ) {
		int outline_thickness_value = request("SYMBOL_OUTLINE_THICKNESS");
		symbolplotting_->outline_thickness_ = outline_thickness_value;
		}
	if  (request.countValues("SYMBOL_CONNECT_LINE") ) {
		string connect_value = request("SYMBOL_CONNECT_LINE");
		
		symbolplotting_->connect_ = MagTranslator<string, bool>()(connect_value);
		
		}
	if  (request.countValues("SYMBOL_CONNECT_AUTOMATIC_LINE_COLOUR") ) {
		string automatic_connect_colour_value = request("SYMBOL_CONNECT_AUTOMATIC_LINE_COLOUR");
		
		symbolplotting_->automatic_connect_colour_ = MagTranslator<string, bool>()(automatic_connect_colour_value);
		
		}
	if  (request.countValues("SYMBOL_CONNECT_LINE_THICKNESS") ) {
		int connect_thickness_value = request("SYMBOL_CONNECT_LINE_THICKNESS");
		symbolplotting_->connect_thickness_ = connect_thickness_value;
		}
	if  (request.countValues("SYMBOL_LEGEND_ONLY") ) {
		string legend_only_value = request("SYMBOL_LEGEND_ONLY");
		
		symbolplotting_->legend_only_ = MagTranslator<string, bool>()(legend_only_value);
		
		}
	if  (request.countValues("SYMBOL_PROPERTY_HUE_NAME") ) {
		string property_hue_name_value = request("SYMBOL_PROPERTY_HUE_NAME");
		symbolplotting_->property_hue_name_ = property_hue_name_value;
		}
	doublearray  property_hue_list_value;
	for (int i = 0; i < request.countValues("SYMBOL_PROPERTY_HUE_LIST"); i++)
		property_hue_list_value.push_back((double)request("SYMBOL_PROPERTY_HUE_LIST", i));
	if ( !property_hue_list_value.empty() )
		symbolplotting_->property_hue_list_ = property_hue_list_value;
	doublearray  property_hue_values_list_value;
	for (int i = 0; i < request.countValues("SYMBOL_PROPERTY_HUE_VALUES_LIST"); i++)
		property_hue_values_list_value.push_back((double)request("SYMBOL_PROPERTY_HUE_VALUES_LIST", i));
	if ( !property_hue_values_list_value.empty() )
		symbolplotting_->property_hue_values_list_ = property_hue_values_list_value;
	if  (request.countValues("SYMBOL_PROPERTY_LIGHTNESS_NAME") ) {
		string property_lightness_name_value = request("SYMBOL_PROPERTY_LIGHTNESS_NAME");
		symbolplotting_->property_lightness_name_ = property_lightness_name_value;
		}
	doublearray  property_lightness_list_value;
	for (int i = 0; i < request.countValues("SYMBOL_PROPERTY_LIGHTNESS_LIST"); i++)
		property_lightness_list_value.push_back((double)request("SYMBOL_PROPERTY_LIGHTNESS_LIST", i));
	if ( !property_lightness_list_value.empty() )
		symbolplotting_->property_lightness_list_ = property_lightness_list_value;
	doublearray  property_lightness_values_list_value;
	for (int i = 0; i < request.countValues("SYMBOL_PROPERTY_LIGHTNESS_VALUES_LIST"); i++)
		property_lightness_values_list_value.push_back((double)request("SYMBOL_PROPERTY_LIGHTNESS_VALUES_LIST", i));
	if ( !property_lightness_values_list_value.empty() )
		symbolplotting_->property_lightness_values_list_ = property_lightness_values_list_value;
	if  (request.countValues("SYMBOL_PROPERTY_SATURATION_VALUE") ) {
		double property_saturation_value_value = request("SYMBOL_PROPERTY_SATURATION_VALUE");
		symbolplotting_->property_saturation_value_ = property_saturation_value_value;
		}
	if  (request.countValues("SYMBOL_PROPERTY_HEIGHT_NAME") ) {
		string property_height_name_value = request("SYMBOL_PROPERTY_HEIGHT_NAME");
		symbolplotting_->property_height_name_ = property_height_name_value;
		}
	if  (request.countValues("SYMBOL_PROPERTY_HEIGHT_SCALING_FACTOR") ) {
		double property_height_scaling_factor_value = request("SYMBOL_PROPERTY_HEIGHT_SCALING_FACTOR");
		symbolplotting_->property_height_scaling_factor_ = property_height_scaling_factor_value;
		}
	if  (request.countValues("SYMBOL_MARKER_INDEX") ) {
		int marker_value = request("SYMBOL_MARKER_INDEX");
		symbolplotting_->marker_ = marker_value;
		}
	
	
		string mode_value = request.countValues("SYMBOL_TABLE_MODE") ?  (string) request("SYMBOL_TABLE_MODE") : "OFF";
	MagLog::debug() << " SYMBOL_TABLE_MODE set to " << mode_value << endl;
	SymbolModeWrapper* mode_wrapper = 0;
	try
	{
		mode_wrapper = SimpleFactory<SymbolModeWrapper>::create(mode_value);
	}
	 catch (NoFactoryException&) {
		if (MagicsGlobal::strict()) {
            throw;
        }
		MagLog::warning() << "[" << mode_value << "] is not a valid value for mode: reset to default -> [OFF]" << endl;
		mode_wrapper = SimpleFactory<SymbolModeWrapper>::create("OFF");
	}
	mode_wrapper->set(request);
	symbolplotting_->mode_ =  unique_ptr<SymbolMode>(mode_wrapper->object());
	delete mode_wrapper;
	if  (request.countValues("SYMBOL_OUTLINE_COLOUR") ) {
		string outline_colour_value = request("SYMBOL_OUTLINE_COLOUR");
		symbolplotting_->outline_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(outline_colour_value));
	}
		
	
	if  (request.countValues("SYMBOL_OUTLINE_STYLE") ) {
		string outline_style_value = request("SYMBOL_OUTLINE_STYLE");
		symbolplotting_->outline_style_ = MagTranslator<string, LineStyle>()(outline_style_value);
	}
		
	if  (request.countValues("SYMBOL_CONNECT_LINE_COLOUR") ) {
		string connect_colour_value = request("SYMBOL_CONNECT_LINE_COLOUR");
		symbolplotting_->connect_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(connect_colour_value));
	}
		
	
	if  (request.countValues("SYMBOL_CONNECT_LINE_STYLE") ) {
		string connect_style_value = request("SYMBOL_CONNECT_LINE_STYLE");
		symbolplotting_->connect_style_ = MagTranslator<string, LineStyle>()(connect_style_value);
	}
		
	
}

void SymbolPlottingWrapper::print(ostream& out)  const
{
	out << "SymbolPlottingWrapper[]";
}


#include "SymbolIndividualModeWrapper.h"
static SimpleObjectMaker<SymbolIndividualMode, SymbolMode> SymbolPlotting_symbol_table_mode_individual ("individual");
static SimpleObjectMaker<SymbolIndividualModeWrapper, SymbolModeWrapper> SymbolPlotting_symbol_table_mode_individual_wrapper ("individual");


#include "SymbolIndividualModeWrapper.h"
static SimpleObjectMaker<SymbolIndividualMode, SymbolMode> SymbolPlotting_symbol_table_mode_off ("off");
static SimpleObjectMaker<SymbolIndividualModeWrapper, SymbolModeWrapper> SymbolPlotting_symbol_table_mode_off_wrapper ("off");


#include "SymbolAdvancedTableModeWrapper.h"
static SimpleObjectMaker<SymbolAdvancedTableMode, SymbolMode> SymbolPlotting_symbol_table_mode_advanced ("advanced");
static SimpleObjectMaker<SymbolAdvancedTableModeWrapper, SymbolModeWrapper> SymbolPlotting_symbol_table_mode_advanced_wrapper ("advanced");


#include "SymbolTableModeWrapper.h"
static SimpleObjectMaker<SymbolTableMode, SymbolMode> SymbolPlotting_symbol_table_mode_table ("table");
static SimpleObjectMaker<SymbolTableModeWrapper, SymbolModeWrapper> SymbolPlotting_symbol_table_mode_table_wrapper ("table");


#include "SymbolTableModeWrapper.h"
static SimpleObjectMaker<SymbolTableMode, SymbolMode> SymbolPlotting_symbol_table_mode_on ("on");
static SimpleObjectMaker<SymbolTableModeWrapper, SymbolModeWrapper> SymbolPlotting_symbol_table_mode_on_wrapper ("on");







