// Copyright 2022 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Toto`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v15.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x01E290, 0x01E2AE]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Toto}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Toto}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Toto}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Toto}"
);
testPropertyEscapes(
  /^\p{scx=Toto}+$/u,
  matchSymbols,
  "\\p{scx=Toto}"
);
testPropertyEscapes(
  /^\p{scx=Toto}+$/u,
  matchSymbols,
  "\\p{scx=Toto}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01E28F],
    [0x01E2AF, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Toto}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Toto}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Toto}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Toto}"
);
testPropertyEscapes(
  /^\P{scx=Toto}+$/u,
  nonMatchSymbols,
  "\\P{scx=Toto}"
);
testPropertyEscapes(
  /^\P{scx=Toto}+$/u,
  nonMatchSymbols,
  "\\P{scx=Toto}"
);

reportCompare(0, 0);
