/*
 *  PowerDNS LDAP Backend
 *  Copyright (C) 2011 Grégory Oestreicher <greg@kamago.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <ldap.h>
#include <string>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef LDAPAUTHENTICATOR_HH
#define LDAPAUTHENTICATOR_HH

class LdapAuthenticator
{
  public:
    virtual ~LdapAuthenticator() {}
    virtual bool authenticate( LDAP *connection ) = 0;
    virtual std::string getError() const = 0;
};

#endif // LDAPAUTHENTICATOR_HH
