<?php
/**
*
* help_bbcode [Bulgarian]
*
* @package language
* @version $Id: help_bbcode.php 9461 2009-04-17 15:23:17Z nacholibre $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$help = array(
	array(
		0 => '--',
		1 => 'Въведение'
	),
	array(
		0 => 'Какво е BBCode?',
		1 => 'BBCode е специална имплементация на HTML. Дали можете да ползвате BBCode във вашите съобщения или не се определя от администраторите. Освен това, можете да изключите BBCode за дадено съобщение от формата за писане на съобщения. BBCode прилича много на HTML, използват се тагове, които са затворени в квадратни скоби (ето така: [таг]), а не в < и >. Освен това BBCode предлага по-голям контрол над стила на това какво и как с е показва. В зависимост от Темата на форума, е възможно да има прост интерфейс за добавяне на BBCode в вашите съобщения (като например в subSilver). Въпреки това, ако се имате проблем с BBCode, това упътване ще ви бъде полезно.'
	),
	array(
		0 => '--',
		1 => 'Форматиране на текст'
	),
	array(
		0 => 'Как да направя удебелен, наклонен и подчертан текст?',
		1 => 'BBCode включва тагове, които позволяват бързо и лесно да промените стила на текста. Това става по следните начини: This is achieved in the following ways: <ul><li>За да направите текст чер, ползвайте <strong>[b][/b]</strong>, например . <br /><br /><strong>[b]</strong>Здравей<strong>[/b]</strong><br /><br />ще се показва като <strong>Здравей</strong></li><li>За подчертан текст, ползвайте <strong>[u][/u]</strong>, пример:<br /><br /><strong>[u]</strong>Добро Утро<strong>[/u]</strong><br /><br />ще се показва като <u>Добро Утро</u></li><li>За да направите текст наклонен, ползвайте <strong>[i][/i]</strong>, пример<br /><br />Това е <strong>[i]</strong>страхотно!<strong>[/i]</strong><br /><br />ще се показва като Това е <i>страхотно!</i></li></ul>'
	),
	array(
		0 => 'Как да променя цвета или размера на текста?',
		1 => 'За да промените цвета или размера на текста, ползвайте един от описаните по-долу тагове. Имайте предвид, че цвета и размера на текста зависят от браузъра и системата на потребителя.<ul><li>За да смените цвета на текст, ползвайте <b>[color=][/color]</b>. Можете да или да напишете името на цвета (например червено, синьо, жълто, т.н.), или да въведете цвета като шестнадесетична стойност (напр. #FFFFFF, #000000). Пример: за да направите червен текст, можете да ползвате:<br /><br /><b>[color=red]</b>Здрасти!<b>[/color]</b><br /><br />или<br /><br /><b>[color=#FF0000]</b>Здрасти!<b>[/color]</b><br /><br />И двете ще покажат <span style=\"color:red\">Hello!</span></li><li>Промяната на размера на текста става по подобен начин, с помощта на <b>[size=][/size]</b>. Този таг зависи от Темата, която ползва форума, но е препоръчително да използвате цифри, представящи размера на текста в пиксели, започващи от 1 (толкова малък текст, че няма да се вижда) до 29 (огромен текст). Пример: <br /><br /><b>[size=9]</b>МАЛЪК<b>[/size]</b><br /><br /> ще се показва като <span style=\"font-size:9px\">МАЛЪК</span><br /><br />докато <br /><br /><b>[size=24]</b>ОГРОМЕН!<b>[/size]</b><br /><br />ще е <span style=\"font-size:24px\">ОГРОМЕН!</span></li></ul>'
	),
	array(
		0 => 'Мога ли да комбинирам форматиращи тагове?',
		1 => 'Да, разбира се, че можете. Например, за да привлечете вниманието на някой, можете да напишете:<br /><br /><b>[size=18][color=red][b]</b>ПОГЛЕДНИ МЕ!<b>[/b][/color][/size]</b><br /><br />което би се показало като <span style=\"color:red;font-size:18px\"><b>ПОГЛЕДНИ МЕ!</b></span><br /><br />Въпреки това, не препоръчваме прекомерната употреба на форматиращите тагове. Запомнете, вие трябва да се уверите дали таговете са затворени правилно, не форума. Например, следния ред е неправилен:<br /><br /><b>[b][u]</b>Това е грешно!<b>[/b][/u]</b>'
	),
	array(
		0 => '--',
		1 => 'Цитати и Код'
	),
	array(
		0 => 'Как да цитирам в отговор на съобщение',
		1 => 'Има два начина за създаване на цитати - със и без автор.<ul><li>Когато използвате Отговор с цитат на форума, ще забележите, че текста на съобщението, на което отговаряте се добавя към вашето съобщение и е заграден в таговете <b>[quote=\"\"][/quote]</b>. Този метод позволява да цитирате, като посочвате автора на цитата. Например, ако искате да цитирате Иван, би трябвало да напишете:<br /><br /><b>[quote=\"Иван\"]</b>Тук поставете текста, който Иван е написал<b>[/quote]</b><br /><br />В резултат над цитирания блок ще се показва <b>Иван написа:</b>. Не забравяйте да поставите името на автора в кавички (ето така: \"Иван\")!</li><li>Втория метод позволява да правите цитати без да посочвате автора. За да цитирате по този начин, просто затворете текста в таговете <b>[quote][/quote]</b>. В резултат над цитирания блок ще се показва само <b>Цитат:</b>.</li></ul>'
	),
	array(
		0 => 'Как да поставя код или друг текст с фиксирана ширина в съобщението си?',
		1 => 'Ако искате да прибавите програмен код или друг текст, изискващ фиксирана ширина в съобщението си, трябва да затворите текста в таговете <b>[code][/code]</b>, например <br /><br /><b>[code]</b>echo \"Това е код\";<b>[/code]</b><br /><br />Форматирането, използвано в таговете <b>[code][/code]</b> се запазва.'
	),
	array(
		0 => '--',
		1 => 'Списъци'
	),
	array(
		0 => 'Как да направя неподреден списък?',
		1 => 'BBCode поддържа два вида списъци: неподреден и подреден. На практика, те се същите като в HTML. Неподреденият списък показва един под друг редовете на списъка, поставяйки в началото им голяма точка. За да създадете неподреден списък, ползвайте <b>[list][/list]</b> и дефинирайте всеки ред от списъка с <b>[*]</b>. Например, за да направите списък с любимите си цветове, можете да ползвате следния синтаксис:<br /><br /><b>[list]</b><br /><b>[*]</b>Червено<br /><b>[*]</b>Синьо<br /><b>[*]</b>Жълто<br /><b>[/list]</b><br /><br />Така ще получите следния списък:<ul><li>Червено</li><li>Синьо</li><li>Жълто</li></ul>'
	),
	array(
		0 => '--',
		1 => '--'
	),
	array(
		0 => 'Как да направя подреден списък?',
		1 => 'Втория вид списък, подредения, ви дава избор какво да бъде поставено в началото на всеки ред. Ползвайте <b>[list=1][/list]</b>, за да създадете номериран списък, или <b>[list=a][/list]</b> за азбучен списък. Също като с неподредените списъци, редовете се дефинират с <b>[*]</b>. Пример:<br /><br /><b>[list=1]</b><br /><b>[*]</b>Иди по магазините<br /><b>[*]</b>Купи нов компютър<br /><b>[*]</b>Псувай компютъра, когато забие<br /><b>[/list]</b><br /><br />ще генерира следното:<ol type=\"1\"><li>Иди по магазините</li><li>Купи нов компютър</li><li>Псувай компютъра, когато забие</li></ol>Ако искате азбучен списък, ползвайте този синтаксис:<br /><br /><b>[list=a]</b><br /><b>[*]</b>Първи отговор<br /><b>[*]</b>Втори отговор<br /><b>[*]</b>Трети отговор<br /><b>[/list]</b><br /><br />и ще получите:<ol type=\"a\"><li>Първи отговор</li><li>Втори отговор</li><li>Трети отговор</li></ol>'
	),
	array(
		0 => '--',
		1 => 'Връзки'
	),
	array(
		0 => 'Създаване на връзка към друг сайт',
		1 => 'BBCode поддържа няколко различни начина за прилагане на връзки (URL) към съобщенията.<ul><li>Първият от тях използва таговете <b>[url=]текст[/url]</b>, като поставяйки връзка след знака = ще превърне текста, затворен в таговете във връзка. Например, за да направите връзка към phpBB.com, можете да напишете: <br /><br /><b>[url=http://www.phpbb.com/]</b>Посетете phpBB!<b>[/url]</b><br /><br />Това ще генерира следната връзка: <a href=\"http://www.phpbb.com/\" target=\"_blank\">Visit phpBB!</a>. Забележете, че връзката се отваря в нов прозорец, така че потребителят да може необезпокоявано да продължи да разглежда форумите.</li><li>Ако искате да покажете самата връзка, това става просто така:<br /><br /><b>[url]</b>http://www.phpbb.com/<b>[/url]</b><br /><br />Това ще генерира следната връзка: <a href=\"http://www.phpbb.com/\" target=\"_blank\">http://www.phpbb.com/</a></li><li>Освен това, phpBB съдържа функция, наречена <i>Магически връзки</i>, която автоматично намира правилно въведените URL-та в съобщението ви и ги обръща във действащи връзки. Няма нужда да въвеждате тагове или дори http://. Например, ако напишете www.phpbb.com във вашето съобщение, автоматично ще се генерира връзката <a href=\"http://www.phpbb.com/\" target=\"_blank\">www.phpbb.com</a></li><li>Същото важи и за мейл адресите. Можете да ползвате тагове:<br /><br /><b>[email]</b>no.one@domain.adr<b>[/email]</b><br /><br />което ще резултира в <a href=\"emailto:no.one@domain.adr\">no.one@domain.adr</a> или можете просто да напишете no.one@domain.adr в съобщението си и адреса автоматично ще бъде конвертиран в мейл-връзка.</li></ul>Както при всички BBCode тагове, можете да наслагвате по няколко едновременно, например <b>[url][img][/img][/url]</b> (виж по-долу), <b>[url][b][/b][/url]</b>, и т.н.. Запомнете, вие трябва да се уверите дали таговете са затворени правилно, не форума. Например:<br /><br /><b>[url=http://www.phpbb.com/][img]</b>http://www.phpbb.com/images/phplogo.gif<b>[/url][/img]</b><br /><br />е <u>неправилен</u> синтаксис, който може да доведе до изтриването на съобщението ви от модераторите, така че бъдете внимателни!'
	),
	array(
		0 => '--',
		1 => 'Показване на изображения в съобщенията'
	),
	array(
		0 => 'Как да добавя картинка към съобщението си?',
		1 => 'BBCode включва таг за прибавяне на изображения към съобщения ви. Помнете две много важни неща, свързани с този таг: много потребители не одобряват много или големи картинки в съобщенията, и второ, картинката, която искате да покажете, трябва да се намира в Интернет (не може просто да я имате на компютъра се, трябва да я качите на някой уеб сървър). В текущата версия няма начин да записвате картинките на сървъра на форума (вероятно тази функция ще намери място в следващата версия на phpBB). За да покажете изображение в съобщението си, трябва да затворите URL-то към картинката с тага <b>[img][/img]</b>. Пример: <br /><br /><b>[img]</b>http://www.google.com/intl/en_ALL/images/logo.gif<b>[/img]</b><br /><br />Както казахме в предната секция, можете да затворите тага за картинка с таг за връзка: <b>[url][/url]</b> ако желаете. Това изписване<br /><br /><b>[url=http://www.google.com/][img]</b>http://www.google.com/intl/en_ALL/images/logo.gif<b>[/img][/url]</b><br /><br />ще покаже:<br /><br /><a href="http://www.google.com/"><img src="http://www.google.com/intl/en_ALL/images/logo.gif" alt="" /></a><br />'
	),
	array(
		0 => 'Добавяне на прикачени файлове към мнение',
		1 => 'Прикачените файлове могат да бъдат сложени на различни места в мнението ви като се използва <b>[attachment=][/attachment]</b>.'
	),
	array(
		0 => '--',
		1 => 'Други въпроси'
	),
	array(
		0 => 'Мога ли да добавям мои тагове?',
		1 => 'Ако сте администратор на този форум можете да добавяте собствени тагове.'
	)
);

?>