from PyQt4 import QtCore, QtGui

import defaults

class Line:
	def __init__(self, scene, image):
		self.scene = scene
		self.image = image

	def QTColorGet(self, color):
		if (color == "#000000"):
			return QtCore.Qt.black
		if (color == "#FF0000"):
			return QtCore.Qt.red
		if (color == "#0000FF"):
			return QtCore.Qt.blue
		if (color == "#FF9900"):
			return QtCore.Qt.yellow

		return QtCore.Qt.black

	def addLines(self, show_max, axislimits=None):
		pen = QtGui.QPen()

		#print str(axislimits)
		linecounter = 0
		for line in self.image['lines']:
			if linecounter == show_max:
				return
			linecounter = linecounter + 1

			plotnb = 0 # Where we are in the axis
			for plot in line:
				if not line[plotnb]['hidden']:
					if plotnb != self.image['axes_number'] - 1:
						qtcolor = self.QTColorGet(line[plotnb]['color'])
						pen.setColor(qtcolor)
						pen.setWidthF(line[plotnb]['penwidth'])
						ptr = self.scene.addLine(plotnb * defaults.axiswidth, self.image['height'] - line[plotnb]['y'], (plotnb + 1) * defaults.axiswidth, self.image['height'] - line[plotnb+1]['y'], pen)
						ptr.setToolTip("%s -> %s" % (line[plotnb]['strval'], line[plotnb+1]['strval']))
						ptr.setCursor(QtCore.Qt.OpenHandCursor)
				plotnb = plotnb + 1

	def showLines(self, show_max):
		itemnb = 0
		counter = 0
		for item in self.scene.items():
			if ((itemnb - 1)/self.image['axes_number']  == show_max):
				return
			itemnb = itemnb + 1
			item.show()

	def update_lines_view(self, value):
		for item in self.scene.items():
			item.hide()

		self.showLines(value)

	def maxLinesGet(self):
		linecounter = 0
		for line in self.image['lines']:
			linecounter = linecounter + 1

		return linecounter

