/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sCAL
extends Chunk {
    Chunk_sCAL() {
        super(Chunk.sCAL);
    }

    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        int n = this.in_data.readUnsignedByte();
        if (n != 1 && n != 2) {
            throw new PngExceptionSoft("Illegal sCAL chunk unit specifier: " + n);
        }
        String string = this.in_data.readString();
        int n2 = this.length - string.length() + 2;
        try {
            double d = ExDataInputStream.parseFloatingPoint(string);
            double d2 = ExDataInputStream.parseFloatingPoint(this.in_data.readString(n2));
            if (d < 0.0 || d2 < 0.0) {
                throw new NumberFormatException();
            }
            this.img.data.properties.put("pixel scale x", new Double(d));
            this.img.data.properties.put("pixel scale y", new Double(d2));
            this.img.data.properties.put("pixel scale unit", new Integer(n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PngExceptionSoft("Bad floating point value in sCAL chunk");
        }
    }
}

