/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import com.sixlegs.png.PixelProcessor;

class BasicPixelProcessor
extends PixelProcessor {
    protected final Destination dst;
    protected final int samples;

    public BasicPixelProcessor(Destination dst, int samples) {
        this.dst = dst;
        this.samples = samples;
    }

    public boolean process(int[] row, int xOffset, int xStep, int yStep, int y, int width) {
        if (xStep == 1) {
            this.dst.setPixels(xOffset, y, width, row);
        } else {
            int dstX = xOffset;
            int total = this.samples * width;
            for (int index = 0; index < total; index += this.samples) {
                for (int i = 0; i < this.samples; ++i) {
                    row[i] = row[index + i];
                }
                this.dst.setPixel(dstX, y, row);
                dstX += xStep;
            }
        }
        return true;
    }
}

