/*
 * Copyright 1997-98 by Pawel Krawczyk <kravietz@ceti.com.pl>
 *
 * See http://www.ceti.com.pl/~kravietz/progs/tacacs.html
 * for details.
 *
 * author_r.c  Reads authorization reply from the server.
 */

#include <netinet/in.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <stdio.h>

#include "tacplus.h"
#include "../server.h"
#include "libtac.h"
#include "messages.h"

/* This function returns structure containing 
    1. status (granted/denied)
    2. message for the user
    3. list of attributes returned by server
   The attributes should be applied to service authorization
   is requested for, but actually the aren't. Attributes are
   discarded. 
*/
struct areply *tac_author_read(int fd) {
	HDR th;
	struct author_reply *tb;
	int len_from_header, r, len_from_body;
	char *pktp;
	char *msg = NULL;

	struct areply *re = (struct areply *) xmalloc(sizeof(struct areply));
	
	r=read(fd, &th, TAC_PLUS_HDR_SIZE);
	if(r < TAC_PLUS_HDR_SIZE) {
  		nsyslog(LOG_ERR,
 			"short author header, %d of %d: %m",
		 	r, TAC_PLUS_HDR_SIZE);
		re->msg = system_err_msg;
		re->status = AUTHOR_STATUS_ERROR;
  		return(re);
 	}

	/* check header consistency */
	msg = _tac_check_header(&th, TAC_PLUS_AUTHOR);
	if(msg != NULL) {
		/* no need to process body if header is broken */
		re->msg = msg;
		re->status = AUTHOR_STATUS_ERROR;
		return(re); 
	}

 	len_from_header=ntohl(th.datalength);
 	tb=(struct author_reply *) xmalloc(len_from_header);

 	/* read reply packet body */
 	r=read(fd, tb, len_from_header);
 	if(r < len_from_header) {
  		nsyslog(LOG_ERR,
			 "short author body, %d of %d: %m",
			 r, len_from_header);
		re->msg = system_err_msg;
		re->status = AUTHOR_STATUS_ERROR;
  		return(re);
 	}

 	/* decrypt the body */
 	_tac_crypt((u_char *) tb, &th, len_from_header);

 	/* check consistency of the reply body
	 * len_from_header = declared in header
	 * len_from_body = value computed from body fields
	 */
 	len_from_body = TAC_AUTHOR_REPLY_FIXED_FIELDS_SIZE +
	    		tb->msg_len + tb->data_len;
	    
	pktp = (u_char *) tb + TAC_AUTHOR_REPLY_FIXED_FIELDS_SIZE;
	
	for(r = 0; r < tb->arg_cnt; r++) {
	    len_from_body += sizeof(u_char); /* add arg length field's size*/
	    len_from_body += *pktp; /* add arg length itself */
	}
	
/* 	if(len_from_header != len_from_body) {
  		nsyslog(LOG_ERR,
			"inconsistent author reply body, incorrect key?");
		re->msg = system_err_msg;
		re->status = AUTHOR_STATUS_ERROR;
  		return(re);
 	}
*/
	/* packet seems to be consistent, prepare return messages */
	/* server message for user */
	if(tb->msg_len) {
		re->msg = (char *) xmalloc(tb->msg_len+1);
		bcopy(tb+TAC_AUTHOR_REPLY_FIXED_FIELDS_SIZE
				+ (tb->arg_cnt)*sizeof(u_char),
				msg, tb->msg_len);
	}

	/* server message to syslog */
	if(tb->data_len) {
		char *smsg=(char *) xmalloc(tb->data_len+1);
		bcopy(tb + TAC_AUTHOR_REPLY_FIXED_FIELDS_SIZE
				+ (tb->arg_cnt)*sizeof(u_char)
				+ tb->msg_len, smsg, 
				tb->data_len);
		nsyslog(LOG_ERR, "author failed: %s", smsg);
		free(smsg);
	}

	/* prepare status */
	switch(tb->status) {
		/* success conditions */
		case AUTHOR_STATUS_PASS_ADD:
		case AUTHOR_STATUS_PASS_REPL:
			if(!re->msg) re->msg=author_ok_msg;
			re->status=tb->status;
			break;

		/* authorization failure conditions */
		/* failing to follow is allowed by RFC, page 23  */
		case AUTHOR_STATUS_FOLLOW: 
		case AUTHOR_STATUS_FAIL:
			if(!re->msg) re->msg=author_fail_msg;
			re->status=AUTHOR_STATUS_FAIL;
			break;

		/* error conditions */	
		case AUTHOR_STATUS_ERROR:
		default:
			if(!re->msg) re->msg=author_err_msg;
			re->status=AUTHOR_STATUS_ERROR;
	}

	free(tb);	
	TACDEBUG((LOG_DEBUG, "%s: server replied '%s'", __FUNCTION__, \
			re->msg))
	return(re);
	
}
