/*
 * Copyright 2022-2023 Soren Stoutner <soren@stoutner.com>.
 *
 * This file is part of Privacy Browser PC <https://www.stoutner.com/privacy-browser-pc>.
 *
 * Privacy Browser PC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Privacy Browser PC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Privacy Browser PC.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DOMAINSDATABASE_H
#define DOMAINSDATABASE_H

// Qt framework headers.
#include <QtSql>

class DomainsDatabase
{
public:
    // The default constructor.
    DomainsDatabase();

    // The public functions.
    static void addDatabase();
    static QSqlQuery getDomainQuery(const QString &hostname);

    // The public int constants.
    static const int SYSTEM_DEFAULT = 0;
    static const int ENABLED = 1;
    static const int DISABLED = 2;
    static const int CUSTOM = 1;

    // The public constants.
    static const QString CONNECTION_NAME;
    static const QString CUSTOM_ZOOM_FACTOR;
    static const QString DOM_STORAGE;
    static const QString DOMAIN_NAME;
    static const QString DOMAINS_TABLE;
    static const QString ID;
    static const QString JAVASCRIPT;
    static const QString LOCAL_STORAGE;
    static const QString USER_AGENT;
    static const QString ZOOM_FACTOR;

private:
    // The private static constants.
    static const int SCHEMA_VERSION;
};
#endif
