# SPDX-FileCopyrightText: 2021-2022 Rene Luria <rene.luria@infomaniak.com>
# SPDX-FileCopyrightText: 2021-2022 Yannik Roth <info@fuechslein.ch>
# SPDX-License-Identifier: Apache-2.0
from setuptools import setup
from setuptools import find_packages
from os import path

version = "0.0.0"

install_requires = [
    "certbot>=0.31.0",
    "setuptools",
    "requests",
    "requests-mock",
    "idna",
]

# read the contents of your README file
this_directory = path.abspath(path.dirname(__file__))
with open(path.join(this_directory, "README.rst")) as f:
    long_description = f.read()

setup(
    name="certbot-dns-infomaniak",
    version=version,
    description="Infomaniak DNS Authenticator plugin for Certbot",
    long_description=long_description,
    long_description_content_type="text/x-rst",
    url="https://github.com/infomaniak/certbot-dns-infomaniak",
    author="Rene Luria",
    author_email="rene.luria@infomaniak.com",
    license="Apache License 2.0",
    python_requires=">=3.5.0",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Plugins",
        "Intended Audience :: System Administrators",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: POSIX :: Linux",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Security",
        "Topic :: System :: Installation/Setup",
        "Topic :: System :: Networking",
        "Topic :: System :: Systems Administration",
        "Topic :: Utilities",
    ],
    packages=find_packages(),
    include_package_data=True,
    install_requires=install_requires,
    entry_points={
        "certbot.plugins": [
            "dns-infomaniak = certbot_dns_infomaniak.dns_infomaniak:Authenticator"
        ]
    },
    test_suite="certbot_dns_infomaniak",
)
