# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class CountryTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v2.countries.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v2/Trunking/Countries',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "countries": [
                    {
                        "country": "Andorra",
                        "iso_country": "AD",
                        "url": "https://pricing.twilio.com/v2/Trunking/Countries/AD"
                    }
                ],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v2/Trunking/Countries?PageSize=50&Page=0",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v2/Trunking/Countries?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.pricing.v2.countries.list()

        self.assertIsNotNone(actual)

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "countries": [],
                "meta": {
                    "first_page_url": "https://pricing.twilio.com/v2/Trunking/Countries?PageSize=50&Page=0",
                    "key": "countries",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://pricing.twilio.com/v2/Trunking/Countries?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.pricing.v2.countries.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.pricing.v2.countries("US").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://pricing.twilio.com/v2/Trunking/Countries/US',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "country": "United States",
                "originating_call_prices": [
                    {
                        "base_price": null,
                        "current_price": "0.0085",
                        "number_type": "local"
                    },
                    {
                        "base_price": null,
                        "current_price": "0.022",
                        "number_type": "toll free"
                    }
                ],
                "iso_country": "US",
                "terminating_prefix_prices": [
                    {
                        "base_price": null,
                        "current_price": "0.090",
                        "destination_prefixes": [
                            "1907"
                        ],
                        "friendly_name": "Outbound Trunking Minute - United States - Alaska",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": null,
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1808"
                        ],
                        "friendly_name": "Outbound Trunking Minute - United States - Hawaii",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": null,
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1800",
                            "1844",
                            "1855",
                            "1866",
                            "1877",
                            "1888"
                        ],
                        "friendly_name": "Outbound Trunking Minute - United States & Canada - Toll Free",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    },
                    {
                        "base_price": null,
                        "current_price": "0.013",
                        "destination_prefixes": [
                            "1"
                        ],
                        "friendly_name": "Outbound Trunking Minute - United States & Canada",
                        "origination_prefixes": [
                            "ALL"
                        ]
                    }
                ],
                "price_unit": "USD",
                "url": "https://pricing.twilio.com/v2/Trunking/Countries/US"
            }
            '''
        ))

        actual = self.client.pricing.v2.countries("US").fetch()

        self.assertIsNotNone(actual)
